/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmConnServerDomain;
import com.qjsoft.laser.controller.facade.am.repository.ConnServerServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/connServer"})
public class ConnServerCon
extends SpringmvcController {
    private static String CODE = "am.connServer.con";
    @Autowired
    private ConnServerServiceRepository connServerServiceRepository;

    protected String getContext() {
        return "connServer";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmConnServerDomain amConnServerDomain) {
        if (null == amConnServerDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.connServerServiceRepository.saveConnServer(amConnServerDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer connServerId, ModelMap modelMap) {
        modelMap.put((Object)"connServerReBean", (Object)this.getConnServer(connServerId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmConnServerDomain amConnServerDomain) {
        if (null == amConnServerDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.connServerServiceRepository.updateConnServer(amConnServerDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer connServerId) {
        if (StringUtils.isBlank((Integer)connServerId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.connServerServiceRepository.deleteConnServer(connServerId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer connServerId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)connServerId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.connServerServiceRepository.updateConnServerState(connServerId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer connServerId, ModelMap modelMap) {
        modelMap.put((Object)"connServerReBean", (Object)this.getConnServer(connServerId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getConnServer(Integer connServerId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)connServerId)) {
            this.logger.error(CODE + ".getConnServer", (Object)"connServerId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.connServerServiceRepository.getConnServer(connServerId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.connServerServiceRepository.queryConnServerPage(param);
    }
}

