/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmPparamDomain;
import com.qjsoft.laser.controller.facade.am.repository.PinfoServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/pparam"})
public class PparamCon
extends SpringmvcController {
    private static String CODE = "am.pparam.con";
    @Autowired
    private PinfoServiceRepository pinfoServiceRepository;

    protected String getContext() {
        return "pparam";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmPparamDomain amPparamDomain) {
        if (null == amPparamDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.savePparam(amPparamDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer pparamId, ModelMap modelMap) {
        modelMap.put((Object)"pparamReBean", (Object)this.getPparam(pparamId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmPparamDomain amPparamDomain) {
        if (null == amPparamDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.updatePparam(amPparamDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer pparamId) {
        if (StringUtils.isBlank((Integer)pparamId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.deletePparam(pparamId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer pparamId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)pparamId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoServiceRepository.updatePparamState(pparamId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer pparamId, ModelMap modelMap) {
        modelMap.put((Object)"pparamReBean", (Object)this.getPparam(pparamId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getPparam(Integer pparamId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)pparamId)) {
            this.logger.error(CODE + ".getPparam", (Object)"pparamId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.pinfoServiceRepository.getPparam(pparamId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pinfoServiceRepository.queryPparamPage(param);
    }
}

