/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.appmanage.util.ExcelExportTemplate;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiParamReDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmPermissionListDomainBean;
import com.qjsoft.laser.controller.facade.am.domain.AmPermissionListReDomainBean;
import com.qjsoft.laser.controller.facade.am.repository.AmPermissionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/permissionlist"})
public class PermissionListCon
extends SpringmvnNewController {
    private static String CODE = "am.permissionlist.con";
    @Autowired
    private AmPermissionServiceRepository amPermissionServiceRepository;

    protected String getContext() {
        return "permissionlist";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmPermissionListReDomainBean> listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("permissionListAction", "rs");
        return this.amPermissionServiceRepository.queryUpPermissionListPage(param);
    }

    @RequestMapping(value={"listQueryExcel.json"})
    @ResponseBody
    public HtmlJsonReBean listQueryExcel(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("permissionListAction", "rs");
        param.put("headMap", ExcelExportTemplate.covertPermissionListExcel());
        param.put("fileName", "\u5bfc\u51fa\u5546\u54c1");
        try {
            this.exportComExcel(request, param, param, "am.permis.queryUpPermissionListPage");
        }
        catch (Exception e) {
            this.logger.error(CODE + ".listQueryExcel.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return new HtmlJsonReBean((Object)"error");
        }
        this.logger.error(CODE + ".listQueryExcel.exportExcel", (Object)"==========\u6210\u529f\uff01");
        return new HtmlJsonReBean((Object)"success");
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List amPermissionListReDomainBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), AmPermissionListReDomainBean.class);
        if (ListUtil.isEmpty((Collection)amPermissionListReDomainBeanList)) {
            return null;
        }
        ArrayList<AmPermissionListReDomainBean> newGoodsList = new ArrayList<AmPermissionListReDomainBean>();
        for (AmPermissionListReDomainBean amPermissionListReDomainBean : amPermissionListReDomainBeanList) {
            AmPermissionListReDomainBean permissionListAll = this.amPermissionServiceRepository.getPermissionListAll(amPermissionListReDomainBean.getPermissionListId());
            this.logger.error(CODE + ".makeExcelData.getPermissionListAll", (Object)(permissionListAll.getPermissionListId() + "-" + amPermissionListReDomainBean.getPermissionListId()));
            newGoodsList.add(permissionListAll);
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (AmPermissionListReDomainBean amPermissionListReDomainBean : newGoodsList) {
            List paramList = amPermissionListReDomainBean.getParamList();
            boolean flag = false;
            if (ListUtil.isNotEmpty((Collection)paramList)) {
                for (AmAppapiParamReDomain amAppapiParamReDomain : paramList) {
                    Map<String, Object> objectDetailToMap = this.covertMap(amAppapiParamReDomain);
                    if (!flag) {
                        Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)amPermissionListReDomainBean), String.class, Object.class);
                        objectDetailToMap.putAll(objectToMap);
                        flag = true;
                    }
                    mapList.add(objectDetailToMap);
                }
                continue;
            }
            Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)paramList), String.class, Object.class);
            mapList.add(objectToMap);
        }
        return mapList;
    }

    protected Map<String, Object> covertMap(AmAppapiParamReDomain amAppapiParamReDomain) {
        HashMap<String, Object> orderDetaiMap = new HashMap<String, Object>();
        orderDetaiMap.put("paramName", amAppapiParamReDomain.getParamName());
        orderDetaiMap.put("paramRemark", amAppapiParamReDomain.getParamRemark());
        orderDetaiMap.put("paramType", amAppapiParamReDomain.getParamType());
        orderDetaiMap.put("paramRemark", amAppapiParamReDomain.getParamRemark());
        orderDetaiMap.put("paramDire", amAppapiParamReDomain.getParamDire());
        return orderDetaiMap;
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmPermissionListDomainBean amPermissionListDomainBean) {
        if (null == amPermissionListDomainBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.savePermissionList(amPermissionListDomainBean);
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmPermissionListDomainBean amPermissionListDomainBean) {
        if (null == amPermissionListDomainBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.updatePermissionList(amPermissionListDomainBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.deletePermissionList(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"getPermissionListAll.json"})
    @ResponseBody
    public Object getPermissionListAll(HttpServletRequest request, Integer permissionListId) {
        if (!StringUtils.isBlank((Integer)permissionListId)) {
            return this.amPermissionServiceRepository.getPermissionListAll(permissionListId);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
    }

    @RequestMapping(value={"preciseQuery.json"})
    @ResponseBody
    public SupQueryResult<AmPermissionListReDomainBean> preciseQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amPermissionServiceRepository.queryUpPermissionListPage(param);
    }

    @RequestMapping(value={"queryLocalCache.json"}, name="\u52a0\u8f7d\u6743\u9650")
    @ResponseBody
    public HtmlJsonReBean queryLocalCache() {
        return this.amPermissionServiceRepository.queryLocalCache();
    }
}

