/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmDataparamListDomain;
import com.qjsoft.laser.controller.facade.am.repository.DataparamServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/dataparamList"})
public class DataparamListCon
extends SpringmvcController {
    private static String CODE = "am.dataparamList.con";
    @Autowired
    private DataparamServiceRepository dataparamServiceRepository;

    protected String getContext() {
        return "dataparamList";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmDataparamListDomain amDataparamList) {
        if (null == amDataparamList) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.saveDataparamList(amDataparamList);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer dataparamListId, ModelMap modelMap) {
        modelMap.put((Object)"dataparamListReBean", (Object)this.getDataparamList(dataparamListId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmDataparamListDomain amDataparamListDomain) {
        if (null == amDataparamListDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.updateDataparamList(amDataparamListDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer dataparamListId) {
        if (StringUtils.isBlank((Integer)dataparamListId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.deleteDataparamList(dataparamListId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer dataparamListId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)dataparamListId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.dataparamServiceRepository.updateDataparamListState(dataparamListId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer dataparamListId, ModelMap modelMap) {
        modelMap.put((Object)"dataparamListReBean", (Object)this.getDataparamList(dataparamListId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getDataparamList(Integer dataparamListId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)dataparamListId)) {
            this.logger.error(CODE + ".getDataparamList", (Object)"dataparamListId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.dataparamServiceRepository.getDataparamList(dataparamListId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.dataparamServiceRepository.queryDataparamListPage(param);
    }
}

