/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.am.domain.AmRouterDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmRouterReDomain;
import com.qjsoft.laser.controller.facade.am.repository.RouterServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/router"})
public class RouterCon
extends SpringmvcController {
    private static String CODE = "am.router.con";
    @Autowired
    private RouterServiceRepository routerServiceRepository;

    protected String getContext() {
        return "router";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmRouterDomain amRouterDomain) {
        if (null == amRouterDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routerServiceRepository.saveRouter(amRouterDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer routerId, ModelMap modelMap) {
        modelMap.put((Object)"routerReBean", (Object)this.getRouter(routerId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmRouterDomain amRouterDomain) {
        if (null == amRouterDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routerServiceRepository.updateRouter(amRouterDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer routerId) {
        if (StringUtils.isBlank((Integer)routerId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routerServiceRepository.deleteRouter(routerId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer routerId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)routerId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routerServiceRepository.updateRouterState(routerId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer routerId, ModelMap modelMap) {
        modelMap.put((Object)"routerReBean", (Object)this.getRouter(routerId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getRouter(Integer routerId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)routerId)) {
            this.logger.error(CODE + ".getRouter", (Object)"routerId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.routerServiceRepository.getRouter(routerId));
        }
        return rs;
    }

    @RequestMapping(value={"getRouter.json"})
    @ResponseBody
    public AmRouterReDomain getRouterFor(Integer routerId) {
        if (StringUtils.isBlank((Integer)routerId)) {
            this.logger.error(CODE + ".getRouterFor", (Object)"param is null");
            return null;
        }
        return this.routerServiceRepository.getRouter(routerId);
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.routerServiceRepository.queryRouterPage(param);
    }
}

