/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auction"}, name="\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "at.auction.con";
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".saveAuction", (Object)"atAuctionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionByCode.json"}, name="\u6839\u636ecode\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        if (atAuctionReDomain.getDataState() != 3) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
        }
        return this.atAuctionServiceRepository.deleteatAuctionByCode(this.getTenantCode(request), auctionCode);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionAuctionAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAuctionAuctionAudit(String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionMemPage.json"}, name="\u67e5\u8be2\u62a5\u540d\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionMemReDomain> queryAuctionMemPage(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionMemPage(param);
    }
}

