/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.basicsetting.controller;

import com.qjsoft.laser.controller.basicsetting.controller.model.Area;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.bs.domain.BsAreaReDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsProvinceDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsProvinceReDomain;
import com.qjsoft.laser.controller.facade.bs.repository.BsAreaServiceRepository;
import com.qjsoft.laser.controller.facade.bs.repository.BsProvinceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/bs/province"}, name="\u7701\u4efd\u670d\u52a1")
public class ProvinceCon
extends SpringmvcController {
    private static String CODE = "bs.province.con";
    @Autowired
    private BsProvinceServiceRepository bsProvinceServiceRepository;
    @Autowired
    private BsAreaServiceRepository bsAreaServiceRepository;

    protected String getContext() {
        return "province";
    }

    @RequestMapping(value={"saveProvince.json"}, name="\u589e\u52a0\u7701\u4efd\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveProvince(HttpServletRequest request, BsProvinceDomain bsProvinceDomain) {
        if (null == bsProvinceDomain) {
            this.logger.error(CODE + ".saveProvince", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsProvinceDomain.setTenantCode(this.getTenantCode(request));
        return this.bsProvinceServiceRepository.saveProvince(bsProvinceDomain);
    }

    @RequestMapping(value={"getProvince.json"}, name="\u83b7\u53d6\u7701\u4efd\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public BsProvinceReDomain getProvince(String provinceId) {
        if (StringUtils.isBlank((String)provinceId)) {
            this.logger.error(CODE + ".getProvince", (Object)"param is null");
            return null;
        }
        return this.bsProvinceServiceRepository.getProvince(Integer.valueOf(provinceId));
    }

    @RequestMapping(value={"updateProvince.json"}, name="\u66f4\u65b0\u7701\u4efd\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateProvince(HttpServletRequest request, BsProvinceDomain bsProvinceDomain) {
        if (null == bsProvinceDomain) {
            this.logger.error(CODE + ".updateProvince", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsProvinceDomain.setTenantCode(this.getTenantCode(request));
        return this.bsProvinceServiceRepository.updateProvince(bsProvinceDomain);
    }

    @RequestMapping(value={"deleteProvince.json"}, name="\u5220\u9664\u7701\u4efd\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteProvince(String provinceId) {
        if (StringUtils.isBlank((String)provinceId)) {
            this.logger.error(CODE + ".deleteProvince", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsProvinceServiceRepository.deleteProvince(Integer.valueOf(provinceId));
    }

    @RequestMapping(value={"queryProvincePage.json"}, name="\u67e5\u8be2\u7701\u4efd\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<BsProvinceReDomain> queryProvincePage(HttpServletRequest request) {
        SupQueryResult qest;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (null == (qest = this.bsProvinceServiceRepository.queryProvincePage(param)) || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsProvinceServiceRepository.queryProvincePage(param);
        }
        return qest;
    }

    @RequestMapping(value={"queryNewProvincePage.json"}, name="\u67e5\u8be2\u7701\u4efd\u670d\u52a1\u5206\u9875\u5217\u8868(\u4e8c\u6b21\u5f00\u53d1)")
    @ResponseBody
    public SupQueryResult<BsProvinceReDomain> queryNewProvincePage(HttpServletRequest request) {
        SupQueryResult qest;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (null == (qest = this.bsProvinceServiceRepository.queryProvincePage(param)) || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsProvinceServiceRepository.queryProvincePage(param);
        }
        return qest;
    }

    @RequestMapping(value={"queryProvincePageForC.json"}, name="\u67e5\u8be2C\u7aef\u7701\u4efd\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<BsProvinceReDomain> queryProvincePageForC(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("tenantCode", this.getTenantCode(request));
        }
        return this.bsProvinceServiceRepository.queryProvincePage(param);
    }

    @RequestMapping(value={"updateProvinceState.json"}, name="\u66f4\u65b0\u7701\u4efd\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProvinceState(String provinceId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)provinceId)) {
            this.logger.error(CODE + ".updateProvinceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsProvinceServiceRepository.updateProvinceState(Integer.valueOf(provinceId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProvincePageByTenantCode.json"}, name="\u67e5\u8be2C\u7aef\u7701\u4efd\u670d\u52a1\u5206\u9875\u5217\u8868\uff08\u8fc7\u6ee4\u5f53\u524d\u79df\u6237\uff09")
    @ResponseBody
    public SupQueryResult<BsProvinceReDomain> queryProvincePageByTenantCode(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bsProvinceServiceRepository.queryProvincePage(param);
    }

    @RequestMapping(value={"queryAllDistrict.json"}, name="\u67e5\u8be2\u5168\u90e8\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public List<Area> queryAreaPage(HttpServletRequest request) {
        String json = SupDisUtil.get((String)"AllDistrict");
        if (StringUtils.isNotBlank((String)json)) {
            return (List)JsonUtil.buildNormalBinder().getJsonToList(json, Area.class);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Integer> param = new HashMap<String, Integer>();
                param.put("page", 1);
                param.put("rows", 200);
                SupQueryResult supQueryResult = ProvinceCon.this.bsProvinceServiceRepository.queryProvincePage(param);
                ArrayList<Area> areaList = new ArrayList<Area>();
                if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    for (BsProvinceReDomain bsProvinceReDomain : supQueryResult.getList()) {
                        Area area = new Area(bsProvinceReDomain.getProvincName(), bsProvinceReDomain.getProvinceCode());
                        ProvinceCon.this.makeShi(area, bsProvinceReDomain.getTenantCode());
                        areaList.add(area);
                    }
                }
                SupDisUtil.set((String)"AllDistrict", (String)JsonUtil.buildNormalBinder().toJson(areaList));
            }
        }).start();
        return null;
    }

    private void makeShi(Area area, String tenantCode) {
        ArrayList<Area> AreaShi = new ArrayList<Area>();
        ArrayList<Area> qu = new ArrayList<Area>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("provinceCode", area.getCode());
        param.put("tenantCode", tenantCode);
        SupQueryResult queryResult = this.bsAreaServiceRepository.queryAreaPage(param);
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (BsAreaReDomain bsAreaReDomain : queryResult.getList()) {
                Area SHI = new Area(bsAreaReDomain.getAreaName(), bsAreaReDomain.getAreaCode());
                param.clear();
                param.put("areaParentCode", SHI.getCode());
                param.put("tenantCode", tenantCode);
                SupQueryResult result = this.bsAreaServiceRepository.queryAreaPage(param);
                if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                    for (BsAreaReDomain areaReDomain : result.getList()) {
                        Area Qu = new Area(areaReDomain.getAreaName(), areaReDomain.getAreaCode());
                        qu.add(Qu);
                    }
                    SHI.setChildren(qu);
                }
                AreaShi.add(SHI);
                area.setChildren(AreaShi);
            }
        }
    }
}

