/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cd.controller;

import com.qjsoft.laser.controller.cd.userexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardpDomain;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardpReDomain;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardplistDomain;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardplistReDomain;
import com.qjsoft.laser.controller.facade.cd.repository.CdCardpServiceRepository;
import com.qjsoft.laser.controller.facade.cd.repository.CdCardplistServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountlistReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionDiscountlistServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cd/cardp"}, name="\u5361\u5bc6\u670d\u52a1")
public class CardpCon
extends SpringmvcController {
    private static String CODE = "cd.cardp.con";
    @Autowired
    private CdCardpServiceRepository cdCardpServiceRepository;
    @Autowired
    private CdCardplistServiceRepository cdCardplistServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private PmPromotionDiscountlistServiceRepository pmPromotionDiscountlistServiceRepositoryl;
    @Autowired
    private PmPromotionDiscountlistServiceRepository pmPromotionDiscountlistServiceRepository;

    protected String getContext() {
        return "cardp";
    }

    @RequestMapping(value={"saveCardp.json"}, name="\u589e\u52a0\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveCardp(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String userName = userSession.getUserName();
        String userCode = userSession.getUserCode();
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, CdCardpDomain.class);
        Date cardpStart = cdCardpDomain.getCardpStart();
        Date cardpEnd = cdCardpDomain.getCardpEnd();
        if (null == cdCardpDomain.getCardpCnum()) {
            this.logger.error(CODE + ".saveCardp", (Object)"cardpCnum is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cdCardpDomain.setMemberCode(userSession.getUserPcode());
        cdCardpDomain.setMemberName(userSession.getUserName());
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        cdCardpDomain.setUserName(userName);
        cdCardpDomain.setUserCode(userCode);
        if (cardpStart != null && cardpEnd != null) {
            Integer state = this.getState(cardpStart, cardpEnd);
            cdCardpDomain.setDataState(state);
        }
        return this.cdCardpServiceRepository.saveCardp(cdCardpDomain);
    }

    private Integer getState(Date dayStart, Date dayEnd) {
        long now = System.currentTimeMillis();
        long startTime = dayStart.getTime();
        long endTime = dayEnd.getTime();
        if (now < startTime) {
            return 4;
        }
        if (startTime <= now && now <= endTime) {
            return 1;
        }
        return 2;
    }

    @RequestMapping(value={"updateBatchCardplist.json"}, name="\u66f4\u65b0\u5361\u5bc6\u5217\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateBatchCardplist(HttpServletRequest request, String cdCardplistDomainBeanStr) {
        if (null == cdCardplistDomainBeanStr) {
            this.logger.error(CODE + ".updateCardplist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(cdCardplistDomainBeanStr, CdCardpDomain.class);
        cdCardpDomain.setMemberCode(userSession.getUserPcode());
        cdCardpDomain.setMemberName(userSession.getUserName());
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        List cdCardplistDomainList = cdCardpDomain.getCdCardplistDomainList();
        if (ListUtil.isNotEmpty((Collection)cdCardplistDomainList)) {
            for (CdCardplistDomain cdCardplistDomain : cdCardplistDomainList) {
                cdCardplistDomain.setCardpCode(cdCardpDomain.getCardpCode());
                cdCardplistDomain.setAppmanageIcode(cdCardpDomain.getAppmanageIcode());
                cdCardplistDomain.setCardpBatch(cdCardpDomain.getCardpBatch());
                cdCardplistDomain.setCardpEnd(cdCardplistDomain.getCardpEnd() == null ? cdCardpDomain.getCardpEnd() : cdCardplistDomain.getCardpEnd());
                cdCardplistDomain.setCardpName(cdCardpDomain.getCardpName());
                cdCardplistDomain.setCardpOptype("3");
                cdCardplistDomain.setCardpStart(cdCardplistDomain.getCardpStart() == null ? cdCardpDomain.getCardpStart() : cdCardplistDomain.getCardpStart());
                cdCardplistDomain.setTenantCode(cdCardpDomain.getTenantCode());
                cdCardplistDomain.setMemberCode(cdCardpDomain.getMemberCode());
                cdCardplistDomain.setMemberName(cdCardpDomain.getMemberName());
                cdCardplistDomain.setGiftNo(cdCardpDomain.getGiftNo());
                cdCardplistDomain.setCardpChange("0");
            }
        }
        if (cdCardplistDomainList.size() > 0) {
            return this.cdCardplistServiceRepository.saveCardplistBatch(cdCardplistDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getCardp.json"}, name="\u83b7\u53d6\u5361\u5bc6\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CdCardpReDomain getCardp(Integer cardpId) {
        if (StringUtils.isBlank((Integer)cardpId)) {
            this.logger.error(CODE + ".getCardp", (Object)"param is null");
            return null;
        }
        return this.cdCardpServiceRepository.getCardp(cardpId);
    }

    @RequestMapping(value={"updateCardp.json"}, name="\u66f4\u65b0\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateCardp(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateCardp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, CdCardpDomain.class);
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        Date cardpStart = cdCardpDomain.getCardpStart();
        Date cardpEnd = cdCardpDomain.getCardpEnd();
        if (cardpStart != null && cardpEnd != null) {
            Integer state = this.getState(cardpStart, cardpEnd);
            cdCardpDomain.setDataState(state);
        }
        return this.cdCardpServiceRepository.updateCardp(cdCardpDomain);
    }

    @RequestMapping(value={"deleteCardp.json"}, name="\u5220\u9664\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteCardp(Integer cardpId) {
        if (StringUtils.isBlank((Integer)cardpId)) {
            this.logger.error(CODE + ".deleteCardp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cdCardpServiceRepository.deleteCardp(cardpId);
    }

    @RequestMapping(value={"queryCardpPage.json"}, name="\u67e5\u8be2\u5916\u90e8\u5238")
    @ResponseBody
    public SupQueryResult<CdCardpReDomain> queryCardpPage(HttpServletRequest request) {
        SupQueryResult cdCardpReDomainSupQueryResult;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((list = (cdCardpReDomainSupQueryResult = this.cdCardpServiceRepository.queryCardpPage(param)).getList()).size() <= 0) {
            return new SupQueryResult();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("fuzzy", false);
        map.put("stateType", 3);
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("tenantCode", this.getTenantCode(request));
        for (int i = 0; i < list.size(); ++i) {
            String cardpCode = ((CdCardpReDomain)list.get(i)).getCardpCode();
            map.put("cardpCode", cardpCode);
            int size = this.cdCardplistServiceRepository.queryCardplistPage(map).getList().size();
            ((CdCardpReDomain)list.get(i)).setCardpPurchased(Integer.valueOf(size));
            ((CdCardpReDomain)list.get(i)).setCardpUnclaimed(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue() - size));
            hash.put("discountCode", ((CdCardpReDomain)list.get(i)).getCardpCode());
            List list1 = this.pmPromotionDiscountlistServiceRepositoryl.queryPromotionDiscountlistPage(hash).getList();
            if (list1 != null && list1.size() > 0) {
                int k = 0;
                for (int j = 0; j < list1.size(); ++j) {
                    k += ((PmPromotionDiscountlistReDomain)list1.get(j)).getDiscountAmount().intValue();
                }
                ((CdCardpReDomain)list.get(i)).setCardpUnallocated(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue() - k));
                continue;
            }
            ((CdCardpReDomain)list.get(i)).setCardpUnallocated(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue()));
        }
        return cdCardpReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryCardpExcludePage.json"}, name="\u67e5\u8be2\u5916\u90e8\u5238")
    @ResponseBody
    public SupQueryResult<CdCardpReDomain> queryCardpExcludePage(HttpServletRequest request) {
        SupQueryResult cdCardpReDomainSupQueryResult;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((list = (cdCardpReDomainSupQueryResult = this.cdCardpServiceRepository.queryCardpPage(param)).getList()).size() <= 0) {
            return new SupQueryResult();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("fuzzy", false);
        map.put("stateType", 3);
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("tenantCode", this.getTenantCode(request));
        for (int i = 0; i < list.size(); ++i) {
            String cardpCode = ((CdCardpReDomain)list.get(i)).getCardpCode();
            map.put("cardpCode", cardpCode);
            int size = this.cdCardplistServiceRepository.queryCardplistPage(map).getList().size();
            ((CdCardpReDomain)list.get(i)).setCardpPurchased(Integer.valueOf(size));
            ((CdCardpReDomain)list.get(i)).setCardpUnclaimed(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue() - size));
            hash.put("discountCode", ((CdCardpReDomain)list.get(i)).getCardpCode());
            List list1 = this.pmPromotionDiscountlistServiceRepositoryl.queryPromotionDiscountlistPage(hash).getList();
            if (list1 != null && list1.size() > 0) {
                int k = 0;
                for (int j = 0; j < list1.size(); ++j) {
                    k += ((PmPromotionDiscountlistReDomain)list1.get(j)).getDiscountAmount().intValue();
                }
                ((CdCardpReDomain)list.get(i)).setCardpUnallocated(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue() - k));
                continue;
            }
            ((CdCardpReDomain)list.get(i)).setCardpUnallocated(Integer.valueOf(((CdCardpReDomain)list.get(i)).getCardpCnum().intValue()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CdCardpReDomain next = (CdCardpReDomain)iterator.next();
            if (next.getCardpUnallocated() > 0) continue;
            iterator.remove();
        }
        return cdCardpReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateCardpState.json"}, name="\u66f4\u65b0\u5361\u5bc6\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCardpState(HttpServletRequest request, String cardpCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)cardpCode)) {
            this.logger.error(CODE + ".updateCardpState", (Object)"cardpCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpReDomain cdCardpReDomain = this.cdCardpServiceRepository.getCardpByCode(this.getTenantCode(request), cardpCode);
        cdCardpReDomain.setDataState(dataState);
        cdCardpReDomain.setUserCode(userSession.getUserPcode());
        cdCardpReDomain.setUserName(userSession.getUserName());
        cdCardpReDomain.setVerifyDate(new Date());
        HtmlJsonReBean htmlJsonReBean = this.cdCardpServiceRepository.updateCardp((CdCardpDomain)cdCardpReDomain);
        if (htmlJsonReBean.isSuccess()) {
            this.cdCardplistServiceRepository.updateCardplistStateByCardpCode(this.getTenantCode(request), cardpCode, dataState, oldDataState);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"savePetCard.json"}, name="\u6dfb\u52a0\u50a8\u503c\u5361")
    @ResponseBody
    public HtmlJsonReBean savePetCard(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePetCard", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePetCard", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, CdCardpDomain.class);
        if (null == cdCardpDomain.getCdCardplistDomainList()) {
            this.logger.error(CODE + ".savePetCard", (Object)"cdCardplistDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int num = cdCardpDomain.getCdCardplistDomainList().size();
        cdCardpDomain.setCardpOptype("3");
        cdCardpDomain.setCardpCnum(BigDecimal.valueOf(num));
        cdCardpDomain.setMemberCode(userSession.getUserPcode());
        cdCardpDomain.setMemberName(userSession.getUserName());
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        return this.cdCardpServiceRepository.saveCardp(cdCardpDomain);
    }

    @RequestMapping(value={"queryPetCardPage.json"}, name="\u67e5\u770b\u50a8\u503c\u5361\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CdCardpReDomain> queryPetCardPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("cardpOptype", "3");
        SupQueryResult cdCardpReDomainList = this.cdCardpServiceRepository.queryCardpPage(param);
        if (ListUtil.isNotEmpty((Collection)cdCardpReDomainList.getList())) {
            for (CdCardpReDomain cdCardpReDomain : cdCardpReDomainList.getList()) {
                HashMap<String, String> paramStr = new HashMap<String, String>();
                paramStr.put("cardpCode", cdCardpReDomain.getCardpCode());
                SupQueryResult cdCardplistReDomainArr = this.cdCardplistServiceRepository.queryCardplistPage(paramStr);
                cdCardpReDomain.setCardpCnum(new BigDecimal(cdCardplistReDomainArr.getTotal()));
            }
        }
        return cdCardpReDomainList;
    }

    @RequestMapping(value={"petCardUpShelf.json"}, name="\u50a8\u503c\u5361\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean petCardUpShelf(HttpServletRequest request, String cardpId) {
        if (null == cardpId) {
            this.logger.error(CODE + ".petCardUpShelf", (Object)"cardpId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpReDomain cdCardpReDomain = this.cdCardpServiceRepository.getCardp(Integer.valueOf(cardpId));
        if (null == cdCardpReDomain) {
            this.logger.error(CODE + ".petCardUpShelf", (Object)"cdCardpReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, cdCardpReDomain);
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        goodsList.add(rsResourceGoodsDomain);
        HtmlJsonReBean htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
        String rs = htmlJsonReBean1.getErrorCode();
        if (StringUtils.isNotBlank((String)rs)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.cdCardpServiceRepository.updateCardpStateByCode(this.getTenantCode(request), cdCardpReDomain.getCardpCode(), Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"petCardDownShelf.json"}, name="\u50a8\u503c\u5361\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean petCardDownShelf(HttpServletRequest request, String cardpCode) {
        HtmlJsonReBean htmlJsonReBean1;
        String errorCode;
        if (StringUtils.isEmpty((String)cardpCode)) {
            this.logger.error(CODE + ".petCardDownShelf", (Object)"cardpCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("goodsOrigin", "14");
        map.put("goodsNo", cardpCode);
        map.put("tenantCode", tenantCode);
        List rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map).getList();
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != rsResourceGoodsReDomainList && rsResourceGoodsReDomainList.size() != 0) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainList.get(0);
            params.put("goodsOrigin", "14");
            params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            params.put("tenantCode", tenantCode);
        }
        if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(params)).getErrorCode()))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
        }
        return this.cdCardpServiceRepository.updateCardpStateByCode(tenantCode, cardpCode, Integer.valueOf(0), Integer.valueOf(1));
    }

    @RequestMapping(value={"getPetCard.json"}, name="\u83b7\u53d6\u50a8\u503c\u5361\u4fe1\u606f")
    @ResponseBody
    public CdCardpReDomain getPetCard(Integer cardpId) {
        if (StringUtils.isBlank((Integer)cardpId)) {
            this.logger.error(CODE + ".getPetCard", (Object)"cardpId is null");
            return null;
        }
        return this.cdCardpServiceRepository.getCardp(cardpId);
    }

    @RequestMapping(value={"queryPetCardList.json"}, name="\u83b7\u53d6\u50a8\u503c\u5361\u660e\u7ec6")
    @ResponseBody
    public SupQueryResult<CdCardplistReDomain> queryPetCardList(HttpServletRequest request, String cardpCode) {
        if (StringUtils.isEmpty((String)cardpCode)) {
            this.logger.error(CODE + ".queryPetCardList", (Object)"cardpCode is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("cardpCode", cardpCode);
        param.put("tenantCode", this.getTenantCode(request));
        return this.cdCardplistServiceRepository.queryCardplistPage(param);
    }

    @RequestMapping(value={"petCardStop.json"}, name="\u50a8\u503c\u5361\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean petCardStop(HttpServletRequest request, String cardplistCode) {
        if (StringUtils.isEmpty((String)cardplistCode)) {
            this.logger.error(CODE + ".petCardStop", (Object)"cardplistCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cdCardplistServiceRepository.updateCardplistStateByCode(this.getTenantCode(request), cardplistCode, Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"petCardStart.json"}, name="\u50a8\u503c\u5361\u542f\u7528")
    @ResponseBody
    public HtmlJsonReBean petCardStart(HttpServletRequest request, String cardplistCode) {
        if (StringUtils.isEmpty((String)cardplistCode)) {
            this.logger.error(CODE + ".petCardStart", (Object)"cardplistCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cdCardplistServiceRepository.updateCardplistStateByCode(this.getTenantCode(request), cardplistCode, Integer.valueOf(0), Integer.valueOf(1));
    }

    public RsResourceGoodsDomain make(HttpServletRequest request, CdCardpReDomain cdCardpReDomain) {
        RsGoodsFileDomain rsGoodsFile;
        if (null == cdCardpReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(cdCardpReDomain.getCardpName());
        rsResourceGoodsDomain.setGoodsNo(cdCardpReDomain.getCardpCode());
        rsResourceGoodsDomain.setPntreeCode(cdCardpReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(cdCardpReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(cdCardpReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(cdCardpReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(cdCardpReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(cdCardpReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(cdCardpReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(cdCardpReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("14");
        rsResourceGoodsDomain.setGoodsType("12");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u5f20");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        SupQueryResult<CdCardplistReDomain> cdCardplistReDomainSupQueryResult = this.queryPetCardList(request, cdCardpReDomain.getCardpCode());
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal(cdCardplistReDomainSupQueryResult.getTotal()));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal(cdCardplistReDomainSupQueryResult.getTotal()));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsRemark(cdCardpReDomain.getCardpRemark());
        rsResourceGoodsDomain.setPricesetAsprice(cdCardpReDomain.getPricesetInsideprice());
        this.makeChannel(rsResourceGoodsDomain, request);
        ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
        if (!StringUtils.isEmpty((String)cdCardpReDomain.getCardpUrl1())) {
            rsGoodsFile = new RsGoodsFileDomain();
            rsGoodsFile.setGoodsFileType("0");
            rsGoodsFile.setGoodsFileUrl(cdCardpReDomain.getCardpUrl1());
            rsGoodsFile.setTenantCode(cdCardpReDomain.getTenantCode());
            rsGoodsFileList.add(rsGoodsFile);
        }
        if (!StringUtils.isEmpty((String)cdCardpReDomain.getCardpUrl2())) {
            rsGoodsFile = new RsGoodsFileDomain();
            rsGoodsFile.setGoodsFileType("0");
            rsGoodsFile.setGoodsFileUrl(cdCardpReDomain.getCardpUrl2());
            rsGoodsFile.setTenantCode(cdCardpReDomain.getTenantCode());
            rsGoodsFileList.add(rsGoodsFile);
        }
        if (!StringUtils.isEmpty((String)cdCardpReDomain.getCardpUrl3())) {
            rsGoodsFile = new RsGoodsFileDomain();
            rsGoodsFile.setGoodsFileType("0");
            rsGoodsFile.setGoodsFileUrl(cdCardpReDomain.getCardpUrl3());
            rsGoodsFile.setTenantCode(cdCardpReDomain.getTenantCode());
            rsGoodsFileList.add(rsGoodsFile);
        }
        if (!StringUtils.isEmpty((String)cdCardpReDomain.getCardpUrl4())) {
            rsGoodsFile = new RsGoodsFileDomain();
            rsGoodsFile.setGoodsFileType("0");
            rsGoodsFile.setGoodsFileUrl(cdCardpReDomain.getCardpUrl4());
            rsGoodsFile.setTenantCode(cdCardpReDomain.getTenantCode());
            rsGoodsFileList.add(rsGoodsFile);
        }
        if (!StringUtils.isEmpty((String)cdCardpReDomain.getCardpUrl5())) {
            rsGoodsFile = new RsGoodsFileDomain();
            rsGoodsFile.setGoodsFileType("0");
            rsGoodsFile.setGoodsFileUrl(cdCardpReDomain.getCardpUrl5());
            rsGoodsFile.setTenantCode(cdCardpReDomain.getTenantCode());
            rsGoodsFileList.add(rsGoodsFile);
        }
        rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        rsSpecValue.setSpecCode("ee840b943ef6448084230297ca7bc920");
        rsSpecValue.setSpecName(cdCardpReDomain.getCardpUrl());
        rsSpecValue.setSpecGroupCode("3179b50cjruk633b80bee32lk49kcwq1");
        rsSpecValue.setSpecValueBillno(cdCardpReDomain.getCardpCode());
        rsSpecValue.setSpecValueFlag("1");
        rsSpecValue.setSpecValueType("0");
        if (cdCardpReDomain.getPricesetMakeprice() != null) {
            rsSpecValue.setSpecValueValue(cdCardpReDomain.getPricesetMakeprice().setScale(2, 4) + "\u5143");
        }
        rsSpecValue.setTenantCode(cdCardpReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        return rsResourceGoodsDomain;
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"queryCardpExcelPage.json"}, name="\u5916\u90e8\u5238\u5bfc\u51fa")
    @ResponseBody
    private void exportUpmupointPage(HttpServletRequest request, HttpServletResponse response) {
        SupQueryResult<CdCardpReDomain> cdCardpReDomainSupQueryResult = this.queryCardpPage(request);
        this.logger.info("umUserinfoReDomainBeanSupQueryResult.getList().size()====" + cdCardpReDomainSupQueryResult.getList().size());
        if (cdCardpReDomainSupQueryResult.getList().size() > 0) {
            this.queryContractPageComHy(request, null, null, cdCardpReDomainSupQueryResult.getList(), response);
        }
        this.logger.info("null------------111111111111====" + cdCardpReDomainSupQueryResult.getList().size());
    }

    protected void queryContractPageComHy(HttpServletRequest request, String fileName, Map<String, Object> param, List<CdCardpReDomain> list, HttpServletResponse response) {
        this.logger.info("\u8fdb\u5165queryContractPageComHy===========");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====a=======");
        String excelTemplate = "";
        this.logger.info("\u8fdb\u5165queryContractPageComHy====b=======");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====c=======");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====b=======");
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "\u79ef\u5206\u5217\u8868";
        }
        UserSession userSession = this.getUserSession(request);
        this.logger.info("\u8fdb\u5165queryContractPageComHy====e=======");
        String userCode = null == userSession ? "" : userSession.getUserCode();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        this.logger.info("\u8fdb\u5165queryContractPageComHy====f=======");
        infoMap.put("headMap", ExcelExportTemplate.covertOrderPointsExcel());
        excelTemplate = "xs";
        fileName = "\u79ef\u5206\u5217\u8868";
        this.logger.info("\u8fdb\u5165queryContractPageComHy====g=======");
        infoMap.put("userCode", userCode);
        infoMap.put("fileName", fileName);
        try {
            this.logger.info("\u8fdb\u5165queryContractPageComHy====h=======");
            this.exportComExcels(request, param, infoMap, excelTemplate, list, response);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryContractPageComHy.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComExcels(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, String excelTemplate, List<CdCardpReDomain> list, HttpServletResponse response) {
        List headMapList;
        String startDate;
        this.logger.info("\u8fdb\u5165exportComExcels=====================");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.logger.info("\u8fdb\u5165exportComExcels===========a==========");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        this.logger.info("\u8fdb\u5165exportComExcels=========b============");
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        this.logger.info("\u8fdb\u5165exportComExcels=========c============");
        String endDate = null == infoMap.get("endDate") ? "" : (String)infoMap.get("endDate");
        this.logger.info("\u8fdb\u5165exportComExcels=========d============");
        String string = startDate = null == infoMap.get("startDate") ? "" : (String)infoMap.get("startDate");
        if (StringUtils.isEmpty((String)excelTemplate) && excelTemplate.equals("lr")) {
            fileName = startDate + "-" + endDate + "-" + fileName;
            this.logger.info("\u8fdb\u5165exportComExcels====e=================");
        } else {
            fileName = formatData + "-" + fileName;
            this.logger.info("\u8fdb\u5165exportComExcels=======f==============");
        }
        this.logger.info("\u8fdb\u5165exportComExcels======11111111===============");
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
        }
        if (ListUtil.isEmpty((Collection)(headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class)))) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
        }
        this.logger.info("\u8fdb\u5165exportComExcels======2222222===============");
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        this.logger.info("\u8fdb\u5165exportComExcels======333333333===============", excelHeader);
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        boolean index = false;
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        List<Map<String, Object>> fromDataList = this.getAllFields(list);
        this.logger.info("\u8fdb\u5165exportComExcels======4444444444===============", fromDataList);
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string2 = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
            this.logger.info("\u8fdb\u5165exportComExcels======5555555===============", dataList);
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
        }
        this.logger.info("\u8fdb\u5165exportComExcels======666666===============");
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            this.logger.info("success=====================la");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5916\u90e8\u5238\u5217\u8868.xls", "utf-8"));
            response.setHeader("Access-Control-Expose-Headers", "content-Disposition");
            ServletOutputStream outputStreams = response.getOutputStream();
            workbook.write((OutputStream)outputStreams);
            outputStreams.flush();
            outputStreams.close();
            this.logger.info("success==========D:\\1.xls -----===========la");
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
            this.logger.info("success==========bytes-----===========la");
            this.saveExcel(bytes, fileName, "1234", fileType, "2020121500000001");
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
        }
    }

    private void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    public List<Map<String, Object>> getAllFields(List<CdCardpReDomain> list) {
        ArrayList<Map<String, Object>> datamap = new ArrayList<Map<String, Object>>();
        for (CdCardpReDomain cdCardpReDomain : list) {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class<?> clazz = cdCardpReDomain.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            }
            HashMap<String, Object> maps = new HashMap<String, Object>();
            this.logger.info("fieldList.size()-----------", (Object)fieldList.size());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Field field : fieldList) {
                this.logger.info("field.getName()-----------", (Object)field.getName());
                if ("cardpName".equals(field.getName())) {
                    maps.put("cardpName", cdCardpReDomain.getCardpName());
                    continue;
                }
                if ("pricesetMakeprice".equals(field.getName())) {
                    maps.put("pricesetMakeprice", cdCardpReDomain.getPricesetMakeprice());
                    continue;
                }
                if ("cardpCnum".equals(field.getName())) {
                    maps.put("cardpCnum", cdCardpReDomain.getCardpCnum());
                    if (cdCardpReDomain.getCardpCnum() == null || cdCardpReDomain.getPricesetMakeprice() == null) {
                        maps.put("cardpPrice", 0);
                        continue;
                    }
                    maps.put("cardpPrice", cdCardpReDomain.getPricesetMakeprice().intValue() * cdCardpReDomain.getCardpCnum().intValue());
                    continue;
                }
                if ("cardpPurchased".equals(field.getName())) {
                    maps.put("cardpPurchased", cdCardpReDomain.getCardpPurchased());
                    if (cdCardpReDomain.getCardpPurchased() == null || cdCardpReDomain.getPricesetMakeprice() == null) {
                        maps.put("cardpCollectedPrice", 0);
                        continue;
                    }
                    maps.put("cardpCollectedPrice", cdCardpReDomain.getCardpPurchased() * cdCardpReDomain.getPricesetMakeprice().intValue());
                    continue;
                }
                if ("cardpStart".equals(field.getName())) {
                    maps.put("cardpStart", simpleDateFormat.format(cdCardpReDomain.getCardpStart()) + " - " + simpleDateFormat.format(cdCardpReDomain.getCardpEnd()));
                    continue;
                }
                if ("userName".equals(field.getName())) {
                    maps.put("userName", cdCardpReDomain.getUserName());
                    continue;
                }
                if ("gmtCreate".equals(field.getName())) {
                    maps.put("gmtCreate", simpleDateFormat.format(cdCardpReDomain.getGmtCreate()));
                    continue;
                }
                if (!"dataState".equals(field.getName())) continue;
                Integer dataState = cdCardpReDomain.getDataState();
                if (dataState == 1) {
                    maps.put("dataState", "\u5df2\u751f\u6548");
                    continue;
                }
                if (dataState == 2) {
                    maps.put("dataState", "\u5df2\u8fc7\u671f");
                    continue;
                }
                if (dataState != 4) continue;
                maps.put("dataState", "\u672a\u751f\u6548");
            }
            datamap.add(maps);
            this.logger.info("datamap----------", datamap);
        }
        return datamap;
    }

    @RequestMapping(value={"queryCardUseNum.json"}, name="\u67e5\u8be2\u53ef\u53d1\u653e\u5916\u90e8\u5238\u6570\u91cf")
    @ResponseBody
    public int queryCardUseNum(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        SupQueryResult cdCardpReDomainSupQueryResult = this.cdCardpServiceRepository.queryCardpPage(map);
        if (null == cdCardpReDomainSupQueryResult || ListUtil.isEmpty((Collection)cdCardpReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryCardUseNum.cdCardpReDomainSupQueryResult.null", (Object)map.toString());
            return 0;
        }
        CdCardpReDomain cdCardpReDomain = (CdCardpReDomain)cdCardpReDomainSupQueryResult.getList().get(0);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("tenantCode", cdCardpReDomain.getTenantCode());
        queryMap.put("discountCode", cdCardpReDomain.getCardpCode());
        SupQueryResult supQueryResult = this.pmPromotionDiscountlistServiceRepository.queryPromotionDiscountlistPage(queryMap);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".queryCardUseNum.supQueryResult.null", (Object)((Object)queryMap).toString());
            return 0;
        }
        Integer num = 0;
        for (PmPromotionDiscountlistReDomain pmPromotionDiscountlistReDomain : supQueryResult.getList()) {
            num = num + pmPromotionDiscountlistReDomain.getDiscountAmount();
        }
        this.logger.error(CODE + ".queryCardUseNum.num", (Object)num);
        BigDecimal subtract = cdCardpReDomain.getCardpCnum().subtract(new BigDecimal(num));
        return subtract.intValue();
    }
}

