/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cms.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsNoticeConfigDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsNoticeDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsNoticeReDomain;
import com.qjsoft.laser.controller.facade.cms.repository.CmsNoticeServiceRepository;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelTagvalueReDomain;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsModelTagvalueServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/noticeBusiness"}, name="\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
public class NoticeBusCon
extends SpringmvcController {
    private static String CODE = "cms.notice.con";
    @Autowired
    private CmsNoticeServiceRepository cmsNoticeServiceRepository;
    @Autowired
    private PfsModelTagvalueServiceRepository pfsModelTagvalueServiceRepository;

    protected String getContext() {
        return "notice";
    }

    @RequestMapping(value={"saveNotice.json"}, name="\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeServiceRepository.saveNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"saveNoticePop.json"}, name="\u589e\u52a0\u5f39\u7a97\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean saveNoticePop(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveNoticeNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsNoticeDomain cmsNoticeDomain = (CmsNoticeDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, CmsNoticeDomain.class);
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        cmsNoticeDomain.setTenantCode(tenantCode);
        cmsNoticeDomain.setMemberCode(userSession.getUserPcode());
        cmsNoticeDomain.setMemberName(userSession.getMerberCompname());
        if (StringUtils.isBlank((String)cmsNoticeDomain.getNoticeType()) || "0".equals(cmsNoticeDomain.getNoticeType())) {
            cmsNoticeDomain.setNoticeType("0");
            if (StringUtils.isBlank((String)cmsNoticeDomain.getNoticeSort()) || StringUtils.isBlank((String)cmsNoticeDomain.getPublishingType())) {
                this.logger.error(CODE + ".saveNoticeNew.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
            }
        }
        if (StringUtils.isBlank((String)cmsNoticeDomain.getPublishingType())) {
            cmsNoticeDomain.setPublishingType("1");
        }
        if ("1".equals(cmsNoticeDomain.getPublishingType()) && (cmsNoticeDomain.getNoticeStart() == null || cmsNoticeDomain.getNoticeEnd() == null)) {
            this.logger.error(CODE + ".saveNoticeNew.time", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
        }
        HtmlJsonReBean htmlJsonReBean = this.cmsNoticeServiceRepository.saveNotice(cmsNoticeDomain);
        List cmsNoticeConfigDomainList = cmsNoticeDomain.getCmsNoticeConfigDomainList();
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess() && ListUtil.isNotEmpty((Collection)cmsNoticeConfigDomainList)) {
            String noticeCode = htmlJsonReBean.getDataObj().toString();
            for (CmsNoticeConfigDomain cmsNoticeConfigDomain : cmsNoticeConfigDomainList) {
                cmsNoticeConfigDomain.setTenantCode(tenantCode);
                cmsNoticeConfigDomain.setNoticeCode(noticeCode);
                cmsNoticeConfigDomain.setNoticeConfigType("=");
            }
            this.cmsNoticeServiceRepository.saveNoticeConfigBatch(cmsNoticeConfigDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateNoticePop.json"}, name="\u7f16\u8f91\u5f39\u7a97\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateNoticePop(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateNoticeNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsNoticeDomain cmsNoticeDomain = (CmsNoticeDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, CmsNoticeDomain.class);
        CmsNoticeReDomain notice = this.cmsNoticeServiceRepository.getNotice(cmsNoticeDomain.getNoticeId());
        if (null == notice) {
            this.logger.error(CODE + ".updateNoticeNew.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4e0d\u5b58\u5728");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)notice, (Object)cmsNoticeDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String tenantCode = this.getTenantCode(request);
        HtmlJsonReBean htmlJsonReBean = this.cmsNoticeServiceRepository.updateNotice((CmsNoticeDomain)notice);
        List cmsNoticeConfigDomainList = cmsNoticeDomain.getCmsNoticeConfigDomainList();
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess() && ListUtil.isNotEmpty((Collection)cmsNoticeConfigDomainList)) {
            String noticeCode = notice.getNoticeCode();
            for (CmsNoticeConfigDomain cmsNoticeConfigDomain : cmsNoticeConfigDomainList) {
                cmsNoticeConfigDomain.setNoticeConfigId(null);
                cmsNoticeConfigDomain.setNoticeConfigCode(null);
                cmsNoticeConfigDomain.setTenantCode(tenantCode);
                cmsNoticeConfigDomain.setNoticeCode(noticeCode);
                cmsNoticeConfigDomain.setNoticeConfigType("=");
            }
            this.cmsNoticeServiceRepository.saveNoticeConfigBatch(cmsNoticeConfigDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateNoticeStateNew.json"}, name="\u516c\u544a\u542f\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean updateNoticeStateNew(HttpServletRequest request, String noticeId, String dataState) {
        if (StringUtils.isBlank((String)noticeId) || StringUtils.isBlank((String)dataState)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u5168");
        }
        CmsNoticeReDomain notice = this.cmsNoticeServiceRepository.getNotice(Integer.valueOf(noticeId));
        if (notice == null) {
            this.logger.error(CODE + ".updateNoticeState.noticeId", (Object)noticeId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u88ab\u5220\u9664");
        }
        Date date = new Date();
        HashMap<String, Date> map = new HashMap<String, Date>();
        if ("1".equals(dataState)) {
            if (0 != notice.getDataState()) {
                this.logger.error(CODE + ".updateNoticeState.getDataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u516c\u544a\u4e0d\u80fd\u53d1\u5e03");
            }
            if (notice.getNoticeEnd() != null && date.getTime() > notice.getNoticeEnd().getTime()) {
                this.logger.error(CODE + ".updateNoticeState.getNoticeEnd", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u53d1\u5e03");
            }
            map.put("noticeStart", date);
            return this.cmsNoticeServiceRepository.updateNoticeState(notice.getNoticeId(), Integer.valueOf(1), Integer.valueOf(0), map);
        }
        if ("0".equals(dataState)) {
            if (1 != notice.getDataState()) {
                this.logger.error(CODE + ".updateNoticeState.getDataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u516c\u544a\u4e0d\u80fd\u505c\u7528");
            }
            map.put("noticeEnd", date);
            return this.cmsNoticeServiceRepository.updateNoticeState(notice.getNoticeId(), Integer.valueOf(0), Integer.valueOf(1), map);
        }
        if ("-1".equals(dataState)) {
            return this.cmsNoticeServiceRepository.updateNoticeState(notice.getNoticeId(), Integer.valueOf(-1), notice.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getNotice.json"}, name="\u83b7\u53d6\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".getNotice", (Object)"param is null");
            return null;
        }
        return this.cmsNoticeServiceRepository.getNotice(noticeId);
    }

    @RequestMapping(value={"updateNotice.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".updateNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeServiceRepository.updateNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"deleteNotice.json"}, name="\u5220\u9664\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeServiceRepository.deleteNotice(noticeId);
    }

    @RequestMapping(value={"queryNoticePage.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cmsNoticeServiceRepository.queryNoticePage(param);
    }

    @RequestMapping(value={"updateNoticeState.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateNoticeState(String noticeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)noticeId)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeServiceRepository.updateNoticeState(Integer.valueOf(noticeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryNoticePageListByPlat.json"}, name="C\u7aef\u67e5\u8be2\u516c\u544a")
    @ResponseBody
    public List<CmsNoticeDomain> queryNoticePageListByPlat(HttpServletRequest request, String noticeType, Integer modelTagvalueId) throws Exception {
        if (StringUtils.isBlank((String)noticeType)) {
            return null;
        }
        PfsModelTagvalueReDomain modelTagvalue = this.pfsModelTagvalueServiceRepository.getModelTagvalue(modelTagvalueId);
        if (modelTagvalue == null) {
            throw new Exception("\u627e\u4e0d\u5230\u4f4e\u4ee3\u7801\u6570\u636e");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyCode", modelTagvalue.getMemberCode());
        return this.cmsNoticeServiceRepository.queryNoticePageList(map, this.getTenantCode(request), noticeType);
    }
}

