/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.co.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.co.domain.CoCorderDomain;
import com.qjsoft.laser.controller.facade.co.domain.CoCorderReDomain;
import com.qjsoft.laser.controller.facade.co.repository.CoCorderServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/co/corder"}, name="\u5408\u540c\u8ba2\u5355")
public class CorderCon
extends SpringmvcController {
    private static String CODE = "co.corder.con";
    @Autowired
    private CoCorderServiceRepository coCorderServiceRepository;

    protected String getContext() {
        return "corder";
    }

    @RequestMapping(value={"saveCorder.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderServiceRepository.saveCorder(coCorderDomain);
    }

    @RequestMapping(value={"getCorder.json"}, name="\u83b7\u53d6\u5408\u540c\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public CoCorderReDomain getCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".getCorder", (Object)"param is null");
            return null;
        }
        return this.coCorderServiceRepository.getCorder(corderId);
    }

    @RequestMapping(value={"updateCorder.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".updateCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderServiceRepository.updateCorder(coCorderDomain);
    }

    @RequestMapping(value={"deleteCorder.json"}, name="\u5220\u9664\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".deleteCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderServiceRepository.deleteCorder(corderId);
    }

    @RequestMapping(value={"queryCorderPage.json"}, name="\u67e5\u8be2\u5408\u540c\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CoCorderReDomain> queryCorderPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.coCorderServiceRepository.queryCorderPage(param);
    }

    @RequestMapping(value={"updateCorderState.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCorderState(String corderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)corderId)) {
            this.logger.error(CODE + ".updateCorderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderServiceRepository.updateCorderState(Integer.valueOf(corderId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"downLoadFile.json"}, name="\u4e0b\u8f7d\u6587\u4ef6")
    @ResponseBody
    public ResponseEntity<byte[]> downLoadFile(String fileName) {
        if (null == fileName) {
            this.logger.error(CODE + ".fileName", (Object)"param is null");
            return null;
        }
        return this.coCorderServiceRepository.downLoadFile(fileName);
    }
}

