/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumListServiceRepository;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.data.domain.DaOpsumListDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListReDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsumlist"}, name="\u6c47\u603b\u6570\u636e\u660e\u7ec6")
public class OpsumlistCon
extends SpringmvcController {
    private static String CODE = "da.opsumlist.con";
    @Autowired
    private DaOpsumListServiceRepository daOpsumListServiceRepository;
    @Autowired
    private DaOpsumServiceRepository daOpsumServiceRepository;

    protected String getContext() {
        return "opsumlist";
    }

    @RequestMapping(value={"saveOpsumlist.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".saveOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.saveOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"getOpsumlist.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public DaOpsumListReDomain getOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".getOpsumlist", (Object)"param is null");
            return null;
        }
        return this.daOpsumListServiceRepository.getOpsumList(opsumlistId);
    }

    @RequestMapping(value={"updateOpsumlist.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".updateOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.updateOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"deleteOpsumlist.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".deleteOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.deleteOpsumList(opsumlistId);
    }

    @RequestMapping(value={"queryOpsumlistPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    @RequestMapping(value={"updateOpsumlistState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlistState(String opsumlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumlistId)) {
            this.logger.error(CODE + ".updateOpsumlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.updateOpsumListState(Integer.valueOf(opsumlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumListPageForPlat.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u79df\u6237")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForPlat(HttpServletRequest request, String sumType) {
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(tenantCode, sumType, tenantCode);
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForUser.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5356\u5bb6")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForUser(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForYunying.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForYunying(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    private Map<String, Object> queryOpsumListPageComm(String userPcode, String sumType, String tenantCode) {
        SupQueryResult daOpsumReDomainSupQueryResult2;
        SupQueryResult daOpsumReDomainSupQueryResult;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("order", true);
            param.put("opsumDate", formatDateLast);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", userPcode);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param)) || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return this.queryOpsumListPageCommToday(userPcode, sumType, tenantCode, resultMap);
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != map) {
            map.put("tenantCode", tenantCode);
            map.put("opsumCode", opsumCode);
            map.put("opsumDate", formatDateLast);
        }
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultLast = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult daOpsumListReDomainSupQueryResult = this.daOpsumListServiceRepository.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            List list = daOpsumListReDomainSupQueryResult.getList();
            for (DaOpsumListReDomain daOpsumListReDomain : list) {
                daOpsumListReDomain.setOpsumDate("\u6628\u65e5");
                daOpsumListReDomainsResultLast.add(daOpsumListReDomain);
            }
        }
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        if (null != param) {
            paramToday.put("tenantCode", tenantCode);
            paramToday.put("order", true);
            paramToday.put("opsumDate", today);
            paramToday.put("opsumType", sumType);
            paramToday.put("opsumDimcode", userPcode);
        }
        if (null == (daOpsumReDomainSupQueryResult2 = this.daOpsumServiceRepository.queryOpsumPage(paramToday)) || daOpsumReDomainSupQueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult2", (Object)"result is null");
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", "0");
            return resultMap;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)daOpsumReDomainSupQueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, String> mapmap = new HashMap<String, String>();
        if (null != paramToday) {
            mapmap.put("opsumCode", opsumCodeToday);
            mapmap.put("tenantCode", tenantCode);
            mapmap.put("opsumDate", today);
        }
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult todayResult = this.daOpsumListServiceRepository.queryOpsumListPage(mapmap);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    private Map<String, Object> queryOpsumListPageCommToday(String userPcode, String sumType, String tenantCode, Map<String, Object> resultMap) {
        SupQueryResult QueryResult;
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        String pattern = "yyyy-MM-dd";
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("order", true);
            param.put("opsumDate", today);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", userPcode);
        }
        if (null == (QueryResult = this.daOpsumServiceRepository.queryOpsumPage(param)) || QueryResult.getList().isEmpty()) {
            this.logger.error(CODE + "queryOpsumListPageCommToday.QueryResult.QueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)QueryResult.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, String> paramToday = new HashMap<String, String>();
        paramToday.put("opsumCode", opsumCodeToday);
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult todayResult = this.daOpsumListServiceRepository.queryOpsumListPage(paramToday);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", "0");
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumListNextPageForSeller.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForSeller(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForSeller" + "param is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForSeller" + "result is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForBusiness.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForBusiness(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusiness" + "param is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusiness" + "result is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForPlat.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForPlat(HttpServletRequest request, String sumType) {
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlat" + "param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(tenantCode, sumType, tenantCode);
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlat" + "result is null");
            return null;
        }
        return result;
    }

    private SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageComm(String opsumDimcode, String sumType, String tenantCode) {
        SupQueryResult daOpsumListReDomainSupQueryResult;
        SupQueryResult daOpsumReDomainSupQueryResult;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("order", true);
            param.put("tenantCode", tenantCode);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", opsumDimcode);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param)) || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListNextPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != map) {
            map.put("opsumCode", opsumCode);
            map.put("tenantCode", tenantCode);
        }
        if (null != (daOpsumListReDomainSupQueryResult = this.daOpsumListServiceRepository.queryOpsumListPage(map))) {
            return daOpsumListReDomainSupQueryResult;
        }
        return null;
    }
}

