/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ddFalgSetting.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingDomain;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dd/discountRatio"}, name="\u4f18\u60e0\u5360\u6bd4")
public class ContractDiscountRatioCon
extends SpringmvcController {
    private static String CODE = "dd.discountRatio.con";
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;

    protected String getContext() {
        return "discountRatio";
    }

    @RequestMapping(value={"queryContractDiscountRatio.json"}, name="\u67e5\u8be2\u8ba2\u5355\u4f18\u60e0\u5360\u6bd4\u63a7\u5236\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DdFalgSettingReDomain> queryContractDiscountRatio(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingCode", "contractDiscountRatio");
        map.put("flagSettingType", "contractDiscountRatio");
        map.put("tenantCode", this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
    }

    @RequestMapping(value={"saveContractDiscountRatio.json"}, name="\u589e\u52a0\u8ba2\u5355\u4f18\u60e0\u5360\u6bd4\u63a7\u5236")
    @ResponseBody
    public HtmlJsonReBean saveContractDiscountRatio(HttpServletRequest request, String ddFalgSettingDomainJson) {
        if (null == ddFalgSettingDomainJson) {
            this.logger.error(CODE + ".saveContractDiscountRatio", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DdFalgSettingDomain ddFalgSettingDomain = (DdFalgSettingDomain)JsonUtil.buildNormalBinder().getJsonToObject(ddFalgSettingDomainJson, DdFalgSettingDomain.class);
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        ddFalgSettingDomain.setFlagSettingCode("contractDiscountRatio");
        ddFalgSettingDomain.setFlagSettingType("contractDiscountRatio");
        return this.ddFalgSettingServiceRepository.saveFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"updateContractDiscountRatio.json"}, name="\u66f4\u65b0\u4f18\u60e0\u5360\u6bd4")
    @ResponseBody
    public HtmlJsonReBean updateContractDiscountRatio(HttpServletRequest request, String ddFalgSettingDomainJson) {
        if (null == ddFalgSettingDomainJson) {
            this.logger.error(CODE + ".saveContractDiscountRatio", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DdFalgSettingDomain ddFalgSettingDomain = (DdFalgSettingDomain)JsonUtil.buildNormalBinder().getJsonToObject(ddFalgSettingDomainJson, DdFalgSettingDomain.class);
        ddFalgSettingDomain.setFlagSettingCode("contractDiscountRatio");
        ddFalgSettingDomain.setFlagSettingType("contractDiscountRatio");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.updateFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"updateContractDiscountRatioByStart.json"}, name="\u66f4\u65b0\u4f18\u60e0\u5360\u6bd4\u72b6\u6001\uff08\u5173\u95ed-\u5f00\u542f\uff09")
    @ResponseBody
    public HtmlJsonReBean updateContractDiscountRatioByStart(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".updateContractDiscountRatioByStart", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingServiceRepository.updateFalgSettingState(Integer.valueOf(flagSettingId), Integer.valueOf(1), Integer.valueOf(-1));
    }

    @RequestMapping(value={"updateContractDiscountRatioByStop.json"}, name="\u66f4\u65b0\u4f18\u60e0\u5360\u6bd4\u72b6\u6001\uff08\u5f00\u542f-\u5173\u95ed\uff09")
    @ResponseBody
    public HtmlJsonReBean updateContractDiscountRatioStateByStop(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".updateContractDiscountRatioByStop", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingServiceRepository.updateFalgSettingState(Integer.valueOf(flagSettingId), Integer.valueOf(-1), Integer.valueOf(1));
    }

    @RequestMapping(value={"updateContractDiscountRatioState.json"}, name="\u66f4\u65b0\u4f18\u60e0\u5360\u6bd4\u72b6\u6001\uff08\u5f85\u5ba1\u6838-\u5f00\u542f\uff09")
    @ResponseBody
    public HtmlJsonReBean updateContractDiscountRatioState(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".updateContractDiscountRatioState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingServiceRepository.updateFalgSettingState(Integer.valueOf(flagSettingId), Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"deleteContractDiscountRatioState.json"}, name="\u5220\u9664\u4f18\u60e0\u5360\u6bd4")
    @ResponseBody
    public HtmlJsonReBean deleteContractDiscountRatioState(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".deleteContractDiscountRatioState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Integer integer = Integer.valueOf(flagSettingId);
        DdFalgSettingReDomain falgSetting = this.ddFalgSettingServiceRepository.getFalgSetting(integer);
        if (null == falgSetting || !"contractDiscountRatio".equals(falgSetting.getFlagSettingScope())) {
            this.logger.error(CODE + ".deleteContractDiscountRatioState.falgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.ddFalgSettingServiceRepository.deleteFalgSetting(integer);
    }
}

