/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceConfDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dprice"}, name="\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
public class DpriceCon
extends SpringmvcController {
    private static String CODE = "dis.dprice.con";
    @Autowired
    private DisDpriceServiceRepository disDpriceServiceRepository;

    protected String getContext() {
        return "dprice";
    }

    @RequestMapping(value={"saveDprice.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDprice(HttpServletRequest request, DisDpriceDomain disDpriceDomain) {
        if (null == disDpriceDomain) {
            this.logger.error(CODE + ".saveDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"saveDpriceAndConf.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u660e\u7ec6\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDpriceAndConf(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        disDpriceDomain.setMemberCode(userSession.getUserPcode());
        disDpriceDomain.setMemberName(userSession.getUserName());
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        if (ListUtil.isNotEmpty((Collection)disDpriceDomain.getDisDpriceConfList())) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomain.getDisDpriceConfList()) {
                disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
            }
        }
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"getDprice.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        DisDpriceReDomain dprice = this.disDpriceServiceRepository.getDprice(dpriceConfId);
        return dprice;
    }

    @RequestMapping(value={"updateDprice.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDprice(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        return this.disDpriceServiceRepository.updateDprice(disDpriceDomain);
    }

    @RequestMapping(value={"deleteDprice.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceConfId);
    }

    @RequestMapping(value={"queryDpricePage.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult disDpriceReDomainSupQueryResult = this.disDpriceServiceRepository.queryDpricePage(param);
        return disDpriceReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateDpriceState.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceState(String dpriceConfId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceConfId)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.updateDpriceState(Integer.valueOf(dpriceConfId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryDpricePageBySS.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePageBySS(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != param.get("channelSort") && "3".equals(param.get("channelSort"))) {
            param.remove("channelSort");
            param.put("channelType", "1");
        }
        return this.disDpriceServiceRepository.queryDpricePage(param);
    }

    @RequestMapping(value={"saveDisDpriceConfByJson.json"}, name="\u5e93\u5b58\u9002\u7528\u8303\u56f4\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveDisDpriceConfByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDpriceConfDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDpriceConfDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (ListUtil.isNotEmpty((Collection)disDpriceConfDomainList)) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
                disDpriceConfDomain.setTenantCode(tenantCode);
            }
            return this.disDpriceServiceRepository.saveDpriceConfBatch(disDpriceConfDomainList);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"getDpriceAndConf.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDpriceAndConf(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        return this.disDpriceServiceRepository.getDprice(dpriceId);
    }

    @RequestMapping(value={"deleteDpriceById.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceById(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceId);
    }
}

