/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisContractDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisContractReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisContractServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/contract"}, name="\u6e20\u9053\u8ba2\u5355")
public class DisContractCon
extends SpringmvcController {
    private static String CODE = "dis.contract.con";
    @Autowired
    private DisContractServiceRepository disContractServiceRepository;

    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u6e20\u9053\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, DisContractDomain disContractDomain) {
        if (null == disContractDomain) {
            this.logger.error(CODE + ".saveContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disContractDomain.setTenantCode(this.getTenantCode(request));
        return this.disContractServiceRepository.saveContract(disContractDomain);
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u6e20\u9053\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public DisContractReDomain getContract(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.disContractServiceRepository.getContract(contractId);
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u6e20\u9053\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, DisContractDomain disContractDomain) {
        if (null == disContractDomain) {
            this.logger.error(CODE + ".updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disContractDomain.setTenantCode(this.getTenantCode(request));
        return this.disContractServiceRepository.updateContract(disContractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u6e20\u9053\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteContract(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disContractServiceRepository.deleteContract(contractId);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disContractServiceRepository.queryContractPage(param);
    }

    @RequestMapping(value={"queryContractPageForStore.json"}, name="\u67e5\u8be2\u6e20\u9053\u8ba2\u5355\u5206\u9875\u5217\u8868-\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<DisContractReDomain> queryContractPageForStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCcode", this.getMerchantCode(request));
        }
        param.put("contractSendstate", "0");
        return this.disContractServiceRepository.queryContractPage(param);
    }

    @RequestMapping(value={"queryContractPageForPlat.json"}, name="\u67e5\u8be2\u6e20\u9053\u8ba2\u5355\u5206\u9875\u5217\u8868-\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisContractReDomain> queryContractPageForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractSendstate", "0");
        return this.disContractServiceRepository.queryContractPage(param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u6e20\u9053\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disContractServiceRepository.updateContractState(Integer.valueOf(contractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getContractDomainByCode.json"}, name="\u83b7\u53d6\u6e20\u9053\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public DisContractDomain getContractDomainByCode(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".getContractDomainByCode", (Object)"param is null");
            return null;
        }
        return this.disContractServiceRepository.getContractDomainByCode(this.getTenantCode(request), contractBillcode);
    }
}

