/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisContractDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisDictionaryServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DisInit
extends SpringmvcController {
    private static String CODE = "dis.init.con";
    @Autowired
    protected DisDictionaryServiceRepository disDictionaryServiceRepository;
    @Autowired
    protected RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    protected RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    protected RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    protected UserServiceRepository userServiceRepository;
    private String cacheDictionarykey = "DisDictionary-channelCode";

    protected String getContext() {
        return "init";
    }

    private Map<String, RsSkuReDomain> makeSku(List<RsSkuReDomain> rsSkuReDomainList) {
        if (ListUtil.isEmpty(rsSkuReDomainList)) {
            return null;
        }
        HashMap<String, RsSkuReDomain> map = new HashMap<String, RsSkuReDomain>();
        for (RsSkuReDomain rsSkuReDomain : rsSkuReDomainList) {
            map.put(rsSkuReDomain.getSkuNo(), rsSkuReDomain);
        }
        return map;
    }

    protected HtmlJsonReBean updateGoodsCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".checkGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        SupQueryResult qsku = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == qsku || ListUtil.isEmpty((Collection)qsku.getList())) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("memberCode", memberCcode);
        parammap.put("tenantCode", tenantCode);
        parammap.put("channelCode", channelCode);
        String msg = "";
        for (RsResourceGoodsReDomain rsResourceGoodsReDomain : qsku.getList()) {
            parammap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            parammap.put("name", StringUtils.isBlank((String)rsResourceGoodsReDomain.getGoodsShowname()) ? rsResourceGoodsReDomain.getGoodsName() : rsResourceGoodsReDomain.getGoodsShowname());
            parammap.put("goodsClass", rsResourceGoodsReDomain.getClasstreeShopname() == null ? rsResourceGoodsReDomain.getClasstreeName() : rsResourceGoodsReDomain.getClasstreeShopname());
            parammap.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
            HtmlJsonReBean htmlJsonReBean = this.updateGoods(parammap, channelCode, memberCcode, tenantCode);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            msg = msg + rsResourceGoodsReDomain.getGoodsShowname() + "[" + htmlJsonReBean.getMsg() + "];";
        }
        if (StringUtils.isBlank((String)msg)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
    }

    protected List<String> checkGoodsCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        List<Map<String, Object>> qrelist;
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".checkGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        ArrayList<String> noList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (channelCode.equals("jddj")) {
            map.put("memberCode", memberCode);
        } else {
            map.put("memberCcode", memberCcode);
            map.put("channelCode", channelCode);
        }
        map.put("tenantCode", tenantCode);
        SupQueryResult qsku = this.rsSkuServiceRepository.querySkuOnePage(map);
        if (null == qsku || ListUtil.isEmpty((Collection)qsku.getList())) {
            noList.add("\u5e73\u53f0\u95e8\u5e97\u6e20\u9053\u6ca1\u6709\u5546\u54c1\u4fe1\u606f");
            return noList;
        }
        Map<String, RsSkuReDomain> skumap = this.makeSku(qsku.getList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCcode);
        param.put("tenantCode", tenantCode);
        param.put("channelCode", channelCode);
        int no = 0;
        param.put("offset", no);
        param.put("limit", 200);
        param.put("pageNo", no + 1);
        while (null != (qrelist = this.querySendGoods(param, channelCode, memberCcode, tenantCode)) && !ListUtil.isEmpty(qrelist)) {
            this.checkComSku(skumap, qrelist, noList);
            param.put("pageNo", ++no);
            param.put("offset", no * 200 + 1);
        }
        if (MapUtil.isNotEmpty(skumap)) {
            for (String key : skumap.keySet()) {
                noList.add("\u8d27\u53f7:\u3010" + key + "\u3011\u5728\u4e09\u65b9\u6e20\u9053\u4e0d\u5b58\u5728");
            }
        }
        return noList;
    }

    protected abstract void checkComSku(Map<String, RsSkuReDomain> var1, List<Map<String, Object>> var2, List<String> var3);

    protected abstract HtmlJsonReBean updateGoods(Map<String, Object> var1, String var2, String var3, String var4);

    protected HtmlJsonReBean saveDictionaryClassCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        UmUserinfoReDomainBean userinfoByCode;
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".saveDictionaryClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)memberCode) && null != (userinfoByCode = this.userServiceRepository.getUserinfoByCode(memberCcode, tenantCode))) {
            memberCode = userinfoByCode.getUserinfoParentCode();
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        SupQueryResult qrelist = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null == qrelist || ListUtil.isEmpty((Collection)qrelist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u6570\u636e:" + ((Object)param).toString());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        String msg = "";
        for (RsGoodsClassReDomain rsGoodsClassReDomain : qrelist.getList()) {
            map.put("rsGoodsClassDomain", rsGoodsClassReDomain);
            HtmlJsonReBean htmlJsonReBean = this.updateSendClassCodeByName(map, channelCode, memberCcode, tenantCode);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            msg = msg + rsGoodsClassReDomain.getGoodsClassName() + "[" + htmlJsonReBean.getMsg() + "];";
        }
        if (StringUtils.isBlank((String)msg)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
    }

    protected String getDictionaryValue(String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        return this.getDictionaryComValue(this.cacheDictionarykey, tenantCode, channelCode, dictionaryType, propertis, value);
    }

    protected String getShoppingId(String tenantCode, String channelCode, String memberCode) {
        String shoppingId = this.getDictionaryValue(tenantCode, channelCode, "UmUserinfo", "userinfoCode", memberCode);
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.debug(CODE + ".getShoppingId.shoppingId", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        return shoppingId;
    }

    private String getDictionaryComValue(String cachekey, String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        if (StringUtils.isBlank((String)cachekey) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)propertis) || StringUtils.isBlank((String)value)) {
            this.logger.debug(CODE + ".getDictionaryComValue.param");
            return null;
        }
        String valueStr = SupDisUtil.getMap((String)cachekey, (String)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
        if (StringUtils.isBlank((String)valueStr)) {
            this.logger.debug(CODE + ".getDictionaryComValue.valueStr", (Object)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
            return null;
        }
        String[] values = valueStr.split("\\,");
        if (null == values || values.length < 1) {
            return null;
        }
        return values[1];
    }

    public HtmlJsonReBean updateAppFoodCodeByNameAndSpec(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disGoods.updateAppFoodCodeByNameAndSpec");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSendClassCodeByName(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disGoods.updateSendClassCodeByName");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<Map<String, Object>> querySendClass(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disGoods.querySendClass");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        String s = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return (List)JsonUtil.buildNormalBinder().getJsonToList(s, Map.class);
    }

    public List<Map<String, Object>> querySendGoods(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disGoods.querySendGoods");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        String s = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return (List)JsonUtil.buildNormalBinder().getJsonToList(s, Map.class);
    }

    public DisContractDomain getSendOrder(String contractNbillcode, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disOrder.getSendOrder");
        pmap.putParam("contractNbillcode", (Object)contractNbillcode);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (DisContractDomain)this.htmlIBaseService.sendMes(pmap, DisContractDomain.class);
    }

    public HtmlJsonReBean saveSendOrderState(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("cmc.disOrder.saveSendOrderState");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

