/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.dis.controller.DisInit;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/initJddj"}, name="\u4eac\u4e1c\u5230\u5bb6\u6e20\u9053\u521d\u59cb\u5316")
public class DisInitJddj
extends DisInit {
    protected static String CODE = "dis.initJddj.con";
    private String channelCode = "jddj";

    @Override
    protected String getContext() {
        return "initJddj";
    }

    @RequestMapping(value={"checkClass.json"}, name="\u95e8\u5e97\u5206\u7c7b\u68c0\u67e5")
    @ResponseBody
    public HtmlJsonReBean checkClass(HttpServletRequest request, String memberCcode, String memberCode) {
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveDictionaryClass.json"}, name="\u95e8\u5e97\u5206\u7c7b\u521d\u59cb\u5316")
    @ResponseBody
    public HtmlJsonReBean saveDictionaryClass(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.saveDictionaryClassCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"checkGoods.json"}, name="\u95e8\u5e97\u5546\u54c1\u68c0\u6d4b")
    @ResponseBody
    public List<String> checkGoods(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.checkGoodsCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"updateGoods.json"}, name="\u95e8\u5e97\u5546\u54c1\u521d\u59cb\u5316")
    @ResponseBody
    public HtmlJsonReBean updateGoods(HttpServletRequest request, String memberCcode, String memberCode) {
        return this.updateGoodsCom(request, this.channelCode, memberCcode, memberCode);
    }

    @RequestMapping(value={"saveOrder.json"}, name="\u62c9\u53d6\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOrder(HttpServletRequest request, String contractNbillcode, String memberCode) {
        if (StringUtils.isBlank((String)contractNbillcode)) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> params = this.creatParams(request, contractNbillcode, memberCode);
        return this.saveSendOrderState(params, this.channelCode, memberCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveOrderForPlat.json"}, name="\u8fd0\u8425\u7aef\u62c9\u53d6\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOrderForPlat(HttpServletRequest request, String contractNbillcode, String memberCode) {
        if (StringUtils.isBlank((String)contractNbillcode)) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> params = this.creatParams(request, contractNbillcode, memberCode);
        return this.saveSendOrderState(params, this.channelCode, memberCode, this.getTenantCode(request));
    }

    private Map<String, Object> creatParams(HttpServletRequest request, String contractNbillcode, String memberCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("billId", contractNbillcode);
        body.put("memberCode", memberCode);
        body.put("channelCode", this.channelCode);
        body.put("tenantCode", this.getTenantCode(request));
        params.put("jd_param_json", JsonUtil.buildNormalBinder().toJson(body));
        params.put("app_key", "3");
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("v", "1");
        params.put("sign", "b9b0d0a16d5a723e");
        params.put("format", "37333");
        return params;
    }

    @Override
    protected HtmlJsonReBean updateGoods(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return new HtmlJsonReBean((Object)"error");
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)map.get("rsResourceGoodsReDomain");
        if (null == rsResourceGoodsReDomain) {
            new HtmlJsonReBean((Object)"error");
        }
        this.rsResourceGoodsServiceRepository.updateGoodsEocode(rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsNo(), tenantCode);
        if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsSkuDomainList())) {
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                this.rsResourceGoodsServiceRepository.updateSkuEocode(rsSkuDomain.getSkuCode(), rsSkuDomain.getSkuNo(), tenantCode);
            }
        }
        return new HtmlJsonReBean();
    }

    @Override
    protected void checkComSku(Map<String, RsSkuReDomain> skumap, List<Map<String, Object>> relist, List<String> noList, Map<String, String> skunoMap) {
        if (null == skumap || ListUtil.isEmpty(relist) || null == noList || null == skunoMap) {
            return;
        }
        for (Map<String, Object> mapParam : relist) {
            String sku_id = (String)mapParam.get("outSkuId");
            RsSkuReDomain rsSkuReDomain = skumap.remove(sku_id);
            String name = (String)mapParam.get("skuName");
            if (null != rsSkuReDomain) {
                if (StringUtils.isBlank((String)rsSkuReDomain.getClasstreeShopcode()) || StringUtils.isBlank((String)rsSkuReDomain.getGoodsShowname())) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5206\u7c7b\u6216\u663e\u793a\u540d\u79f0\u672a\u8bbe\u7f6e");
                }
                if (StringUtils.isBlank((String)rsSkuReDomain.getGoodsShowname()) || !rsSkuReDomain.getGoodsShowname().equals(name)) {
                    noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u540d\u79f0\u4e0d\u4e00\u81f4(\u4e2d\u53f0\uff1a" + rsSkuReDomain.getGoodsShowname() + "\uff0c\u4e09\u65b9\u5e73\u53f0" + name + ")");
                }
            } else if (StringUtils.isNotBlank((String)skunoMap.get(sku_id))) {
                noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5728\u4e09\u65b9\u5e73\u53f0\u91cd\u590d");
            } else {
                noList.add("\u8d27\u53f7:\u3010" + sku_id + "\u3011\u5728\u95e8\u5e97\u6e20\u9053\u4e0d\u5b58\u5728");
            }
            skunoMap.put(sku_id, sku_id);
        }
    }
}

