/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelsendBaseServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDgoodsServiceRepository;
import com.qjsoft.laser.controller.facade.msc.domain.MscMschannelReDomain;
import com.qjsoft.laser.controller.facade.msc.repository.MscMschannelServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/channel"}, name="\u6e20\u9053\u5b9a\u4e49")
public class ChannelCon
extends SpringmvcController {
    private static String CODE = "dis.channel.con";
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private DisChannelsendBaseServiceRepository disChannelsendBaseServiceRepository;
    @Autowired
    private DisDgoodsServiceRepository disDgoodsServiceRepository;
    @Autowired
    private MscMschannelServiceRepository mscMschannelServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "channel";
    }

    @RequestMapping(value={"updateChannel.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelSale.json"}, name="\u66f4\u65b0\u9500\u552e\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannelSale(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelStore.json"}, name="\u66f4\u65b0\u95e8\u5e97\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannelStore(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelBySer.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateChannelBySer(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelFromZx.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean updateChannelFromZx(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChaFromZxBySer.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateChaFromZxBySer(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    private HtmlJsonReBean updateChannelMain(String tenantCode, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelName", disChannelDomain.getChannelName());
        SupQueryResult supQueryResult = this.disChannelServiceRepository.queryChannelPage(map);
        if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0 && !((DisChannelReDomain)supQueryResult.getList().get(0)).getChannelId().equals(disChannelDomain.getChannelId())) {
            this.logger.error(CODE + ".updateChannel", (Object)"\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
        }
        return this.disChannelServiceRepository.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"enableChannel.json"}, name="\u542f\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannel.json"}, name="\u505c\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelSale.json"}, name="\u542f\u7528\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannelSale(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelSale.json"}, name="\u505c\u7528\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannelSale(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelStore.json"}, name="\u542f\u7528\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannelStore(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelStore.json"}, name="\u505c\u7528\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannelStore(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelBySer.json"}, name="\u542f\u7528\u6e20\u9053-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean enableChannelBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelBySer.json"}, name="\u505c\u7528\u6e20\u9053-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean disconChannelBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelFromZx.json"}, name="\u542f\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean enableChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannelZx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelFromZx.json"}, name="\u505c\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean disconChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChaFromZxBySer.json"}, name="\u542f\u7528\u6e20\u9053-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean enableChaFromZxBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChaFromZxBySer.json"}, name="\u505c\u7528\u6e20\u9053-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean disconChaFromZxBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    private HtmlJsonReBean updateDateStateMain(Integer id, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)id)) {
            this.logger.error(CODE + ".updateDateStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.updateChannelState(Integer.valueOf(id), dataState, oldDataState);
    }

    @RequestMapping(value={"queryChannelPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "1");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageSale.json"}, name="\u67e5\u8be2\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageSale(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageStore.json"}, name="\u67e5\u8be2\u7c7b\u578b\u662f\u95e8\u5e97\u7684\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "1");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelBySer.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelBySer(HttpServletRequest request) {
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageSale.json"}, name="\u9500\u552e\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageSale(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageStore.json"}, name="\u95e8\u5e97\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "1");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPage.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "1");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChaFromConfigBySer.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChaFromConfigBySer(HttpServletRequest request) {
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("channelSort", (Boolean)((Object)"1"));
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageFromZx.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageFromZx(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "2");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChaFromZxBySer.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChaFromZxBySer(HttpServletRequest request) {
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("channelSort", (Boolean)((Object)"2"));
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageZx.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageFromZx(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "2");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"saveChannel.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".saveChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(this.getTenantCode(request));
        return this.disChannelServiceRepository.saveChannel(disChannelDomain);
    }

    @RequestMapping(value={"updateChannelState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateChannelState(String channelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".updateChannelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.updateChannelState(Integer.valueOf(channelId), dataState, oldDataState);
    }

    @RequestMapping(value={"deleteChannel.json"}, name="\u5220\u9664\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".deleteChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.deleteChannel(channelId);
    }

    @RequestMapping(value={"getChannel.json"}, name="\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisChannelReDomain getChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getChannel", (Object)"param is null");
            return null;
        }
        return this.disChannelServiceRepository.getChannel(channelId);
    }

    @RequestMapping(value={"getMscByDisChaCode.json"}, name="\u6839\u636e\u6e20\u9053\u53d6\u9891\u9053")
    @ResponseBody
    public List<MscMschannelReDomain> getMscChannelByDisCha(HttpServletRequest request) {
        String channelCode = this.getNowChannel(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        Map<String, Object> scopeMap = this.getDgoodsScopeList(channelCode, tenantCode);
        if (null == scopeMap) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.mscMschannelServiceRepository.queryMschannelPage(param);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return null;
        }
        ArrayList<MscMschannelReDomain> reDomains = new ArrayList<MscMschannelReDomain>();
        for (MscMschannelReDomain mscMschannelReDomain : supQueryResult.getList()) {
            if (!mscMschannelReDomain.getMschannelCode().equals(scopeMap.get(mscMschannelReDomain.getMschannelCode()))) continue;
            reDomains.add(mscMschannelReDomain);
        }
        return ListUtil.isEmpty(reDomains) ? null : reDomains;
    }

    private Map<String, Object> getDgoodsScopeList(String channelCode, String tenantCode) {
        DisDgoodsReDomain disDgoods = (DisDgoodsReDomain)SupDisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoodsReDomain.class);
        if (null == disDgoods) {
            return null;
        }
        List disDgoodsScopeLists = SupDisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + tenantCode), DisDgoodsScopelistReDomain.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopeLists)) {
            return null;
        }
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        for (DisDgoodsScopelistReDomain dgsl : disDgoodsScopeLists) {
            reMap.put(dgsl.getDgoodsScopelistValue(), dgsl.getDgoodsScopelistValue());
        }
        return reMap;
    }

    @RequestMapping(value={"queryChannelThirdParty.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u7ed1\u5b9a\u5e97\u94fa")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelThirdParty(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "2");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannel.json"}, name="\u67e5\u8be2\u9500\u552e\u7c7b\u7684\u6e20\u9053(\u9500\u552e\u548c\u76f4\u9500)")
    @ResponseBody
    public List<DisChannelReDomain> querySaleChannel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null == param) {
            return null;
        }
        param.put("channelSort", "0");
        ArrayList<DisChannelReDomain> relist = new ArrayList<DisChannelReDomain>();
        SupQueryResult saleList = this.disChannelServiceRepository.queryChannelPage(param);
        if (null != saleList && ListUtil.isNotEmpty((Collection)saleList.getList())) {
            relist.addAll(saleList.getList());
        }
        param.put("channelSort", "2");
        SupQueryResult qList = this.disChannelServiceRepository.queryChannelPage(param);
        if (null != qList && ListUtil.isNotEmpty((Collection)qList.getList())) {
            relist.addAll(qList.getList());
        }
        return relist;
    }

    @RequestMapping(value={"queryThirdPpartyChannel.json"}, name="\u67e5\u8be2\u7b2c\u4e09\u65b9\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryThirdPpartyChannel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("channelType", "2");
        param.put("channelSort", "0");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"getUrl.json"}, name="\u83b7\u53d6\u6388\u6743\u8df3\u8f6c\u9875\u9762\u8def\u7531")
    @ResponseBody
    public HtmlJsonReBean getUrl(HttpServletRequest request, String channelCode, String memberCode) {
        String url = this.disChannelServiceRepository.getUrl(channelCode, memberCode, this.getTenantCode(request));
        return new HtmlJsonReBean((Object)url);
    }

    @RequestMapping(value={"queryChannelPageBySS.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageBySS(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error("param++", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageBySSStr.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageBySSStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        param.put("goodsClass", "B2B");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannelPage.json"}, name="\u67e5\u8be2\u7528\u6237\u4e0b\u7684\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaleChannelPage(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageByMemberMoce.json"}, name="\u5f53\u524d\u767b\u5f55\u8005\u4e0b\u7ea7\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageByMemberMoce(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("channelSort", "0");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"saveChannelEx.json"}, name="\u6267\u884c\u6e20\u9053\u89c4\u5219")
    @ResponseBody
    public HtmlJsonReBean saveChannelEx(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".saveChannelEx", (Object)"param is null");
            return null;
        }
        return this.disChannelsendBaseServiceRepository.sendSaveDgoodsUpdate(channelCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryCompanyLoadCache.json"}, name="\u6267\u884c\u6e20\u9053\u89c4\u5219")
    @ResponseBody
    public HtmlJsonReBean queryCompanyLoadCache() {
        return this.disChannelServiceRepository.queryChannelLoadCache();
    }

    @RequestMapping(value={"saveDealerChannel.json"}, name="\u589e\u52a0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean saveDealerChannel(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("3");
        disChannelDomain.setChannelSort("3");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userServiceRepository.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        return this.disChannelServiceRepository.saveChannel(disChannelDomain);
    }

    @RequestMapping(value={"updateDealerChannel.json"}, name="\u66f4\u65b0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean updateDealerChannel(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("3");
        disChannelDomain.setChannelSort("3");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userServiceRepository.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        return this.disChannelServiceRepository.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"updateDealerChannelNew.json"}, name="\u66f4\u65b0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean updateDealerChannelNew(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("0");
        disChannelDomain.setChannelSort("0");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userServiceRepository.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        return this.disChannelServiceRepository.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"saveDealerChannelNew.json"}, name="\u66f4\u65b0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean saveDealerChannelNew(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "0");
        param.put("channelSort", "0");
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("0");
        disChannelDomain.setChannelSort("0");
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        if (ListUtil.isNotEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            for (DisChannelReDomain disChannelReDomain1 : disChannelReDomainSupQueryResult.getList()) {
                if (!disChannelReDomain1.getChannelCode().equals(disChannelDomain.getChannelCode())) continue;
                this.logger.error(CODE + ".updateDealerChannelNew", (Object)"\u6e20\u9053\u7f16\u53f7\u91cd\u590d");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
        }
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userServiceRepository.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        HtmlJsonReBean disChannel = this.disChannelServiceRepository.saveChannel(disChannelDomain);
        param.put("channelCode", disChannelDomain.getChannelCode());
        SupQueryResult disChannelResultList = this.disChannelServiceRepository.queryChannelPage(param);
        DisChannelReDomain disChannelResult = (DisChannelReDomain)disChannelResultList.getList().get(0);
        this.logger.error(CODE + ".disChannelResult", (Object)disChannelResult);
        DisDgoodsDomain disDgoodsDomain = new DisDgoodsDomain();
        disDgoodsDomain.setChannelId(disChannelResult.getChannelId());
        disDgoodsDomain.setChannelCode(disChannelResult.getChannelCode());
        disDgoodsDomain.setChannelName(disChannelResult.getChannelName());
        disDgoodsDomain.setChannelSort(disChannelResult.getChannelSort());
        disDgoodsDomain.setChannelType(disChannelResult.getChannelType());
        disDgoodsDomain.setMemberCode(disChannelResult.getMemberCode());
        disDgoodsDomain.setMemberName(disChannelResult.getMemberName());
        disDgoodsDomain.setMemberMcode(disChannelResult.getMemberMcode());
        disDgoodsDomain.setMemberMname(disChannelResult.getMemberMname());
        disDgoodsDomain.setDgoodsPut("1");
        disDgoodsDomain.setDgoodsUprice("1");
        disDgoodsDomain.setDgoodsEdit("1");
        disDgoodsDomain.setDgoodsSync("1");
        disDgoodsDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean disDgoods = this.disDgoodsServiceRepository.saveDgoods(disDgoodsDomain);
        return disChannel;
    }

    @RequestMapping(value={"queryDealerChannelPage.json"}, name="\u7ecf\u9500\u5546\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryDealerChannelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "3");
        param.put("channelSort", "3");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryDealerChannelPageNew.json"}, name="\u7ecf\u9500\u5546\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryDealerChannelPageNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "0");
        param.put("channelSort", "0");
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("fuzzy", true);
        map.put("tenantCode", this.getTenantCode(request));
        if (ListUtil.isNotEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            for (DisChannelReDomain disChannelReDomain : disChannelReDomainSupQueryResult.getList()) {
                map.put("channelId", disChannelReDomain.getChannelId());
                List disDgoodsDomain = this.disDgoodsServiceRepository.queryDgoodsPageNew(map).getList();
                map.put("channelCode", disChannelReDomain.getChannelCode());
                param.put("channelCode", disChannelReDomain.getChannelCode());
                SupQueryResult sResourceGoodsReDomain = this.disDgoodsServiceRepository.queryResourceGoodsPage(param);
                disChannelReDomain.setDgoodsBm(String.valueOf(sResourceGoodsReDomain.getList().size()));
                disChannelReDomain.setDisDgoodsDomainList(disDgoodsDomain);
            }
        }
        return disChannelReDomainSupQueryResult;
    }

    @RequestMapping(value={"deleteDealerChannelByCode.json"}, name="\u5220\u9664\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean deleteDealerChannelByCode(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".deleteDealerChannelByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelServiceRepository.deleteChannelByCode(this.getTenantCode(request), channelCode);
    }

    @RequestMapping(value={"querySaveDealerChannelPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5206\u9875\u5217\u8868\uff08\u6dfb\u52a0\u7ecf\u9500\u5546\uff09")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaveDealerChannelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "3");
        param.put("channelSort", "3");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannelStr.json"}, name="\u67e5\u8be2\u56fd\u5bb6\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaleChannelStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null == param) {
            return null;
        }
        param.put("channelSort", "8");
        return this.disChannelServiceRepository.queryChannelPage(param);
    }

    @RequestMapping(value={"queryDealerChannelByAreaId.json"}, name="\u6839\u636e\u57ce\u5e02\u67e5\u8be2\u6e20\u9053")
    @ResponseBody
    public DisChannelReDomain queryDealerChannelByAreaId(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "0");
        param.put("channelSort", "0");
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("fuzzy", true);
        map.put("tenantCode", this.getTenantCode(request));
        if (ListUtil.isNotEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            for (DisChannelReDomain disChannelReDomain : disChannelReDomainSupQueryResult.getList()) {
                String[] areaIds;
                map.put("channelId", disChannelReDomain.getChannelId());
                List disDgoodsDomain = this.disDgoodsServiceRepository.queryDgoodsPageNew(map).getList();
                map.put("channelCode", disChannelReDomain.getChannelCode());
                param.put("channelCode", disChannelReDomain.getChannelCode());
                SupQueryResult sResourceGoodsReDomain = this.disDgoodsServiceRepository.queryResourceGoodsPage(param);
                disChannelReDomain.setDgoodsBm(String.valueOf(sResourceGoodsReDomain.getList().size()));
                disChannelReDomain.setDisDgoodsDomainList(disDgoodsDomain);
                if (param.get("areaId") == null || "".equals(param.get("areaId")) || "".equals(disChannelReDomain.getChannelMemname())) continue;
                for (String areaId : areaIds = disChannelReDomain.getChannelMemname().trim().split(",")) {
                    if (!areaId.equals(param.get("areaId"))) continue;
                    return disChannelReDomain;
                }
            }
        }
        return null;
    }

    @RequestMapping(value={"queryDealerChannelByAreaIdNew.json"}, name="\u6839\u636e\u57ce\u5e02\u67e5\u8be2\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryDealerChannelByAreaIdNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "0");
        param.put("channelSort", "0");
        SupQueryResult disChannelReDomainSupQueryResult = this.disChannelServiceRepository.queryChannelPage(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("fuzzy", true);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = new SupQueryResult();
        if (ListUtil.isNotEmpty((Collection)disChannelReDomainSupQueryResult.getList())) {
            block0: for (DisChannelReDomain disChannelReDomain : disChannelReDomainSupQueryResult.getList()) {
                String[] areaIds;
                map.put("channelId", disChannelReDomain.getChannelId());
                List disDgoodsDomain = this.disDgoodsServiceRepository.queryDgoodsPageNew(map).getList();
                map.put("channelCode", disChannelReDomain.getChannelCode());
                param.put("channelCode", disChannelReDomain.getChannelCode());
                SupQueryResult sResourceGoodsReDomain = this.disDgoodsServiceRepository.queryResourceGoodsPage(param);
                disChannelReDomain.setDgoodsBm(String.valueOf(sResourceGoodsReDomain.getList().size()));
                disChannelReDomain.setDisDgoodsDomainList(disDgoodsDomain);
                if (param.get("areaId") == null || "".equals(param.get("areaId")) || "".equals(disChannelReDomain.getChannelMemname())) continue;
                for (String areaId : areaIds = disChannelReDomain.getChannelMemname().trim().split(",")) {
                    if (!areaId.equals(param.get("areaId"))) continue;
                    result.getList().add(disChannelReDomain);
                    continue block0;
                }
            }
        }
        return result;
    }
}

