/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.dis.controller.DpriceSkuBean;
import com.qjsoft.laser.controller.dis.controller.DpriceSkuListBean;
import com.qjsoft.laser.controller.dis.controller.ResComCon;
import com.qjsoft.laser.controller.dis.controller.RsClassBean;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceConfDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceConfReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelsendlistServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dprice"}, name="\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
public class DpriceCon
extends ResComCon {
    private static String CODE = "dis.dprice.con";
    @Autowired
    private DisDpriceServiceRepository disDpriceServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private DisChannelsendlistServiceRepository disChannelsendlistServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;

    @Override
    protected String getContext() {
        return "dprice";
    }

    @RequestMapping(value={"queryDpriceSku.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5bf9\u5e94\u7684\u5546\u54c1\u7684\u4fe1\u606f")
    @ResponseBody
    public DpriceSkuBean queryDpriceSku(HttpServletRequest request, String dpriceCode) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)dpriceCode)) {
            this.logger.error(CODE + ".queryDpriceSku", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        DisDpriceReDomain disDpriceReDomain = this.disDpriceServiceRepository.getDpriceByCode(tenantCode, dpriceCode);
        if (null == disDpriceReDomain) {
            this.logger.error(CODE + ".queryDpriceSku", (Object)dpriceCode);
            return null;
        }
        SupQueryResult qdisConf = this.disDpriceServiceRepository.queryDpriceConfPage(this.getQueryMapParam("dpriceCode,tenantCode", new Object[]{dpriceCode, tenantCode}));
        Map<Object, Object> map = null;
        if (null == qdisConf || ListUtil.isEmpty((Collection)qdisConf.getList())) {
            map = new HashMap<String, String>();
        } else {
            map = this.makeDpeicelist(qdisConf.getList());
            if (null == map) {
                map = new HashMap();
            }
        }
        map.put("tenantCode", tenantCode);
        param.put("tenantCode", tenantCode);
        map.put("channelCode", disDpriceReDomain.getChannelCode());
        param.put("channelCode", disDpriceReDomain.getChannelCode());
        map.put("dataOpbillstate", 1);
        param.put("dataOpbillstate", 1);
        map.put("channelTverQmin", disDpriceReDomain.getChannelVer());
        map.put("startRow", 0);
        map.put("rows", 1);
        SupQueryResult qlist = this.rsSkuServiceRepository.querySkuOnePage(map);
        DpriceSkuBean dpriceSkuBean = new DpriceSkuBean();
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            dpriceSkuBean.setSucRow(qlist.getTotal());
        }
        param.put("channelTverQmax", disDpriceReDomain.getChannelVer());
        qlist = this.rsSkuServiceRepository.querySkuOnePage(param);
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            dpriceSkuBean.setErrorRow(qlist.getTotal());
            ArrayList<DpriceSkuListBean> dpriceSkuListBeanList = new ArrayList<DpriceSkuListBean>();
            dpriceSkuBean.setDpriceSkuListBeanList(dpriceSkuListBeanList);
            HashMap<String, Object> qmap = new HashMap<String, Object>();
            qmap.put("fuzzy", true);
            qmap.put("order", true);
            qmap.put("tenantCode", tenantCode);
            qmap.put("channelCode", disDpriceReDomain.getChannelCode());
            qmap.put("channelsendType", "RsSku");
            qmap.put("channelsendDir", "insert");
            for (RsSkuReDomain rsSkuReDomain : qlist.getList()) {
                qmap.put("channelsendTxt", "\"skuCode\":\"" + rsSkuReDomain.getSkuCode() + "\"");
                DpriceSkuListBean dpriceSkuListBean = new DpriceSkuListBean();
                try {
                    BeanUtils.copyAllPropertys((Object)((Object)dpriceSkuListBean), (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (null == rsSkuReDomain.getChannelVer()) {
                    rsSkuReDomain.setChannelVer(Integer.valueOf(0));
                }
                if (null == rsSkuReDomain.getChannelTver()) {
                    rsSkuReDomain.setChannelTver(Integer.valueOf(0));
                }
                if (rsSkuReDomain.getChannelVer().intValue() != rsSkuReDomain.getChannelTver().intValue()) {
                    dpriceSkuListBean.setSynmsg("\u540c\u6b65\u5e73\u53f0\u4e2d");
                }
                if (rsSkuReDomain.getChannelVer().intValue() == rsSkuReDomain.getChannelTver().intValue()) {
                    dpriceSkuListBean.setSynmsg("\u66f4\u65b0\u5546\u54c1\u4e2d");
                }
                dpriceSkuListBeanList.add(dpriceSkuListBean);
            }
        }
        return dpriceSkuBean;
    }

    private Map<String, Object> makeDpeicelist(List<DisDpriceConfReDomain> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String term = "";
        for (DisDpriceConfReDomain disDpriceConf : disDpriceConfList) {
            String list;
            if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
                disDpriceConf.setDpriceConfTerm("=");
            }
            if (!"=".equals(disDpriceConf.getDpriceConfTerm())) {
                term = "Not";
            }
            list = StringUtils.isBlank((String)(list = (String)map.get(disDpriceConf.getDpriceConfType() + term))) ? disDpriceConf.getDpriceConfValue() : list + "," + disDpriceConf.getDpriceConfValue();
            map.put(disDpriceConf.getDpriceConfType() + term, list);
        }
        return map;
    }

    @RequestMapping(value={"saveDprice.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDprice(HttpServletRequest request, DisDpriceDomain disDpriceDomain) {
        if (null == disDpriceDomain) {
            this.logger.error(CODE + ".saveDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"saveDpriceAndConf.json"}, name="\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u660e\u7ec6\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDpriceAndConf(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        disDpriceDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)disDpriceDomain.getDisDpriceConfList())) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomain.getDisDpriceConfList()) {
                disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
            }
        }
        return this.disDpriceServiceRepository.saveDprice(disDpriceDomain);
    }

    @RequestMapping(value={"saveBatchDpriceAndConf.json"}, name="\u6279\u91cf\u589e\u52a0\u6e20\u9053\u4ef7\u683c\u660e\u7ec6\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveBatchDpriceAndConf(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDpriceDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\u7684\u5185\u5bb9\u4e3a\u7a7a!");
        }
        HashMap<String, String> brandMap = new HashMap<String, String>();
        HashMap<String, RsClassBean> classtreeMap = new HashMap<String, RsClassBean>();
        for (DisDpriceDomain disDpriceDomain : disDpriceDomainList) {
            disDpriceDomain.setTenantCode(this.getTenantCode(request));
            this.copyChannel(disDpriceDomain, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode());
            if (!ListUtil.isNotEmpty((Collection)disDpriceDomain.getDisDpriceConfList())) continue;
            ArrayList<DisDpriceConfDomain> otherdisDpriceConfList = new ArrayList<DisDpriceConfDomain>();
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceDomain.getDisDpriceConfList()) {
                disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
                this.makeCode(disDpriceConfDomain, disDpriceDomain, brandMap, classtreeMap, otherdisDpriceConfList);
            }
            if (!ListUtil.isNotEmpty(otherdisDpriceConfList)) continue;
            disDpriceDomain.getDisDpriceConfList().addAll(otherdisDpriceConfList);
        }
        return this.disDpriceServiceRepository.saveDpriceBatch(disDpriceDomainList);
    }

    private void setClass(DisDpriceConfDomain disDpriceConfDomain, List<DisDpriceConfDomain> otherdisDpriceConfList, List<RsClassBean> rsClassBeanList) {
        if (null == disDpriceConfDomain || null == otherdisDpriceConfList || ListUtil.isEmpty(rsClassBeanList)) {
            return;
        }
        for (int i = 0; i < rsClassBeanList.size(); ++i) {
            if (ListUtil.isEmpty(rsClassBeanList.get(i).getChildList())) {
                if (i == 0) {
                    disDpriceConfDomain.setDpriceConfValue(rsClassBeanList.get(i).getClasstreeCode());
                    disDpriceConfDomain.setDpriceConfValuen(rsClassBeanList.get(i).getClasstreeName());
                    continue;
                }
                DisDpriceConfDomain newDisDpriceConfDomain = new DisDpriceConfDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)newDisDpriceConfDomain, (Object)disDpriceConfDomain);
                    newDisDpriceConfDomain.setDpriceConfValue(rsClassBeanList.get(i).getClasstreeCode());
                    newDisDpriceConfDomain.setDpriceConfValuen(rsClassBeanList.get(i).getClasstreeName());
                    otherdisDpriceConfList.add(newDisDpriceConfDomain);
                }
                catch (Exception e) {}
                continue;
            }
            this.setClass(disDpriceConfDomain, otherdisDpriceConfList, rsClassBeanList.get(i).getChildList());
        }
    }

    private void makeCode(DisDpriceConfDomain disDpriceConfDomain, DisDpriceDomain disDpriceDomain, Map<String, String> brandMap, Map<String, RsClassBean> classtreeMap, List<DisDpriceConfDomain> otherdisDpriceConfList) {
        if (null == disDpriceConfDomain || null == disDpriceDomain) {
            return;
        }
        disDpriceConfDomain.setTenantCode(disDpriceDomain.getTenantCode());
        if ("classtreeCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfValue()) && StringUtils.isNotBlank((String)disDpriceConfDomain.getDpriceConfValuen())) {
                RsClassBean rsClassBean;
                if (MapUtil.isEmpty(classtreeMap)) {
                    this.getRsClasstree(null, disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode(), classtreeMap);
                }
                if (null != (rsClassBean = classtreeMap.get(disDpriceConfDomain.getDpriceConfDes() + "-" + disDpriceConfDomain.getDpriceConfValue()))) {
                    if (ListUtil.isEmpty(rsClassBean.getChildList())) {
                        disDpriceConfDomain.setDpriceConfValue(rsClassBean.getClasstreeCode());
                    } else {
                        this.setClass(disDpriceConfDomain, otherdisDpriceConfList, rsClassBean.getChildList());
                    }
                }
            }
        } else if ("brandCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfValue()) && StringUtils.isNotBlank((String)disDpriceConfDomain.getDpriceConfValuen())) {
                if (MapUtil.isEmpty(brandMap)) {
                    this.getRsBrandAll(disDpriceDomain.getChannelCode(), disDpriceDomain.getTenantCode(), brandMap);
                }
                disDpriceConfDomain.setDpriceConfValue(brandMap.get(disDpriceConfDomain.getDpriceConfValuen()));
            }
        } else if ("warehouseCode".equals(disDpriceConfDomain.getDpriceConfType())) {
            // empty if block
        }
    }

    @RequestMapping(value={"getDprice.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        DisDpriceReDomain dprice = this.disDpriceServiceRepository.getDprice(dpriceConfId);
        return dprice;
    }

    @RequestMapping(value={"updateDprice.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDprice(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveDprice", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveDprice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        DisDpriceDomain disDpriceDomain = (DisDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDpriceDomain.class);
        return this.disDpriceServiceRepository.updateDprice(disDpriceDomain);
    }

    @RequestMapping(value={"deleteDprice.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDprice(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceConfId);
    }

    @RequestMapping(value={"queryDpricePage.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult disDpriceReDomainSupQueryResult = this.disDpriceServiceRepository.queryDpricePage(param);
        return disDpriceReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateDpriceState.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceState(String dpriceConfId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceConfId)) {
            this.logger.error(CODE + ".updateDpriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.updateDpriceState(Integer.valueOf(dpriceConfId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryDpricePageBySS.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceReDomain> queryDpricePageBySS(HttpServletRequest request) {
        String dataStateStr;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (StringUtils.isNotBlank((String)(dataStateStr = (String)param.get("dataStateStr")))) {
            param.remove("dataStateStr");
            String[] split = dataStateStr.split(",");
            if (split.length > 1) {
                param.put("dataStateStr", dataStateStr);
            } else if (split.length == 1) {
                param.put("dataState", split[0]);
            }
        }
        if (null != param.get("channelSort") && "3".equals(param.get("channelSort"))) {
            param.remove("channelSort");
            param.put("channelType", "1");
        }
        param.put("dpriceConf", false);
        this.logger.error(CODE + ".queryDpricePageBySS", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        return this.disDpriceServiceRepository.queryDpricePage(param);
    }

    @RequestMapping(value={"saveDisDpriceConfByJson.json"}, name="\u5e93\u5b58\u9002\u7528\u8303\u56f4\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveDisDpriceConfByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDpriceConfDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDpriceConfDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (ListUtil.isNotEmpty((Collection)disDpriceConfDomainList)) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
                disDpriceConfDomain.setTenantCode(tenantCode);
            }
            return this.disDpriceServiceRepository.saveDpriceConfBatch(disDpriceConfDomainList);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"getDpriceAndConf.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceReDomain getDpriceAndConf(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        return this.disDpriceServiceRepository.getDprice(dpriceId);
    }

    @RequestMapping(value={"deleteDpriceById.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceById(Integer dpriceId) {
        if (StringUtils.isBlank((Integer)dpriceId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDprice(dpriceId);
    }

    @RequestMapping(value={"updateStopDpriceByCode.json"}, name="\u505c\u7528\u6e20\u9053\u4ef7\u683c\uff08\u516c\u7528\uff09")
    @ResponseBody
    public HtmlJsonReBean updateStopDpriceByCode(HttpServletRequest request, String dpriceConfbakCode) {
        if (StringUtils.isBlank((String)dpriceConfbakCode)) {
            this.logger.error(CODE + ".updateStopDpriceById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.updateDpriceStateByCode(this.getTenantCode(request), dpriceConfbakCode, Integer.valueOf(3), Integer.valueOf(4));
    }

    @RequestMapping(value={"deleteDpriceConfByPriceCode.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceConfByPriceCode(HttpServletRequest request, String dpriceCode) {
        if (StringUtils.isBlank((String)dpriceCode)) {
            this.logger.error(CODE + ".deleteDpriceConfByPriceCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDpriceConfByPriceCode(this.getTenantCode(request), dpriceCode);
    }

    @RequestMapping(value={"getDpriceConf.json"}, name="\u83b7\u53d6\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDpriceConfReDomain getDpriceConf(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".getDprice", (Object)"param is null");
            return null;
        }
        return this.disDpriceServiceRepository.getDpriceConf(dpriceConfId);
    }

    @RequestMapping(value={"updateDpriceConf.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDpriceConf(HttpServletRequest request, DisDpriceConfDomain disDpriceConfDomain) {
        if (null == disDpriceConfDomain) {
            return new HtmlJsonReBean("error", "param is null");
        }
        disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
        return this.disDpriceServiceRepository.updateDpriceConf(disDpriceConfDomain);
    }

    @RequestMapping(value={"updateDpriceConfNew.json"}, name="\u66f4\u65b0\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDpriceConfNew(HttpServletRequest request, DisDpriceConfDomain disDpriceConfDomain) {
        if (null == disDpriceConfDomain) {
            return new HtmlJsonReBean("error", "param is null");
        }
        disDpriceConfDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("tenantCode", this.getTenantCode(request));
        param.put("dpriceConfValue", disDpriceConfDomain.getDpriceConfValue());
        List disDpriceConfReDomain = this.disDpriceServiceRepository.queryDpriceConfPage(param).getList();
        if (ListUtil.isNotEmpty((Collection)disDpriceConfReDomain)) {
            DisDpriceConfReDomain disDpriceConf = (DisDpriceConfReDomain)disDpriceConfReDomain.get(0);
            this.logger.error(CODE + ".disDpriceConf", (Object)disDpriceConf.getDpriceConfPrice());
            disDpriceConf.setDpriceConfMprice(disDpriceConfDomain.getDpriceConfMprice());
            disDpriceConf.setDpriceConfPrice(disDpriceConfDomain.getDpriceConfPrice());
            disDpriceConf.setDpriceConfSync("1");
        }
        return this.disDpriceServiceRepository.updateDpriceConf((DisDpriceConfDomain)disDpriceConfReDomain.get(0));
    }

    @RequestMapping(value={"deleteDpriceConf.json"}, name="\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceConf(Integer dpriceConfId) {
        if (StringUtils.isBlank((Integer)dpriceConfId)) {
            this.logger.error(CODE + ".deleteDprice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.deleteDpriceConf(dpriceConfId);
    }

    @RequestMapping(value={"deleteBatchDpricesConf.json"}, name="\u6279\u91cf\u5220\u9664\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteBatchDpricesConf(String dpriceConfIdList) {
        if (StringUtils.isBlank((String)dpriceConfIdList)) {
            this.logger.error(CODE + ".deleteDpriceConf", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> dpriceConfIdList1 = this.getDpriceConfIdList(dpriceConfIdList);
        return this.disDpriceServiceRepository.deleteBatchDpriceConf(dpriceConfIdList1);
    }

    protected List<Integer> getDpriceConfIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> getDpriceConfIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            getDpriceConfIdList.add(Integer.parseInt(id));
        }
        return getDpriceConfIdList;
    }

    @RequestMapping(value={"queryDpriceConfPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceConfReDomain> queryDpriceConfPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDpriceServiceRepository.queryDpriceConfPage(param);
    }

    @RequestMapping(value={"queryDpriceLoadCache.json"}, name="\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean queryDpriceLoadCache(HttpServletRequest request) {
        return this.disDpriceServiceRepository.queryDpriceLoadCache();
    }

    @RequestMapping(value={"saveDpriceToApprovalProcess.json"}, name="\u6e20\u9053\u4ef7\u683c\u52a0\u5165\u52a0\u5165\u5ba1\u6279\u6d41")
    @ResponseBody
    public HtmlJsonReBean saveDpriceToApprovalProcess(HttpServletRequest request, String disDpriceDomainStr) {
        if (StringUtils.isBlank((String)disDpriceDomainStr)) {
            this.logger.error(CODE + ".saveDpriceToApprovalProcess", (Object)"disDpriceDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List disDpriceConfDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(disDpriceDomainStr, DisDpriceConfDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceConfDomainList)) {
            this.logger.error(CODE + ".saveDpriceToApprovalProcess", (Object)"disDpriceConfDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceServiceRepository.saveDpriceToApprovalProcess(disDpriceConfDomainList);
    }
}

