/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.dis.controller.RsClassBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ResComCon
extends SpringmvcController {
    private static String CODE = "dis.resCom.con";
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;

    protected String getContext() {
        return "resCom";
    }

    protected Map<String, String> getRsBrandAll(String channelCode, String tenantCode, Map<String, String> map) {
        if (StringUtils.isBlank((String)tenantCode) || null == map) {
            return null;
        }
        SupQueryResult qlist = this.rsBrandServiceRepository.queryBrandPage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        for (RsBrandReDomain rsBrandReDomain : qlist.getList()) {
            map.put(rsBrandReDomain.getBrandName(), rsBrandReDomain.getBrandCode());
        }
        return map;
    }

    protected Map<String, RsClassBean> getRsClasstree(String memberCode, String channelCode, String tenantCode, Map<String, RsClassBean> map) {
        if (StringUtils.isBlank((String)tenantCode) || null == map) {
            return null;
        }
        PostParamMap pmap = new PostParamMap("rs.rsClasstree.queryClasstree");
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        List rslist = (List)this.htmlIBaseService.senReList(pmap, RsClassBean.class);
        if (ListUtil.isEmpty((Collection)rslist)) {
            return null;
        }
        this.makeRsClass(rslist, map, "");
        return map;
    }

    private void makeRsClass(List<RsClassBean> rslist, Map<String, RsClassBean> map, String parentClasstreeName) {
        if (null == map || ListUtil.isEmpty(rslist)) {
            return;
        }
        for (RsClassBean rsClassBean : rslist) {
            map.put(parentClasstreeName + "-" + rsClassBean.getClasstreeName(), rsClassBean);
            this.makeRsClass(rsClassBean.getChildList(), map, rsClassBean.getClasstreeName());
        }
    }

    protected DisChannelDomain getDisChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return (DisChannelDomain)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannelDomain.class);
    }

    protected void copyChannel(Object obj, String channelCode, String tenantCode) {
        if (null == obj || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        DisChannelDomain disChannelDomain = this.getDisChannel(channelCode, tenantCode);
        if (null == disChannelDomain) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)obj, (Object)disChannelDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".copyChannel", (Throwable)e);
        }
    }
}

