/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.dis.controller.DisConstants;
import com.qjsoft.laser.controller.dis.controller.orderexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceSubDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceSubReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceSubServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dpriceSub"}, name="\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
public class DpriceSubCon
extends SpringmvnNewController {
    private static String CODE = "dis.dpriceSub.con";
    @Autowired
    private DisDpriceSubServiceRepository disDpriceSubServiceRepository;
    @Autowired
    private DisDpriceServiceRepository disDpriceServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "dpriceSub";
    }

    @RequestMapping(value={"saveDpriceSub.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveDpriceSub(HttpServletRequest request, DisDpriceSubDomain dpriceSubDomain) {
        if (null == dpriceSubDomain) {
            this.logger.error(CODE + ".saveDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String dPriceCode = this.getDpriceCode(dpriceSubDomain.getChannelCode(), tenantCode);
        dpriceSubDomain.setTenantCode(tenantCode);
        dpriceSubDomain.setDpriceCode(dPriceCode);
        return this.disDpriceSubServiceRepository.saveDpriceSub(dpriceSubDomain);
    }

    @RequestMapping(value={"saveDpriceSubBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveDpriceSubBatch(HttpServletRequest request, String dpriceSubDomainStr) {
        if (null == dpriceSubDomainStr) {
            this.logger.error(CODE + ".saveDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List disDpriceSubDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dpriceSubDomainStr, DisDpriceSubDomain.class);
        String tenantCode = this.getTenantCode(request);
        String dPriceCode = this.getDpriceCode(((DisDpriceSubDomain)disDpriceSubDomainList.get(0)).getChannelCode(), tenantCode);
        StringBuffer skuNoStr = new StringBuffer();
        for (DisDpriceSubDomain disDpriceSubDomain : disDpriceSubDomainList) {
            disDpriceSubDomain.setTenantCode(tenantCode);
            disDpriceSubDomain.setDpriceCode(dPriceCode);
            if (StringUtils.isNotBlank((String)skuNoStr.toString())) {
                skuNoStr.append(",");
            }
            skuNoStr.append(disDpriceSubDomain.getSkuName());
        }
        List<RsResourceGoodsReDomain> resourceGoodsReDomainList = this.queryGoods(tenantCode, skuNoStr.toString());
        for (DisDpriceSubDomain disDpriceSubDomain : disDpriceSubDomainList) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : resourceGoodsReDomainList) {
                if (!disDpriceSubDomain.getSkuName().equals(rsResourceGoodsReDomain.getGoodsShowno())) continue;
                disDpriceSubDomain.setTempFieild5(rsResourceGoodsReDomain.getGoodsProperty1());
            }
        }
        return this.disDpriceSubServiceRepository.saveDpriceSubBatch(disDpriceSubDomainList);
    }

    private List<RsResourceGoodsReDomain> queryGoods(String tenantCode, String skuNoStr) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantCode", tenantCode);
        params.put("goodsShowNoStr", skuNoStr);
        params.put("goodsOrigin", "0,8");
        this.logger.error(CODE + ".queryGoods.params", params);
        SupQueryResult result = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(params);
        this.logger.error(CODE + ".queryGoods.size", (Object)result.getList().size());
        return result.getList();
    }

    private String getDpriceCode(String channelCode, String tenantCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channelCode", channelCode);
        params.put("tenantCode", tenantCode);
        SupQueryResult priceResult = this.disDpriceServiceRepository.queryDpricePage(params);
        if (priceResult == null || priceResult.getList() == null || priceResult.getList().isEmpty()) {
            this.logger.error(CODE + ".getDpriceCode.is null", (Object)("channelCode:" + channelCode));
            return null;
        }
        return ((DisDpriceReDomain)priceResult.getList().get(0)).getDpriceCode();
    }

    @RequestMapping(value={"getDpriceSub.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u4fe1\u606f")
    @ResponseBody
    public DisDpriceSubReDomain getDpriceSub(Integer dpriceSubId) {
        if (StringUtils.isBlank((Integer)dpriceSubId)) {
            this.logger.error(CODE + ".getDpriceSub", (Object)"param is null");
            return null;
        }
        return this.disDpriceSubServiceRepository.getDpriceSub(dpriceSubId);
    }

    @RequestMapping(value={"updateDpriceSub.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean updateDpriceSub(HttpServletRequest request, DisDpriceSubDomain dpriceSubDomain) {
        if (null == dpriceSubDomain) {
            this.logger.error(CODE + ".updateDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        dpriceSubDomain.setTenantCode(this.getTenantCode(request));
        return this.disDpriceSubServiceRepository.updateDpriceSub(dpriceSubDomain);
    }

    @RequestMapping(value={"deleteDpriceSub.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceSub(Integer dpriceSubId) {
        if (StringUtils.isBlank((Integer)dpriceSubId)) {
            this.logger.error(CODE + ".deleteDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceSubServiceRepository.deleteDpriceSub(dpriceSubId);
    }

    @RequestMapping(value={"queryDpriceSubPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceSubReDomain> queryDpriceSubPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error("log >>> debug: queryDpriceSubPage params{param}=====", (Object)param);
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            String fileName = "\u4ef7\u683c\u7ec4\u5217\u8868";
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isBlank((String)excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertDPriceConfExcelParams());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "dis.dpriceSub.queryDpriceSubPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryUserinfoByCommon.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.disDpriceSubServiceRepository.queryDpriceSubPage(param);
    }

    @RequestMapping(value={"updateDpriceSubState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceSubState(String dpriceSubId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceSubId)) {
            this.logger.error(CODE + ".updateDpriceSubState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceSubServiceRepository.updateDpriceSubState(Integer.valueOf(dpriceSubId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"resetDisPriceSub.json"}, name="\u66f4\u65b0\u7279\u4ef7")
    @ResponseBody
    public HtmlJsonReBean resetDisPriceSub(HttpServletRequest request, String channelCodeStr, String skuNoStr) {
        if (StringUtils.isBlank((String)skuNoStr)) {
            this.logger.error(CODE + ".resetDisPriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuNoStr is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("channelCodeStr", channelCodeStr);
        params.put("skuNoStr", skuNoStr);
        params.put("dataState", DisConstants.PRICE_SUB_STATE_2);
        params.put("pricesetNprice", BigDecimal.ZERO);
        return this.disDpriceSubServiceRepository.resetDisPriceSub(params);
    }

    protected List<Map<String, Object>> makeExcelData(String s, String s1, String s2) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, SupQueryResult.class);
        List disDpriceSubReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisDpriceSubReDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceSubReDomainList)) {
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (DisDpriceSubReDomain dis : disDpriceSubReDomainList) {
            Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)dis), String.class, Object.class);
            this.coverDPriceConf(objectToMap);
            mapList.add(objectToMap);
        }
        return mapList;
    }

    protected void coverDPriceConf(Map<String, Object> map) {
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6279\u6210\u529f");
                break;
            }
            case 13: {
                map.put("dataState", "\u5ba1\u6838\u4e2d");
                break;
            }
            case 14: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5:" + map.get("dataState"));
            }
        }
        if (map.get("tempFieild4") == null) {
            map.put("tempFieild4", 0);
        }
        if (map.get("pricesetNprice") == null) {
            map.put("pricesetNprice", 0);
        } else {
            map.put("pricesetNprice", map.get("pricesetNprice").toString().split("-")[0]);
        }
    }
}

