/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.eq.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionGinfoDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionReDomain;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionFileServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionGinfoServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityQtypeReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityQtypeServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/eq/auction"}, name="\u8be2\u4ef7\u9700\u6c42")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "eq.auction.con";
    @Autowired
    private EqAuctionFileServiceRepository eqAuctionFileServiceRepository;
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    @Autowired
    private EqAuctionGinfoServiceRepository eqAuctionGinfoServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private EqAuctionServiceRepository eqAuctionServiceRepository;
    @Autowired
    private UmQualityQtypeServiceRepository umQualityQtypeServiceRepository;
    private static final String dao_startRow = "startRow";
    private static final String dao_endRow = "endRow";

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, String param) {
        HtmlJsonReBean htmlJsonReBean;
        this.logger.error(CODE + ".saveAuction----param-----", (Object)param);
        if (StringUtils.isBlank((String)param)) {
            this.logger.error(CODE + ".saveAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionReDomain eqAuctionReDomain = (EqAuctionReDomain)JsonUtil.buildNormalBinder().getJsonToObject(param, EqAuctionReDomain.class);
        if (null == eqAuctionReDomain) {
            this.logger.error(CODE + ".eqAuctionReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        eqAuctionReDomain.setTenantCode(tenantCode);
        if (StringUtils.isNotBlank((String)eqAuctionReDomain.getClasstreeCode())) {
            UmQualityQtypeReDomain qualityQtypeByCode = this.umQualityQtypeServiceRepository.getQualityQtypeByCode(tenantCode, eqAuctionReDomain.getClasstreeCode());
            if (qualityQtypeByCode == null) {
                this.logger.error(CODE + ".eqAuctionReDomain\u3002qualityQtypeByCode is null", (Object)eqAuctionReDomain.getClasstreeCode());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u670d\u52a1\u4e13\u4e1a");
            }
            eqAuctionReDomain.setClasstreeName(qualityQtypeByCode.getQtypeQtypeName());
        }
        UserSession userSession = this.getUserSession(request);
        eqAuctionReDomain.setAuctionAudit(Integer.valueOf(1));
        if (null != userSession) {
            eqAuctionReDomain.setMemberName(userSession.getMerberCompname());
            eqAuctionReDomain.setMemberCode(userSession.getUserPcode());
            eqAuctionReDomain.setMemberCname(userSession.getUserName());
            eqAuctionReDomain.setMemberCcode(userSession.getUserCode());
        }
        if ((htmlJsonReBean = this.eqAuctionServiceRepository.saveAuction(eqAuctionReDomain)).isSuccess()) {
            this.eqAuctionServiceRepository.updateAuctionStateByCode(this.getTenantCode(request), htmlJsonReBean.getDataObj().toString(), Integer.valueOf(1), null, null);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u8be2\u4ef7\u9700\u6c42\u4fe1\u606f")
    @ResponseBody
    public EqAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        EqAuctionReDomain eqAuctionReDomain = this.eqAuctionServiceRepository.getAuction(auctionId);
        if (eqAuctionReDomain != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("auctionCode", eqAuctionReDomain.getAuctionCode());
            map.put("tenantCode", eqAuctionReDomain.getTenantCode());
            map.put("fuzzy", false);
            List fileList = null;
            List ginfoList = null;
            List enrollList = null;
            fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map).getList();
            if (fileList != null && fileList.size() != 0) {
                eqAuctionReDomain.setEqAuctionFileDomainList(fileList);
            }
            if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList()) != null && ginfoList.size() != 0) {
                eqAuctionReDomain.setEqAuctionGinfoDomainList(ginfoList);
            }
            map.put("colName0", "DATA_STATE");
            map.put("colValue0", "1,0,-1");
            map.put("order", true);
            map.put("orderStr", " IF ( ISNULL( CONTRACT_PRICETYPE ), 0, CONTRACT_PRICETYPE ) DESC,IF ( ISNULL( AUCTION_PRICE_AMOUNT ), 99999999, AUCTION_PRICE_AMOUNT ) ASC");
            enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map).getList();
            if (enrollList != null && enrollList.size() != 0) {
                eqAuctionReDomain.setEqAuctionEnrollReDomainList(enrollList);
                eqAuctionReDomain.setAuctionSort(Integer.valueOf(enrollList.size()));
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"updateAuctionData.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateAuctionData(HttpServletRequest request, EqAuctionDomain eqAuctionDomain) {
        if (null == eqAuctionDomain || null == eqAuctionDomain.getAuctionId()) {
            this.logger.error(CODE + ".updateAuction param is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionReDomain auction = this.eqAuctionServiceRepository.getAuction(eqAuctionDomain.getAuctionId());
        if (auction == null) {
            this.logger.error(CODE + ".updateAuction auction is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u8be2\u4ef7\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)auction, (Object)eqAuctionDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.eqAuctionServiceRepository.updateAuction((EqAuctionDomain)auction);
    }

    @RequestMapping(value={"updateAuctionSuccess.json"}, name="\u8be2\u4ef7\u786e\u8ba4\u8fbe\u6210")
    @ResponseBody
    public HtmlJsonReBean updateAuctionSuccess(HttpServletRequest request, EqAuctionDomain eqAuctionDomain, Integer auctionEnrollId) {
        this.logger.error(CODE + ".updateAuction eqAuctionDomain is", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
        if (null == eqAuctionDomain || null == eqAuctionDomain.getAuctionId() || null == auctionEnrollId) {
            this.logger.error(CODE + ".updateAuction param is null", (Object)(auctionEnrollId + "\u2014\u2014\u2014\u2014" + JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionReDomain auction = this.eqAuctionServiceRepository.getAuction(eqAuctionDomain.getAuctionId());
        if (auction == null) {
            this.logger.error(CODE + ".updateAuction auction is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u8be2\u4ef7\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)auction, (Object)eqAuctionDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("auctionCode", auction.getAuctionCode());
        SupQueryResult auctionEnrollPage = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map);
        if (auctionEnrollPage != null && ListUtil.isNotEmpty((Collection)auctionEnrollPage.getList())) {
            for (EqAuctionEnrollReDomain eqAuctionEnrollReDomain : auctionEnrollPage.getList()) {
                if (0 != eqAuctionEnrollReDomain.getDataState() || 1 != eqAuctionEnrollReDomain.getDataOpbillstate() || !auctionEnrollId.equals(eqAuctionEnrollReDomain.getAuctionEnrollId())) continue;
                this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(eqAuctionEnrollReDomain.getAuctionEnrollId(), Integer.valueOf(1), Integer.valueOf(0), null);
            }
        }
        if (auction.getDataState() == 1) {
            this.eqAuctionServiceRepository.updateAuctionState(auction.getAuctionId(), Integer.valueOf(2), Integer.valueOf(1), null);
        }
        this.logger.error(CODE + ".updateAuction auction is", (Object)JsonUtil.buildNormalBinder().toJson((Object)auction));
        return this.eqAuctionServiceRepository.updateAuction((EqAuctionDomain)auction);
    }

    @RequestMapping(value={"updateAuctionFail.json"}, name="\u8be2\u4ef7\u672a\u8fbe\u6210")
    @ResponseBody
    public HtmlJsonReBean updateAuctionFail(HttpServletRequest request, EqAuctionDomain eqAuctionDomain) {
        this.logger.error(CODE + ".updateAuction eqAuctionDomain is", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
        if (null == eqAuctionDomain || null == eqAuctionDomain.getAuctionId()) {
            this.logger.error(CODE + ".updateAuction param is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionReDomain auction = this.eqAuctionServiceRepository.getAuction(eqAuctionDomain.getAuctionId());
        if (auction == null) {
            this.logger.error(CODE + ".updateAuction auction is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u8be2\u4ef7\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)auction, (Object)eqAuctionDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("auctionCode", auction.getAuctionCode());
        map.put("dataState", 0);
        map.put("dataOpbillstate", 1);
        SupQueryResult auctionEnrollPage = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map);
        if (auctionEnrollPage != null && ListUtil.isNotEmpty((Collection)auctionEnrollPage.getList())) {
            for (EqAuctionEnrollReDomain eqAuctionEnrollReDomain : auctionEnrollPage.getList()) {
                this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(eqAuctionEnrollReDomain.getAuctionEnrollId(), Integer.valueOf(-1), Integer.valueOf(0), null);
            }
        }
        if (auction.getDataState() == 2) {
            this.logger.error(CODE + ".updateAuction \u72b6\u6001\u95ee\u9898", (Object)JsonUtil.buildNormalBinder().toJson((Object)auction));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be2\u4ef7\u5355\u5df2\u8fbe\u6210\uff0c\u4e0d\u80fd\u4fee\u6539\u72b6\u6001");
        }
        this.eqAuctionServiceRepository.updateAuctionState(auction.getAuctionId(), Integer.valueOf(3), Integer.valueOf(1), null);
        this.logger.error(CODE + ".updateAuction auction is", (Object)JsonUtil.buildNormalBinder().toJson((Object)auction));
        return this.eqAuctionServiceRepository.updateAuction((EqAuctionDomain)auction);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, EqAuctionDomain eqAuctionDomain) {
        if (null == eqAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        eqAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.eqAuctionServiceRepository.updateAuction(eqAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionServiceRepository.deleteAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionDataByUser.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public Map<String, Object> queryAuctionDataByUser(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        param.put(dao_startRow, 0);
        param.put(dao_endRow, 1);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", userSession.getUserPcode());
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("auctionAudit", 1);
        param.put("colName0", "DATA_STATE");
        param.put("colValue0", "1");
        SupQueryResult eqAuctionReDomain1 = this.eqAuctionServiceRepository.queryAuctionPage(param);
        resultMap.put("AuctionNum", eqAuctionReDomain1.getTotal());
        param.put("colValue0", "0");
        SupQueryResult eqAuctionEnrollReDomain = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param);
        resultMap.put("AuctionenorllNum", eqAuctionEnrollReDomain.getTotal());
        param.remove("colName0");
        param.remove("colValue0");
        param.put("auctionEdateQend", new Date());
        SupQueryResult eqAuctionReDomain2 = this.eqAuctionServiceRepository.queryAuctionPage(param);
        resultMap.put("AuctionEndNum", eqAuctionReDomain2.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionReDomain> queryAuctionPage(HttpServletRequest request, String dataOpbillstate) {
        String goodsName;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionAudit", 1);
            param.put("colValue0", dataOpbillstate);
            param.put("colName0", "DATA_OPBILLSTATE");
            param.remove("dataOpbillstate");
            param.put("colName1", "DATA_STATE");
            param.put("colValue1", param.get("dataStateStr"));
            param.remove("dataStateStr");
        }
        if ((goodsName = request.getParameter("goodsName")) != null && !goodsName.isEmpty()) {
            this.logger.error(CODE + ".queryAuctionPage", (Object)(".goodsName" + goodsName));
            HashMap<String, Object> map = new HashMap<String, Object>();
            StringBuffer auctionCode = new StringBuffer();
            map.put("tenantCode", this.getTenantCode(request));
            map.put("goodsName", goodsName);
            map.put("fuzzy", true);
            List list = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList();
            if (ListUtil.isNotEmpty((Collection)list) && list.size() > 0) {
                this.logger.error(CODE + ".queryAuctionPage", (Object)(".list.size" + list.size()));
                for (EqAuctionGinfoDomain auction : list) {
                    auctionCode.append(auction.getAuctionCode() + ",");
                }
                param.put("auctionCode", auctionCode);
            } else {
                return new SupQueryResult();
            }
        }
        this.logger.error(CODE + ".queryAuctionPage", (Object)(".param" + param.toString()));
        SupQueryResult eqAuctionReDomain = this.eqAuctionServiceRepository.queryAuctionPage(param);
        if (eqAuctionReDomain.getList() != null && eqAuctionReDomain.getList().size() != 0) {
            for (EqAuctionReDomain eq : eqAuctionReDomain.getList()) {
                String userinfoCode = eq.getMemberCode();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("userinfoCode", userinfoCode);
                map1.put("tenantCode", eq.getTenantCode());
                map1.put("qualityCode", "opbus");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("auctionCode", eq.getAuctionCode());
                map.put("tenantCode", eq.getTenantCode());
                map.put("fuzzy", false);
                List fileList = null;
                List ginfoList = null;
                List enrollList = null;
                List umUserinfoQua = null;
                umUserinfoQua = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map1).getList();
                if (umUserinfoQua != null && umUserinfoQua.size() != 0) {
                    for (UmUserinfoQuaReDomain um : umUserinfoQua) {
                        if (um.getUserinfoQuaKey().equals("serverTypesCode")) {
                            eq.setClasstreeShopcode(um.getUserinfoQuaVaule());
                        }
                        if (!um.getUserinfoQuaKey().equals("serverTypes")) continue;
                        eq.setClasstreeShopname(um.getUserinfoQuaVaule());
                    }
                }
                if ((fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map).getList()) != null && fileList.size() != 0) {
                    eq.setEqAuctionFileDomainList(fileList);
                }
                HashMap<String, Object> mapEnroll = new HashMap<String, Object>();
                mapEnroll.put("auctionCode", eq.getAuctionCode());
                mapEnroll.put("tenantCode", eq.getTenantCode());
                mapEnroll.put("fuzzy", false);
                mapEnroll.put("colName0", "DATA_STATE");
                mapEnroll.put("colValue0", "1,0,-1");
                mapEnroll.put("order", true);
                mapEnroll.put("orderStr", " IF ( ISNULL( CONTRACT_PRICETYPE ), 0, CONTRACT_PRICETYPE ) DESC,IF ( ISNULL( AUCTION_PRICE_AMOUNT ), 99999999, AUCTION_PRICE_AMOUNT ) ASC");
                enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(mapEnroll).getList();
                if (enrollList != null && enrollList.size() != 0) {
                    eq.setEqAuctionEnrollReDomainList(enrollList);
                }
                if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList()) == null || ginfoList.size() == 0) continue;
                eq.setEqAuctionGinfoDomainList(ginfoList);
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"queryAuctionApplyPage.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u5ba1\u6838\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionReDomain> queryAuctionApplyPage(HttpServletRequest request, String dataOpbillstate) {
        String goodsName;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("colValue0", dataOpbillstate);
            param.put("colName0", "DATA_OPBILLSTATE");
            param.remove("dataOpbillstate");
            param.put("colName1", "DATA_STATE");
            param.put("colValue1", param.get("dataStateStr"));
            param.remove("dataStateStr");
        }
        if ((goodsName = request.getParameter("goodsName")) != null && !goodsName.isEmpty()) {
            this.logger.error(CODE + ".queryAuctionPage", (Object)(".goodsName" + goodsName));
            HashMap<String, Object> map = new HashMap<String, Object>();
            StringBuffer auctionCode = new StringBuffer();
            map.put("tenantCode", this.getTenantCode(request));
            map.put("goodsName", goodsName);
            map.put("fuzzy", true);
            List list = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList();
            if (ListUtil.isNotEmpty((Collection)list) && list.size() > 0) {
                this.logger.error(CODE + ".queryAuctionPage", (Object)(".list.size" + list.size()));
                for (EqAuctionGinfoDomain auction : list) {
                    auctionCode.append(auction.getAuctionCode() + ",");
                }
                param.put("auctionCode", auctionCode);
            } else {
                return new SupQueryResult();
            }
        }
        this.logger.error(CODE + ".queryAuctionPage", (Object)(".param" + param.toString()));
        SupQueryResult eqAuctionReDomain = this.eqAuctionServiceRepository.queryAuctionPage(param);
        if (eqAuctionReDomain.getList() != null && eqAuctionReDomain.getList().size() != 0) {
            for (EqAuctionReDomain eq : eqAuctionReDomain.getList()) {
                String userinfoCode = eq.getMemberCode();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("userinfoCode", userinfoCode);
                map1.put("tenantCode", eq.getTenantCode());
                map1.put("qualityCode", "opbus");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("auctionCode", eq.getAuctionCode());
                map.put("tenantCode", eq.getTenantCode());
                map.put("fuzzy", false);
                List fileList = null;
                List ginfoList = null;
                List enrollList = null;
                List umUserinfoQua = null;
                umUserinfoQua = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map1).getList();
                if (umUserinfoQua != null && umUserinfoQua.size() != 0) {
                    for (UmUserinfoQuaReDomain um : umUserinfoQua) {
                        if (um.getUserinfoQuaKey().equals("serverTypesCode")) {
                            eq.setClasstreeShopcode(um.getUserinfoQuaVaule());
                        }
                        if (!um.getUserinfoQuaKey().equals("serverTypes")) continue;
                        eq.setClasstreeShopname(um.getUserinfoQuaVaule());
                    }
                }
                if ((fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map).getList()) != null && fileList.size() != 0) {
                    eq.setEqAuctionFileDomainList(fileList);
                }
                HashMap<String, Object> mapEnroll = new HashMap<String, Object>();
                mapEnroll.put("auctionCode", eq.getAuctionCode());
                mapEnroll.put("tenantCode", eq.getTenantCode());
                mapEnroll.put("fuzzy", false);
                mapEnroll.put("colName0", "DATA_STATE");
                mapEnroll.put("colValue0", "1,0,-1");
                mapEnroll.put("order", true);
                mapEnroll.put("orderStr", " IF ( ISNULL( CONTRACT_PRICETYPE ), 0, CONTRACT_PRICETYPE ) DESC,IF ( ISNULL( AUCTION_PRICE_AMOUNT ), 99999999, AUCTION_PRICE_AMOUNT ) ASC");
                enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(mapEnroll).getList();
                if (enrollList != null && enrollList.size() != 0) {
                    eq.setEqAuctionEnrollReDomainList(enrollList);
                }
                if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList()) == null || ginfoList.size() == 0) continue;
                eq.setEqAuctionGinfoDomainList(ginfoList);
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"queryAuctionPageC.json"}, name="\u67e5\u8be2\u88ab\u9080\u8bf7\u4f9b\u5e94\u5546\u62a5\u4ef7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionReDomain> queryAuctionPageC(HttpServletRequest request, String memberCcode) {
        SupQueryResult eqAuctionReDomain;
        Map map = this.assemMapParam(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("memberCcode", memberCcode);
        param.put("tenantCode", this.getTenantCode(request));
        StringBuffer auctionCode = new StringBuffer();
        SupQueryResult SupQueryResult2 = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param);
        if (SupQueryResult2 != null && SupQueryResult2.getList().size() != 0) {
            for (EqAuctionEnrollReDomain enrollList : SupQueryResult2.getList()) {
                if (map.get("auctionCode") != null) {
                    if (!enrollList.getAuctionCode().matches(".*" + map.get("auctionCode") + ".*")) continue;
                    auctionCode.append(enrollList.getAuctionCode() + ",");
                    continue;
                }
                auctionCode.append(enrollList.getAuctionCode() + ",");
            }
        }
        this.logger.error(".SupQueryResultmap", (Object)(".map:" + map.toString()));
        this.logger.error(".SupQueryResult", (Object)(".auctionCode:" + auctionCode.toString()));
        if (auctionCode == null || auctionCode.length() == 0 || auctionCode.toString() == "") {
            return new SupQueryResult();
        }
        if (null != map) {
            if (map.get("auctionCode") != null) {
                map.remove("auctionCode");
            }
            if (map.get("memberCcode") != null) {
                map.remove("memberCcode");
            }
            map.put("auctionCode", auctionCode);
            map.put("memberCappoint", "1");
            map.put("order", true);
        }
        if ((eqAuctionReDomain = this.eqAuctionServiceRepository.queryAuctionPage(map)).getList() != null && eqAuctionReDomain.getList().size() != 0) {
            for (EqAuctionReDomain eq : eqAuctionReDomain.getList()) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("auctionCode", eq.getAuctionCode());
                map1.put("tenantCode", eq.getTenantCode());
                map1.put("memberCcode", memberCcode);
                map1.put("fuzzy", false);
                this.logger.error(CODE + ".eqAuctionReDomain", (Object)("map1:" + map1.toString()));
                List fileList = null;
                List ginfoList = null;
                List enrollList = null;
                fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map1).getList();
                if (fileList != null && fileList.size() != 0) {
                    eq.setEqAuctionFileDomainList(fileList);
                }
                if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map1).getList()) != null && ginfoList.size() != 0) {
                    eq.setEqAuctionGinfoDomainList(ginfoList);
                }
                if ((enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map1).getList()) == null || enrollList.size() == 0) continue;
                eq.setEqAuctionEnrollReDomainList(enrollList);
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionStateAndMemo.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionStateAndMemo(String auctionId, Integer dataState, Integer oldDataState, String memo) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        return this.eqAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"priceRanks.json"}, name="\u4ef7\u683c\u6392\u884c\u5217\u8868")
    @ResponseBody
    public EqAuctionReDomain priceRanks(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return null;
        }
        return this.eqAuctionServiceRepository.priceRanks(Integer.valueOf(auctionId));
    }

    @RequestMapping(value={"updateAuctionAudit.json"}, name="\u5ba1\u6838\u8be2\u4ef7\u5355")
    @ResponseBody
    public HtmlJsonReBean updateAuctionAudit(String auctionId, String auctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId) || StringUtils.isBlank((String)auctionAudit)) {
            this.logger.error(CODE + ".updateAuctionAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionReDomain auctionReDomain = this.eqAuctionServiceRepository.getAuction(Integer.valueOf(auctionId));
        if (null == auctionReDomain) {
            this.logger.error(CODE + ".updateAuctionAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        auctionReDomain.setAuctionAudit(Integer.valueOf(auctionAudit));
        if ("1".equals(auctionAudit)) {
            this.eqAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), Integer.valueOf(1), Integer.valueOf(0), null);
        }
        auctionReDomain.setAuctionAuremark(auctionAuremark);
        return this.eqAuctionServiceRepository.updateAuction((EqAuctionDomain)auctionReDomain);
    }

    @RequestMapping(value={"saveAuctionAward.json"}, name="\u6388\u6807")
    @ResponseBody
    public HtmlJsonReBean saveAuctionAward(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveAuctionAward", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List eqAuctionGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, EqAuctionGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)eqAuctionGoodsDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        for (EqAuctionGoodsDomain domain : eqAuctionGoodsDomainList) {
            domain.setTenantCode(this.getTenantCode(request));
        }
        return this.eqAuctionServiceRepository.saveAuctionAward(eqAuctionGoodsDomainList);
    }
}

