/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.eq.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionReDomain;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollfileServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/eq/auctionEnroll"}, name="\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "eq.auctionEnroll.con";
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private EqAuctionServiceRepository eqAuctionServiceRepository;
    @Autowired
    private EqAuctionEnrollfileServiceRepository eqAuctionEnrollfileServiceRepository;
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    static final String EQ_AUCTION_PRICE_SORT = "EQ_AUCTION_PRICE_SORT";

    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"getAuctionEnrollSort.json"}, name="\u83b7\u53d6\u62a5\u4ef7\u6392\u540d")
    @ResponseBody
    public HtmlJsonReBean getAuctionEnrollSort(HttpServletRequest request, String auctionCode, String auctionEnrollCode) {
        if (StringUtils.isBlank((String)auctionCode) || StringUtils.isBlank((String)auctionEnrollCode)) {
            this.logger.error(CODE + ".getAuctionEnrollSort", (Object)(auctionCode + "-" + auctionEnrollCode));
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String mapJson = SupDisUtil.getMap((String)EQ_AUCTION_PRICE_SORT, (String)(auctionCode + "-" + this.getTenantCode(request)));
        if (StringUtils.isBlank((String)mapJson)) {
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u6b63\u5728\u6392\u540d");
        }
        ArrayList eqAuctionEnrolls = (ArrayList)JsonUtil.buildNormalBinder().getJsonToList(mapJson, EqAuctionEnrollReDomain.class);
        if (ListUtil.isEmpty((Collection)eqAuctionEnrolls)) {
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u8f6c\u6362\u5931\u8d25");
        }
        Integer i = 0;
        for (EqAuctionEnrollReDomain eqAuctionEnroll : eqAuctionEnrolls) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            if (!auctionEnrollCode.equals(eqAuctionEnroll.getAuctionEnrollCode())) continue;
            return new HtmlJsonReBean((Object)i);
        }
        return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u6b63\u5728\u6392\u540d");
    }

    @RequestMapping(value={"reordAuctionEnrollSort.json"}, name="\u5237\u65b0\u62a5\u4ef7\u6392\u540d")
    @ResponseBody
    public HtmlJsonReBean reordAuctionEnrollSort(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".reordAuctionEnrollSort", (Object)auctionCode);
            return new HtmlJsonReBean(JsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> eqMap = new HashMap<String, Object>();
        eqMap.put("auctionCode", auctionCode);
        eqMap.put("tenantCode", this.getTenantCode(request));
        eqMap.put("dataOpbillstate", 1);
        eqMap.put("fuzzy", false);
        this.logger.error(CODE + ".reordAuctionEnrollSort.eqMap", eqMap);
        SupQueryResult eqAuctionEnrollQuery = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(eqMap);
        if (eqAuctionEnrollQuery != null && ListUtil.isNotEmpty((Collection)eqAuctionEnrollQuery.getList())) {
            List eqAuctionEnrolls = eqAuctionEnrollQuery.getList();
            this.logger.error(CODE + ".reordAuctionEnrollSort.\u6392\u5e8f\u524d:\u62a5\u4ef7", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrolls));
            Collections.sort(eqAuctionEnrolls, new Comparator<EqAuctionEnrollReDomain>(){

                @Override
                public int compare(EqAuctionEnrollReDomain o1, EqAuctionEnrollReDomain o2) {
                    return o1.getAuctionPriceAmount().compareTo(o2.getAuctionPriceAmount());
                }
            });
            this.logger.error(CODE + ".reordAuctionEnrollSort.\u6392\u5e8f\u540e:\u62a5\u4ef7", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrolls));
            SupDisUtil.setMapVer((String)EQ_AUCTION_PRICE_SORT, (String)(auctionCode + "-" + this.getTenantCode(request)), (String)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrolls));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, String paramStr) {
        this.logger.error(CODE + ".paramStr", (Object)paramStr);
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u767b\u5f55");
        }
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, EqAuctionEnrollReDomain.class);
        if (null == eqAuctionEnrollReDomain) {
            this.logger.error(CODE + ".eqAuctionEnrollReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)eqAuctionEnrollReDomain.getAuctionCode())) {
            this.logger.error(CODE + ".auctionCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollReDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5931");
        }
        String tenantCode = this.getTenantCode(request);
        EqAuctionReDomain auctionByCode = this.eqAuctionServiceRepository.getAuctionByCode(tenantCode, eqAuctionEnrollReDomain.getAuctionCode());
        if (null == auctionByCode) {
            this.logger.error(CODE + ".auctionCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollReDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be2\u4ef7\u5355\u4e0d\u5b58");
        }
        if (auctionByCode.getAuctionEdate().getTime() < System.currentTimeMillis()) {
            this.logger.error(CODE + ".auctionCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)auctionByCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be2\u4ef7\u5df2\u622a\u6b62");
        }
        eqAuctionEnrollReDomain.setTenantCode(tenantCode);
        eqAuctionEnrollReDomain.setMemberName(auctionByCode.getMemberName());
        eqAuctionEnrollReDomain.setMemberCode(auctionByCode.getMemberCode());
        eqAuctionEnrollReDomain.setMemberCname(userSession.getUserRelname());
        eqAuctionEnrollReDomain.setMemberCcode(userSession.getUserPcode());
        return this.eqAuctionEnrollServiceRepository.saveAuctionEnroll(eqAuctionEnrollReDomain);
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u4fe1\u606f")
    @ResponseBody
    public EqAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollId) {
        if (StringUtils.isBlank((Integer)auctionEnrollId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = this.eqAuctionEnrollServiceRepository.getAuctionEnroll(auctionEnrollId);
        if (eqAuctionEnrollReDomain != null) {
            EqAuctionReDomain auctionByCode;
            SupQueryResult goodsList;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("auctionEnrollCode", eqAuctionEnrollReDomain.getAuctionEnrollCode());
            map.put("tenantCode", eqAuctionEnrollReDomain.getTenantCode());
            SupQueryResult fileList = this.eqAuctionEnrollfileServiceRepository.queryAuctionEnrollfilePage(map);
            if (fileList != null && !fileList.getList().isEmpty()) {
                eqAuctionEnrollReDomain.setEqAuctionEnrollfileDomainList(fileList.getList());
            }
            if ((goodsList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map)) != null && !goodsList.getList().isEmpty()) {
                eqAuctionEnrollReDomain.setEqAuctionGoodsDomainList(goodsList.getList());
            }
            if ((auctionByCode = this.eqAuctionServiceRepository.getAuctionByCode(eqAuctionEnrollReDomain.getTenantCode(), eqAuctionEnrollReDomain.getAuctionCode())) != null) {
                eqAuctionEnrollReDomain.setAuctionSupplierCode(auctionByCode.getInvoiceType());
                eqAuctionEnrollReDomain.setAuctionSupplierName(auctionByCode.getInvoiceTaxRate());
                eqAuctionEnrollReDomain.setAuctionPriceType(auctionByCode.getAuctionBrand());
            }
        }
        return eqAuctionEnrollReDomain;
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        if (null == eqAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        eqAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(eqAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollId) {
        if (StringUtils.isBlank((Integer)auctionEnrollId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.deleteAuctionEnroll(auctionEnrollId);
    }

    @RequestMapping(value={"deleteAuctionEnrollByCode.json"}, name="\u5220\u9664\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnrollByCode(HttpServletRequest request, String auctionEnrollCode) {
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            this.logger.error(CODE + ".deleteAuctionEnrollByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.deleteAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        String userinfoCode = userSession.getUserPcode();
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (param.get("memberCcode") == null) {
                param.put("memberCcode", userinfoCode);
            }
            if (param.get("dataStateStr") != null) {
                param.put("colName1", "DATA_STATE");
                param.put("colValue1", param.get("dataStateStr"));
                param.remove("dataStateStr");
            }
        }
        this.logger.error(CODE + ".queryAuctionEnrollPage.param", (Object)param);
        SupQueryResult eqAuctionEnrollReDomain = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param);
        if (eqAuctionEnrollReDomain != null && !eqAuctionEnrollReDomain.getList().isEmpty()) {
            for (EqAuctionEnrollReDomain eq : eqAuctionEnrollReDomain.getList()) {
                SupQueryResult goodsList;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("auctionEnrollCode", eq.getAuctionEnrollCode());
                map.put("tenantCode", eq.getTenantCode());
                EqAuctionReDomain auctionByCode = this.eqAuctionServiceRepository.getAuctionByCode(eq.getTenantCode(), eq.getAuctionCode());
                if (auctionByCode == null) continue;
                eq.setAuctionDataState(auctionByCode.getDataState());
                SupQueryResult fileList = this.eqAuctionEnrollfileServiceRepository.queryAuctionEnrollfilePage(map);
                if (fileList != null && !fileList.getList().isEmpty()) {
                    eq.setEqAuctionEnrollfileDomainList(fileList.getList());
                }
                if ((goodsList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map)) == null || goodsList.getList().isEmpty()) continue;
                eq.setEqAuctionGoodsDomainList(goodsList.getList());
            }
        }
        return eqAuctionEnrollReDomain;
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(Integer.valueOf(auctionEnrollId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionEnrollStateAndMemo.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollStateAndMemo(String auctionEnrollId, Integer dataState, Integer oldDataState, String memo) {
        if (StringUtils.isBlank((String)auctionEnrollId)) {
            this.logger.error(CODE + ".updateAuctionEnrollStateAndMemo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(Integer.valueOf(auctionEnrollId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollData.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollData(HttpServletRequest request, EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        if (null == eqAuctionEnrollDomain || null == eqAuctionEnrollDomain.getAuctionEnrollId()) {
            this.logger.error(CODE + ".updateAuctionEnrollData.param is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionEnrollReDomain auctionEnroll = this.eqAuctionEnrollServiceRepository.getAuctionEnroll(eqAuctionEnrollDomain.getAuctionEnrollId());
        if (auctionEnroll == null) {
            this.logger.error(CODE + ".updateAuctionEnrollData auctionEnroll is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u62a5\u4ef7\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)auctionEnroll, (Object)eqAuctionEnrollDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll((EqAuctionEnrollDomain)auctionEnroll);
    }
}

