/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.express.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wl.domain.WlExptimeDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlExptimeReDomain;
import com.qjsoft.laser.controller.facade.wl.repository.WlExptimeServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/exptime"}, name="\u914d\u9001\u65f6\u95f4\u6bb5")
public class ExptimeCon
extends SpringmvcController {
    private static String CODE = "express.exptime.con";
    @Autowired
    private WlExptimeServiceRepository wlExptimeServiceRepository;

    protected String getContext() {
        return "exptime";
    }

    @RequestMapping(value={"saveExptime.json"}, name="\u589e\u52a0\u914d\u9001\u65f6\u95f4\u6bb5")
    @ResponseBody
    public HtmlJsonReBean saveExptime(HttpServletRequest request, WlExptimeDomain WlExptimeDomain2) {
        if (null == WlExptimeDomain2) {
            this.logger.error(CODE + ".saveExptime", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WlExptimeDomain2.setTenantCode(this.getTenantCode(request));
        return this.wlExptimeServiceRepository.saveExptime(WlExptimeDomain2);
    }

    @RequestMapping(value={"getExptime.json"}, name="\u83b7\u53d6\u914d\u9001\u65f6\u95f4\u6bb5\u4fe1\u606f")
    @ResponseBody
    public WlExptimeReDomain getExptime(Integer exptimeId) {
        if (StringUtils.isBlank((Integer)exptimeId)) {
            this.logger.error(CODE + ".getExptime", (Object)"param is null");
            return null;
        }
        return this.wlExptimeServiceRepository.getExptime(exptimeId);
    }

    @RequestMapping(value={"updateExptime.json"}, name="\u66f4\u65b0\u914d\u9001\u65f6\u95f4\u6bb5")
    @ResponseBody
    public HtmlJsonReBean updateExptime(HttpServletRequest request, WlExptimeDomain WlExptimeDomain2) {
        if (null == WlExptimeDomain2) {
            this.logger.error(CODE + ".updateExptime", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WlExptimeDomain2.setTenantCode(this.getTenantCode(request));
        return this.wlExptimeServiceRepository.updateExptime(WlExptimeDomain2);
    }

    @RequestMapping(value={"deleteExptime.json"}, name="\u5220\u9664\u914d\u9001\u65f6\u95f4\u6bb5")
    @ResponseBody
    public HtmlJsonReBean deleteExptime(Integer exptimeId) {
        if (StringUtils.isBlank((Integer)exptimeId)) {
            this.logger.error(CODE + ".deleteExptime", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExptimeServiceRepository.deleteExptime(exptimeId);
    }

    @RequestMapping(value={"queryExptimePage.json"}, name="\u67e5\u8be2\u914d\u9001\u65f6\u95f4\u6bb5\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExptimeReDomain> queryExptimePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExptimeServiceRepository.queryExptimePage(param);
    }

    @RequestMapping(value={"updateExptimeState.json"}, name="\u66f4\u65b0\u914d\u9001\u65f6\u95f4\u6bb5\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExptimeState(String exptimeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)exptimeId)) {
            this.logger.error(CODE + ".updateExptimeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExptimeServiceRepository.updateExptimeState(Integer.valueOf(exptimeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getExpTimes.json"}, name="\u83b7\u53d6\u7269\u6d41\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public List<WlExptimeReDomain> getExpTimes(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (param.get("tenantCode") == null || StringUtils.isEmpty((String)((String)param.get("tenantCode")))) {
            param.put("tenantCode", this.getTenantCode(request));
        }
        return this.wlExptimeServiceRepository.getExpTimes(param);
    }
}

