/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.crms.repository;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderGoodsReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsURechargeDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsURechargeReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.OcContractGoodsGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.crms.enums.OrderStateEnums;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsSOrderGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsURechargeServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CrmsSOrderServiceRepository
extends SupperFacade {
    private static String CODE = "crms.CrmsSOrderServiceRepository";
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private CrmsURechargeServiceRepository crmsURechargeServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private CrmsSOrderGoodsServiceRepository crmsSOrderGoodsServiceRepository;
    @Autowired
    private RsResourceServiceRepository rsResourceServiceRepository;
    private Object UUIDLock = new Object();

    public HtmlJsonReBean saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) {
        PostParamMap pmap = new PostParamMap("crms.send.sendSaveSOrderBatch");
        pmap.putParamToJson("crmsSOrderDomainList", crmsSOrderDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public CrmsSOrderReDomain getSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.send.updateSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<CrmsSOrderReDomain> querySOrderPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.querySOrderPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean saveSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.send.sendSaveSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean createOrder(List<CrmsSOrderDomain> crmsSOrderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(crmsSOrderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<CrmsSOrderDomain> crmsSOrderDomains = new ArrayList<CrmsSOrderDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        for (CrmsSOrderDomain orderDomain : crmsSOrderDomainList) {
            CrmsSOrderDomain crmsSOrderDomain;
            try {
                crmsSOrderDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == crmsSOrderDomain) {
                    this.logger.error(CODE + ".createOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                if (StringUtils.isNotBlank((String)contractProperty)) {
                    crmsSOrderDomain.setContractProperty(contractProperty);
                }
                if (StringUtils.isBlank((String)crmsSOrderDomain.getContractProperty())) {
                    crmsSOrderDomain.setContractProperty("0");
                }
                for (PackageDomain packageDomain : orderDomain.getPackageList()) {
                    List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = this.makePackageDomain(packageDomain, crmsSOrderDomain);
                    if (ListUtil.isEmpty(crmsSOrderDomain.getCrmsSOrderGoodsDomainList())) {
                        crmsSOrderDomain.setCrmsSOrderGoodsDomainList(crmsSOrderGoodsDomainList);
                    } else {
                        crmsSOrderDomain.getCrmsSOrderGoodsDomainList().addAll(crmsSOrderGoodsDomainList);
                    }
                    if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
                    shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
                }
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(crmsSOrderDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            crmsSOrderDomains.add(crmsSOrderDomain);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        CrmsURechargeReDomain crmsURechargeReDomain = this.getCrmsURechargeReDomain(crmsSOrderDomainList.get(0));
        if (crmsURechargeReDomain != null) {
            if (crmsURechargeReDomain.getRechargeSmoney().compareTo(crmsSOrderDomainList.get(0).getContractMoney()) >= 0) {
                crmsSOrderDomainList.get(0).setContractObillcode("NO");
            } else {
                crmsSOrderDomainList.get(0).setContractObillcode("YES");
            }
        } else {
            throw new ApiException(CODE + ".createOrder.ex", "\u672a\u67e5\u8be2\u5230\u529e\u4e8b\u5904\u989d\u5ea6\u4fe1\u606f\uff01\u501f\u8d27\u5355\u751f\u6210\u5931\u8d25\uff01");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String orderCode = "";
        if (crmsSOrderDomains.size() > 1) {
            htmlJsonReBean = this.saveSOrderBatch(crmsSOrderDomains);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                orderCode = htmlJsonReBean.getDataObj().toString();
                result.put("contractBbillcode", orderCode);
            }
        } else {
            htmlJsonReBean = this.saveSOrder((CrmsSOrderDomain)crmsSOrderDomains.get(0));
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                orderCode = htmlJsonReBean.getDataObj().toString();
                result.put("contractBbillcode", orderCode);
            }
        }
        this.otherOperations(crmsSOrderDomains, shoppingGoodsIdList, orderCode, crmsURechargeReDomain);
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    private void otherOperations(List<CrmsSOrderDomain> crmsSOrderDomains, List<Integer> shoppingGoodsIdList, String sOrderCode, CrmsURechargeReDomain crmsURechargeReDomain) {
        if (shoppingGoodsIdList == null || shoppingGoodsIdList.size() > 0) {
            // empty if block
        }
        ArrayList<RsSkuDomain> list = new ArrayList<RsSkuDomain>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (CrmsSOrderDomain crmsSOrderDomain : crmsSOrderDomains) {
            if (ListUtil.isEmpty(crmsSOrderDomain.getCrmsSOrderGoodsDomainList())) {
                this.logger.error(CODE + ".otherOperations", (Object)"crmsSOrderGoodsDomainList is null");
                return;
            }
            for (CrmsSOrderGoodsDomain orderGoodsDomain : crmsSOrderDomain.getCrmsSOrderGoodsDomainList()) {
                if ("hangzhou".equals(orderGoodsDomain.getWarehouseCode())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", orderGoodsDomain.getSkuCode());
                map.put("tenantCode", orderGoodsDomain.getTenantCode());
                RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                if (rsSkuReDomain.getGoodsSupplynum().subtract(orderGoodsDomain.getGoodsCamount()).intValue() < 0) {
                    throw new ApiException(CODE + ".otherOperations", "\u5e93\u5b58\u4e0d\u8db3" + rsSkuReDomain.getSkuNo());
                }
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuId(rsSkuReDomain.getSkuId());
                rsSkuDomain.setGoodsSupplynum(rsSkuReDomain.getGoodsSupplynum().subtract(orderGoodsDomain.getGoodsCamount()));
                rsSkuDomain.setDataOpbillstate(rsSkuReDomain.getDataOpbillstate());
                list.add(rsSkuDomain);
                idList.add(rsSkuDomain.getSkuId());
            }
        }
        if (ListUtil.isNotEmpty(list)) {
            HtmlJsonReBean htmlJsonReBean = this.rsSkuServiceRepository.updateSkuList(list);
            if (!"success".equals(htmlJsonReBean.getSysRecode())) {
                throw new ApiException(CODE + ".otherOperations", "\u4fee\u6539\u5e93\u5b58\u5931\u8d25");
            }
            ArrayList<Integer> idShelList = new ArrayList<Integer>();
            for (RsSkuDomain skuDomain : list) {
                if (!"1".equals(String.valueOf(skuDomain.getDataOpbillstate()))) continue;
                idShelList.add(skuDomain.getSkuId());
            }
            HtmlJsonReBean htmlJson = this.rsResourceServiceRepository.sendUpdateSoldOutBatchSku(idShelList);
            if (null == htmlJson || "error".equals(htmlJson.getSysRecode())) {
                throw new ApiException(CODE + ".otherOperations", "\u5546\u54c1\u4e0b\u67b6\u5931\u8d25");
            }
            htmlJson = this.rsResourceServiceRepository.sendUpdateShelveBatchSku(idList);
            if (null == htmlJson || "error".equals(htmlJson.getSysRecode())) {
                throw new ApiException(CODE + ".otherOperations", "\u5546\u54c1\u4e0a\u67b6\u5931\u8d25");
            }
        }
        BigDecimal allMoney = BigDecimal.ZERO;
        for (CrmsSOrderDomain crmsSOrderDomain : crmsSOrderDomains) {
            allMoney = allMoney.add(crmsSOrderDomain.getContractMoney());
        }
        if (crmsURechargeReDomain != null) {
            CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
            crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
            crmsURechargeDomain.setRechargeSmoney(allMoney.multiply(new BigDecimal(-1)));
            crmsURechargeDomain.setTenantCode(crmsURechargeReDomain.getTenantCode());
            crmsURechargeDomain.setOrderCode(sOrderCode);
            this.crmsURechargeServiceRepository.updateURecharge(crmsURechargeDomain);
        }
    }

    private CrmsURechargeReDomain getCrmsURechargeReDomain(CrmsSOrderDomain crmsSOrderDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", crmsSOrderDomain.getTenantCode());
        map.put("userinfoCode", crmsSOrderDomain.getMemberBcode());
        map.put("userinfoQuaKey", "depName");
        List umUserinfoQuaReDomains = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList();
        if (umUserinfoQuaReDomains != null && umUserinfoQuaReDomains.size() > 0) {
            UmUserinfoQuaReDomain domain = null;
            for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaReDomains) {
                if (!"depName".equals(umUserinfoQuaReDomain.getUserinfoQuaKey()) || !StringUtils.isNotBlank((String)umUserinfoQuaReDomain.getUserinfoQuaVaule1())) continue;
                domain = umUserinfoQuaReDomain;
            }
            if (domain == null) {
                return null;
            }
            return this.crmsURechargeServiceRepository.getURechargeByUserInfoCode(crmsSOrderDomain.getTenantCode(), domain.getUserinfoQuaVaule1());
        }
        return null;
    }

    public HtmlJsonReBean calculateContract(CrmsSOrderDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String memberCode = "";
        boolean teflag = false;
        for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : contractDomain.getCrmsSOrderGoodsDomainList()) {
            if (StringUtils.isBlank((String)memberCode)) {
                memberCode = crmsSOrderGoodsDomain.getMemberCode();
            } else if (!memberCode.equals(crmsSOrderGoodsDomain.getMemberCode())) {
                teflag = true;
            }
            contractDomain.setMemberCode(crmsSOrderGoodsDomain.getMemberCode());
            contractDomain.setMemberName(crmsSOrderGoodsDomain.getMemberName());
            if (null == crmsSOrderGoodsDomain.getGoodsNum()) {
                crmsSOrderGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(crmsSOrderGoodsDomain.getGoodsNum());
            if (null == crmsSOrderGoodsDomain.getGoodsWeight()) {
                crmsSOrderGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(crmsSOrderGoodsDomain.getGoodsWeight());
            if (null == crmsSOrderGoodsDomain.getContractGoodsPrice()) {
                crmsSOrderGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(crmsSOrderGoodsDomain.getContractGoodsPrice());
            if (null == contractDomain.getGoodsLogmoney()) {
                contractDomain.setGoodsLogmoney(BigDecimal.ZERO);
            }
            if (null == contractDomain.getGoodsPmoney()) {
                contractDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(crmsSOrderGoodsDomain.getContractGoodsPrice().multiply(crmsSOrderGoodsDomain.getGoodsNum()));
            if (null == contractDomain.getPricesetRefrice()) {
                contractDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(contractDomain.getPricesetRefrice());
        }
        if (ListUtil.isNotEmpty(contractDomain.getPackageList()) && contractDomain.getPackageList().size() == 1 && StringUtils.isBlank((String)contractDomain.getContractRemark())) {
            contractDomain.setContractRemark(contractDomain.getPackageList().get(0).getPackageRemark());
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        if (null == contractDomain.getContractPaymoney()) {
            contractDomain.setContractPaymoney(BigDecimal.ZERO);
        }
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setGoodsMoney(contractMoney);
        contractDomain.setContractMoney(contractMoney.add(contractDomain.getGoodsLogmoney()));
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        if ("06".equals(contractDomain.getContractType()) || "28".equals(contractDomain.getContractType())) {
            contractDomain.setDataBmoney(contractMoney.add(contractDomain.getGoodsLogmoney()).add(contractDomain.getContractPaymoney()));
        } else {
            contractDomain.setDataBmoney(contractMoney.add(contractDomain.getGoodsLogmoney()).add(pefMoney).add(contractDomain.getContractPaymoney()));
        }
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        if (teflag) {
            if (StringUtils.isNotBlank((String)contractDomain.getChannelCode())) {
                DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(contractDomain.getChannelCode() + "-" + contractDomain.getTenantCode()), DisChannel.class);
                if (null != disChannel) {
                    contractDomain.setMemberCode(disChannel.getMemberCode());
                    contractDomain.setMemberName(disChannel.getMemberName());
                } else {
                    contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                    contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                }
            } else {
                contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
            }
        }
        return new HtmlJsonReBean();
    }

    private List<CrmsSOrderGoodsDomain> makePackageDomain(PackageDomain packageDomain, CrmsSOrderDomain ocContractDomain) throws Exception {
        if (null == packageDomain || null == ocContractDomain) {
            return null;
        }
        ArrayList<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = new ArrayList<CrmsSOrderGoodsDomain>();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : packageDomain.getContractGoodsList()) {
            ocContractGoodsDomain.setContractGoodsCode(this.createUUIDString());
            ocContractGoodsDomain.setGoodsOrdnum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsOrdweight(ocContractGoodsDomain.getGoodsCweight());
            ocContractGoodsDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsCweight());
            if (null == ocContractGoodsDomain.getPricesetRefrice()) {
                ocContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getShoppingGoodsPm())) {
                ocContractGoodsDomain.setGinfoCode(ocContractGoodsDomain.getShoppingGoodsPm());
            }
            ocContractGoodsDomain.setContractGoodsPefprice(ocContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(ocContractGoodsDomain);
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCcode())) {
                ocContractDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                ocContractDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
            }
            ocContractDomain.setChannelCode(ocContractGoodsDomain.getChannelCode());
            ocContractDomain.setChannelName(ocContractGoodsDomain.getChannelName());
            ocContractDomain.setMschannelCode(ocContractGoodsDomain.getMschannelCode());
            ocContractDomain.setMschannelName(ocContractGoodsDomain.getMschannelName());
            if (StringUtils.isEmpty((String)ocContractDomain.getMemberBname())) {
                ocContractDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            }
            contractGoodsList.add(ocContractGoodsDomain);
        }
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                CrmsSOrderGoodsDomain crmsSOrderGoodsDomain = new CrmsSOrderGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsDomain, (Object)ocContractGoodsDomain);
                    crmsSOrderGoodsDomain.setGoodsPro("2");
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makePackageDomain.copyAllPropertys.e", (Throwable)e);
                }
                crmsSOrderGoodsDomainList.add(crmsSOrderGoodsDomain);
            }
        }
        return crmsSOrderGoodsDomainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private OcContractGoodsDomain makeGoodsAdd(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain || ListUtil.isEmpty(ocContractGoodsDomain.getOcContractGoodsGoodsList())) {
            return null;
        }
        for (OcContractGoodsGoodsDomain ocContractGoodsGoodsDomain : ocContractGoodsDomain.getOcContractGoodsGoodsList()) {
            OcContractGoodsDomain tcOcContractGoodsDomain = new OcContractGoodsDomain();
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getChannelSkuBySkuNo(ocContractGoodsGoodsDomain.getSkuNo(), ocContractGoodsDomain.getMemberCode(), ocContractGoodsDomain.getMemberCcode(), ocContractGoodsDomain.getChannelCode(), ocContractGoodsDomain.getTenantCode());
            if (null == rsSkuReDomain) {
                CODE = ".makeGoodsAdd.rsSkuReDomain.null";
                this.logger.error(".makeGoodsAdd.rsSkuReDomain.null", (Object)(ocContractGoodsGoodsDomain.getSkuNo() + ocContractGoodsGoodsDomain.getChannelCode()));
                continue;
            }
            RsResourceGoodsReDomain resourceGoodsByCodeStr = this.rsResourceGoodsServiceRepository.getResourceGoodsByCodeStr(rsSkuReDomain.getGoodsCode(), rsSkuReDomain.getTenantCode());
            if (null == resourceGoodsByCodeStr) {
                CODE = ".makeGoodsAdd.resourceGoodsByCodeStr.null";
                this.logger.error(".makeGoodsAdd.resourceGoodsByCodeStr.null", (Object)(rsSkuReDomain.getGoodsCode() + rsSkuReDomain.getTenantCode()));
                continue;
            }
            try {
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)resourceGoodsByCodeStr);
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)rsSkuReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".makeGoodsAdd.copyAllPropertys.e", (Throwable)e);
            }
            tcOcContractGoodsDomain.setMemberBcode(ocContractGoodsDomain.getMemberBcode());
            tcOcContractGoodsDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            tcOcContractGoodsDomain.setContractGoodsType(3);
            tcOcContractGoodsDomain.setContractGoodsGtype("3");
            tcOcContractGoodsDomain.setContractGoodsOldcode(ocContractGoodsDomain.getContractGoodsCode());
            tcOcContractGoodsDomain.setGoodsMinnum(ocContractGoodsGoodsDomain.getGoodsMinnum());
            tcOcContractGoodsDomain.setGoodsHangnum(ocContractGoodsGoodsDomain.getGoodsHangnum());
            this.logger.error(CODE + ".makeGoodsAdd.ocContractGoodsGoodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsGoodsDomain));
            tcOcContractGoodsDomain.setGoodsAhnum(ocContractGoodsGoodsDomain.getGoodsAhnum());
            tcOcContractGoodsDomain.setGoodsNum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setPricesetNprice(ocContractGoodsGoodsDomain.getPricesetNprice());
            tcOcContractGoodsDomain.setPricesetMakeprice(ocContractGoodsGoodsDomain.getPricesetMakeprice());
            tcOcContractGoodsDomain.setGoodsOrdnum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsOrdweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            tcOcContractGoodsDomain.setGoodsCamount(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsCweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            if (null == tcOcContractGoodsDomain.getPricesetRefrice()) {
                tcOcContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)tcOcContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)tcOcContractGoodsDomain.getShoppingGoodsPm())) {
                tcOcContractGoodsDomain.setGinfoCode(tcOcContractGoodsDomain.getShoppingGoodsPm());
            }
            tcOcContractGoodsDomain.setContractGoodsPefprice(tcOcContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(tcOcContractGoodsDomain);
            return tcOcContractGoodsDomain;
        }
        return null;
    }

    public CrmsSOrderDomain makeContractDomain(CrmsSOrderDomain crmsSOrderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == crmsSOrderDomain) {
            this.logger.error("CrmsSOrderServiceRepository.makeContractDomain", (Object)"UserSession is null");
            return null;
        }
        try {
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("CrmsSOrderServiceRepository.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = "00";
            }
            crmsSOrderDomain.setContractType(contractType);
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getMemberBcode())) {
            crmsSOrderDomain.setMemberBcode(userSession.getUserPcode());
            crmsSOrderDomain.setMemberBname(userSession.getMerberCompname());
        }
        crmsSOrderDomain.setTenantCode(userSession.getTenantCode());
        crmsSOrderDomain.setAppmanageIcode(proappCode);
        crmsSOrderDomain.setContractUserurl(userSession.getUserImgurl());
        crmsSOrderDomain.setUserCode(userSession.getUserCode());
        crmsSOrderDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        crmsSOrderDomain.setContractDelcode(randomCode);
        return crmsSOrderDomain;
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null == contractGoodsDomain.getGoodsNum()) {
            contractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
            contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        }
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(0);
        contractGoodsDomain.setRefundFlag(0);
    }

    public CrmsSOrderReDomain getSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderState");
        pmap.putParam("sorderId", (Object)sorderId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState) {
        if (OrderStateEnums.AUDIT_FAILURE.getCode().equals(dataState) || OrderStateEnums.ORDER_CLOSED.getCode().equals(dataState)) {
            CrmsSOrderReDomain crmsSOrderReDomain = this.getSOrder(sorderId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", crmsSOrderReDomain.getTenantCode());
            map.put("userinfoCode", crmsSOrderReDomain.getMemberBcode());
            map.put("userinfoQuaKey", "depName");
            List umUserinfoQuaReDomains = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList();
            if (umUserinfoQuaReDomains != null && umUserinfoQuaReDomains.size() > 0) {
                UmUserinfoQuaReDomain domain = (UmUserinfoQuaReDomain)umUserinfoQuaReDomains.get(0);
                CrmsURechargeReDomain crmsURechargeReDomain = this.crmsURechargeServiceRepository.getURechargeByUserInfoCode(crmsSOrderReDomain.getTenantCode(), domain.getUserinfoQuaVaule1());
                CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
                crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
                crmsURechargeDomain.setRechargeAllmoney(crmsSOrderReDomain.getContractMoney());
                crmsURechargeDomain.setOrderCode(crmsSOrderReDomain.getSorderCode());
                crmsURechargeDomain.setTenantCode(crmsURechargeReDomain.getTenantCode());
                this.crmsURechargeServiceRepository.updateURecharge(crmsURechargeDomain);
            }
        }
        return this.updateSOrderState(sorderId, dataState, oldDataState, null);
    }

    public HtmlJsonReBean updateSOrderStateByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean returnOrderGoods(Map<String, Object> paramMap, String orderGoodsDomainStr) {
        BigDecimal allMoney = BigDecimal.ZERO;
        List crmsSOrderGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderGoodsDomainStr, CrmsSOrderGoodsDomain.class);
        Boolean flag = true;
        String tenantCode = paramMap.get("tenantCode") + "";
        String type = paramMap.get("type") + "";
        if (ListUtil.isEmpty((Collection)crmsSOrderGoodsDomainList)) {
            throw new ApiException(CODE + ".returnOrderGoods", "\u53c2\u6570\u5f02\u5e38\uff01");
        }
        CrmsSOrderReDomain crmsSOrderReDomain = this.getSOrderByCode(tenantCode, ((CrmsSOrderGoodsDomain)crmsSOrderGoodsDomainList.get(0)).getCorderCode());
        if (StringUtils.isNotBlank((String)type)) {
            if ("1".equals(type)) {
                crmsSOrderReDomain.setCrmsSOrderGoodsDomainList(crmsSOrderGoodsDomainList);
                this.returnOrderGoods(crmsSOrderReDomain);
            } else {
                List list = this.crmsSOrderGoodsServiceRepository.querySOrderGoodsPage(paramMap).getList();
                HashMap<String, String> crmsMap = new HashMap<String, String>();
                for (CrmsSOrderGoodsReDomain crmsSOrderGoodsReDomain : list) {
                    if (crmsSOrderGoodsReDomain.getGoodsAhnum() == null) {
                        crmsSOrderGoodsReDomain.setGoodsAhnum(BigDecimal.ZERO);
                    }
                    if (crmsSOrderGoodsReDomain.getContractGoodsRefnum() == null) {
                        crmsSOrderGoodsReDomain.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    if (crmsSOrderGoodsReDomain.getContractGoodsSendweight() == null) {
                        crmsSOrderGoodsReDomain.setContractGoodsSendweight(BigDecimal.ZERO);
                    }
                    if (crmsSOrderGoodsReDomain.getGoodsAhnum().add(crmsSOrderGoodsReDomain.getContractGoodsRefnum().add(crmsSOrderGoodsReDomain.getContractGoodsSendweight())).compareTo(crmsSOrderGoodsReDomain.getGoodsNum()) == 0) continue;
                    crmsMap.put(crmsSOrderGoodsReDomain.getSorderGoodsCode(), crmsSOrderGoodsReDomain.getSorderGoodsCode());
                }
                for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : crmsSOrderGoodsDomainList) {
                    CrmsSOrderGoodsReDomain crmsSOrderGoodsReDomain = this.crmsSOrderGoodsServiceRepository.getSOrderGoods(crmsSOrderGoodsDomain.getSorderGoodsId());
                    allMoney = allMoney.add(crmsSOrderGoodsDomain.getGoodsAhnum().multiply(crmsSOrderGoodsReDomain.getContractGoodsInmoney()));
                    if (null == crmsSOrderGoodsReDomain) {
                        return new HtmlJsonReBean(CODE + ".returnOrderGoods", "crmsSOrderGoodsReDomain is null");
                    }
                    if (null == crmsSOrderGoodsReDomain.getGoodsAhnum()) {
                        crmsSOrderGoodsReDomain.setGoodsAhnum(BigDecimal.ZERO);
                    }
                    if (null == crmsSOrderGoodsReDomain.getContractGoodsRefnum()) {
                        crmsSOrderGoodsReDomain.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    if (null == crmsSOrderGoodsReDomain.getContractGoodsSendweight()) {
                        crmsSOrderGoodsReDomain.setContractGoodsSendweight(BigDecimal.ZERO);
                    }
                    BigDecimal allGoodsAhnum = crmsSOrderGoodsReDomain.getGoodsAhnum().add(crmsSOrderGoodsDomain.getGoodsAhnum());
                    crmsSOrderGoodsReDomain.setGoodsAhnum(allGoodsAhnum);
                    this.crmsSOrderGoodsServiceRepository.updateSOrderGoods(crmsSOrderGoodsReDomain);
                    if (allGoodsAhnum.add(crmsSOrderGoodsReDomain.getContractGoodsRefnum().add(crmsSOrderGoodsReDomain.getContractGoodsSendweight())).compareTo(crmsSOrderGoodsReDomain.getGoodsNum()) != 0) {
                        flag = false;
                        continue;
                    }
                    crmsMap.remove(crmsSOrderGoodsDomain.getSorderGoodsCode());
                }
                if (flag.booleanValue() && MapUtil.isEmpty(crmsMap)) {
                    this.updateSOrderState(crmsSOrderReDomain.getSorderId(), 3, null);
                }
                if (crmsSOrderReDomain == null) {
                    return new HtmlJsonReBean();
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantCode", tenantCode);
                map.put("userinfoCode", crmsSOrderReDomain.getMemberBcode());
                map.put("userinfoQuaKey", "depName");
                List umUserinfoQuaReDomains = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList();
                if (ListUtil.isEmpty((Collection)umUserinfoQuaReDomains)) {
                    return new HtmlJsonReBean();
                }
                UmUserinfoQuaReDomain domain = null;
                for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaReDomains) {
                    if (!StringUtils.isNotBlank((String)umUserinfoQuaReDomain.getUserinfoQuaVaule1())) continue;
                    domain = umUserinfoQuaReDomain;
                }
                if (domain == null) {
                    return new HtmlJsonReBean();
                }
                CrmsURechargeReDomain crmsURechargeReDomain = this.crmsURechargeServiceRepository.getURechargeByUserInfoCode(tenantCode, domain.getUserinfoQuaVaule1());
                if (crmsURechargeReDomain != null) {
                    CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
                    crmsURechargeDomain.setUrechargeId(crmsURechargeReDomain.getUrechargeId());
                    crmsURechargeDomain.setRechargeSmoney(allMoney);
                    crmsURechargeDomain.setOrderCode(crmsSOrderReDomain.getSorderCode());
                    crmsURechargeDomain.setTenantCode(tenantCode);
                    return this.crmsURechargeServiceRepository.updateURecharge(crmsURechargeDomain);
                }
                throw new ApiException(CODE + ".returnOrderGoods.null", "\u672a\u67e5\u8be2\u5230\u529e\u4e8b\u5904\u989d\u5ea6\u4fe1\u606f\uff01");
            }
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean returnOrderGoods(CrmsSOrderReDomain crmsSOrderReDomain) {
        HashMap<String, CrmsSOrderReDomain> paramMap = new HashMap<String, CrmsSOrderReDomain>();
        paramMap.put("crmsSOrderReDomain", crmsSOrderReDomain);
        PostParamMap pmap = new PostParamMap("crms.send.returnOrderGoods");
        pmap.putParamToJson("paramMap", paramMap);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean cancelCrmsSOrder(Map<String, Object> paramMap) {
        PostParamMap pmap = new PostParamMap("crms.send.cancelCrmsSOrder");
        pmap.putParamToJson("paramMap", paramMap);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

