/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.fm.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFchannelDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFchannelReDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFilelistDomainBean;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Repository
public class FileServiceRepository
extends SupperFacade {
    private static final int FM_NAME_MAX_LENGTH = 40;

    public SupQueryResult<FmFileReDomainBean> queryFilePage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFilePage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, FmFileReDomainBean.class);
    }

    public List<FmFilelistDomainBean> queryFilelist(String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFilelist");
        pmap.putParam("fileCode", (Object)fileCode);
        return this.htmlIBaseService.getForList(pmap, FmFilelistDomainBean.class);
    }

    public FmFileReDomainBean queryFileByFileCode(String fileCode) {
        PostParamMap postParamMap = new PostParamMap("fm.file.queryFilePage");
        HashMap<String, String> inner = new HashMap<String, String>();
        inner.put("fileCode", fileCode);
        postParamMap.putParamToJson("map", inner);
        SupQueryResult result = this.htmlIBaseService.sendReSupObject(postParamMap, FmFileDomainBean.class);
        if (result != null && !CollectionUtils.isEmpty((Collection)result.getRows())) {
            return (FmFileReDomainBean)result.getRows().get(0);
        }
        return null;
    }

    public List<FmFileReDomainBean> queryFile(String fileSort, String tenantCode, String relationCode) {
        List fileList = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileSort", fileSort);
        map.put("tenantCode", tenantCode);
        map.put("relationCode", relationCode);
        map.put("order", true);
        String key = "filePath";
        String settingType = "0";
        String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
        String separtor = System.getProperties().getProperty("file.separator");
        SupQueryResult<FmFileReDomainBean> queryResult = this.queryFilePage(map);
        if (queryResult != null && !CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            fileList = queryResult.getList();
            for (FmFileDomainBean FmFileDomainBean2 : queryResult.getList()) {
                String fileCode = FmFileDomainBean2.getFileCode();
                String fileUrl = FmFileDomainBean2.getFileUrl();
                String fileCtype = FmFileDomainBean2.getFileCtype();
                FmFileDomainBean2.setRootPath(httpPath + separtor + fileUrl + separtor + fileCode + "." + fileCtype);
            }
        }
        return fileList;
    }

    private FmFileReDomainBean convertFmFileDomainBean(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(name.length() > 40 ? name.substring(0, 40) : name);
        fmFileReDomainBean.setFileSize((int)file.getSize());
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileCtype(fileType);
        return fmFileReDomainBean;
    }

    private FileBean convertFileBean(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        byte[] fileBytes = new byte[(int)file.getSize()];
        try {
            file.getInputStream().read(fileBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileBean fileBean = new FileBean();
        fileBean.setBytes(fileBytes);
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name.length() > 40 ? name.substring(0, 40) : name);
        fileBean.setSize(Long.valueOf(file.getSize()));
        return fileBean;
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        FmFileReDomainBean FmFileDomainBeanBean = this.convertFmFileDomainBean(file);
        FileBean fileBean = this.convertFileBean(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key + "-" + ServletMain.getAppName()));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fmFileReDomainBean;
    }

    public FmFileReDomainBean saveFile(byte[] file, String tenantCode, String fileSort, String relationCode, String fileType, String fileRemark) {
        if (file == null) {
            return null;
        }
        FmFileDomainBean FmFileDomainBeanBean = new FmFileDomainBean();
        FmFileDomainBeanBean.setFileSize(file.length);
        FmFileDomainBeanBean.setFileType("0");
        FmFileDomainBeanBean.setFileCtype(fileType);
        FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
        FmFileDomainBeanBean.setTenantCode(tenantCode);
        FmFileDomainBeanBean.setRootPath(tenantCode + "/");
        FmFileDomainBeanBean.setFileRemark(fileRemark);
        FmFileDomainBeanBean.setRelationCode(relationCode);
        FileBean fileBean = new FileBean();
        fileBean.setFileType(fileType);
        fileBean.setSize(Long.valueOf(file.length));
        fileBean.setBytes(file);
        return this.saveFile(fileBean, tenantCode, fileSort, FmFileDomainBeanBean);
    }

    private FileBean getFileBean(InputStream is, long flex, String fileType, String name) throws IOException {
        byte[] b = new byte[(int)flex];
        FileBean fileBean = new FileBean();
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name);
        fileBean.setSize(Long.valueOf(flex));
        is.read(b);
        fileBean.setBytes(b);
        return fileBean;
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort, String code, String fileRemark) {
        return this.asserblyFile(file, tenantCode, fileSort, code, fileRemark);
    }

    public FmFileReDomainBean saveFile(MultipartFile file, String tenantCode, String fileSort, String code) {
        return this.asserblyFile(file, tenantCode, fileSort, code, "");
    }

    public HtmlJsonReBean deleteFile(Integer fileId) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFile");
        pmap.putParamToJson("fileId", (Object)fileId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFileByCode(String tenantCode, String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFileByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFileListByCode(String tenantCode, String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFileListByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFile(FmFileDomainBean FmFileDomainBean2) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFile");
        pmap.putParamToJson("fmFmFileDomainBeanBean", (Object)FmFileDomainBean2);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFileByCode(FmFileDomainBean FmFileDomainBean2) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFileByCode");
        pmap.putParamToJson("fmFmFileDomainBeanBean", (Object)FmFileDomainBean2);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public FmFileReDomainBean getFileById(Integer fileId) {
        PostParamMap pmap = new PostParamMap("fm.file.getFile");
        pmap.putParamToJson("fileId", (Object)fileId);
        return (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
    }

    public FmFileReDomainBean getFileByCode(String fileCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("fm.file.getFileByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("fileCode", (Object)fileCode);
        return (FmFileReDomainBean)this.htmlIBaseService.sendMes(pmap, FmFileReDomainBean.class);
    }

    public FmFileReDomainBean downloadFile(String fileCode) {
        PostParamMap pmap = new PostParamMap("fm.file.getDownloadFile");
        pmap.putParam("fileCode", (Object)fileCode);
        return (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
    }

    public HtmlJsonReBean saveFchannel(FmFchannelDomainBean fmFchannelDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.saveFchannel");
        pmap.putParamToJson("fmFchannelDomainBeanBean", (Object)fmFchannelDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFchannel(FmFchannelDomainBean fmFchannelDomainBean) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFchannel");
        pmap.putParamToJson("fmFchannelDomainBeanBean", (Object)fmFchannelDomainBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteFchannel(Integer fchannelId) {
        PostParamMap pmap = new PostParamMap("fm.file.deleteFchannel");
        pmap.putParam("fchannelId", (Object)fchannelId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateFchannelState(String fchannelId, String dataState, String oldDataState) {
        PostParamMap pmap = new PostParamMap("fm.file.updateFchannelState");
        pmap.putParam("fchannelId", (Object)Integer.valueOf(fchannelId));
        pmap.putParam("dataState", (Object)Integer.valueOf(dataState));
        pmap.putParam("oldDataState", (Object)Integer.valueOf(oldDataState));
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public FmFchannelReDomainBean getFchannel(Integer fchannelId) {
        PostParamMap pmap = new PostParamMap("fm.file.getFchannel");
        pmap.putParam("fchannelId", (Object)fchannelId);
        return (FmFchannelReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFchannelReDomainBean.class);
    }

    public SupQueryResult<FmFchannelReDomainBean> queryFchannelPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("fm.file.queryFchannelPage");
        pmap.putParam("map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        return this.htmlIBaseService.sendReSupObject(pmap, FmFchannelReDomainBean.class);
    }

    private FmFileReDomainBean asserblyFile(MultipartFile file, String tenantCode, String fileSort, String relationCode, String fileRemark) {
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            if (file == null) {
                return null;
            }
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            String filename = file.getOriginalFilename();
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            String name = filename.substring(0, filename.lastIndexOf("."));
            if (name.length() > 50) {
                throw new SupperSysException("error", "\u6587\u4ef6\u540d\u8fc7\u957f");
            }
            FmFileDomainBean FmFileDomainBeanBean = new FmFileDomainBean();
            FmFileDomainBeanBean.setFileName(name);
            FmFileDomainBeanBean.setFileSize((int)file.getSize());
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileCtype(fileType);
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            FmFileDomainBeanBean.setFileRemark(fileRemark);
            FmFileDomainBeanBean.setRelationCode(relationCode);
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            FileBean fileBean = new FileBean();
            fileBean.setFileType(fileType);
            fileBean.setOriginalFilename(name);
            fileBean.setSize(Long.valueOf(file.getSize()));
            InputStream is = file.getInputStream();
            byte[] b = new byte[(int)file.getSize()];
            is.read(b);
            fileBean.setBytes(b);
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFmFileDomainBeanBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            String fileUrl = fmFileReDomainBean.getFileUrl();
            if (StringUtils.isNotBlank((String)fileUrl)) {
                fmFileReDomainBean.setFileUrl(httpPath + System.getProperties().getProperty("file.separator") + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            throw new SupperSysException("error", e.getMessage());
        }
        return fmFileReDomainBean;
    }

    public Map<String, Object> updateFile(HttpServletRequest request, String tenantCode, String fileSort, String relationCode, String fileRemark) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer flexSize = 2;
        Integer returnInfo = 0;
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> fileCodes = new ArrayList<String>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map multipartFileMap = multipartRequest.getFileMap();
        for (Map.Entry entryFile : multipartFileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entryFile.getValue();
            if (StringUtils.isBlank((String)file.getOriginalFilename())) {
                returnInfo = 1;
                continue;
            }
            if (file == null) continue;
            long fileSize = file.getSize() / 1024L / 1024L;
            if (fileSize > (long)flexSize.intValue()) {
                returnInfo = 2;
                break;
            }
            FmFileReDomainBean FmFileDomainBean2 = this.saveFile(file, tenantCode, fileSort, relationCode, fileRemark);
            if (FmFileDomainBean2 != null) {
                returnInfo = 0;
                fileCodes.add(FmFileDomainBean2.getFileCode());
                urls.add(FmFileDomainBean2.getRootPath());
                break;
            }
            returnInfo = 3;
        }
        if (returnInfo == 0) {
            map.put("data", "success");
            map.put("msg", urls.get(0));
            map.put("tenantCode", tenantCode);
            map.put("fileCode", fileCodes.get(0));
        } else if (returnInfo == 1) {
            map.put("data", "error");
            map.put("msg", "\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        } else {
            map.put("data", "error");
            map.put("msg", "\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + flexSize + "M");
        }
        return map;
    }
}

