/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.oc.alirisk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestRequest;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestResponse;
import com.qjsoft.laser.controller.facade.oc.alirisk.entity.AliyunRiskRequest;
import com.qjsoft.laser.controller.facade.oc.alirisk.entity.AliyunRiskResponse;
import com.qjsoft.laser.controller.facade.oc.alirisk.entity.DomainStrEnum;
import com.qjsoft.laser.controller.facade.oc.alirisk.processor.AliyunRiskRequestProcessor;
import com.qjsoft.laser.controller.facade.oc.alirisk.processor.impl.DefaultAliyunRiskRequestProcessor;
import com.qjsoft.laser.controller.facade.oc.alirisk.service.AliyunRiskService;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import java.math.BigDecimal;
import javax.annotation.PostConstruct;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:/aliyunRiskConf.properties"})
public class AliyunRiskServiceImpl
extends ObjectService
implements AliyunRiskService,
EnvironmentAware {
    private Environment environment;
    protected Integer readTimeout;
    protected BigDecimal threshold;
    protected Integer isVerify;
    protected IAcsClient acsClient;
    protected AliyunRiskRequestProcessor aliyunRiskRequestProcessor = new DefaultAliyunRiskRequestProcessor();

    @PostConstruct
    public void init() {
        String regionId = this.environment.getProperty("aliyun.risk.regionId");
        String accessKeyId = this.environment.getProperty("aliyun.risk.acesskeyId");
        String secret = this.environment.getProperty("aliyun.risk.secertKey");
        String readTimeout = this.environment.getProperty("aliyun.risk.readTimeout");
        String threshold = this.environment.getProperty("aliyun.risk.threshold");
        String isVerify = this.environment.getProperty("aliyun.risk.isVerify");
        if (regionId == null || accessKeyId == null || secret == null || readTimeout == null || threshold == null || isVerify == null) {
            throw new IllegalArgumentException("ali risk info is null");
        }
        this.isVerify = Integer.parseInt(isVerify);
        this.threshold = new BigDecimal(threshold);
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)secret);
        DefaultProfile.addEndpoint((String)regionId, (String)"saf", (String)this.getDomain(false, regionId));
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    public BigDecimal threshold() {
        return this.threshold;
    }

    @Override
    public Integer isVerify() {
        return this.isVerify;
    }

    @Override
    public AliyunRiskResponse analysis(AliyunRiskRequest request) throws Exception {
        ExecuteRequestRequest executeRequest = this.beforeRequest(request);
        this.aliyunRiskRequestProcessor.process(executeRequest, request.getBaseAliyunRiskParams());
        ExecuteRequestResponse executeRequestResponse = (ExecuteRequestResponse)this.acsClient.getAcsResponse((AcsRequest)executeRequest);
        AliyunRiskResponse aliyunRiskResponse = this.afterRequest(executeRequestResponse);
        this.logger.info("\u963f\u91cc\u4e91\u98ce\u9669\u8bc6\u522b\u54cd\u5e94\uff1a {}", (Object)aliyunRiskResponse);
        return aliyunRiskResponse;
    }

    @Override
    public AliyunRiskResponse analysis(AliyunRiskRequest request, AliyunRiskRequestProcessor processor) throws Exception {
        ExecuteRequestRequest executeRequest = this.beforeRequest(request);
        processor.process(executeRequest, request.getBaseAliyunRiskParams());
        ExecuteRequestResponse executeRequestResponse = (ExecuteRequestResponse)this.acsClient.getAcsResponse((AcsRequest)executeRequest);
        AliyunRiskResponse aliyunRiskResponse = this.afterRequest(executeRequestResponse);
        this.logger.info("\u963f\u91cc\u4e91\u98ce\u9669\u8bc6\u522b\u54cd\u5e94\uff1a {}", (Object)aliyunRiskResponse);
        return aliyunRiskResponse;
    }

    protected ExecuteRequestRequest beforeRequest(AliyunRiskRequest request) {
        if (null == request.getServiceEnum()) {
            throw new IllegalArgumentException("service type not null");
        }
        if (null == request.getBaseAliyunRiskParams()) {
            throw new IllegalArgumentException("biz params is not null");
        }
        ExecuteRequestRequest executeRequest = new ExecuteRequestRequest();
        executeRequest.setMethod(MethodType.POST);
        executeRequest.setService(request.getServiceEnum().getValue());
        executeRequest.setReadTimeout(this.readTimeout);
        return executeRequest;
    }

    protected AliyunRiskResponse afterRequest(ExecuteRequestResponse executeRequestResponse) {
        return (AliyunRiskResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)executeRequestResponse), AliyunRiskResponse.class);
    }

    protected String getDomain(boolean isVpc, String regionId) {
        String product = DomainStrEnum.PRODUCT.getStr();
        if (isVpc) {
            product = product + DomainStrEnum.VPC.getStr();
        }
        if (DomainStrEnum.SHANG_HAI.getStr().equals(regionId)) {
            return product + DomainStrEnum.SUFFIX.getStr();
        }
        if (DomainStrEnum.HANG_ZHOU.getStr().equals(regionId)) {
            return product + DomainStrEnum.SUFFIX.getStr();
        }
        if (DomainStrEnum.SHEN_ZHEN.getStr().equals(regionId)) {
            return product + DomainStrEnum.SUFFIX.getStr();
        }
        if (DomainStrEnum.ZHANG_JIA_KOU.getStr().equals(regionId)) {
            return product + DomainStrEnum.SUFFIX.getStr();
        }
        if (DomainStrEnum.BEI_JING.getStr().equals(regionId)) {
            return product + DomainStrEnum.SUFFIX.getStr();
        }
        return DomainStrEnum.DEFAULT.getStr();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public void setIsVerify(Integer isVerify) {
        this.isVerify = isVerify;
    }

    public void setAcsClient(IAcsClient acsClient) {
        this.acsClient = acsClient;
    }

    public void setAliyunRiskRequestProcessor(AliyunRiskRequestProcessor aliyunRiskRequestProcessor) {
        this.aliyunRiskRequestProcessor = aliyunRiskRequestProcessor;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public BigDecimal getThreshold() {
        return this.threshold;
    }

    public Integer getIsVerify() {
        return this.isVerify;
    }

    public IAcsClient getAcsClient() {
        return this.acsClient;
    }

    public AliyunRiskRequestProcessor getAliyunRiskRequestProcessor() {
        return this.aliyunRiskRequestProcessor;
    }
}

