/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fc.domain.FcTrainuserEntryDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTrainuserEntryReDomain;
import com.qjsoft.laser.controller.facade.fc.repository.FcTrainuserEntryServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.fc.controller.exceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fc/trainuserEntry"}, name="\u7528\u6237\u57f9\u8bad\u6761\u76ee\u670d\u52a1")
public class TrainuserEntryCon
extends SpringmvcController {
    private static String CODE = "fc.trainuserEntry.con";
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private FcTrainuserEntryServiceRepository fcTrainuserEntryServiceRepository;

    protected String getContext() {
        return "trainuserEntry";
    }

    @RequestMapping(value={"saveTrainuserEntry.json"}, name="\u589e\u52a0\u7528\u6237\u57f9\u8bad\u6761\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTrainuserEntry(HttpServletRequest request, FcTrainuserEntryDomain fcTrainuserEntryDomain) {
        if (null == fcTrainuserEntryDomain) {
            this.logger.error(CODE + ".saveTrainuserEntry", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcTrainuserEntryDomain.setTenantCode(this.getTenantCode(request));
        return this.fcTrainuserEntryServiceRepository.saveTrainuserEntry(fcTrainuserEntryDomain);
    }

    @RequestMapping(value={"getTrainuserEntry.json"}, name="\u83b7\u53d6\u7528\u6237\u89c6\u9891\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getTrainuserEntry(Integer trainuserEntryId) {
        if (StringUtils.isBlank((Integer)trainuserEntryId)) {
            this.logger.error(CODE + ".getTrainuserEntry", (Object)"param is null");
            return null;
        }
        FcTrainuserEntryReDomain trainuserEntry = this.fcTrainuserEntryServiceRepository.getTrainuserEntry(trainuserEntryId);
        if (trainuserEntry == null) {
            return new HtmlJsonReBean(CODE, "trainuserEntry is null");
        }
        return new HtmlJsonReBean((Object)trainuserEntry);
    }

    @RequestMapping(value={"updateTrainuserEntry.json"}, name="\u66f4\u65b0\u7528\u6237\u57f9\u8bad\u6761\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTrainuserEntry(HttpServletRequest request, FcTrainuserEntryDomain fcTrainuserEntryDomain) {
        if (null == fcTrainuserEntryDomain) {
            this.logger.error(CODE + ".updateTrainuserEntry", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcTrainuserEntryDomain.setTenantCode(this.getTenantCode(request));
        return this.fcTrainuserEntryServiceRepository.updateTrainuserEntry(fcTrainuserEntryDomain);
    }

    @RequestMapping(value={"deleteTrainuserEntry.json"}, name="\u5220\u9664\u7528\u6237\u57f9\u8bad\u6761\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTrainuserEntry(Integer trainuserEntryId) {
        if (StringUtils.isBlank((Integer)trainuserEntryId)) {
            this.logger.error(CODE + ".deleteTrainuserEntry", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcTrainuserEntryServiceRepository.deleteTrainuserEntry(trainuserEntryId);
    }

    @RequestMapping(value={"queryTrainuserEntryPage.json"}, name="\u67e5\u8be2\u7528\u6237\u89c6\u9891\u62a5\u8868")
    @ResponseBody
    public SupQueryResult<FcTrainuserEntryReDomain> queryTrainuserEntryPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String proappCode = this.getProappCode(request);
        if (null != param && "032".equals(proappCode)) {
            param.put("traintemOcode3", "1");
        }
        SupQueryResult supQueryResult = this.fcTrainuserEntryServiceRepository.queryTrainuserEntryPage(param);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            String fileName = "\u57f9\u8bad\u62a5\u8868\u5bfc\u51fa";
            ArrayList<SupQueryResult> resultList = new ArrayList<SupQueryResult>();
            List jsonToList = null;
            String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
            Boolean flag = Boolean.valueOf(exportFlag);
            if (flag.booleanValue()) {
                String userCode;
                String string = userCode = null == param.get("userCode") ? null : (String)param.get("userCode");
                if (StringUtils.isBlank((String)userCode)) {
                    UserSession userSession = this.getUserSession(request);
                    userCode = userSession.getUserCode();
                }
                infoMap.put("userCode", userCode);
                infoMap.put("fileName", fileName);
                infoMap.put("headMap", ExcelExportTemplate.CourseWatchExcelParam());
                try {
                    resultList.add(supQueryResult);
                    String str = JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList());
                    jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, Map.class);
                    this.exportExcel(request, param, infoMap, jsonToList);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".excelExportGoods.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                    SupQueryResult errorResult = new SupQueryResult();
                    errorResult.setTotal(-1L);
                    return errorResult;
                }
                return null;
            }
        }
        return supQueryResult;
    }

    @RequestMapping(value={"queryRecentVideoPage.json"}, name="\u67e5\u8be2\u6700\u8fd1\u89c2\u770b\u7684\u89c6\u9891")
    @ResponseBody
    public List<FcTrainuserEntryReDomain> queryRecentTrainuserEntryPage(HttpServletRequest request, String recentNum, String trainuserCode) {
        UserSession userSession = this.getUserSession(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("recentNum", recentNum);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("trainuserCode", trainuserCode);
        map.put("traintemOcode3", "1");
        return this.fcTrainuserEntryServiceRepository.queryRecentVideos(map);
    }

    @RequestMapping(value={"updateTrainuserEntryState.json"}, name="\u66f4\u65b0\u7528\u6237\u57f9\u8bad\u6761\u76ee\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTrainuserEntryState(String trainuserEntryId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)trainuserEntryId)) {
            this.logger.error(CODE + ".updateTrainuserEntryState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcTrainuserEntryServiceRepository.updateTrainuserEntryState(Integer.valueOf(trainuserEntryId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateVideoProgress.json"}, name="\u66f4\u65b0\u89c6\u9891\u8fdb\u5ea6")
    @ResponseBody
    public HtmlJsonReBean updateVideoProgress(HttpServletRequest request, Integer trainuserEntryId, Integer traintemProgress, Integer traintemEntryStart, Integer traintemEntryEnd, Integer dataState) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("trainuserEntryId", trainuserEntryId);
        map.put("traintemEntryStart", traintemEntryStart);
        map.put("traintemEntryEnd", traintemEntryEnd);
        map.put("traintemProgress", traintemProgress);
        if (dataState != 2) {
            map.put("dataState", 1);
            if (traintemEntryStart.equals(traintemEntryEnd)) {
                map.put("dataState", 2);
            }
        }
        return this.fcTrainuserEntryServiceRepository.updateVideoProgress(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, List<Map<String, Object>> fromDataList) {
        this.logger.info("=======================\u4f20\u5165\u7684\u6570\u91cf===================" + fromDataList.size());
        this.logger.error("paramMap-_=+is", paramMap);
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    if ("gmtModified".equals(beanName)) {
                        Object date = map.get(beanName);
                        this.logger.info("\u65f6\u95f4:" + date);
                        value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    } else {
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    }
                    if (map.get(beanName) != null && "traintemProgress".equals(beanName)) {
                        Integer traintemProgress = (Integer)map.get(beanName);
                        BigDecimal divide = BigDecimal.valueOf(traintemProgress.intValue()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                        this.logger.error("------------1>", (Object)JsonUtil.buildNormalBinder().toJson((Object)divide.toString()));
                        String progress = divide + "%";
                        map.put("traintemProgress", progress);
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    }
                    if (map.get(beanName) != null && "traintemEntryStart".equals(beanName)) {
                        Integer traintemEntryStart = (Integer)map.get(beanName);
                        String formattedTime = String.format("%02d:%02d:%02d", traintemEntryStart / 3600, traintemEntryStart % 3600 / 60, traintemEntryStart % 60);
                        map.put("traintemEntryStart", formattedTime);
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    }
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
            this.logger.info("================================\u6570\u91cf==================================" + dataList.size());
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
            return;
        }
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException beanName) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    public void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }
}

