/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/fc/shardFile"}, name="\u5206\u7247\u4e0a\u4f20\u6587\u4ef6")
public class ShardFileController
extends SpringmvcController {
    private static String CODE = "fc.shardFile.con";
    @Autowired
    private FileServiceRepository fileServiceRepository;
    private static final String UPLOAD_DIR = "uploads/";
    private ConcurrentHashMap<String, Integer> uploadedChunks = new ConcurrentHashMap();

    protected String getContext() {
        return null;
    }

    @RequestMapping(value={"uploadShardFile.json"}, name="\u5206\u7247\u4e0a\u4f20\u89c6\u9891\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadShardFile(HttpServletRequest request, MultipartFile file, String fileSort, String fileName, int chunkIndex, int totalChunks) throws Exception {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileOwner = null;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"\u672a\u767b\u9646");
            return null;
        }
        fileOwner = "plat".equals(userSession.getUserinfoQuality()) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        File uploadDir = new File(UPLOAD_DIR);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        File tempFile = new File(UPLOAD_DIR + fileName + ".part" + chunkIndex);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            fos.write(file.getBytes());
        }
        this.uploadedChunks.put(fileName + chunkIndex, chunkIndex);
        if (this.uploadedChunks.size() == totalChunks) {
            File finalFile = this.combineChunks(fileName, totalChunks);
            FmFileReDomainBean fmFileReDomainBean = this.fileServiceRepository.saveFile(Files.readAllBytes(Paths.get(finalFile.getPath(), new String[0])), tenantCode, fileSort, null, null, fileName);
            this.uploadedChunks.clear();
            return fmFileReDomainBean;
        }
        return null;
    }

    private File combineChunks(String fileName, int totalChunks) throws IOException {
        File finalFile = new File(UPLOAD_DIR + fileName);
        try (FileOutputStream fos = new FileOutputStream(finalFile, true);){
            for (int i = 0; i < totalChunks; ++i) {
                File partFile = new File(UPLOAD_DIR + fileName + ".part" + i);
                fos.write(Files.readAllBytes(partFile.toPath()));
                partFile.delete();
            }
        }
        return finalFile;
    }
}

