/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/fc/shardFile"}, name="\u5206\u7247\u4e0a\u4f20\u6587\u4ef6")
public class ShardFileController
extends SpringmvcController {
    private static String CODE = "fc.shardFile.con";
    private static final String UPLOAD_DIR = "uploads/";
    private static final String BASE_URL = "rcyx-video/peixun/";
    @Autowired
    private FileServiceRepository fileServiceRepository;
    private ConcurrentHashMap<String, Integer> uploadedChunks = new ConcurrentHashMap();

    protected String getContext() {
        return "ShardFileController";
    }

    protected String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(byte[] bytes, String objectName, String tenantCode) {
        String accessKeyId = this.getDdFlag(tenantCode, "accessKeyId", "accessKeyId");
        String accessKeySecret = this.getDdFlag(tenantCode, "accessKeySecret", "accessKeySecret");
        String bucketName = this.getDdFlag(tenantCode, "bucketName", "bucketName");
        String endpoint = this.getDdFlag(tenantCode, "endpoint", "endpoint");
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        try {
            ossClient.putObject(bucketName, objectName, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (OSSException oe) {
            System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            System.out.println("Error Message:" + oe.getErrorMessage());
            System.out.println("Error Code:" + oe.getErrorCode());
            System.out.println("Request ID:" + oe.getRequestId());
            System.out.println("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            System.out.println("Error Message:" + ce.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("https://");
        stringBuilder.append(bucketName).append(".").append(endpoint).append("/").append(objectName);
        return stringBuilder.toString();
    }

    @RequestMapping(value={"uploadShardFile.json"}, name="\u5206\u7247\u4e0a\u4f20\u89c6\u9891\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadShardFile(HttpServletRequest request, MultipartFile file, String fileSort, String fileType, String fileName, int chunkIndex, int totalChunks) throws Exception {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        File uploadDir = new File(UPLOAD_DIR);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        File tempFile = new File(UPLOAD_DIR + fileName + ".part" + chunkIndex);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            fos.write(file.getBytes());
        }
        this.uploadedChunks.put(fileName + chunkIndex, chunkIndex);
        if (this.uploadedChunks.size() == totalChunks) {
            File finalFile = this.combineChunks(fileName, totalChunks);
            String objectName = this.fileNameGenerator(fileName, fileType);
            String filePath = this.upload(Files.readAllBytes(Paths.get(finalFile.getPath(), new String[0])), objectName, tenantCode);
            this.uploadedChunks.clear();
            FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
            fmFileReDomainBean.setFileUrl(filePath);
            return fmFileReDomainBean;
        }
        return null;
    }

    private String fileNameGenerator(String fileName, String fileType) {
        Date now = new Date();
        SimpleDateFormat dirFormatter = new SimpleDateFormat("yyyy-MM");
        String dateDir = dirFormatter.format(now);
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String hashPrefix = DigestUtils.md5Hex((String)uuid).substring(0, 4);
        return String.format("%s%s/%s_%s.%s", BASE_URL, dateDir, hashPrefix, uuid, fileType);
    }

    private File combineChunks(String fileName, int totalChunks) throws IOException {
        File finalFile = new File(UPLOAD_DIR + fileName);
        try (FileOutputStream fos = new FileOutputStream(finalFile, true);){
            for (int i = 0; i < totalChunks; ++i) {
                File partFile = new File(UPLOAD_DIR + fileName + ".part" + i);
                fos.write(Files.readAllBytes(partFile.toPath()));
                partFile.delete();
            }
        }
        return finalFile;
    }
}

