/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.interceptor.service;

import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.interceptor.bean.InterBean;
import com.qjsoft.laser.controller.interceptor.bean.OsOAuthConfigDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BaseInterUtil {
    public static String TenantCode = "saas-tenantcode";
    public static String CookieToken = "saas-token";
    public static String CookieUser = "saas-user";
    public static String ProappCode = "saas-proappcode";
    public static String TginfoCode = "saas-tginfocode";
    public static String ProappEnv = "saas-proappEnv";
    public static String ResparamTokenkey = "tokenkey";
    public static String SESSION_KEY = "laser_usersession";
    public static String UP_URL = "laser_upurl";
    public static String COMPANYCODE_KEY = "saas-companycode";
    public static String OrgUsercode_KEY = "saas-orgusercode";

    public static String getCacheComTenantCode(String key, String domain, String contextPath, String oauthEnvCode) {
        if (StringUtils.isBlankLoop((String[])new String[]{domain, contextPath, oauthEnvCode})) {
            return null;
        }
        String checkdomain = domain;
        String cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
        }
        int len = checkdomain.split(".").length;
        if (StringUtils.isBlank((String)cacheTenantCode) && len > 1) {
            switch (len) {
                case 2: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                    }
                    if (!StringUtils.isNotBlank((String)cacheTenantCode)) break;
                    return cacheTenantCode;
                }
                case 3: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (!StringUtils.isBlank((String)cacheTenantCode)) break;
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                    break;
                }
                case 4: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (!StringUtils.isBlank((String)cacheTenantCode)) break;
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + "*" + "-" + oauthEnvCode));
                }
            }
        }
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = BaseInterUtil.getHost(key, checkdomain, contextPath, oauthEnvCode);
        }
        return cacheTenantCode;
    }

    public static String getHost(String key, String domain, String contextPath, String oauthEnvCode) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (StringUtils.isBlankLoop((String[])new String[]{domain, contextPath, oauthEnvCode})) {
            return null;
        }
        if (!"TmProoapp-domain".equals(key)) {
            return null;
        }
        String cacheTenantCode = SupDisUtil.getMap((String)key, (String)("host-" + contextPath + "-" + oauthEnvCode));
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = SupDisUtil.getMap((String)key, (String)("host-*-" + oauthEnvCode));
        }
        return cacheTenantCode;
    }

    public static void putTokenHeader(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(CookieToken, token);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(CookieToken, (Object)token);
    }

    public static void putTenantHeader(HttpServletRequest request, HttpServletResponse response, String tenantCode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(TenantCode, tenantCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(TenantCode, (Object)tenantCode);
    }

    public static void putProappHeader(HttpServletRequest request, HttpServletResponse response, String proappCode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(ProappCode, proappCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(ProappCode, (Object)proappCode);
    }

    public static void putOrgUsercodeHeader(HttpServletRequest request, HttpServletResponse response, String orgUsercode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(OrgUsercode_KEY, orgUsercode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(OrgUsercode_KEY, (Object)orgUsercode);
        BaseInterUtil.putOrgCookie(request, response, BaseInterUtil.getProappCode(request), OrgUsercode_KEY, orgUsercode, BaseInterUtil.getTenantCode(request));
    }

    protected static String getDomain(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String domain = request.getServerName();
        return domain;
    }

    public static void putOrgCookie(HttpServletRequest request, HttpServletResponse response, String proappCode, String key, String code, String tenantCode) {
        if (null == key) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String host = BaseInterUtil.getDomain(request);
        OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(proappCode, null, tenantCode, host);
        if (null == osOAuthConfigReDomain || StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            return;
        }
        if (null == code) {
            code = "";
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String cookieCode = "";
        if (null != cookieMap && cookieMap.isEmpty() && null == (cookieCode = cookieMap.get(key))) {
            cookieCode = "";
        }
        if (code.equals(cookieCode)) {
            return;
        }
        Cookie _cookie = new Cookie(key, code);
        _cookie.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookie.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        _cookie.setHttpOnly(true);
        Integer expiry = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiry) {
            expiry = 6000;
        }
        _cookie.setMaxAge(expiry.intValue());
        if (StringUtils.isBlank((String)code)) {
            _cookie.setMaxAge(0);
        }
        response.addCookie(_cookie);
    }

    public static void putTginfoHeader(HttpServletRequest request, HttpServletResponse response, String tginfoCode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(TginfoCode, tginfoCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(TginfoCode, (Object)tginfoCode);
    }

    public static void putProappEnvHeader(HttpServletRequest request, HttpServletResponse response, String proappEnv) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(ProappEnv, proappEnv);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(ProappEnv, (Object)proappEnv);
    }

    public static Boolean isJsonRequest(HttpServletRequest request) {
        String url = request.getServletPath();
        return url.endsWith(".json") || StringUtils.isNotBlank((String)request.getHeader("X-Requested-With"));
    }

    public static String getUrl(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String queryString = request.getQueryString();
        String url = !StringUtils.isEmpty((String)queryString) && queryString.indexOf("=") > 0 ? request.getServletPath() + "?" + queryString : request.getServletPath();
        return url;
    }

    public static String getRedurl(HttpServletRequest request, String url) {
        if (null == request || StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            String redurl = URLEncoder.encode(request.getContextPath() + url, "UTF-8");
            return redurl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTokenGroup(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request || null == cookieMap) {
            return null;
        }
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return BaseInterUtil.getTokenGroup(proappCode, tenantCode);
    }

    public static String getTokenGroup(String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String key = proappCode + "-" + tenantCode;
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        if (StringUtils.isBlank((String)group)) {
            key = proappCode + "-" + "00000000";
            group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        }
        return group;
    }

    public static String getToKen(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String token = request.getHeader(CookieToken);
        if (StringUtils.isBlank((String)token)) {
            Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
            String group = BaseInterUtil.getTokenGroup(request, cookieMap);
            token = BaseInterUtil.getToKen(request, group, cookieMap);
        }
        return token;
    }

    public static String getToKen(HttpServletRequest request, String group) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getToKen(request, group, cookieMap);
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == response) {
            return;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        BaseInterUtil.putTokenCookie(request, response, proappCode, token, tenantCode);
    }

    public static UserInfo getUserInfo(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getSession(request);
        if (null == userSession) {
            return null;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setTicketTokenid(userSession.getTicketTokenid());
        userInfo.setMerberCompname(userSession.getMerberCompname());
        userInfo.setUserCode(userSession.getUserCode());
        userInfo.setUserId(userSession.getUserId());
        userInfo.setUserImgurl(userSession.getUserImgurl());
        userInfo.setUserMsg(userSession.getUserMsg());
        userInfo.setUserName(userSession.getUserName());
        userInfo.setUserNickname(userSession.getUserNickname());
        userInfo.setUserRelname(userSession.getUserRelname());
        userInfo.setUserType(userSession.getUserType());
        userInfo.setCompanyCode(userSession.getCompanyCode());
        userInfo.setEmpType(userSession.getEmpType());
        userInfo.setEmpTypecode(userSession.getEmpTypecode());
        userInfo.setUserInfoCode(userSession.getUserPcode());
        userInfo.setUserPhone(userSession.getUserPhone());
        return userInfo;
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, String proappCode, String token, String tenantCode) {
        if (null == response) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String host = BaseInterUtil.getDomain(request);
        OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(proappCode, null, tenantCode, host);
        if (null == osOAuthConfigReDomain || StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            return;
        }
        if (null == token) {
            token = "";
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String tokenKey = CookieToken + "-" + osOAuthConfigReDomain.getAppmanageGroup();
        String cookieToken = "";
        if (null != cookieMap && cookieMap.isEmpty() && null == (cookieToken = cookieMap.get(tokenKey))) {
            cookieToken = "";
        }
        if (StringUtils.isNotBlank((String)token) && token.equals(cookieToken)) {
            return;
        }
        Cookie _cookie = new Cookie(CookieToken + "-" + osOAuthConfigReDomain.getAppmanageGroup(), token);
        _cookie.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookie.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        Integer expiry = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiry) {
            expiry = 6000;
        }
        _cookie.setMaxAge(expiry.intValue());
        if (StringUtils.isBlank((String)token)) {
            _cookie.setMaxAge(0);
        }
        response.addCookie(_cookie);
        String json = "";
        if (StringUtils.isBlank((String)token)) {
            json = "";
        } else {
            json = JsonUtil.buildNormalBinder().toJson((Object)BaseInterUtil.getUserInfo(request));
            try {
                json = URLEncoder.encode(json, "utf-8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Cookie _cookieuser = new Cookie(CookieUser + "-" + osOAuthConfigReDomain.getAppmanageGroup(), json);
        _cookieuser.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookieuser.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        Integer expiryuser = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiryuser) {
            expiry = 6000;
        }
        _cookieuser.setMaxAge(expiryuser.intValue());
        if (StringUtils.isBlank((String)token)) {
            _cookieuser.setMaxAge(0);
        }
        response.addCookie(_cookieuser);
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, InterBean interBean) {
        if (null == interBean || StringUtils.isBlank((String)interBean.getProappCode()) || StringUtils.isBlank((String)interBean.getTenantCode())) {
            return;
        }
        BaseInterUtil.putTokenCookie(request, response, interBean.getProappCode(), interBean.getToken(), interBean.getTenantCode());
    }

    public static OsOAuthConfigDomain getOsOAuthConfigDomain(String proappCode, String oauthEnvCode, String tenantCode, String host) {
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OsOAuthConfigDomain cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getMapJson((String)"OsOAuthConfig_Key", (String)(proappCode + "-" + tenantCode), OsOAuthConfigDomain.class);
        if (null == cacheOsOAuthConfigReDomain) {
            cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getMapJson((String)"OsOAuthConfig_Key", (String)(proappCode + "-" + "00000000"), OsOAuthConfigDomain.class);
        }
        if (null == cacheOsOAuthConfigReDomain) {
            return null;
        }
        OsOAuthConfigDomain osOAuthConfigReDomain = new OsOAuthConfigDomain();
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfigReDomain, (Object)cacheOsOAuthConfigReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigUrl())) {
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigIndexurl())) {
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigNoresurl())) {
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            String domain;
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{host}") >= 0) {
                if (null == host) {
                    host = "";
                }
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{host}", host));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain"));
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain0}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain0"));
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain0}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain1}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain1"));
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain1}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain2}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain2"));
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain2}", domain));
            }
        }
        return osOAuthConfigReDomain;
    }

    public static String getToKen(HttpServletRequest request, String group, Map<String, String> cookieMap) {
        if (null == cookieMap) {
            return null;
        }
        String token = cookieMap.get(CookieToken + "-" + group);
        if (StringUtils.isBlank((String)token) && null != request) {
            token = request.getParameter(ResparamTokenkey);
        }
        return token;
    }

    public static void putSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession) {
        if (null == request || null == request.getSession()) {
            return;
        }
        request.getSession().setAttribute(SESSION_KEY, (Object)userSession);
        if (null != userSession) {
            BaseInterUtil.putTenantHeader(request, response, userSession.getTenantCode());
        }
    }

    public static UserSession getSession(HttpServletRequest request) {
        if (null == request || null == request.getSession()) {
            return null;
        }
        return (UserSession)request.getSession().getAttribute(SESSION_KEY);
    }

    public static String getSessionCompany(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        if (null == request || null == request.getSession()) {
            return null;
        }
        String companyCode = request.getHeader(COMPANYCODE_KEY);
        if (StringUtils.isBlank((String)companyCode)) {
            companyCode = (String)request.getSession().getAttribute(COMPANYCODE_KEY);
        }
        if (StringUtils.isBlank((String)companyCode) && null != (cookies = request.getCookies())) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(COMPANYCODE_KEY)) continue;
                companyCode = cookie.getValue();
                return companyCode;
            }
        }
        return companyCode;
    }

    public static void setSessionCompany(HttpServletRequest request, HttpServletResponse response, String companyCode) {
        if (null == request || null == request.getSession()) {
            return;
        }
        response.setHeader(COMPANYCODE_KEY, companyCode);
        request.getSession().setAttribute(COMPANYCODE_KEY, (Object)companyCode);
        BaseInterUtil.putOrgCookie(request, response, BaseInterUtil.getProappCode(request), COMPANYCODE_KEY, companyCode, BaseInterUtil.getTenantCode(request));
    }

    public static String getRequestservice(HttpServletRequest request, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        String schemeStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-scheme-scheme"));
        String ddserverName = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-serverName-serverName"));
        String serverName = request.getServerName();
        if (StringUtils.isNotBlank((String)ddserverName) && serverName.contains(ddserverName)) {
            schemeStr = "https";
        }
        schemeStr = StringUtils.isBlank((String)schemeStr) ? "http" : schemeStr;
        String str = schemeStr + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            str = str + ":" + request.getServerPort();
        }
        return str;
    }

    public static String getTenantCode(HttpServletRequest request, Map<String, String> cookieMap) {
        HttpSession httpSession;
        if (null == request) {
            return null;
        }
        String tenantCode = request.getHeader(TenantCode);
        if (StringUtils.isBlank((String)tenantCode) && null != cookieMap) {
            tenantCode = cookieMap.get(TenantCode);
        }
        if (null == (httpSession = request.getSession())) {
            return null;
        }
        tenantCode = (String)httpSession.getAttribute(TenantCode);
        return tenantCode;
    }

    public static String getTenantCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTenantCode(request, cookieMap);
    }

    public static String getProappCode(HttpServletRequest request, Map<String, String> cookieMap) {
        HttpSession httpSession;
        if (null == request) {
            return null;
        }
        String proappCode = request.getHeader(ProappCode);
        if (StringUtils.isBlank((String)proappCode) && null != cookieMap) {
            proappCode = cookieMap.get(ProappCode);
        }
        if (null == (httpSession = request.getSession())) {
            return null;
        }
        proappCode = (String)httpSession.getAttribute(ProappCode);
        return proappCode;
    }

    public static String getOrgUsercode(HttpServletRequest request, Map<String, String> cookieMap) {
        HttpSession httpSession;
        if (null == request) {
            return null;
        }
        String orgUsercode = request.getHeader(OrgUsercode_KEY);
        if (StringUtils.isBlank((String)orgUsercode) && null != cookieMap) {
            orgUsercode = cookieMap.get(OrgUsercode_KEY);
        }
        if (null == (httpSession = request.getSession())) {
            return null;
        }
        orgUsercode = (String)httpSession.getAttribute(OrgUsercode_KEY);
        return orgUsercode;
    }

    public static String getTginfoCode(HttpServletRequest request, Map<String, String> cookieMap) {
        HttpSession httpSession;
        if (null == request) {
            return null;
        }
        String tginfoCode = request.getHeader(TginfoCode);
        if (StringUtils.isBlank((String)tginfoCode) && null != cookieMap) {
            tginfoCode = cookieMap.get(TginfoCode);
        }
        if (null == (httpSession = request.getSession())) {
            return null;
        }
        tginfoCode = (String)httpSession.getAttribute(TginfoCode);
        return tginfoCode;
    }

    public static String getProappCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getProappCode(request, cookieMap);
    }

    public static String getTginfoCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTginfoCode(request, cookieMap);
    }

    public static Map<String, String> getSaaSCookies(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("saas-")) continue;
            map.put(cookie.getName(), cookie.getValue());
        }
        return map;
    }
}

