/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.inv.controller;

import com.alibaba.fastjson.JSONArray;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistGoodsDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistGoodsReDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistReDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvsetReDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvUserinvDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvUserinvReDomain;
import com.qjsoft.laser.controller.facade.inv.repository.InvInvlistGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.inv.repository.InvInvlistServiceRepository;
import com.qjsoft.laser.controller.facade.inv.repository.InvInvsetServiceRepository;
import com.qjsoft.laser.controller.facade.inv.repository.InvUserinvServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.sg.domain.SgSendgoodsGoodsReDomain;
import com.qjsoft.laser.controller.facade.sg.domain.SgSendgoodsReDomain;
import com.qjsoft.laser.controller.facade.sg.repository.SgSendgoodsServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.inv.exceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.qjsoft.laser.controller.util.ExcelUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/inv/invlist"}, name="\u5f00\u7968\u6d41\u6c34")
public class InvlistCon
extends SpringmvnNewController {
    private static String CODE = "inv.invlist.con";
    @Autowired
    private InvInvlistServiceRepository invInvlistServiceRepository;
    @Autowired
    private InvUserinvServiceRepository invUserinvServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private InvInvsetServiceRepository invInvsetServiceRepository;
    @Autowired
    private SgSendgoodsServiceRepository sgSendgoodsServiceRepository;
    @Autowired
    private InvInvlistGoodsServiceRepository invInvlistGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "invlist";
    }

    @RequestMapping(value={"saveInvlist.json"}, name="\u589e\u52a0\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveInvlist(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean;
        if (null == paramStr) {
            this.logger.error(CODE + ".saveInvlist", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        InvInvlistDomain invInvlistDomain = (InvInvlistDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, InvInvlistDomain.class);
        BigDecimal invlistOpamt = invInvlistDomain.getInvlistOpamt();
        if (null == invlistOpamt || invlistOpamt.compareTo(BigDecimal.ZERO) <= 0 || StringUtils.isBlank((String)invInvlistDomain.getInvlistOpcode())) {
            this.logger.error(CODE + ".saveInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        InvUserinvDomain invUserinvDomain = invInvlistDomain.getInvUserinvDomain();
        String code = null;
        if (null == invUserinvDomain.getUserinvCode() || "" == invUserinvDomain.getUserinvCode()) {
            invUserinvDomain.setMemberCode(userSession.getUserPcode());
            invUserinvDomain.setMemberName(userSession.getUserName());
            invUserinvDomain.setUserCode(userSession.getUserCode());
            invUserinvDomain.setUserName(userSession.getUserName());
            invUserinvDomain.setTenantCode(this.getTenantCode(request));
            htmlJsonReBean = this.invUserinvServiceRepository.saveUserinv(invUserinvDomain);
            if (null != htmlJsonReBean.getDataObj()) {
                code = htmlJsonReBean.getDataObj().toString();
                invInvlistDomain.setUserinvCode(code);
            }
        }
        invInvlistDomain.setMemberCode(userSession.getUserPcode());
        invInvlistDomain.setMemberName(userSession.getUserName());
        invInvlistDomain.setUserCode(userSession.getUserCode());
        invInvlistDomain.setUserName(userSession.getUserName());
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        invInvlistDomain.setInvInvlistGoodsDomainList(this.getInvInvlistGoodsDomains(invInvlistDomain));
        htmlJsonReBean = this.invInvlistServiceRepository.saveInvlist(invInvlistDomain);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveInvlistByOcCodes.json"}, name="\u589e\u52a0\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveInvlistByOcCodes(HttpServletRequest request, String contractBillcodes, String paramStr) {
        if (StringUtils.isBlank((String)contractBillcodes) || StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        InvInvlistDomain invInvlistDomain = (InvInvlistDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, InvInvlistDomain.class);
        if (null == invInvlistDomain || StringUtils.isBlank((String)invInvlistDomain.getUserinvCode())) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        UserSession userSession = this.getUserSession(request);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(userSession.getTenantCode(), invInvlistDomain.getUserinvCode());
        if (null == invUserinvDomain) {
            this.logger.error(CODE + ".invUserinvDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinvCode\u53c2\u6570\u9519\u8bef");
        }
        this.makeInvInvlistDomain(invInvlistDomain, (InvUserinvDomain)invUserinvDomain);
        invInvlistDomain.setUserCode(userSession.getUserCode());
        invInvlistDomain.setUserName(userSession.getUserName());
        invInvlistDomain.setInvlistOptype("OcContract");
        String[] split = contractBillcodes.split(",");
        OcContractReDomain contractByCode = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", userSession.getTenantCode());
        String userinfcode = invUserinvDomain.getMemberCode();
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (String code : split) {
            map.put("contractBillcode", code);
            contractByCode = this.ocContractServiceRepository.getContractByCode(map);
            if (null == contractByCode || !contractByCode.getMemberCcode().equals(userSession.getUserPcode()) || 4 != contractByCode.getDataState() || 0 != contractByCode.getContractInvstate()) {
                this.logger.error(CODE + ".saveInvlistByOcCodes.contractByCode", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef[" + code + "]");
            }
            if (!userinfcode.equals(contractByCode.getMemberBcode())) {
                this.logger.error(CODE + ".saveInvlistByOcCodes.contractByCode", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef[" + code + "]");
            }
            invInvlistDomain.setInvlistOpamt(contractByCode.getDataBmoney());
            invInvlistDomain.setTenantCode(userSession.getTenantCode());
            invInvlistDomain.setInvlistOpcode(code);
            invInvlistDomain.setInvInvlistGoodsDomainList(this.makeInvInvlistGoods(contractByCode));
            htmlJsonReBean = this.invInvlistServiceRepository.saveInvlist(invInvlistDomain);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveInvlistByOcCodesPlat.json"}, name="\u589e\u52a0\u5f00\u7968\u6d41\u6c34\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public HtmlJsonReBean saveInvlistByOcCodesPlat(HttpServletRequest request, String contractBillcodes, String paramStr) {
        if (StringUtils.isBlank((String)contractBillcodes) || StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        InvInvlistDomain invInvlistDomain = (InvInvlistDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, InvInvlistDomain.class);
        if (null == invInvlistDomain || StringUtils.isBlank((String)invInvlistDomain.getUserinvCode())) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        UserSession userSession = this.getUserSession(request);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(userSession.getTenantCode(), invInvlistDomain.getUserinvCode());
        if (null == invUserinvDomain) {
            this.logger.error(CODE + ".invUserinvDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinvCode\u53c2\u6570\u9519\u8bef");
        }
        this.makeInvInvlistDomain(invInvlistDomain, (InvUserinvDomain)invUserinvDomain);
        invInvlistDomain.setUserCode(userSession.getUserCode());
        invInvlistDomain.setUserName(userSession.getUserName());
        invInvlistDomain.setInvlistOptype("OcContract");
        String[] split = contractBillcodes.split(",");
        OcContractReDomain contractByCode = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", userSession.getTenantCode());
        String userinfcode = invUserinvDomain.getMemberCode();
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (String code : split) {
            map.put("contractBillcode", code);
            contractByCode = this.ocContractServiceRepository.getContractByCode(map);
            if (null == contractByCode || !contractByCode.getMemberCode().equals(userSession.getUserPcode()) || 4 != contractByCode.getDataState() || 0 != contractByCode.getContractInvstate()) {
                this.logger.error(CODE + ".saveInvlistByOcCodes.contractByCode", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef[" + code + "]");
            }
            if (!userinfcode.equals(contractByCode.getMemberBcode())) {
                this.logger.error(CODE + ".saveInvlistByOcCodes.contractByCode", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef[" + code + "]");
            }
            invInvlistDomain.setInvlistOpamt(contractByCode.getDataBmoney());
            invInvlistDomain.setTenantCode(userSession.getTenantCode());
            invInvlistDomain.setInvlistOpcode(code);
            invInvlistDomain.setInvInvlistGoodsDomainList(this.makeInvInvlistGoods(contractByCode));
            htmlJsonReBean = this.invInvlistServiceRepository.saveInvlist(invInvlistDomain);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateInvlistBatchByCode.json"}, name="\u589e\u52a0\u5f00\u7968\u6d41\u6c34\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public HtmlJsonReBean saveInvlistByCode(HttpServletRequest request, String paramStr, String userinvCode) {
        if (StringUtils.isBlank((String)paramStr) || StringUtils.isBlank((String)userinvCode)) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List invInvlistDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, InvInvlistDomain.class);
        if (ListUtil.isEmpty((Collection)invInvlistDomainList)) {
            this.logger.error(CODE + ".saveInvlistByOcCodes", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        UserSession userSession = this.getUserSession(request);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(userSession.getTenantCode(), userinvCode);
        if (null == invUserinvDomain) {
            this.logger.error(CODE + ".invUserinvDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinvCode\u53c2\u6570\u9519\u8bef");
        }
        String tenantCode = userSession.getTenantCode();
        ArrayList<InvInvlistDomain> invInvlistDomains = new ArrayList<InvInvlistDomain>();
        for (InvInvlistDomain invInvlistDomain : invInvlistDomainList) {
            if (StringUtils.isBlank((String)invInvlistDomain.getInvlistCode())) {
                this.logger.error(CODE + ".invUserinvDomain", (Object)"InvlistCode is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
            }
            InvInvlistReDomain invlistByCode = this.invInvlistServiceRepository.getInvlistByCode(tenantCode, invInvlistDomain.getInvlistCode());
            if (null == invlistByCode || 10 != invlistByCode.getDataState()) {
                this.logger.error(CODE + "", (Object)"InvlistCode is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6216\u72b6\u6001\u9519\u8bef");
            }
            InvInvlistDomain invInvlist = this.makeInvInvlistDomain(invlistByCode);
            this.makeInvInvlistDomain(invInvlist, (InvUserinvDomain)invUserinvDomain);
            invInvlist.setTenantCode(tenantCode);
            invInvlistDomains.add(invInvlist);
        }
        return this.invInvlistServiceRepository.updateInvlistBatch(invInvlistDomains, Integer.valueOf(0), Integer.valueOf(10));
    }

    private InvInvlistDomain makeInvInvlistDomain(InvInvlistReDomain invlistByCode) {
        InvInvlistDomain invInvlistDomain = new InvInvlistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistDomain, (Object)invlistByCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".sgSendgoodsGoodsReDomainList", (Object)"fileList is null");
        }
        return invInvlistDomain;
    }

    private void makeInvInvlistDomain(InvInvlistDomain invInvlistDomain, InvUserinvDomain invUserinvDomain) {
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistDomain, (Object)invUserinvDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".sgSendgoodsGoodsReDomainList", (Object)"fileList is null");
        }
    }

    private List<InvInvlistGoodsDomain> makeInvInvlistGoods(OcContractReDomain contractByCode) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        if (ListUtil.isEmpty((Collection)contractByCode.getGoodsList())) {
            return invInvlistGoodsDomainList;
        }
        for (OcContractGoodsDomain OoContractGoodsDomain : contractByCode.getGoodsList()) {
            InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)OoContractGoodsDomain);
                invInvlistGoodsDomain.setInvlistOpcode(contractByCode.getContractBillcode());
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".OoContractGoodsDomainList", (Object)"fileList is null");
            }
        }
        return invInvlistGoodsDomainList;
    }

    @RequestMapping(value={"saveSgSendgoodsInvlist.json"}, name="\u589e\u52a0\u53d1\u8d27\u5355\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveSgSendgoodsInvlist(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveInvlist", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        InvInvlistDomain invInvlistDomain = (InvInvlistDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, InvInvlistDomain.class);
        invInvlistDomain.setInvlistOptype("SgSendgoods");
        SgSendgoodsReDomain sgSendgoodsReDomain = this.sgSendgoodsServiceRepository.getSendgoodsByCode(this.getTenantCode(request), invInvlistDomain.getInvlistOpcode());
        if (null == sgSendgoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ListUtil.isEmpty((Collection)sgSendgoodsReDomain.getSgSendgoodsGoodsReDomainList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u8d27\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvUserinvDomain invUserinvDomain = invInvlistDomain.getInvUserinvDomain();
        String code = null;
        if (null == invUserinvDomain.getUserinvCode() || "" == invUserinvDomain.getUserinvCode()) {
            invUserinvDomain.setMemberCode(userSession.getUserPcode());
            invUserinvDomain.setMemberName(userSession.getUserName());
            invUserinvDomain.setUserCode(userSession.getUserCode());
            invUserinvDomain.setUserName(userSession.getUserName());
            invUserinvDomain.setTenantCode(this.getTenantCode(request));
            HtmlJsonReBean htmlJsonReBean = this.invUserinvServiceRepository.saveUserinv(invUserinvDomain);
            if (null != htmlJsonReBean.getDataObj()) {
                code = htmlJsonReBean.getDataObj().toString();
                invInvlistDomain.setUserinvCode(code);
            }
        }
        invInvlistDomain.setMemberCode(userSession.getUserPcode());
        invInvlistDomain.setMemberName(userSession.getUserName());
        invInvlistDomain.setUserCode(userSession.getUserCode());
        invInvlistDomain.setUserName(userSession.getUserName());
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsReDomainList()) {
            InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)sgSendgoodsGoodsReDomain);
                invInvlistGoodsDomain.setInvlistOpcode(invInvlistDomain.getInvlistOpcode());
                invInvlistGoodsDomain.setInvlistCode(code);
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".sgSendgoodsGoodsReDomainList", (Object)"fileList is null");
            }
        }
        invInvlistDomain.setInvInvlistGoodsDomainList(invInvlistGoodsDomainList);
        HtmlJsonReBean htmlJsonReBean = this.invInvlistServiceRepository.saveInvlist(invInvlistDomain);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getSgSendgoodsInvlist.json"}, name="\u83b7\u53d6\u53d1\u8d27\u5f00\u7968\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public InvInvlistReDomain getInvlist(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".getInvlist", (Object)"param is null");
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlist(invlistId);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invlistCode", invInvlistReDomain.getInvlistCode());
        List invInvlistGoodsReDomainList = this.invInvlistGoodsServiceRepository.queryInvlistGoodsPage(map).getList();
        invInvlistReDomain.setInvInvlistGoodsReDomainList(invInvlistGoodsReDomainList);
        return invInvlistReDomain;
    }

    @RequestMapping(value={"updateInvlist.json"}, name="\u66f4\u65b0\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateInvlist(HttpServletRequest request, InvInvlistDomain invInvlistDomain) {
        if (null == invInvlistDomain) {
            this.logger.error(CODE + ".updateInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        return this.invInvlistServiceRepository.updateInvlist(invInvlistDomain);
    }

    @RequestMapping(value={"updateInvlistRatecode.json"}, name="\u66f4\u65b0\u5f00\u7968\u5f00\u7968\u7a0e\u53f7")
    @ResponseBody
    public HtmlJsonReBean updateInvlistRatecode(HttpServletRequest request, InvInvlistDomain invInvlistDomain, String dataState, String gmtModified) {
        if (null == invInvlistDomain) {
            this.logger.error(CODE + ".updateInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        return this.invInvlistServiceRepository.updateInvlistRatecode(invInvlistDomain, dataState, gmtModified);
    }

    @RequestMapping(value={"updateInvlistRatecodeByScode.json"}, name="\u66f4\u65b0\u5f00\u7968\u5f00\u7968\u7a0e\u53f7")
    @ResponseBody
    public HtmlJsonReBean updateInvlistRatecodeByScode(HttpServletRequest request, InvInvlistDomain invInvlistDomain, String dataState, String gmtModified) {
        if (null == invInvlistDomain) {
            this.logger.error(CODE + ".updateInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)invInvlistDomain.getInvlistCode())) {
            this.logger.error(CODE + ".updateInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, JsonUtil.buildNonNullBinder().toJson((Object)invInvlistDomain));
        }
        UserSession userSession = this.getUserSession(request);
        InvInvlistReDomain invlistByCode = this.invInvlistServiceRepository.getInvlistByCode(this.getTenantCode(request), invInvlistDomain.getInvlistCode());
        if (null == invlistByCode || null == invlistByCode.getMemberScode() || !invlistByCode.getMemberScode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateInvlist", (Object)"\u53c2\u6570\u9519\u8bef");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, JsonUtil.buildNonNullBinder().toJson((Object)invInvlistDomain));
        }
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        return this.invInvlistServiceRepository.updateInvlistRatecode(invInvlistDomain, dataState, gmtModified);
    }

    @RequestMapping(value={"deleteInvlist.json"}, name="\u5220\u9664\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteInvlist(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".deleteInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.deleteInvlist(invlistId);
    }

    @RequestMapping(value={"queryInvlistPageOrd.json"}, name="\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPageOrd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("userCode");
        param.remove("userName");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param);
        List invInvlistReDomainArr = invInvlistReDomainList.getList();
        if (null != invInvlistReDomainArr && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"updateInvlistState.json"}, name="\u66f4\u65b0\u5f00\u7968\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInvlistState(String invlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)invlistId)) {
            this.logger.error(CODE + ".updateInvlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.updateInvlistState(Integer.valueOf(invlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateInvlistStateOrd.json"}, name="\u5ba1\u6838\u666e\u901a\u7684\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInvlistStateOrd(String invlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)invlistId)) {
            this.logger.error(CODE + ".updateInvlistStateOrd", (Object)"invlistId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.updateInvlistState(Integer.valueOf(invlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getInvlistOrd.json"}, name="\u67e5\u770b\u666e\u901a\u53d1\u7968\u7684\u4fe1\u606f")
    @ResponseBody
    public InvInvlistReDomain getInvlistOrd(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".getInvlistOrd", (Object)"invlistId is null");
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlist(invlistId);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invlistCode", invInvlistReDomain.getInvlistCode());
        SupQueryResult invInvlistGoodsReDomainSupQueryResult = this.invInvlistGoodsServiceRepository.queryInvlistGoodsPage(map);
        if (ListUtil.isNotEmpty((Collection)invInvlistGoodsReDomainSupQueryResult.getList())) {
            invInvlistReDomain.setInvInvlistGoodsReDomainList(invInvlistGoodsReDomainSupQueryResult.getList());
        }
        return invInvlistReDomain;
    }

    @RequestMapping(value={"queryInvlistPageTowap.json"}, name="wap\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPageTowap(HttpServletRequest request, String dataStateStr) {
        SupQueryResult invInvlistReDomainList;
        List invInvlistReDomainArr;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        if (StringUtils.isNotBlank((String)dataStateStr)) {
            param.put("dataStateStr", dataStateStr);
        }
        if (null != (invInvlistReDomainArr = (invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param)).getList()) && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u770b\u672a\u5f00\u7968\u7684\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlat(HttpServletRequest request) {
        String dataStatestrs;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (StringUtils.isBlank((String)(dataStatestrs = String.valueOf(param.get("dataStatestrs"))))) {
            dataStatestrs = "2,3,4";
        }
        if (StringUtils.isNotBlank((String)dataStatestrs)) {
            param.put("dataStatestrs", dataStatestrs);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("contractInvstate", 0);
        param.put("memberBcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("notContractType", "08");
        param.put("channelCode", this.getNowChannel(request));
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    private List<Integer> getList(String paramStr) {
        String[] idStr = paramStr.split(",");
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (String id : idStr) {
            retList.add(Integer.parseInt(id));
        }
        return retList;
    }

    @RequestMapping(value={"fcSaveOrder.json"}, name="\u53d1\u7968\u5230\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean fcSaveOrder(HttpServletRequest request, String invlistCode) {
        if (StringUtils.isEmpty((String)invlistCode)) {
            this.logger.error(CODE + ".fcSaveOrder", (Object)"invlistCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".fcSaveOrder", (Object)"\u672a\u767b\u9646");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlistByCode(this.getTenantCode(request), invlistCode);
        if (null == invInvlistReDomain) {
            this.logger.error(CODE + ".fcSaveOrder.invInvlistReDomain", (Object)"\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
        }
        if (!userPcode.equals(invInvlistReDomain.getMemberCode())) {
            this.logger.error(CODE + ".fcSaveOrder.invInvlistReDomain.memberCode", (Object)"\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
        }
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        HtmlJsonReBean htmlJsonReBean = this.saveOrder(request, invInvlistReDomain, invlistCode);
        return htmlJsonReBean;
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, InvInvlistReDomain invInvlistReDomain, String code) {
        if (null == invInvlistReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap invSetMap = new HashMap();
        List invInvsetReDomainList = this.invInvsetServiceRepository.queryInvsetPage(invSetMap).getList();
        if (null == invInvsetReDomainList || invInvsetReDomainList.size() == 0) {
            this.logger.error(CODE + ".saveOrder", (Object)"invInvsetReDomainList is null");
            return null;
        }
        InvInvsetReDomain invInvsetReDomain = (InvInvsetReDomain)invInvsetReDomainList.get(0);
        InvUserinvDomain invUserinvDomain = invInvlistReDomain.getInvUserinvDomain();
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "11";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocContractServiceRepository.getOcSetting(shoppingType, invInvlistReDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setAreaCode(invUserinvDomain.getAreaCode());
        orderDomain.setContractRemark(invInvlistReDomain.getInvlistMeno());
        orderDomain.setContractType(shoppingType);
        orderDomain.setContractTypepro("03");
        orderDomain.setGoodsReceiptArrdess(invUserinvDomain.getUserinvUadd());
        orderDomain.setGoodsReceiptMem(invUserinvDomain.getUserinvName());
        orderDomain.setGoodsReceiptPhone("");
        orderDomain.setContractNbillcode(code);
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(invInvsetReDomain.getInvsetOpamt());
        ocContractGoodsDomain.setContractGoodsMoney(invInvsetReDomain.getInvsetOpamt());
        ocContractGoodsDomain.setContractGoodsPrice(invInvsetReDomain.getInvsetOpamt());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(invInvlistReDomain.getMemberName() + (StringUtils.isBlank((String)invInvlistReDomain.getInvlistName()) ? "" : invInvlistReDomain.getInvlistName()) + "\u5f00\u7968");
        ocContractGoodsDomain.setGoodsNo(code);
        ocContractGoodsDomain.setGoodsCode(code);
        ocContractGoodsDomain.setSkuCode(code);
        ocContractGoodsDomain.setSkuNo(code);
        ocContractGoodsDomain.setSkuName(invInvlistReDomain.getMemberName() + (StringUtils.isBlank((String)invInvlistReDomain.getInvlistName()) ? "" : invInvlistReDomain.getInvlistName()) + "\u5f00\u7968");
        ocContractGoodsDomain.setMemberBcode(invInvlistReDomain.getMemberCode());
        ocContractGoodsDomain.setMemberBname(invInvlistReDomain.getMemberName());
        ocContractGoodsDomain.setMemberCode(this.getTeananMemberCode(request));
        ocContractGoodsDomain.setMemberName("\u5e73\u53f0");
        UserSession userSession = this.getUserSession(request);
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", invInvsetReDomain.getInvsetOpamt());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"querySgSendgoodsInvlistPage.json"}, name="\u67e5\u770b\u672a\u5f00\u7968\u7684\u53d1\u8d27\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SgSendgoodsReDomain> querySendgoodsGoodsPage(HttpServletRequest request) {
        SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainSupQueryResult = this.getSgSendgoodsReDomainSupQueryResult(request);
        return sgSendgoodsReDomainSupQueryResult;
    }

    @RequestMapping(value={"querySendgoodsInvlistPage.json"}, name="\u67e5\u8be2\u53d1\u8d27\u5f00\u7968\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> querySgSendgoodsInvlistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("tenantCode", this.getTenantCode(request));
        }
        return this.fetchInfo(param);
    }

    @RequestMapping(value={"querySendgoodsInvlistForAud.json"}, name="\u53d1\u8d27\u5f00\u7968\u6d41\u6c34\u5217\u8868-\u53d1\u7968\u5ba1\u6838\u9875")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> querySendgoodsInvlistForAud(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("excelTemplate", "invD");
            param.put("fileName", "\u53d1\u7968\u5217\u8868");
        }
        if (null == param.get("dataState")) {
            param.put("dataStateStr", "0,1,2,5");
        }
        return this.queryInvlistCom(request, param);
    }

    @RequestMapping(value={"queryInvlistByINT.json"}, name="\u53d1\u8d27\u5f00\u7968\u6d41\u6c34\u5217\u8868-\u53d1\u7968\u5ba1\u6838\u9875")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistByINT(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "invD");
            param.put("fileName", "\u53d1\u7968\u5217\u8868");
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        return this.queryInvlistCom(request, param);
    }

    @RequestMapping(value={"querySendgoodsInvlistByScode.json"}, name="\u53d1\u8d27\u5f00\u7968\u6d41\u6c34\u5217\u8868\uff08\u5f00\u7968\u65b9\uff09")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> querySendgoodsInvlistByScode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("tenantCode", this.getTenantCode(request));
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberScode", userSession.getUserPcode());
        return this.queryInvlistCom(request, param);
    }

    private SupQueryResult<InvInvlistReDomain> queryInvlistCom(HttpServletRequest request, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        String fileName = (String)param.get("fileName");
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u4e00\u822c\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if ("invD".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertMsHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "inv.invlist.queryInvlistPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageComHy.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.fetchInfo(param);
    }

    private SupQueryResult<InvInvlistReDomain> fetchInfo(Map<String, Object> param) {
        if (null == param) {
            return null;
        }
        SupQueryResult invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param);
        List invInvlistReDomainArr = invInvlistReDomainList.getList();
        if (null != invInvlistReDomainArr && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
                this.logger.error("----------invInvlistReDomain----------", (Object)invInvlistReDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"getSendgoodsInvlist.json"}, name="\u67e5\u770b\u53d1\u8d27\u5355\u53d1\u7968\u7684\u4fe1\u606f")
    @ResponseBody
    public InvInvlistReDomain getSendgoodsInvlist(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".getInvlistOrd", (Object)"invlistId is null");
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlist(invlistId);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        return invInvlistReDomain;
    }

    @RequestMapping(value={"updateSendgoodsInvlist.json"}, name="\u5ba1\u6838\u53d1\u8d27\u666e\u901a\u7684\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSendgoodsInvlist(String invlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)invlistId)) {
            this.logger.error(CODE + ".updateInvlistStateOrd", (Object)"invlistId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.updateInvlistState(Integer.valueOf(invlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryPcSgSendgoodsInvlistPage.json"}, name="\u67e5\u770bPc\u672a\u5f00\u7968\u7684\u53d1\u8d27\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SgSendgoodsReDomain> queryPcSendgoodsGoodsPage(HttpServletRequest request) {
        SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainSupQueryResult = this.getSgSendgoodsReDomainSupQueryResult(request);
        return sgSendgoodsReDomainSupQueryResult;
    }

    private SupQueryResult<SgSendgoodsReDomain> getSgSendgoodsReDomainSupQueryResult(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractInvstate", 0);
        SupQueryResult sgSendgoodsReDomainSupQueryResult = this.sgSendgoodsServiceRepository.querySendgoodsPage(param);
        if (ListUtil.isNotEmpty((Collection)sgSendgoodsReDomainSupQueryResult.getList())) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainSupQueryResult.getList()) {
                map.put("sendgoodsCode", sgSendgoodsReDomain.getSendgoodsCode());
                map.put("tenantCode", this.getTenantCode(request));
                SupQueryResult sgSendgoodsGoodsReDomainSupQueryResult = this.sgSendgoodsServiceRepository.querySendgoodsGoodsPage(map);
                List list = sgSendgoodsGoodsReDomainSupQueryResult.getList();
                sgSendgoodsReDomain.setSgSendgoodsGoodsReDomainList(list);
            }
        } else {
            this.logger.error(CODE + ".querySendgoodsGoodsPage", (Object)param.toString());
        }
        return sgSendgoodsReDomainSupQueryResult;
    }

    private List<InvInvlistGoodsDomain> getInvInvlistGoodsDomains(InvInvlistDomain invInvlistDomain) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        if (null != invInvlistDomain.getInvlistOptype() && invInvlistDomain.getInvlistOptype().equals("SgSendgoods")) {
            SgSendgoodsReDomain sgSendgoodsReDomain = this.sgSendgoodsServiceRepository.getSendgoodsByCode(invInvlistDomain.getTenantCode(), invInvlistDomain.getInvlistOpcode());
            if (null == sgSendgoodsReDomain || ListUtil.isEmpty((Collection)sgSendgoodsReDomain.getSgSendgoodsGoodsReDomainList())) {
                this.logger.error(CODE + ".getInvInvlistGoodsDomains", (Object)"\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                return invInvlistGoodsDomainList;
            }
            invInvlistDomain.setMemberScode(sgSendgoodsReDomain.getMemberCcode());
            invInvlistDomain.setMemberSname(sgSendgoodsReDomain.getMemberCname());
            for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsReDomainList()) {
                InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)sgSendgoodsGoodsReDomain);
                    invInvlistGoodsDomain.setInvlistOpcode(invInvlistDomain.getInvlistOpcode());
                    invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".sgSendgoodsGoodsReDomainList", (Object)"fileList is null");
                }
            }
        }
        if (null != invInvlistDomain.getInvlistOptype() && invInvlistDomain.getInvlistOptype().equals("OcContract")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractBillcode", invInvlistDomain.getInvlistOpcode());
            map.put("tenantCode", invInvlistDomain.getTenantCode());
            OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
            if (null == contractReDomain || ListUtil.isEmpty((Collection)contractReDomain.getGoodsList())) {
                this.logger.error(CODE + ".getInvInvlistGoodsDomains", (Object)"\u5b9a\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                return invInvlistGoodsDomainList;
            }
            invInvlistDomain.setMemberScode(contractReDomain.getMemberCcode());
            invInvlistDomain.setMemberSname(contractReDomain.getMemberCname());
            for (OcContractGoodsDomain OoContractGoodsDomain : contractReDomain.getGoodsList()) {
                InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)OoContractGoodsDomain);
                    invInvlistGoodsDomain.setInvlistOpcode(invInvlistDomain.getInvlistOpcode());
                    invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".OoContractGoodsDomainList", (Object)"fileList is null");
                }
            }
        }
        return invInvlistGoodsDomainList;
    }

    @RequestMapping(value={"queryInvlistPageForAt.json"}, name="\u7ade\u4ef7\u53d1\u7968\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPageForAt(HttpServletRequest request, String dataStateStr) {
        SupQueryResult invInvlistReDomainList;
        List invInvlistReDomainArr;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        if (StringUtils.isNotBlank((String)dataStateStr)) {
            param.put("dataStateStr", dataStateStr);
        }
        if (null != (invInvlistReDomainArr = (invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param)).getList()) && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"deleteInvlistForAt.json"}, name="\u5220\u9664\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteInvlistForAt(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".deleteInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.deleteInvlist(invlistId);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List invlistReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), InvInvlistReDomain.class);
        if (ListUtil.isEmpty((Collection)invlistReDomainList)) {
            return null;
        }
        this.logger.error("======-----invlistReDomainList------===== is ", invlistReDomainList.get(0));
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (InvInvlistReDomain invInvlistReDomain : invlistReDomainList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("invlistCode", invInvlistReDomain.getInvlistCode());
            map.put("tenantCode", invInvlistReDomain.getTenantCode());
            SupQueryResult result = this.invInvlistGoodsServiceRepository.queryInvlistGoodsPage(map);
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) continue;
            Map objectToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)invInvlistReDomain), String.class, Object.class);
            InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
            if (null == invUserinvDomain) continue;
            Map invUserinvToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)invUserinvDomain), String.class, Object.class);
            Map<String, Object> ocMap = this.getOcMap((InvInvlistDomain)invInvlistReDomain);
            for (InvInvlistGoodsReDomain reDomain : result.getList()) {
                Map reDomainToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)reDomain), String.class, Object.class);
                if (MapUtils.isEmpty((Map)reDomainToMap)) continue;
                if (MapUtils.isNotEmpty(ocMap)) {
                    reDomainToMap.putAll(ocMap);
                }
                if (MapUtils.isNotEmpty((Map)objectToMap)) {
                    reDomainToMap.putAll(objectToMap);
                }
                Map<String, Object> stringObjectMap = this.coverOrderState(reDomainToMap);
                reDomainToMap.putAll(stringObjectMap);
                mapList.add(reDomainToMap);
            }
        }
        return mapList;
    }

    private Map<String, Object> getOcMap(InvInvlistDomain invInvlistDomain) {
        Map<String, Object> param = new HashMap<String, Object>();
        if (null != invInvlistDomain.getInvlistOptype() && invInvlistDomain.getInvlistOptype().equals("OcContract")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractBillcode", invInvlistDomain.getInvlistOpcode());
            map.put("tenantCode", invInvlistDomain.getTenantCode());
            OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
            param = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)contractReDomain), String.class, Object.class);
        }
        return param;
    }

    protected Map<String, Object> coverOrderState(Map<String, Object> map) {
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            case 4: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer userinvType = null == map.get("userinvType") ? 8888 : Integer.valueOf(map.get("userinvType").toString());
        switch (userinvType) {
            case 1: {
                map.put("userinvType", "\u7535\u5b50\u53d1\u7968");
                break;
            }
            case 2: {
                map.put("userinvType", "\u4e13\u7968");
                break;
            }
            case 3: {
                map.put("userinvType", "\u666e\u901a\u53d1\u7968");
                break;
            }
            default: {
                map.put("userinvType", "\u672a\u77e5\u7c7b\u578b\u53d1\u7968:" + map.get("userinvType"));
            }
        }
        Integer userinvSort = null == map.get("userinvSort") ? 8888 : Integer.valueOf(map.get("userinvSort").toString());
        switch (userinvSort) {
            case 1: {
                map.put("userinvSort", "\u4e2a\u4eba");
                break;
            }
            case 2: {
                map.put("userinvSort", "\u4f01\u4e1a");
                break;
            }
            default: {
                map.put("userinvSort", "\u672a\u77e5\u7c7b\u578b:" + map.get("userinvSort"));
            }
        }
        return map;
    }

    protected Map<String, Object> covertMap(InvInvlistGoodsReDomain invInvlistGoodsReDomain) {
        HashMap<String, Object> invMap = new HashMap<String, Object>();
        invMap.put("invlistCode", invInvlistGoodsReDomain.getInvlistCode());
        invMap.put("goodsNo", invInvlistGoodsReDomain.getGoodsNo());
        invMap.put("invlistOpcode", invInvlistGoodsReDomain.getInvlistOpcode());
        invMap.put("goodsName", invInvlistGoodsReDomain.getGoodsName());
        invMap.put("contractGoodsPrice", invInvlistGoodsReDomain.getContractGoodsPrice());
        invMap.put("goodsCweight", invInvlistGoodsReDomain.getGoodsCweight());
        invMap.put("contractMoney", invInvlistGoodsReDomain.getContractGoodsPrice());
        invMap.put("goodsSpec", invInvlistGoodsReDomain.getGoodsSpec());
        invMap.put("goodsOneweight", invInvlistGoodsReDomain.getGoodsOneweight());
        invMap.put("memberName", invInvlistGoodsReDomain.getMemberName());
        invMap.put("dataState", invInvlistGoodsReDomain.getDataState());
        invMap.put("gmtModified", invInvlistGoodsReDomain.getGmtModified());
        return invMap;
    }

    @RequestMapping(value={"invExcel.json"}, name="\u53d1\u7968\u6570\u636e\u5bfc\u51fa")
    @ResponseBody
    public HtmlJsonReBean invExcel(HttpServletRequest request, HttpServletResponse response) {
        try {
            Map param = this.assemMapParam(request);
            String tenantCode = this.getTenantCode(request);
            UserSession userSession = this.getUserSession(request);
            param.put("tenantCode", tenantCode);
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u53d1\u7968\u5217\u8868\u4fe1\u606f=========================================================================");
            List<InvUserinvReDomain> userinvList = this.queryUserInv(param, userSession);
            this.logger.info("\u67e5\u8be2\u53d1\u7968\u5217\u8868\u6210\u529f===================================================================================");
            this.logger.info("\u8f6c\u6362JSON\u683c\u5f0f=======================================================================================");
            JSONArray jsonArray = JSONArray.parseArray((String)JsonUtil.buildNonDefaultBinder().jsonObject(userinvList));
            this.logger.info("\u8f6c\u6362JSON\u683c\u5f0f\u6210\u529f====================================================================================");
            LinkedHashMap<String, String> headMap = new LinkedHashMap<String, String>();
            headMap.put("memberName", "\u4f1a\u5458\u540d\u79f0");
            headMap.put("userinvUeamil", "\u7535\u5b50\u90ae\u7bb1");
            headMap.put("gmtCreate", "\u7533\u8bf7\u5f00\u7968\u65f6\u95f4");
            headMap.put("userinvImgurl2", "\u53d1\u7968\u7c7b\u578b");
            headMap.put("userinvMember", "\u53d1\u7968\u62ac\u5934");
            headMap.put("userinvNo", "\u7a0e\u53f7");
            headMap.put("userinvAdd", "\u516c\u53f8\u5730\u5740");
            headMap.put("userinvPhone", "\u516c\u53f8\u7535\u8bdd");
            headMap.put("userinvBankname", "\u516c\u53f8\u5f00\u6237\u884c");
            headMap.put("userinvBankno", "\u5f00\u6237\u884c\u8d26\u53f7");
            headMap.put("userinvImgurl", "\u8ba2\u5355\u7f16\u53f7");
            headMap.put("userinvImgurl1", "\u8ba2\u5355\u91d1\u989d");
            String title = "\u7ebf\u4e0a\u6d3b\u52a8\u5217\u8868" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMddHHmm");
            ExcelUtil.downloadExcelFile((String)title, headMap, (JSONArray)jsonArray, (HttpServletResponse)response);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".exportOnlineActivies", (Object)e.getMessage());
            e.printStackTrace();
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u51fa\u5f02\u5e38");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryInvlistPage.json"}, name="\u67e5\u8be2\u5f00\u7968\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPage(HttpServletRequest request, String dataStateStr) {
        this.logger.info("\u8fdb\u5165\u53d1\u7968\u5206\u9875\u67e5\u8be2==========================================================");
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.info("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f=======================================================================================");
        SupQueryResult invInvlistReDomainSupQueryResult = this.invInvlistServiceRepository.queryInvlistPage(param);
        this.logger.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u8868========================================================================================");
        HashMap<String, String> userParam = new HashMap<String, String>();
        userParam.put("tenantCode", this.getTenantCode(request));
        SupQueryResult umUserReDomainBeanSupQueryResult = this.userServiceRepository.queryUserPage(userParam);
        this.logger.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u6210\u529f=========================================================");
        if (null != invInvlistReDomainSupQueryResult && null != umUserReDomainBeanSupQueryResult && ListUtil.isNotEmpty((Collection)invInvlistReDomainSupQueryResult.getList()) && ListUtil.isNotEmpty((Collection)umUserReDomainBeanSupQueryResult.getList())) {
            this.logger.info("\u5f00\u59cb\u5c01\u88c5\u6570\u636e===================================================================================");
            HashMap userMap = new HashMap();
            ListIterator userIt = umUserReDomainBeanSupQueryResult.getList().listIterator();
            while (userIt.hasNext()) {
                userMap.put(((UmUserReDomainBean)userIt.next()).getUserCode(), userIt.next());
            }
            for (InvInvlistReDomain invlistReDomain : invInvlistReDomainSupQueryResult.getList()) {
                String userSort = "";
                if (null != invlistReDomain.getUserinvSort()) {
                    Integer sort = Integer.valueOf(invlistReDomain.getUserinvSort());
                    switch (sort) {
                        case 1: {
                            userSort = "\u4f01\u4e1a";
                            break;
                        }
                        case 2: {
                            userSort = "\u4e2a\u4eba";
                        }
                    }
                }
                if ("2".equals(invlistReDomain.getUserinvType())) {
                    invlistReDomain.setInvlistType(userSort + "\u666e\u7968(\u7535\u5b50)");
                } else if ("3".equals(invlistReDomain.getUserinvType())) {
                    invlistReDomain.setInvlistType(userSort + "\u4e13\u7968(\u7eb8\u8d28)");
                } else {
                    invlistReDomain.setInvlistType(null);
                }
                if (!userMap.containsKey(invlistReDomain.getMemberCode())) continue;
                invlistReDomain.setInvlistOcode2(invlistReDomain.getMemberCode());
            }
        }
        this.logger.info("\u67e5\u8be2\u6210\u529f=======================================================================================");
        return invInvlistReDomainSupQueryResult;
    }

    private List<InvUserinvReDomain> queryUserInv(Map<String, Object> param, UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        param.put("invlistOptype", "OcContract");
        SupQueryResult invInvlistReDomainSupQueryResult = this.invInvlistServiceRepository.queryInvlistPage(param);
        List<Object> userList = new ArrayList<InvUserinvReDomain>();
        if (null != invInvlistReDomainSupQueryResult) {
            SupQueryResult invUserinvReDomainSupQueryResult;
            List invList = invInvlistReDomainSupQueryResult.getList();
            HashMap<String, InvInvlistReDomain> invMap = new HashMap<String, InvInvlistReDomain>();
            if (ListUtil.isNotEmpty((Collection)invList)) {
                for (InvInvlistReDomain invNext : invList) {
                    invMap.put(invNext.getUserinvCode(), invNext);
                }
            } else {
                this.logger.error("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
            }
            HashMap<String, Boolean> userParam = new HashMap<String, Boolean>();
            userParam.put("order", true);
            userParam.put("fuzzy", true);
            if (null != param.get("tenantCode")) {
                userParam.put("tenantCode", (Boolean)userParam.get("tenantCode"));
            }
            if (null != (invUserinvReDomainSupQueryResult = this.invUserinvServiceRepository.queryUserinvPage(userParam)) && ListUtil.isNotEmpty(userList = invUserinvReDomainSupQueryResult.getList())) {
                for (InvUserinvReDomain invUserinvReDomain : userList) {
                    InvInvlistReDomain reDomain = (InvInvlistReDomain)invMap.get(invUserinvReDomain.getUserinvCode());
                    invUserinvReDomain.setUserinvImgurl(reDomain.getInvlistOpcode());
                    if (null != reDomain.getInvlistOpamt()) {
                        invUserinvReDomain.setUserinvImgurl1(String.valueOf(reDomain.getInvlistOpamt()));
                    }
                    String userinvType = "";
                    String userinvSort = "";
                    if (null != invUserinvReDomain.getUserinvSort()) {
                        Integer sort = Integer.valueOf(invUserinvReDomain.getUserinvSort());
                        switch (sort) {
                            case 1: {
                                userinvSort = "\u4f01\u4e1a";
                                break;
                            }
                            case 2: {
                                userinvSort = "\u4e2a\u4eba";
                            }
                        }
                    }
                    if (null != invUserinvReDomain.getUserinvType()) {
                        Integer type = Integer.valueOf(invUserinvReDomain.getUserinvType());
                        switch (type) {
                            case 1: {
                                userinvType = "\u7535\u5b50";
                                break;
                            }
                            case 2: {
                                userinvType = "\u4e13\u7968";
                                break;
                            }
                            case 3: {
                                userinvType = "\u666e\u7968";
                            }
                        }
                    }
                    if ("3".equals(invUserinvReDomain.getUserinvType())) {
                        invUserinvReDomain.setUserinvImgurl2(userinvSort + userinvType + "(\u7535\u5b50)");
                        continue;
                    }
                    if ("2".equals(invUserinvReDomain.getUserinvType())) {
                        invUserinvReDomain.setUserinvImgurl2(userinvSort + userinvType + "(\u7eb8\u8d28)");
                        continue;
                    }
                    invUserinvReDomain.setUserinvImgurl2("\u672a\u77e5\u53d1\u7968");
                }
            }
        }
        return userList;
    }
}

