/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mindex.controller;

import com.qjsoft.laser.controller.core.auth.AuthService;
import com.qjsoft.laser.controller.core.auth.MenuInfoBean;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.mindex.bean.IndexBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mindex"})
public class MindexCon
extends SpringmvcController {
    @Autowired
    private AuthService authService;

    protected String getContext() {
        return "mindex";
    }

    @RequestMapping(value={"getTopMenuList.json"})
    @ResponseBody
    public List<MenuInfoBean> getTopMenuList(HttpServletRequest request) {
        return this.getMenu(request);
    }

    private List<MenuInfoBean> getMenu(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        List<MenuInfoBean> menuList = this.navQuery(proappCode, tenantCode);
        if (null != menuList && !menuList.isEmpty()) {
            this.order(menuList);
            for (MenuInfoBean menuInfoBean : menuList) {
                if (StringUtils.isNotBlank((String)menuInfoBean.getMenuAction())) {
                    menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${tenantCode}", tenantCode));
                    menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${proappCode}", proappCode));
                    menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${oauthEnvCode}", oauthEnvCode));
                }
                if (!StringUtils.isNotBlank((String)menuInfoBean.getMenuJspath())) continue;
                menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${tenantCode}", tenantCode));
                menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${proappCode}", proappCode));
                menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${oauthEnvCode}", oauthEnvCode));
            }
        }
        return menuList;
    }

    @RequestMapping(value={"index.json"})
    @ResponseBody
    public IndexBean index(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        IndexBean indexBean = new IndexBean();
        List<MenuInfoBean> menuList = this.getMenu(request);
        if (null != menuList && !menuList.isEmpty()) {
            List<MenuInfoBean> childList = null;
            for (MenuInfoBean menuBean : menuList) {
                childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                if (null != childList && !childList.isEmpty()) {
                    this.order(childList);
                }
                menuBean.setChildren(childList);
            }
        }
        UserInfo userInfo = this.getUserInfo(request);
        indexBean.setUserInfo(userInfo);
        UserSession userSession = this.getUserSession(request);
        Object extensions = userSession.getExtensions();
        this.logger.error("ex====" + extensions);
        indexBean.setTopMenuList(menuList);
        return indexBean;
    }

    private void order(List<MenuInfoBean> menuList) {
        Collections.sort(menuList, new Comparator<MenuInfoBean>(){

            @Override
            public int compare(MenuInfoBean menuInfoBean1, MenuInfoBean menuInfoBean2) {
                int order1 = menuInfoBean1.getProappMenuOrder();
                int order2 = menuInfoBean2.getProappMenuOrder();
                return Integer.compare(order1, order2);
            }
        });
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> listQuery(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.navQuery(proappCode, tenantCode);
    }

    @RequestMapping(value={"menuQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuQuery(HttpServletRequest request, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    private List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        return this.authService.navQuery(proappCode, tenantCode);
    }

    private List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        return this.authService.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    @RequestMapping(value={"defaultAccess.json"}, name="\u9ed8\u8ba4\u8bbf\u95ee")
    @ResponseBody
    public HtmlJsonReBean defaultAccess(HttpServletRequest request) {
        return new HtmlJsonReBean();
    }
}

