/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mns.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.mns.domain.MnsMnstemplateDomainBean;
import com.qjsoft.laser.controller.facade.mns.domain.MnsMnstemplateReDomainBean;
import com.qjsoft.laser.controller.facade.mns.repository.MnstemplateServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mns/mnstemplate"}, name="\u77ed\u4fe1\u6a21\u677f")
public class MnstemplateCon
extends SpringmvcController {
    private static String CODE = "mns.Mnstemplate.con";
    @Autowired
    private MnstemplateServiceRepository mnstemplateServiceRepository;

    protected String getContext() {
        return "Mnstemplate";
    }

    @RequestMapping(value={"saveMnstemplate.json"}, name="\u589e\u52a0\u77ed\u4fe1\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean saveMnstemplate(HttpServletRequest request, MnsMnstemplateDomainBean mnsMnstemplateDomainBean) {
        if (null == mnsMnstemplateDomainBean) {
            this.logger.error(CODE + ".saveMnstemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "usersession is null");
        }
        Map map = this.assemdataTenantParam(request);
        String dataTenant = (String)map.get("dataTenant");
        mnsMnstemplateDomainBean.setDataTenant(dataTenant);
        mnsMnstemplateDomainBean.setMemberCode(userSession.getUserPcode());
        mnsMnstemplateDomainBean.setMemberName(userSession.getUserName());
        mnsMnstemplateDomainBean.setTenantCode(this.getTenantCode(request));
        return this.mnstemplateServiceRepository.saveMnstemplate(mnsMnstemplateDomainBean);
    }

    @RequestMapping(value={"getMnstemplate.json"}, name="\u83b7\u53d6\u77ed\u4fe1\u6a21\u677f\u4fe1\u606f")
    @ResponseBody
    public MnsMnstemplateReDomainBean getMnstemplate(Integer mnstemplateId) {
        if (StringUtils.isBlank((Integer)mnstemplateId)) {
            this.logger.error(CODE + ".getMnstemplate", (Object)"param is null");
            return null;
        }
        return this.mnstemplateServiceRepository.getMnstemplate(mnstemplateId);
    }

    @RequestMapping(value={"updateMnstemplate.json"}, name="\u66f4\u65b0\u77ed\u4fe1\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean updateMnstemplate(HttpServletRequest request, MnsMnstemplateDomainBean mnsMnstemplateDomainBean) {
        if (null == mnsMnstemplateDomainBean) {
            this.logger.error(CODE + ".updateMnstemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        mnsMnstemplateDomainBean.setTenantCode(this.getTenantCode(request));
        return this.mnstemplateServiceRepository.updateMnstemplate(mnsMnstemplateDomainBean);
    }

    @RequestMapping(value={"deleteMnstemplate.json"}, name="\u5220\u9664\u77ed\u4fe1\u6a21\u677f")
    @ResponseBody
    public HtmlJsonReBean deleteMnstemplate(Integer mnstemplateId) {
        if (StringUtils.isBlank((Integer)mnstemplateId)) {
            this.logger.error(CODE + ".deleteMnstemplate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mnstemplateServiceRepository.deleteMnstemplate(mnstemplateId);
    }

    @RequestMapping(value={"queryMnstemplatePage.json"}, name="\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<MnsMnstemplateReDomainBean> queryMnstemplatePage(HttpServletRequest request) {
        Map param = this.assemdataTenantParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.mnstemplateServiceRepository.queryMnstemplatePage(param);
    }

    @RequestMapping(value={"updateMnstemplateState.json"}, name="\u66f4\u65b0\u77ed\u4fe1\u6a21\u677f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateMnstemplateState(String mnstemplateId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)mnstemplateId)) {
            this.logger.error(CODE + ".updateMnstemplateState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mnstemplateServiceRepository.updateMnstemplateState(Integer.valueOf(mnstemplateId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateMnstemplateMname.json"}, name="\u66f4\u65b0\u6a21\u677f\u7b7e\u540d")
    @ResponseBody
    public HtmlJsonReBean updateMnstemplateMname(HttpServletRequest request, String mnstemplateCode, String mnstemplateMname) {
        if (StringUtils.isBlank((String)mnstemplateMname)) {
            this.logger.error(CODE + ".updateMnstemplateMname", (Object)"mnstemplateMname is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mnstemplateMname", mnstemplateMname);
        map.put("mnstemplateCode", mnstemplateCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.mnstemplateServiceRepository.updateMnstemplateMname(map);
    }

    @RequestMapping(value={"getOverReason.json"}, name="\u83b7\u53d6\u5931\u8d25\u539f\u56e0")
    @ResponseBody
    public HtmlJsonReBean getOverReason(HttpServletRequest request, String mnstemplateCode) {
        if (StringUtils.isBlank((String)mnstemplateCode)) {
            this.logger.error(CODE + ".getOverReason", (Object)"mnstemplateCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "mnstemplateCode null");
        }
        MnsMnstemplateReDomainBean mnstemplate = this.mnstemplateServiceRepository.getMnstemplate(mnstemplateCode, this.getTenantCode(request));
        if (null == mnstemplate) {
            this.logger.error(CODE + ".getOverReason", (Object)"mnstemplate is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "mnstemplate null");
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        htmlJsonReBean.setMsg(mnstemplate.getMemo());
        return htmlJsonReBean;
    }
}

