/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mns.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.mns.domain.MnsBatchmnsDomain;
import com.qjsoft.laser.controller.facade.mns.domain.MnsBatchmnsReDomain;
import com.qjsoft.laser.controller.facade.mns.repository.MnsBatchmnsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mns/batchmns"}, name="\u77ed\u4fe1\u7fa4\u53d1")
public class BatchmnsCon
extends SpringmvcController {
    private static String CODE = "mns.batchmns.con";
    @Autowired
    private MnsBatchmnsServiceRepository mnsBatchmnsServiceRepository;

    protected String getContext() {
        return "batchmns";
    }

    @RequestMapping(value={"saveBatchmns.json"}, name="\u589e\u52a0\u77ed\u4fe1\u7fa4\u53d1")
    @ResponseBody
    public HtmlJsonReBean saveBatchmns(HttpServletRequest request, MnsBatchmnsDomain mnsBatchmnsDomain) {
        if (null == mnsBatchmnsDomain) {
            this.logger.error(CODE + ".saveBatchmns", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        Map map = this.assemdataTenantParam(request);
        String dataTenant = (String)map.get("dataTenant");
        mnsBatchmnsDomain.setTenantCode(this.getTenantCode(request));
        mnsBatchmnsDomain.setDataTenant(dataTenant);
        mnsBatchmnsDomain.setMemberCode(userSession.getUserPcode());
        mnsBatchmnsDomain.setMnslistSubject("1");
        mnsBatchmnsDomain.setMnslistSource(Integer.valueOf(0));
        mnsBatchmnsDomain.setMnslistBustype("param");
        mnsBatchmnsDomain.setMnschannelType(Integer.valueOf(0));
        return this.mnsBatchmnsServiceRepository.saveBatchmns(mnsBatchmnsDomain);
    }

    @RequestMapping(value={"getBatchmns.json"}, name="\u83b7\u53d6\u77ed\u4fe1\u7fa4\u53d1\u4fe1\u606f")
    @ResponseBody
    public MnsBatchmnsReDomain getBatchmns(Integer batchmnsId) {
        if (StringUtils.isBlank((Integer)batchmnsId)) {
            this.logger.error(CODE + ".getBatchmns", (Object)"param is null");
            return null;
        }
        return this.mnsBatchmnsServiceRepository.getBatchmns(batchmnsId);
    }

    @RequestMapping(value={"updateBatchmns.json"}, name="\u66f4\u65b0\u77ed\u4fe1\u7fa4\u53d1")
    @ResponseBody
    public HtmlJsonReBean updateBatchmns(HttpServletRequest request, MnsBatchmnsDomain MnsBatchmnsDomain2) {
        if (null == MnsBatchmnsDomain2) {
            this.logger.error(CODE + ".updateBatchmns", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        MnsBatchmnsDomain2.setTenantCode(this.getTenantCode(request));
        return this.mnsBatchmnsServiceRepository.updateBatchmns(MnsBatchmnsDomain2);
    }

    @RequestMapping(value={"deleteBatchmns.json"}, name="\u5220\u9664\u77ed\u4fe1\u7fa4\u53d1")
    @ResponseBody
    public HtmlJsonReBean deleteBatchmns(Integer batchmnsId) {
        if (StringUtils.isBlank((Integer)batchmnsId)) {
            this.logger.error(CODE + ".deleteBatchmns", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mnsBatchmnsServiceRepository.deleteBatchmns(batchmnsId);
    }

    @RequestMapping(value={"queryBatchmnsPage.json"}, name="\u67e5\u8be2\u77ed\u4fe1\u7fa4\u53d1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<MnsBatchmnsReDomain> queryBatchmnsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.mnsBatchmnsServiceRepository.queryBatchmnsPage(param);
    }

    @RequestMapping(value={"updateBatchmnsState.json"}, name="\u66f4\u65b0\u77ed\u4fe1\u7fa4\u53d1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBatchmnsState(String batchmnsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)batchmnsId)) {
            this.logger.error(CODE + ".updateBatchmnsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mnsBatchmnsServiceRepository.updateBatchmnsState(Integer.valueOf(batchmnsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"releaseBatchmns.json"}, name="\u4e00\u952e\u7fa4\u53d1")
    @ResponseBody
    public HtmlJsonReBean releaseBatchmns(String batchmnsId) {
        if (StringUtils.isBlank((String)batchmnsId)) {
            this.logger.error(CODE + ".releaseBatchmns", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.mnsBatchmnsServiceRepository.releaseBatchmns(Integer.valueOf(batchmnsId));
    }

    @RequestMapping(value={"saveBatchMnsByChannel.json"}, name="\u77ed\u4fe1\u7fa4\u53d1\u4fe1\u606f\u6279\u91cf\u5bfc\u5165")
    @ResponseBody
    public HtmlJsonReBean saveBatchMnsByChannel(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveBatchOperatorByDealerYunying", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        MnsBatchmnsDomain mnsBatchmnsDomain = new MnsBatchmnsDomain();
        Map map = this.assemdataTenantParam(request);
        String dataTenant = (String)map.get("dataTenant");
        mnsBatchmnsDomain.setTenantCode(this.getTenantCode(request));
        mnsBatchmnsDomain.setDataTenant(dataTenant);
        mnsBatchmnsDomain.setMemberCode(userSession.getUserPcode());
        mnsBatchmnsDomain.setMnslistSubject("1");
        mnsBatchmnsDomain.setMnslistSource(Integer.valueOf(0));
        mnsBatchmnsDomain.setMnslistBustype("param");
        mnsBatchmnsDomain.setMnschannelType(Integer.valueOf(0));
        Map jsonMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(paramStr, String.class, String.class);
        String mnslistBusname = (String)jsonMap.get("mnslistBusname");
        String mnslistPhone = (String)jsonMap.get("mnslistPhone");
        String mnslistContent = (String)jsonMap.get("mnslistContent");
        if (StringUtils.isBlank((String)mnslistBusname) || StringUtils.isBlank((String)mnslistPhone) || StringUtils.isBlank((String)mnslistContent)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u4f20\u53c2\u6570\u5bfc\u5165\u4e3a\u7a7a\uff01");
        }
        mnsBatchmnsDomain.setMnslistBusname(mnslistBusname);
        mnsBatchmnsDomain.setMnslistPhone(mnslistPhone);
        mnsBatchmnsDomain.setMnslistContent(mnslistContent);
        return this.mnsBatchmnsServiceRepository.saveBatchmns(mnsBatchmnsDomain);
    }

    @RequestMapping(value={"releaseBatchmnsBycode.json"}, name="\u6839\u636ecode\u4e00\u952e\u7fa4\u53d1")
    @ResponseBody
    public HtmlJsonReBean releaseBatchmnsBycode(HttpServletRequest request, String batchmnsCode) {
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)batchmnsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".releaseBatchmnsBycode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        MnsBatchmnsReDomain batchmnsByCode = this.mnsBatchmnsServiceRepository.getBatchmnsByCode(tenantCode, batchmnsCode);
        if (null == batchmnsByCode) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "batchmns is null");
        }
        return this.mnsBatchmnsServiceRepository.releaseBatchmns(Integer.valueOf(batchmnsByCode.getBatchmnsId()));
    }
}

