/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsNumDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/shopping"}, name="\u8d2d\u7269\u8f66\u670d\u52a1")
public class ShoppingCon
extends SpringmvcController {
    private static String CODE = "oc.shopping.con";
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;

    protected String getContext() {
        return "shopping";
    }

    @RequestMapping(value={"saveShopping.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveShopping(ocShoppingDomain);
    }

    @RequestMapping(value={"getShopping.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingReDomain getShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShopping", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShopping(Integer.valueOf(shoppingId));
    }

    @RequestMapping(value={"updateShopping.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShopping(ocShoppingDomain);
    }

    @RequestMapping(value={"deleteShopping.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingIdS = shoppingId.split(",");
        if (null == shoppingIdS || shoppingIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShopping1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingServiceRepository.deleteShopping(Integer.valueOf(shoppingIdS[i]));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"wishLists.json"}, name="\u6e20\u9053\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> wishLists(HttpServletRequest request) {
        String memberCode;
        String channelCode;
        SupQueryResult number = new SupQueryResult();
        HashMap<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            param.put("channelCode", channelCode);
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        this.logger.error(CODE + ".wishLists.json=" + param);
        SupQueryResult ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    @RequestMapping(value={"shoppingList.json"}, name="\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> shoppingList(HttpServletRequest request) {
        String memberCode;
        String channelCode;
        SupQueryResult number = new SupQueryResult();
        HashMap<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            param.put("channelCode", channelCode);
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        this.logger.error(CODE + ".shoppingList.json=" + param);
        SupQueryResult ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    @RequestMapping(value={"queryShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryShopping(request, param);
    }

    private SupQueryResult<OcShoppingReDomain> queryShopping(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult ocShoppingReDomainSupQueryResult;
        String memberCode;
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (ocShoppingReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingPage(param)) || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            return null;
        }
        return ocShoppingReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateShoppingGoodsPmInfo.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsPmInfo(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsPmInfo(Integer.valueOf(shoppingGoodsId), promotionCode);
    }

    @RequestMapping(value={"updateShoppingGoodsCheckState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u9009\u4e2d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsCheckState(HttpServletRequest request, Integer shoppingGoodsId, String shoppingCode, Integer checkState) {
        String memberCode = this.getMerchantCode(request);
        return this.ocShoppingServiceRepository.updateShoppingGoodsCheckState(memberCode, shoppingCode, shoppingGoodsId, checkState);
    }

    @RequestMapping(value={"updateShoppingGoodsNum.json"}, name="\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNum(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingServiceRepository.getShoppingGoods(shoppingGoodsId);
        if (null == ocShoppingGoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (null == ocShoppingGoodsReDomain.getGoodsSupplynum()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        this.ocShoppingServiceRepository.updateShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
        return this.updateShoppingGoodsCheckState(request, shoppingGoodsId, "", 0);
    }

    @RequestMapping(value={"updateShoppingState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingState(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveContractByOcShopping.json"}, name="\u4ece\u8d2d\u7269\u8f66\u4e2d\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveContractByOcShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveContractByOcShopping(ocShoppingDomain, contractTypepro);
    }

    @RequestMapping(value={"insertShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean insertShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"addShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsBySpec(HttpServletRequest request, String goodsCode, String specStr) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        List spcList = (List)JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class);
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuBySpec(spcList, goodsCode, tenantCode);
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        if (null != userSession && rsSkuReDomain.getMemberCode().equals(userSession.getUserPcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5df1\u5546\u54c1");
        }
        if (1 != rsSkuReDomain.getDataOpbillstate()) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec1", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db31");
        }
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("skuCode", rsSkuReDomain.getSkuCode());
        pMap.put("tenantCode", tenantCode);
        SupQueryResult rsGoodsFileReDomainSupQueryResult = this.rsGoodsOtherServiceRepository.queryGoodsFilePage(pMap);
        if (ListUtil.isNotEmpty((Collection)rsGoodsFileReDomainSupQueryResult.getList())) {
            rsSkuReDomain.setRsGoodsFileReDomainList(rsGoodsFileReDomainSupQueryResult.getList());
        }
        return new HtmlJsonReBean((Object)rsSkuReDomain);
    }

    private HtmlJsonReBean saveShopping(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        if (null == skuId) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, skuId, goodsNum, goodsWeght, null, null);
        return this.saveShoppingDomain(request, ocShoppingDomain);
    }

    private HtmlJsonReBean saveShoppingDomain(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain || null == ocShoppingDomain.getPackageList() || ocShoppingDomain.getPackageList().isEmpty()) {
            this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = (OcShoppingGoodsDomain)((OcPackageDomain)ocShoppingDomain.getPackageList().get(0)).getShoppingGoodsList().get(0);
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShopping", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingGoodsDomain.setMemberBname(userSession.showUserName());
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        ocShoppingGoodsDomain.setShoppingType(ocShoppingDomain.getShoppingType());
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingServiceRepository.insertShoppingGoods(ocShoppingGoodsDomain);
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(ocShoppingGoodsDomain.getTenantCode() + "-bigdata-bigdataflag"));
        if (!StringUtils.isBlank((String)bigdataFlag) && "true".equals(bigdataFlag)) {
            try {
                this.sendShoppingBigData(ocShoppingGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("sendBigData", (Object)"\u53d1\u9001\u5927\u6570\u636e\u5931\u8d25");
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"addShoppingGoodss.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodss(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        String userinfoCode = this.getUserInfo(request).getUserInfoCode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("userinfoCode", userinfoCode);
        pMap.put("tenantCode", tenantCode);
        List ctCustrelEmpReDomainsList = this.ctCustrelServiceRepository.queryCustrelEmpPage(pMap).getList();
        if (ListUtil.isNotEmpty((Collection)ctCustrelEmpReDomainsList)) {
            return this.saveShopping(request, skuId, goodsNum, goodsWeght);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    @RequestMapping(value={"addShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoods(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.saveShopping(request, skuId, goodsNum, goodsWeght);
    }

    @RequestMapping(value={"addShoppingGoodsForCh.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsForCh(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        String userinfoCode = this.getUserInfo(request).getUserInfoCode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("userinfoCode", userinfoCode);
        pMap.put("tenantCode", tenantCode);
        List ctCustrelEmpReDomainsList = this.ctCustrelServiceRepository.queryCustrelEmpPage(pMap).getList();
        if (ListUtil.isNotEmpty((Collection)ctCustrelEmpReDomainsList)) {
            return this.saveShopping(request, skuId, goodsNum, goodsWeght);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    private HtmlJsonReBean saveShoppingSkuCode(HttpServletRequest request, String goodsBeanStr) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".saveShoppingSkuCode", (Object)"goodsBeanStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        List skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        HtmlJsonReBean htmlJsonReBean = null;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShoppingSkuCode.UserSession", (Object)"UserSession is null");
            return null;
        }
        for (GoodsBean goodsBean : skuCodeList) {
            OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, goodsBean.getSkuCode(), goodsBean.getGoodsNum(), goodsBean.getGoodsWeght(), goodsBean.getShoppingType(), null, null);
            if (null == ocShoppingDomain || ListUtil.isEmpty((Collection)ocShoppingDomain.getPackageList()) || ListUtil.isEmpty((Collection)((OcPackageDomain)ocShoppingDomain.getPackageList().get(0)).getShoppingGoodsList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            }
            if (StringUtils.isNotBlank((String)goodsBean.getGoodsContract())) {
                ((OcShoppingGoodsDomain)((OcPackageDomain)ocShoppingDomain.getPackageList().get(0)).getShoppingGoodsList().get(0)).setGoodsContract(goodsBean.getGoodsContract());
            }
            if (null != (htmlJsonReBean = this.saveShoppingDomain(request, ocShoppingDomain)) && htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"addShoppingGoodsCode.json"}, name="\u901a\u8fc7SKUcode\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1,\u53ef\u4f20\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsCode(HttpServletRequest request, String goodsBeanStr) {
        return this.saveShoppingSkuCode(request, goodsBeanStr);
    }

    @RequestMapping(value={"getShoppingGoods.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingGoodsReDomain getShoppingGoods(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoods", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
    }

    @RequestMapping(value={"updateShoppingGoods.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShoppingGoods(ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"deleteShoppingGoods.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoods(HttpServletRequest request, String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsIdS = shoppingGoodsId.split(",");
        if (null == shoppingGoodsIdS || shoppingGoodsIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingGoodsIdS.length; ++i) {
            String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(this.getTenantCode(request) + "-bigdata-bigdataflag"));
            if (!StringUtils.isBlank((String)bigdataFlag) && "true".equals(bigdataFlag)) {
                try {
                    OcShoppingGoodsReDomain ocShoppingGoodsDomain = this.ocShoppingServiceRepository.getShoppingGoods(Integer.valueOf(shoppingGoodsIdS[i]));
                    this.sendShoppingBigData((OcShoppingGoodsDomain)ocShoppingGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error("sendBigData", (Object)"\u53d1\u9001\u5927\u6570\u636e\u5931\u8d25");
                }
            }
            htmlJsonReBean = this.ocShoppingServiceRepository.deleteShoppingGoods(Integer.valueOf(shoppingGoodsIdS[i]));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteShoppingGoodsBatch.json"}, name="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoodsBatch(String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        return this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdList);
    }

    private void sendShoppingBigData(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    @RequestMapping(value={"updateShoppingGoodsNumBatch.json"}, name="\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNumBatch(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, GoodsNumDomain.class);
        return this.ocShoppingServiceRepository.updateShoppingGoodsNumBatch(goodsList);
    }

    @RequestMapping(value={"queryShoppingGoodsPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
    }

    @RequestMapping(value={"updateShoppingGoodsState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsState(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsState(Integer.valueOf(shoppingGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryShoppingToContract.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryShoppingToContract(HttpServletRequest request, String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContract", (Object)"param is null");
            return null;
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        List ocShoppingReDomainList = this.ocShoppingServiceRepository.queryShoppingToContract(shoppingGoodsIdList, this.getOauthEnvCode(request));
        this.ocShoppingServiceRepository.makePm(ocShoppingReDomainList, this.getTeananMemberCode(request));
        return ocShoppingReDomainList;
    }

    @RequestMapping(value={"queryToContractCode.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCode,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCode(HttpServletRequest request, String skuCode, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryToContractCode", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, skuCode, goodsNum, goodsWeght, shoppingType, contractNbillcode, pricesetType);
        return this.ocShoppingServiceRepository.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request));
    }

    @RequestMapping(value={"queryToContractCodeList.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCodeList,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCodeList(HttpServletRequest request, String goodsBeanStr) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryToContractCodeList.UserSession", (Object)"UserSession is null");
            return null;
        }
        List skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        if (ListUtil.isEmpty((Collection)skuCodeList)) {
            this.logger.error(CODE + ".queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return null;
        }
        List ocShoppingDomainList = this.ocShoppingServiceRepository.makeOcShoppingDomainList(userSession, skuCodeList);
        return this.ocShoppingServiceRepository.queryToContractDomainList(ocShoppingDomainList, this.getTeananMemberCode(request));
    }

    @RequestMapping(value={"queryToContract.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContract(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        if (null == skuId) {
            this.logger.error(CODE + ".queryToContract", (Object)"skuId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, skuId, goodsNum, goodsWeght, null, null);
        return this.ocShoppingServiceRepository.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request));
    }

    @RequestMapping(value={"queryNewToContract.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryNewToContract(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        if (null == skuId) {
            this.logger.error(CODE + ".queryNewToContract", (Object)"skuId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, goodsBean);
        return this.ocShoppingServiceRepository.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request), this.getPmCheckBean(request));
    }

    @RequestMapping(value={"queryNewShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryNewShoppingPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryNewShoppingPage(request, param);
    }

    private SupQueryResult<OcShoppingReDomain> queryNewShoppingPage(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult ocShoppingReDomainSupQueryResult;
        String memberCode;
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (ocShoppingReDomainSupQueryResult = this.ocShoppingServiceRepository.queryNewShoppingPage(param)) || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            return null;
        }
        TypeBean typeBean = this.ocShoppingServiceRepository.getOcSetting(((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType(), tenantCode);
        List ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getRows();
        if (this.ocShoppingServiceRepository.checkPm(typeBean)) {
            PmCheckBean pmCheckBean = this.getPmCheckBean(request);
            ocShoppingReDomainList = this.ocShoppingServiceRepository.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        return ocShoppingReDomainSupQueryResult;
    }

    private PmCheckBean getPmCheckBean(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        return this.ocShoppingServiceRepository.getPmCheckBean(this.getNowChannel(request), this.getProappCode(request), this.getTenantCode(request), userSession);
    }

    @RequestMapping(value={"updateNewShoppingGoodsNum.json"}, name="\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateNewShoppingGoodsNum(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error(CODE + ".updateNewShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateNewShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
    }

    @RequestMapping(value={"addNewShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addNewShoppingGoods(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String type) {
        return this.saveNewShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, type);
    }

    private HtmlJsonReBean saveNewShopping(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String type) {
        if (null == skuId || StringUtils.isBlank((String)type)) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingServiceRepository.createShoppingGoodsDomain(userSession, goodsBean);
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        shoppingGoodsList.add(ocShoppingGoodsDomain);
        return this.newSaveShoppingDomain(request, shoppingGoodsList, type);
    }

    @RequestMapping(value={"deleteNewShoppingGoodsBatch.json"}, name="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteNewShoppingGoodsBatch(String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        return this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdList);
    }

    @RequestMapping(value={"updateNewShoppingGoodsCheckState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u9009\u4e2d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateNewShoppingGoodsCheckState(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        String memberCode = this.getMerchantCode(request);
        return this.ocShoppingServiceRepository.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    @RequestMapping(value={"addNewShoppingGoodsCode.json"}, name="\u901a\u8fc7SKUcode\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1,\u53ef\u4f20\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean addNewShoppingGoodsCode(HttpServletRequest request, String goodsBeanStr, String type) {
        return this.newSaveShoppingSkuCode(request, goodsBeanStr, type);
    }

    private HtmlJsonReBean newSaveShoppingSkuCode(HttpServletRequest request, String goodsBeanStr, String type) {
        if (StringUtils.isBlank((String)goodsBeanStr) || StringUtils.isBlank((String)type)) {
            this.logger.error(CODE + ".saveShoppingSkuCode", (Object)"goodsBeanStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        List skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShoppingSkuCode.UserSession", (Object)"UserSession is null");
            return null;
        }
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        for (GoodsBean goodsBean : skuCodeList) {
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingServiceRepository.createShoppingGoodsDomain(userSession, goodsBean);
            if (null == ocShoppingGoodsDomain) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            }
            shoppingGoodsList.add(ocShoppingGoodsDomain);
        }
        return this.newSaveShoppingDomain(request, shoppingGoodsList, type);
    }

    private HtmlJsonReBean newSaveShoppingDomain(HttpServletRequest request, List<OcShoppingGoodsDomain> shoppingGoodsList, String type) {
        if (ListUtil.isEmpty(shoppingGoodsList)) {
            this.logger.error(CODE + ".newSaveShoppingDomain", (Object)"newSaveShoppingDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingServiceRepository.insertBatchShoppingGoods(shoppingGoodsList, type);
        return htmlJsonReBean;
    }
}

