/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractEngine"}, name="\u8ba2\u5355\u5f15\u64ce\u670d\u52a1")
public class ContractEngineCon
extends SpringmvcController {
    private static String CODE = "oc.contractEngine.con";
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "contractEngine";
    }

    @RequestMapping(value={"sendContractNext.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBuiMat.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBuiMat(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNextBuiMat", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBySg.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBySg(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNextBySg", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendBatchContractNext.json"}, name="\u6279\u91cf\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendBatchContractNext(HttpServletRequest request, String contractBillcodes, String currentDataState) {
        if (StringUtils.isEmpty((String)contractBillcodes)) {
            this.logger.error(CODE + ".sendBatchContractNext", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("contractBillcode", contractBillcode);
            param.put("tenantCode", tenantCode);
            OcContractReDomain contractByCode = this.ocContractServiceRepository.getContractByCode(param);
            if (null == contractByCode) {
                this.logger.error(CODE + ".sendBatchContractNext.contractByCode", (Object)contractByCode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
            }
            if (Integer.valueOf(currentDataState) == contractByCode.getDataState()) continue;
            this.logger.error(CODE + ".sendBatchContractNext.dataState", (Object)contractByCode.getDataState());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            this.ocContractServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }
}

