/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcConsumeBigData;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmContractGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectCskuServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.qjsoft.laser.controller.order.domain.FareBean;
import com.qjsoft.laser.controller.order.orderexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.order.utils.MatrixToImageWriter;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ContractComCon
extends SpringmvnNewController {
    private static String CODE = "oc.contractcom.con";
    @Autowired
    protected OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;
    @Autowired
    private ProProjectCskuServiceRepository proProjectCskuServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    UmGroupServiceRepository umGroupServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "contractcom";
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        String employeeCode = userSession.getEmployeeCode();
        if (StringUtils.isNotBlank((String)employeeCode)) {
            return employeeCode;
        }
        SupQueryResult qemp = this.orgEmployeeServiceRepository.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", new Object[]{userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()}));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public String getDep(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getDepartCode();
    }

    public String getCom(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode())) {
            return userSession.getCompanyCode();
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getCompanyCode();
    }

    public HtmlJsonReBean saveExContractGoodsCom(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".saveExContractGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ocContractGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderGoodsDomainStr, OcContractGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)ocContractGoodsDomainList)) {
            this.logger.error(CODE + ".saveExContractGoodsCom.ocContractGoodsDomainList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
        }
        HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.saveExContractGoods(ocContractGoodsDomainList);
        return htmlJsonReBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannel(orderDomainList, request);
        return this.ocShoppingServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    private OrgUserBean getOrgUserBean(String memberBcode, String userCode, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
        }
        return orgUserBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType) {
        return this.createOrder(request, orderDomainStr, contractType, null, "0");
    }

    private void makeChannel(List<OrderDomain> orderDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(orderDomainList) || null == request) {
            return;
        }
        for (OrderDomain orderDomain : orderDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    public OcContractReDomain getContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContractCom", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
    }

    public HtmlJsonReBean updateContractCom(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContract(ocContractDomain);
    }

    public HtmlJsonReBean deleteContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContract(Integer.valueOf(contractId));
    }

    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    public OcContractReDomain getContractByCodeCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractServiceRepository.getContractByCode(param);
    }

    public HtmlJsonReBean updateContractSubMoneyCom(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyCom", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractSubMoney(contractId, subMoney, remark);
    }

    public HtmlJsonReBean syncContractStateCom(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    public HtmlJsonReBean syncContractBatchStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractServiceRepository.dataState_no;
        Integer newDataState = OcContractServiceRepository.dataState_1;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean syncContractPayStateCom(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isNotBlank((String)contractSubCode)) {
            return this.getContrantSub(request, contractBillcode, contractSubCode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
        }
        return this.getContrant(request, contractBillcode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_2);
    }

    public HtmlJsonReBean syncContractBatchPayStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractServiceRepository.dataState_no;
        Integer newDataState = OcContractServiceRepository.dataState_2;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean getContrantSub(HttpServletRequest request, String contractBillcode, String contractSubCode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContractSub-state-" + contractSubCode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (System.currentTimeMillis() - currentTime > 10000L) {
                OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
                if (ocContractSubReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                    break;
                }
                dataState = ocContractSubReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    if (!this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) break;
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
                    if (ocContractSubReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                        break;
                    }
                    dataState = ocContractSubReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.sendOrderBigData(contractReDomain);
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public HtmlJsonReBean getContrant(HttpServletRequest request, String contractBillcode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContract-state-" + contractBillcode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        OcContractReDomain contractReDomain = null;
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            contractReDomain = null;
            if (System.currentTimeMillis() - currentTime > 10000L) {
                contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                dataState = contractReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u60011\uff1a" + dataState + "=" + newDataState));
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (!this.checkErrorDataState(dataState, errDataState, newDataState)) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    dataState = contractReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                if (null == contractReDomain) {
                    contractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
                }
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + dataState + "=" + newDataState));
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public Map<String, Object> getContract(OcContractReDomain contractReDomain) {
        if (null == contractReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractReDomain.getContractBillcode());
        map.put("contractBbillcode", contractReDomain.getContractBbillcode());
        map.put("contractType", contractReDomain.getContractType());
        map.put("contractBlance", contractReDomain.getContractBlance());
        map.put("contractPmode", contractReDomain.getContractPmode());
        map.put("contractPaygmoney", contractReDomain.getContractPayamoney());
        map.put("dataBmoney", contractReDomain.getDataBmoney());
        return map;
    }

    public void sendOrderBigData(OcContractReDomain contractReDomain) {
    }

    public HtmlJsonReBean checkDataState(Integer errDataState, Integer newDataState, String DisKey, Map<String, Object> map) {
        String str = SupDisUtil.getRemot((String)DisKey);
        Integer dataState = null;
        OcContractReDomain contractReDomain = null;
        if (StringUtils.isNotBlank((String)str)) {
            dataState = Integer.valueOf(str);
        } else {
            contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
            if (contractReDomain == null) {
                return null;
            }
            dataState = contractReDomain.getDataState();
        }
        if (this.checkErrorDataState(dataState, errDataState, newDataState)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (null == contractReDomain) {
                contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
            }
            if (contractReDomain == null) {
                this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + map.toString()));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            if (this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) {
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
        }
        return null;
    }

    public boolean checkErrorDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        return dataState != null && dataState.intValue() == errDataState.intValue();
    }

    public boolean checkOkDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        if (OcContractServiceRepository.dataState_2.intValue() == newDataState.intValue() && dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1 || dataState.intValue() == OcContractServiceRepository.dataState_30.intValue())) {
            return true;
        }
        return dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1);
    }

    public HtmlJsonReBean checkContractPayCom(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
        if (null == ocContractReDomain || OcContractServiceRepository.dataState_2.intValue() != ocContractReDomain.getDataState().intValue() && OcContractServiceRepository.dataState_30.intValue() != ocContractReDomain.getDataState().intValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean updateShippedPackageExpressCom(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updatePackage(request, packageId, packageExpress);
    }

    public HtmlJsonReBean updatePackage(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageExpress);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updatePackage.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        ocPackageDomain.setPackageId(packageId);
        ocPackageDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updatePackage(ocPackageDomain);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, Integer contractId, Integer dateState) {
        if (null == contractId || null == dateState) {
            this.logger.error(CODE + ".sendContractNextCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractServiceRepository.getContract(contractId);
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contract.getContractBillcode());
    }

    public HtmlJsonReBean sendContractPay(HttpServletRequest request, Integer dateState, OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            this.logger.error(CODE + ".sendContractPay", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractServiceRepository.getContractOneByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractSettlDomain.getContractBillcode(), ocContractSettlDomain.getTenantCode()}));
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.ocContractEngineServiceRepository.sendSaveOffPayOk(ocContractSettlDomain);
    }

    public HtmlJsonReBean sendContractPayBatch(HttpServletRequest request, Integer dateState, List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            this.logger.error(CODE + ".sendContractPayBatch", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        return this.ocContractEngineServiceRepository.sendSaveOffPayOkBatch(ocContractSettlDomainList);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, String contractBillcode, Integer dateState) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (StringUtils.isBlank((String)contractBillcode) || null == dateState) {
            this.logger.error(CODE + ".sendContractNextCom", (Object)"param is null");
        }
        if ((contract = this.ocContractServiceRepository.getContractOneByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.getTenantCode(request)}))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contractBillcode);
    }

    public HtmlJsonReBean calculateFreightFareBatchCom(HttpServletRequest request, String paramStr, String memberBcode) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List fareBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, FareBean.class);
        if (ListUtil.isEmpty((Collection)fareBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        String areaCode = null;
        String shoppingGoodsIdStr = null;
        String skuIdStr = null;
        BigDecimal fare = new BigDecimal(0);
        BigDecimal fare_temp = new BigDecimal(0);
        HtmlJsonReBean htmlJsonReBean = null;
        for (FareBean fareBean : fareBeanList) {
            areaCode = fareBean.getAreaCode();
            if (StringUtils.isNotBlank((String)fareBean.getShoppingGoodsIdStr())) {
                shoppingGoodsIdStr = fareBean.getShoppingGoodsIdStr();
            } else {
                skuIdStr = fareBean.getSkuIdStr();
            }
            htmlJsonReBean = this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, memberBcode);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + ".calculateFreightFareBatch", (Object)"param is null");
                return htmlJsonReBean;
            }
            fare_temp = (BigDecimal)htmlJsonReBean.getDataObj();
            fare = fare.add(fare_temp);
        }
        return new HtmlJsonReBean((Object)fare);
    }

    public HtmlJsonReBean calculateFreightFareCom(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode, String memberBcode) {
        BigDecimal fare;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List shoppingGoodsIdList = null;
        List skuIdList = null;
        if (StringUtils.isNotBlank((String)shoppingGoodsIdStr)) {
            shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        } else {
            skuIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(skuIdStr, SkuDomain.class);
            if (null == skuIdList || skuIdList.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
            }
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setMemberBcode(StringUtils.isBlank((String)memberBcode) ? userSession.getUserPcode() : memberBcode);
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        try {
            fare = this.ocContractServiceRepository.getFreightFare(this.ocContractServiceRepository.makeContractGoodsDomainList("", shoppingGoodsIdList, skuIdList, ocContractDomain, null), areaCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".calculateFreightFare.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        this.logger.error(CODE + ".calculateFreightFare.json" + fare);
        return new HtmlJsonReBean((Object)fare);
    }

    protected HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    public HtmlJsonReBean caExistenceCom(HttpServletRequest request, String contractBillcode, String CallbackURL) throws Exception {
        if (StringUtils.isBlank((String)CallbackURL)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)("CallbackURL is===-===" + contractBillcode));
        }
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)("contractBillcode is==-===" + contractBillcode));
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String tenanrCode = this.getTenantCode(request);
        return this.ocContractServiceRepository.CaFollowupoperation(contractBillcode, userCode, CallbackURL, tenanrCode);
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageCom(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block9: {
            List ocContractReDomainList;
            block8: {
                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                ocContractReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractReDomain.class);
                if (ListUtil.isEmpty((Collection)ocContractReDomainList)) {
                    return null;
                }
                mapList = new ArrayList<Map<String, Object>>();
                if (!StringUtils.isBlank((String)excelTemplate)) break block8;
                for (OcContractReDomain oc : ocContractReDomainList) {
                    List goodsList = oc.getGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty((Collection)goodsList)) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                    mapList.add(stringObjectMap);
                }
                break block9;
            }
            if (!"ag".equals(excelTemplate)) break block9;
            for (OcContractReDomain oc : ocContractReDomainList) {
                List goodsList = oc.getGoodsList();
                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                if (ListUtil.isNotEmpty((Collection)goodsList)) {
                    for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                        Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                        objectDetailToMap.putAll(objectToMap);
                        mapList.add(objectDetailToMap);
                    }
                    continue;
                }
                mapList.add(objectToMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> coverOrderState(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5ba2\u6237\u5df2\u4ed8\u6b3e");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 0: {
                map.put("dataState", "\u5904\u7406\u4e2d");
                break;
            }
            case 4: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            case 20: {
                map.put("dataState", "\u5546\u5bb6\u5df2\u63a5\u5355");
                break;
            }
            case 21: {
                map.put("dataState", "\u9a91\u58eb\u5df2\u63a5\u5355");
                break;
            }
            case 22: {
                map.put("dataState", "\u9a91\u58eb\u5df2\u53d6\u9910");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> covertMap(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> orderDetaiMap = new HashMap<String, Object>();
        orderDetaiMap.put("classtreeName", ocContractGoodsDomain.getClasstreeName());
        orderDetaiMap.put("warehouseName", ocContractGoodsDomain.getWarehouseName());
        orderDetaiMap.put("goodsProperty5", ocContractGoodsDomain.getGoodsProperty5());
        orderDetaiMap.put("goodsSupplyweight", ocContractGoodsDomain.getGoodsSupplyweight());
        orderDetaiMap.put("partsnameWeightunit", ocContractGoodsDomain.getPartsnameWeightunit());
        orderDetaiMap.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
        orderDetaiMap.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderDetaiMap.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
        orderDetaiMap.put("contractGoodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderDetaiMap.put("contractGoodsMoney", ocContractGoodsDomain.getContractGoodsMoney());
        orderDetaiMap.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
        orderDetaiMap.put("contractGoodsPrice", ocContractGoodsDomain.getContractGoodsPrice());
        return orderDetaiMap;
    }

    public List<OcContractReDomain> queryContractPlatForBalanceCom(HttpServletRequest request, String memberCcode) {
        SupQueryResult qlist;
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", memberCcode);
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("dataState", OcContractServiceRepository.dataState_4);
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (qlist = this.ocContractServiceRepository.queryContractPageReDomain(param)) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return this.create(qlist.getList(), erpFlag);
    }

    protected List<OcContractReDomain> create(List<OcContractReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcContractReDomain> relist = new ArrayList<OcContractReDomain>();
        for (OcContractReDomain ocContractReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocContractReDomain.getContractBillcode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocContractReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocContractReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocContractReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocContractReDomain);
                    continue;
                }
                this.logger.info(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocContractReDomain);
                continue;
            }
            this.logger.info(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocContractReDomain);
        }
        return relist;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractServiceRepository.queryOrderErpFlag(nostr);
    }

    private String getListToString(List<OcContractReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcContractReDomain ocContractReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocContractReDomain.getContractBillcode();
        }
        return noStr;
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
        }
        catch (Exception e) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult qmem = this.umGroupServiceRepository.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()}));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public List<PmUserCouponReDomain> queryUserConByGoodsCom(HttpServletRequest request, String pmContractGoodsDomainListStr, String memberBcode) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            this.logger.error(CODE + ".queryUserConByGoodsCom", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        List pmContractGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pmContractGoodsDomainListStr, PmContractGoodsDomain.class);
        return this.ocContractServiceRepository.queryUserCon(pmContractGoodsDomainList, this.ocContractServiceRepository.getPmCheckBean(this.getNowChannel(request), this.getProappCode(request), this.getTenantCode(request), userSession.getUserPcode(), userSession.getMerberCompname(), userSession.getUserName()));
    }

    public SupQueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPageCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllUserOcConsumeBigDataPage(param);
    }

    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDayCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllOcConsumeBigDataByDay(param);
    }

    public SupQueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPageCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllOcConsumeBigDataForSellerPage(param);
    }

    public HtmlJsonReBean getOrderInvUrlCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        HashMap queryUserinfoMap = new HashMap();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult umUserinfoReResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        return new HtmlJsonReBean((Object)url);
    }

    public HtmlJsonReBean getOrderInvUrlForPlatCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        if (StringUtils.isBlank((String)((String)param.get("memberCcode")))) {
            this.logger.error(CODE + ".getOrderInvUrl.memberCcode.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "memberCcode is null");
        }
        HashMap queryUserinfoMap = new HashMap();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult umUserinfoReResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        if (StringUtils.isBlank((String)shopId)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopId.null", param.get("memberCcode"));
            return new HtmlJsonReBean("error", "shopId is null");
        }
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        this.logger.error(CODE + ".getOrderInvUrlForPlatCom.url", (Object)url);
        String text = "";
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, 90, 90);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream(bitMatrix, "PNG", outputStream);
            text = Base64.encodeBase64String((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HtmlJsonReBean((Object)text);
    }

    public HtmlJsonReBean updateContractDelcodeCom(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(CODE + ".updateContractDelcodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(param);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".updateContractDelcodeCom.ocContractReDomain", (Object)((Object)param).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
        }
        if (!contractDelcode.equals(ocContractReDomain.getContractDelcode())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(ocContractReDomain.getMemberBcode(), this.getTenantCode(request));
            if (null == umUserinfoReDomainBean) {
                this.logger.error(CODE + ".updateContractDelcodeCom.umUserinfoReDomainBean", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
            if (!contractDelcode.equals(umUserinfoReDomainBean.getUserinfoUcode())) {
                this.logger.error(CODE + ".updateContractDelcodeCom.userinfoUcode", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
        }
        if (3 != ocContractReDomain.getDataState()) {
            this.logger.error(CODE + ".updateContractDelcodeCom.dataState", (Object)ocContractReDomain.getDataState());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        return this.ocContractServiceRepository.sendContractNext(contractBillcode, this.getTenantCode(request), null);
    }

    public HtmlJsonReBean updateContractUserinfoCodeCom(HttpServletRequest request, String contractBillcodes, String userinfoCode) {
        if (StringUtils.isBlank((String)contractBillcodes) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error(CODE + ".updateContractUserinfoCodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryContractForUserBySupplierCode.userSession", (Object)"userSession is null");
            return null;
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("contractBillcode", contractBillcode);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("userinfoCode", userinfoCode);
            OcContractReDomain contractByCode = this.ocContractServiceRepository.getContractByCode(param);
            if (null == contractByCode) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.contractByCode", (Object)contractByCode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
            }
            if (3 != contractByCode.getDataState()) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.dataState", (Object)contractByCode.getDataState());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
            }
            if (userSession.getUserPcode().equals(contractByCode.getGoodsSupplierCode())) continue;
            this.logger.error(CODE + ".updateContractUserinfoCodeCom.goodsSupplierCode", (Object)contractByCode.getGoodsSupplierCode());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u914d\u9001\u5546\u6709\u8bef");
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            this.ocContractServiceRepository.sendContractNext(contractBillcode, this.getTenantCode(request), null);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }

    public HtmlJsonReBean updateContractStateExtendCom(Integer contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)contractId) || null == dataState) {
            this.logger.error(CODE + ".cancelContractForAll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != oldDataState) {
            OcContractReDomain contract = this.ocContractServiceRepository.getContract(contractId);
            if (null == contract) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contract is null");
            }
            if (contract.getDataState().intValue() != oldDataState.intValue()) {
                return new HtmlJsonReBean("error", "\u72b6\u6001\u5df2\u53d8\u5316");
            }
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, dataState, oldDataState);
    }
}

