/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingDomain;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundJdBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundReDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.RefundType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/oc/refund"}, name="\u9000\u6b3e\u670d\u52a1")
public class RefundCon
extends SpringmvcController {
    private static String CODE = "oc.refund.con";
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "refund";
    }

    @RequestMapping(value={"saveRefundForPlat.json"}, name="\u5e73\u53f0\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefundForPlat(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.PLAT.getCode());
    }

    @RequestMapping(value={"saveRefundForMem.json"}, name="\u5546\u5bb6\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefundForBus(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.MEM.getCode());
    }

    private HtmlJsonReBean saveRefund(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error(CODE + ".saveRefund.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (ocRefundBean.getRefundMoney().compareTo(ocContractReDomain.getDataBmoney()) == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), (OcContractDomain)ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            if (ListUtil.isNotEmpty((Collection)ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(((OcRefundGoodsDomain)ocRefundDomain.getOcRefundGoodsDomainList().get(0)).getMemberCcode());
                ocRefundDomain.setMemberCname(((OcRefundGoodsDomain)ocRefundDomain.getOcRefundGoodsDomainList().get(0)).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveRefund.ex", e.getMessage());
        }
        return this.ocRefundServiceRepository.saveRefund(ocRefundDomain);
    }

    @RequestMapping(value={"saveRefund.json"}, name="\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefund(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.USER.getCode());
    }

    @RequestMapping(value={"jDsaveRefund.json"}, name="\u4eac\u4e1c\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean jDsaveRefund(HttpServletRequest request, String params) {
        if (null == params) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundJdBean ocRefundBean = (OcRefundJdBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundJdBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocRefundBean);
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), (OcContractDomain)ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            if (ListUtil.isNotEmpty((Collection)ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(((OcRefundGoodsDomain)ocRefundDomain.getOcRefundGoodsDomainList().get(0)).getMemberCcode());
                ocRefundDomain.setMemberCname(((OcRefundGoodsDomain)ocRefundDomain.getOcRefundGoodsDomainList().get(0)).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveRefund.ex", e.getMessage());
        }
        this.sendReFundOrderBigData(ocRefundDomain);
        return this.ocRefundServiceRepository.saveRefund(ocRefundDomain);
    }

    @RequestMapping(value={"jDgetRefundByCode.json"}, name="\u6839\u636eCODE\u83b7\u53d6jD\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain jDgetRefundByCode(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error(CODE + ".getRefundByCode.refundCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundServiceRepository.getRefundByCode(map);
    }

    @RequestMapping(value={"queryjDRefundPage.json"}, name="\u67e5\u8be2jD\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryjDRefundPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractType", "16");
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryjDBooksRefundPage.json"}, name="\u67e5\u8be2jD\u56fe\u4e66\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryjDBooksRefundPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractType", "17");
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractDomain ocContractDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error(CODE + ".makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (refundGoodsList.getGoodsCamount().compareTo(ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum())) > 0) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
            refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
            refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
            refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            if (null == refundGoodsList.getRefundGoodsNum() || refundGoodsList.getRefundGoodsNum() == BigDecimal.ZERO) {
                throw new Exception("\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e0\u6216\u8005\u4e0d\u586b");
            }
            if (null == refundGoodsList.getRefundGoodsAmt() || refundGoodsList.getRefundGoodsAmt() == BigDecimal.ZERO) {
                throw new Exception("\u9000\u8d27\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e0\u6216\u8005\u4e0d\u586b");
            }
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum()).setScale(2, 4);
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error(CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    @RequestMapping(value={"getRefund.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundForPlat.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefundForPlat(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundByCode.json"}, name="\u6839\u636eCODE\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefundByCode(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error(CODE + ".getRefundByCode.refundCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundServiceRepository.getRefundByCode(map);
    }

    @RequestMapping(value={"updateRefund.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRefund(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error(CODE + ".updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundServiceRepository.updateRefund(ocRefundDomain);
    }

    @RequestMapping(value={"deleteRefund.json"}, name="\u5220\u9664\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".deleteRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.deleteRefund(refundId);
    }

    @RequestMapping(value={"queryRefundPage.json"}, name="\u5546\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPage(HttpServletRequest request) {
        return this.queryRefund(request);
    }

    @RequestMapping(value={"queryRefundForMem.json"}, name="\u5546\u5bb6\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForMem(HttpServletRequest request) {
        return this.queryRefund(request);
    }

    private SupQueryResult<OcRefundReDomain> queryRefund(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryByMemberCcode.json"}, name="\u4f9b\u5e94\u5546\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryByMemberCcode(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        UserSession userSession = this.getUserSession(request);
        param.put("memberCcode", userSession.getUserPcode());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPageBuy.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPageBuy(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"updateRefundState.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRefundState(String refundId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundId)) {
            this.logger.error(CODE + ".updateRefundState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.updateRefundState(Integer.valueOf(refundId), dataState, oldDataState);
    }

    @RequestMapping(value={"uploadRefFile.json"}, name="\u4e0a\u4f20\u9000\u8d27\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadRefFile(MultipartFile file, HttpServletRequest request) {
        if (null == file) {
            this.logger.error(CODE + ".uploadRefFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileSort = "FILE_02";
        return this.fileServiceRepository.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"arrGoods.json"}, name="\u5230\u8d27")
    @ResponseBody
    public HtmlJsonReBean arrGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".arrGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".arrGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"platformAuditRefund.json"}, name="\u5e73\u53f0\u5ba1\u6838\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean platformAuditRefund(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".platformAuditRefund", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".platformAuditRefund", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"sendGoods.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09")
    @ResponseBody
    public HtmlJsonReBean sendGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".sendGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".sendGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"supplieraudit.json"}, name="\u4f9b\u5e94\u5546\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean supplieraudit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"audit.json"}, name="\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean audit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    private HtmlJsonReBean auditPlus(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".auditPlus.into", map);
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".audit", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        this.logger.error(CODE + ".auditPlus.into.getRefundByCode", (Object)refundReDomain.getRefundId());
        if (refundReDomain.getDataState() == 0) {
            map.put("dataStatestr", "60");
            return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5ba1\u6838");
    }

    @RequestMapping(value={"res.json"}, name="\u64a4\u9500\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean res(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() == 0) {
            return this.ocRefundServiceRepository.updateRefundRes(refundCode, tenantCode, map);
        }
        this.sendReFundOrderBigData((OcRefundDomain)refundReDomain);
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u72b6\u6001\u5df2\u66f4\u6539\uff0c\u64a4\u9500\u5931\u8d25");
    }

    @RequestMapping(value={"queryRefCause.json"}, name="\u83b7\u53d6\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryRefCause(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        return this.queryRefCause(tenantCode);
    }

    @RequestMapping(value={"refuseApplication.json"}, name="\u8fd0\u8425\u7aef\u62d2\u7edd\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean refuseApplication(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocRefundServiceRepository.updateRefundRefuse(refundCode, tenantCode, map);
        if (null != htmlJsonReBean && !htmlJsonReBean.isSuccess()) {
            this.sendReFundOrderBigData((OcRefundDomain)refundReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"refuseGoods.json"}, name="\u8fd0\u8425\u7aef\u62d2\u7edd\u6536\u8d27")
    @ResponseBody
    public HtmlJsonReBean refuseGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocRefundServiceRepository.updateRefundRefuse(refundCode, tenantCode, map);
        if (null != htmlJsonReBean && !htmlJsonReBean.isSuccess()) {
            this.sendReFundOrderBigData((OcRefundDomain)refundReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveFalgSetting.json"}, name="\u589e\u52a0\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean saveFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error(CODE + ".saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.saveFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"deleteFalgSetting.json"}, name="\u5220\u9664\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean deleteFalgSetting(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".deleteFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingServiceRepository.deleteFalgSetting(Integer.valueOf(flagSettingId));
    }

    @RequestMapping(value={"updateFalgSetting.json"}, name="\u4fee\u6539\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean updateFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error(CODE + ".saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.updateFalgSetting(ddFalgSettingDomain);
    }

    private List<DdFalgSettingReDomain> queryRefCause(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingScope", "refundEx");
        map.put("flagSettingType", "refundEx");
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
        if (qlist == null) {
            return null;
        }
        return qlist.getRows();
    }

    public void sendReFundOrderBigData(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(ocRefundDomain.getTenantCode() + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        String value = "{\"paasLabel\":\"refundOrder\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    @RequestMapping(value={"queryOcRefundPage.json"}, name="\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"supplierOcAudit.json"}, name="\u4f9b\u5e94\u5546\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean supplierOcAudit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"getRefundPlat.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public OcRefundReDomain getRefundPlat(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefundPlat", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundByCodeForC.json"}, name="\u6839\u636eCODE\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f-C\u7aef\u9000\u8d27\u7269\u6d41")
    @ResponseBody
    public OcRefundReDomain getRefundByCodeForC(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error(CODE + ".getRefundByCodeForC.refundCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundServiceRepository.getRefundByCode(map);
    }

    @RequestMapping(value={"sendGoodsForC.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean sendGoodsForC(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".sendGoodsForC", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".sendGoodsForC", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"queryRefundPlatForBalance.json"}, name="\u5e73\u53f0\u67e5\u770b\u5168\u6e20\u9053\u9000\u6b3e\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcRefundReDomain> queryRefundPlatForBalance(HttpServletRequest request, String memberCcode) {
        SupQueryResult ocRefundReDomainSupQueryResult;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("contractState", "4");
        param.put("dataState", "4");
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundReDomainPage(param)) || ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryRefundPlatForBalance.ocRefundReDomainSupQueryResult.null", (Object)("param==" + JsonUtil.buildNonDefaultBinder().toJson((Object)param)));
            return null;
        }
        return this.create(ocRefundReDomainSupQueryResult.getList(), erpFlag);
    }

    @RequestMapping(value={"queryRefundUserForBalance.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u9000\u6b3e\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcRefundReDomain> queryRefundUserForBalance(HttpServletRequest request) {
        SupQueryResult ocRefundReDomainSupQueryResult;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("contractState", "4");
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundReDomainPage(param)) || ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryRefundPlatForBalance.ocRefundReDomainSupQueryResult.null", (Object)("param==" + JsonUtil.buildNonDefaultBinder().toJson((Object)param)));
            return null;
        }
        return this.create(ocRefundReDomainSupQueryResult.getList(), erpFlag);
    }

    private List<OcRefundReDomain> create(List<OcRefundReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcRefundReDomain> relist = new ArrayList<OcRefundReDomain>();
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocRefundReDomain.getRefundCode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocRefundReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocRefundReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocRefundReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocRefundReDomain);
                    continue;
                }
                this.logger.info(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocRefundReDomain);
                continue;
            }
            this.logger.info(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocRefundReDomain);
        }
        return relist;
    }

    private String getListToString(List<OcRefundReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocRefundReDomain.getRefundCode();
        }
        return noStr;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractServiceRepository.queryOrderErpFlag(nostr);
    }

    @RequestMapping(value={"queryRefundForPlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundForStore.json"}, name="\u95e8\u5e97\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", userSession.getUserPcode());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"supplierOcAuditForStore.json"}, name="\u95e8\u5e97\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean supplierOcAuditForStore(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"refuseApplicationForStore.json"}, name="\u95e8\u5e97\u62d2\u7edd\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean refuseApplicationForStore(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        map.put("dataStatestr", "50");
        HtmlJsonReBean htmlJsonReBean = this.ocRefundServiceRepository.updateRefundRefuse(refundCode, tenantCode, map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getRefundStore.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f\uff08\u95e8\u5e97\uff09")
    @ResponseBody
    public OcRefundReDomain getRefundStore(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefundStore", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefund(refundId);
    }
}

