/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractSub"}, name="\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
public class ContractSubCon
extends SpringmvcController {
    private static String CODE = "oc.contractSub.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;

    protected String getContext() {
        return "contractSub";
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney) {
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error(CODE + ".addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractSubDomain ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain);
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return ocContractSubDomain;
    }

    @RequestMapping(value={"saveContractSub.json"}, name="\u589e\u52a0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".saveContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"getContractSub.json"}, name="\u83b7\u53d6\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractSubReDomain getContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".getContractSub", (Object)"param is null");
            return null;
        }
        return this.ocContractSubServiceRepository.getContractSub(contractSubId);
    }

    @RequestMapping(value={"updateContractSub.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".updateContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubServiceRepository.updateContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"deleteContractSub.json"}, name="\u5220\u9664\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".deleteContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.deleteContractSub(contractSubId);
    }

    @RequestMapping(value={"queryContractSubPage.json"}, name="\u67e5\u8be2\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractSubReDomain> queryContractSubPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractSubServiceRepository.queryContractSubPage(param);
    }

    @RequestMapping(value={"updateContractSubState.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractSubState(String contractSubId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractSubId)) {
            this.logger.error(CODE + ".updateContractSubState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.updateContractSubState(Integer.valueOf(contractSubId), dataState, oldDataState, null);
    }
}

