/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cp.domain.CpRechargeReDomain;
import com.qjsoft.laser.controller.facade.cp.repository.CpRechargeServiceRepository;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsumOrderlistReDomain;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.ContractGoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.ContractStatisticsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsSendNumBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcBusinessDimensionDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClinicRankingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClinicReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClorstDataStatisticsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcCommissionStatisticsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcConsumeBigData;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcDentalReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcDistributorEmployeeReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingpackgeDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.qjsoft.laser.controller.order.orderexceltemplate.ExcelExportTemplate;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contract"}, name="\u7528\u6237\u7aef\u8ba2\u5355\u670d\u52a1")
public class ContractCon
extends ContractComCon {
    private static String CODE = "oc.contract.con";
    @Autowired
    private CpRechargeServiceRepository cpRechargeServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"queryOcContractByContractNbillCode.json"}, name="\u6309\u573a\u6b21\u53f7\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractByContractNbillCode(HttpServletRequest request, String contractNbillcode) {
        String tenantCode = this.getTenantCode(request);
        return this.ocContractServiceRepository.queryOcContractByContractNbillCode(contractNbillcode, tenantCode);
    }

    @RequestMapping(value={"updateTopNum.json"}, name="\u5b9e\u53d1\u6570\u91cf\u56de\u8c03")
    @ResponseBody
    public HtmlJsonReBean updateTopNum(HttpServletRequest request, String goodsSendNumBeanList) {
        if (StringUtils.isBlank((String)goodsSendNumBeanList)) {
            this.logger.error(CODE + ".updateTopNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsSendNumBeans = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsSendNumBeanList, GoodsSendNumBean.class);
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeans) {
            goodsSendNumBean.setTenantCode(this.getTenantCode(request));
        }
        this.ocContractServiceRepository.updateTopNum(goodsSendNumBeans);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateBatchGoodsInfo.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u5c5e\u6027")
    @ResponseBody
    public HtmlJsonReBean updateBatchGoodsInfo(HttpServletRequest request, String mapList) {
        if (StringUtils.isBlank((String)mapList)) {
            this.logger.error(CODE + ".updateTopNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(mapList, Map.class);
        this.ocContractServiceRepository.updateBatchGoodsInfo(list);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateNewBatchGoodsInfo.json"}, name="\u53d6\u6d88\u8ba2\u5355\u5546\u54c1\u6700\u540e\u56de\u9000\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateNewBatchGoodsInfo(HttpServletRequest request, String mapListStr) {
        if (StringUtils.isBlank((String)mapListStr)) {
            this.logger.error(CODE + ".updateBatchGoodsInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(mapListStr, ContractGoodsBean.class);
        this.ocContractServiceRepository.sendUpdateBatchGoodsInfo(list);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkGoodsPmbillno.json"}, name="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u65f6\u5019\u6709\u8425\u9500\u672a\u5b8c\u6210\u7684\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean checkGoodsPmbillno(HttpServletRequest request, String goodsPmbillno) {
        if (StringUtils.isBlank((String)goodsPmbillno)) {
            return new HtmlJsonReBean((Object)0);
        }
        Map param = this.assemMapBuyParam(request);
        SupQueryResult qr = this.ocContractServiceRepository.queryContractPage(param);
        if (null == qr || ListUtil.isEmpty((Collection)qr.getList())) {
            return new HtmlJsonReBean();
        }
        int i = 0;
        for (OcContractReDomain ocContractReDomain : qr.getList()) {
            if (OcContractServiceRepository.dataState_no.intValue() == ocContractReDomain.getDataState().intValue()) continue;
            ++i;
        }
        return new HtmlJsonReBean((Object)i);
    }

    @RequestMapping(value={"saveExContractGoods.json"}, name="\u8ba2\u5355\u6362\u8d27\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExContractGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".saveExContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveExContractGoodsCom(request, orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String orderDomainStr) {
        this.logger.error(CODE + "saveContract.json----------", (Object)(orderDomainStr + "                 \u53c2\u6570"));
        return this.createOrder(request, orderDomainStr, ContractType.CON.getCode());
    }

    @RequestMapping(value={"saveContractEmp.json"}, name="C\u7aef\u4e0b\u5355\u5f52\u5c5e\u64cd\u4f5c\u5458\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractEmp(HttpServletRequest request, String orderDomainStr) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String memberBcode = userSession.getUserPcode();
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode(), memberBcode, "0");
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveOcContractGoodsEmp.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveOcContractGoodsEmp(HttpServletRequest request, String ocContractGoodsDomainStr) {
        if (StringUtils.isBlank((String)ocContractGoodsDomainStr)) {
            this.logger.error(CODE + ".saveOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List ocContractGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractGoodsDomainStr, OcContractGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
                ocContractGoodsDomain.setTenantCode(tenantCode);
                ocContractGoodsDomain.setContractGoodsGtype("1");
                this.ocContractServiceRepository.saveContractGoods(ocContractGoodsDomain);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveContractSettlEmp.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveContractSettlEmp(HttpServletRequest request, String ocContractSettlDomainStr) {
        if (StringUtils.isBlank((String)ocContractSettlDomainStr)) {
            this.logger.error(CODE + ".saveContractSettl", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractSettlDomainStr, OcContractSettlDomain.class);
        ocContractSettlDomain.setTenantCode(tenantCode);
        ocContractSettlDomain.setContractSettlBlance("GQ");
        return this.ocContractServiceRepository.saveContractSettl(ocContractSettlDomain);
    }

    @RequestMapping(value={"saveContractSp.json"}, name="\u5408\u540c\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractSp(HttpServletRequest request, String orderDomainStr, String contractProperty) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode(), null, contractProperty);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveEaseContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u7b80\u6613)")
    @ResponseBody
    public HtmlJsonReBean saveEaseContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.PROJECT.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u5151\u6362)")
    @ResponseBody
    public HtmlJsonReBean saveGiftContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFTEX.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftExchangeContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u8d2d\u4e70)")
    @ResponseBody
    public HtmlJsonReBean saveGiftExchangeContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFT.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveSplitSendgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractDomain occontractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, OcContractDomain.class);
        return this.updateContractCom(request, occontractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContract(HttpServletRequest request, String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".deleteContract.ocContractReDomain", (Object)"ocContractReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocContractReDomain");
        }
        String userinfoCode = this.getUserSession(request).getUserPcode();
        if (!userinfoCode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".deleteContract.userinfoCode", (Object)"userinfoCode is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error");
        }
        return this.deleteContractCom(contractId);
    }

    @RequestMapping(value={"queryContractGoodsPage.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractGoodsPageBytenant.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868(\u79df\u6237)")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageBytenant(HttpServletRequest request) {
        String exportFlag;
        Boolean flag;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((flag = Boolean.valueOf(exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag"))).booleanValue()) {
            String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
            String fileName = "\u8ba2\u5355\u5546\u54c1\u5217\u8868";
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractGoodsPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractGoodsPageBytenant.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractForMem.json"}, name="\u5546\u5bb6\u8ba2\u5355\u5217\u8868-\u5546\u5bb6\u8ba2\u5355\u5217\u8868\u9875")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForMem(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    @RequestMapping(value={"queryContractPageForPlat.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForPlat(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    @RequestMapping(value={"queryContractSettlDomain.json"}, name="\u8ba2\u5355\u670d\u52a1\u7ed3\u7b97\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractSettlDomain> queryContractSettlDomain(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult ocContractSettlDomainSupQueryResult = this.ocContractServiceRepository.queryContractSettlPage(param);
        return ocContractSettlDomainSupQueryResult;
    }

    @RequestMapping(value={"updateContractSettl.json"}, name="\u5408\u540c\u7ed3\u7b97\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateContractSettl(HttpServletRequest request, OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            this.logger.error(CODE + ".updateContractSettl", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractSettl(ocContractSettlDomain);
    }

    @RequestMapping(value={"updateContractSettlNew.json"}, name="\u5408\u540c\u7ed3\u7b97\u4fee\u6539\u51ed\u8bc1\u53f7")
    @ResponseBody
    public HtmlJsonReBean updateContractSettlNew(HttpServletRequest request, String contractSettlStr) {
        if (null == contractSettlStr) {
            this.logger.error(CODE + ".updateContractSettl", (Object)("param is null" + contractSettlStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map param = this.assemMapParam(request);
        OcContractSettlDomain contractSettlByCode = this.ocContractServiceRepository.getContractSettlByCode(param);
        if (contractSettlByCode == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "nullocContractSettlDomain" + contractSettlStr);
        }
        contractSettlByCode.setContractSettlOpno(contractSettlStr);
        return this.ocContractServiceRepository.updateContractSettl(contractSettlByCode);
    }

    @RequestMapping(value={"queryRechargePagePayment.json"}, name="\u67e5\u8be2\u6709\u51e0\u6761\u6d41\u6c34\u53ef\u4ee5\u7ebf\u4e0b\u4ed8\u6b3e")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryRechargePagePayment(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        ArrayList<CpRechargeReDomain> cpRechargeReDomainList = new ArrayList<CpRechargeReDomain>();
        SupQueryResult cpRechargeReDomainSupQueryResultStr = new SupQueryResult();
        SupQueryResult cpRechargeReDomainSupQueryResult = this.cpRechargeServiceRepository.queryRechargePage(param);
        if (ListUtil.isNotEmpty((Collection)cpRechargeReDomainSupQueryResult.getList())) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (CpRechargeReDomain cpRechargeReDomain : cpRechargeReDomainSupQueryResult.getList()) {
                params.put("tenantCode", cpRechargeReDomain.getTenantCode());
                params.put("contractSettlOpno", cpRechargeReDomain.getRechargeOpcode());
                SupQueryResult ocContractSettlDomainSupQueryResult = this.ocContractServiceRepository.queryContractSettlPage(params);
                if (!ListUtil.isEmpty((Collection)ocContractSettlDomainSupQueryResult.getList())) continue;
                cpRechargeReDomainList.add(cpRechargeReDomain);
            }
        }
        cpRechargeReDomainSupQueryResultStr.setList(cpRechargeReDomainList);
        cpRechargeReDomainSupQueryResultStr.setRows(cpRechargeReDomainList);
        return cpRechargeReDomainSupQueryResultStr;
    }

    private SupQueryResult<OcContractReDomain> queryContractPageS(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE, (Object)("--------------------" + param.toString()));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageCchannelCode.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u52a0\u5165\u6e20\u9053\u8fc7\u6ee4")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageCchannelCode(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("channelCode", this.getNowChannel(request));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_2, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"cancelContractC.json"}, name="\u53d6\u6d88\u8ba2\u5355  C\u7aef")
    @ResponseBody
    public HtmlJsonReBean cancelContractC(HttpServletRequest request, Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Object htmlJsonReBean = null;
        Map paramStr = this.assemMapBuyParam(request);
        paramStr.put("contractId", contractId);
        SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(paramStr);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".cancelContractC", (Object)"ocContractGoodsReDomainSupQueryResult is null");
            return null;
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocContractReDomain.getMemberBcode())) {
            return null;
        }
        return ocContractReDomain;
    }

    @RequestMapping(value={"getContractByBillcode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\uff08sort=1\uff09")
    @ResponseBody
    public OcContractReDomain getContractByBillcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param) || null == param.get("contractBillcode")) {
            this.logger.error(CODE + ".getContractByBillcode.param:", (Object)param);
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".getContractByBillcode.ocContractReDomain:", (Object)("\u65e0\u6b64\u8ba2\u5355" + param));
            return null;
        }
        if (userSession.getUserPcode().equals(this.getTeananMemberCode(request))) {
            return ocContractReDomain;
        }
        if (userSession.getUserPcode().equals(ocContractReDomain.getMemberMcode())) {
            return ocContractReDomain;
        }
        return null;
    }

    @RequestMapping(value={"getContractByCodeNo.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\uff08\u4e0d\u6821\u9a8c\u767b\u5f55\u8005\uff09")
    @ResponseBody
    public OcContractReDomain getContractByCodeNo(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        String fileName = "\u9500\u552e\u7ef4\u5ea6(\u8ba2\u5355)";
        param.put("excelTemplate", "dimension");
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.queryContractPageComes(request, fileName, param);
        return ocContractReDomain;
    }

    @RequestMapping(value={"getContractByCodeForGroup.json"}, name="\u56e2\u957f\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCodeForGroup(HttpServletRequest request) {
        Map param = this.getQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"getContractByCodeByPlat.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5(\u5e73\u53f0)")
    @ResponseBody
    public OcContractReDomain getContractByCodeByPlat(HttpServletRequest request) {
        Map param = this.getQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"getContractByCodeForService.json"}, name="\u670d\u52a1\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCodeForService(HttpServletRequest request) {
        Map param = this.getQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        return this.syncContractPayStateCom(request, contractBillcode, contractSubCode);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchPayStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkContractPayCom(request, contractBillcode);
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updatePackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_3, true);
    }

    @RequestMapping(value={"confirmReceivable.json"}, name="\u786e\u8ba4\u6536\u6b3e")
    @ResponseBody
    public HtmlJsonReBean confirmReceivable(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceive.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1, false);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFareBatch.json"}, name="\u6279\u91cf\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFareBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareBatchCom(request, paramStr, null);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, null);
    }

    @RequestMapping(value={"CaExistence.json"}, name="CA\u5b58\u5728\u65f6")
    @ResponseBody
    public HtmlJsonReBean CaExistence(HttpServletRequest request, String contractBillcode, String CallbackURL) throws Exception {
        if (StringUtils.isBlank((String)CallbackURL)) {
            this.logger.error(CODE + ".CaExistence", (Object)("CallbackURL is===-===" + contractBillcode));
        }
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".CaExistence", (Object)("contractBillcode is==-===" + contractBillcode));
        }
        return this.caExistenceCom(request, contractBillcode, CallbackURL);
    }

    @RequestMapping(value={"queryContractPagePlatBuild.json"}, name="\u67e5\u8be2\u5e73\u53f0\u623f\u5c4b\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlatBuild(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractStatePlatBuild.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u5e73\u53f0\u623f\u5c4b)")
    @ResponseBody
    public HtmlJsonReBean updateContractStatePlatBuild(HttpServletRequest request, String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStatePlatBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, Integer.valueOf(contractId), oldDataState, false);
    }

    @RequestMapping(value={"confirmReceivablePlatBuild.json"}, name="\u786e\u8ba4\u6536\u6b3e\uff08\u5e73\u53f0\u623f\u5c4b\uff09")
    @ResponseBody
    public HtmlJsonReBean confirmReceivablePlatBuild(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceivablePlatBuild.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1, false);
    }

    @RequestMapping(value={"queryContractPagNew.json"}, name="\u65b0\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractNewPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPageBuiMats.json"}, name="\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMats(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBuiMatsBymem.json"}, name="\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u5f53\u524d\u767b\u5f55\u8005")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMatsBymem(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractStorePage.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractStorePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("memberCcode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractStoreForBalance.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcContractReDomain> queryContractStoreForBalance(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        return this.queryContractPlatForBalanceCom(request, userSession.getUserPcode());
    }

    @RequestMapping(value={"queryContractPlatForBalance.json"}, name="\u4e2d\u53f0\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcContractReDomain> queryContractPlatForBalance(HttpServletRequest request, String memberCcode) {
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        return this.queryContractPlatForBalanceCom(request, memberCcode);
    }

    @RequestMapping(value={"queryContractMyPage.json"}, name="\u67e5\u770b\u81ea\u5df1\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractMyPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("memberCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateShippedPackageExpressBuiMat.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpressBuiMat(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"updateContractSubMoneyBuiMat.json"}, name="\u4fee\u6539\u4ef7\u683c(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoneyBuiMat(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyBuiMat", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"updateContractStateBuiMat.json"}, name="\u8fd0\u8425\u7aef\u53d6\u6d88\u5f85\u652f\u4ed8\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBuiMat(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractStateBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"offlinePayContractStateBuiMat.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractStateBuiMat(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractStateBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_2, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"queryContractPageBuild.json"}, name="\u5168\u6e20\u9053\u623f\u5c4b\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuild(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractStateBuild.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u5168\u6e20\u9053\u623f\u5c4b)")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBuild(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStateBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"confirmReceivableBuild.json"}, name="\u786e\u8ba4\u6536\u6b3e\uff08\u5168\u6e20\u9053\u623f\u5c4b\uff09")
    @ResponseBody
    public HtmlJsonReBean confirmReceivableBuild(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceivableBuild.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1, false);
    }

    @RequestMapping(value={"queryContractPageBySg.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySg(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        String fileName = "\u9500\u552e\u7ef4\u5ea6(\u5546\u54c1)";
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "dimensionGoods");
        }
        return this.queryContractPageCom(request, fileName, param);
    }

    @RequestMapping(value={"updateContractSubMoneyBySg.json"}, name="\u4fee\u6539\u4ef7\u683c(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoneyBySg(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyBySg", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"updateContractStateBySg.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBySg(HttpServletRequest request, String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStateBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, Integer.valueOf(contractId), oldDataState, false);
    }

    @RequestMapping(value={"offlinePayContractStateBySg.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractStateBySg(HttpServletRequest request, Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractStateBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, (int)contractId, (Integer)1, false);
    }

    @RequestMapping(value={"updateShippedPackageExpressBySg.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpressBySg(HttpServletRequest request, String contractBillcode, String packageBillno, String packageMode, String expressCode, String expressName) {
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)packageBillno) || StringUtils.isEmpty((String)expressCode) || StringUtils.isEmpty((String)packageMode)) {
            this.logger.error(CODE + ".updateShippedPackageExpressBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNext(request, contractBillcode);
    }

    @RequestMapping(value={"queryUserConByGoods.json"}, name="\u6839\u636e\u5546\u54c1\u83b7\u53d6\u5bf9\u5e94\u7684\u4f18\u60e0\u5377")
    @ResponseBody
    public List<PmUserCouponReDomain> queryUserConByGoods(HttpServletRequest request, String pmContractGoodsDomainListStr, String contractPmode) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            this.logger.error(CODE + ".queryUserConByGoods", (Object)"param is null");
            return null;
        }
        return this.queryUserConByGoodsCom(request, pmContractGoodsDomainListStr, null, contractPmode);
    }

    @RequestMapping(value={"queryContractForAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u4e2a\u4eba")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForPaasAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u6240\u6709")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPaasAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForPaasPlatformAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u5e73\u53f0\u6240\u6709")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPaasPlatformAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "ag");
            param.put("childFlag", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForPgWrite.json"}, name="\u8ba2\u5355\u5bfc\u51fa--Pg")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPgWrite(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pg");
            param.put("childFlag", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForRetailerWrite.json"}, name="\u8ba2\u5355\u5bfc\u51fa--\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForRetailerWrite(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "retailer");
            param.put("childFlag", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractForPaasPlatformAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u5e73\u53f0\u6240\u6709")
    @ResponseBody
    public OcContractReDomain getContractForPaasPlatformAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"getContractForAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u4e2a\u4eba")
    @ResponseBody
    public OcContractReDomain getContractForAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"getContractForPaasAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u6240\u6709")
    @ResponseBody
    public OcContractReDomain getContractForPaasAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractPageCForAt.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868--\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageCForAt(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractCForAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u7ade\u4ef7")
    @ResponseBody
    public OcContractReDomain getContractCForAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"updateContractForAt.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContractForAt(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveSplitSendgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractDomain occontractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, OcContractDomain.class);
        return this.updateContractCom(request, occontractDomain);
    }

    @RequestMapping(value={"queryContractByUser.json"}, name="\u67e5\u770b\u7528\u6237\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractByUser(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractCForUser.json"}, name="\u67e5\u770b\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractCForUser(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractGoodsByUser.json"}, name="\u67e5\u770b\u7528\u6237\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractForUser(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractForUser.json"}, name="\u67e5\u770b\u7528\u6237\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForUserBySupplierCode.json"}, name="\u67e5\u770b\u7528\u6237\u8ba2\u5355\u901a\u8fc7\u914d\u9001\u5546\u4ee3\u7801")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForUserBySupplierCode(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryContractForUserBySupplierCode.userSession", (Object)"userSession is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        param.put("goodsSupplierCode", userSession.getUserPcode());
        param.put("dataState", "3");
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractGoodsForUser.json"}, name="\u67e5\u770b\u7528\u6237\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractPageBuiMatsBymemForStore.json"}, name="\u95e8\u5e97\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u5f53\u524d\u767b\u5f55\u8005")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMatsBymemForStore(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryAllUserOcConsumeBigDataPage.json"}, name="\u5ba2\u6237\u8ba2\u5355\u6d88\u8d39\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPage(HttpServletRequest request) {
        return this.queryAllUserOcConsumeBigDataPageCom(request);
    }

    @RequestMapping(value={"queryAllOcConsumeBigDataByDay.json"}, name="\u5e73\u53f0\u603b\u9500\u552e\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDay(HttpServletRequest request) {
        return this.queryAllOcConsumeBigDataByDayCom(request);
    }

    @RequestMapping(value={"queryAllOcConsumeBigDataForSellerPage.json"}, name="\u5356\u65b9\u9500\u552e\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPage(HttpServletRequest request) {
        return this.queryAllOcConsumeBigDataForSellerPageCom(request);
    }

    @RequestMapping(value={"getOrderInvUrl.json"}, name="\u83b7\u53d6\u5f00\u7968\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean getOrderInvUrl(HttpServletRequest request) {
        return this.getOrderInvUrlCom(request);
    }

    @RequestMapping(value={"getOrderInvUrlForPlat.json"}, name="\u5e73\u53f0\u83b7\u53d6\u5f00\u7968\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean getOrderInvUrlForPlat(HttpServletRequest request) {
        return this.getOrderInvUrlForPlatCom(request);
    }

    @RequestMapping(value={"queryContractPageByABulk.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u56e2\u8d2d")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByAbulk(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_Abulk);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBySpellGroup.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u62fc\u56e2")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySpellGroup(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SpellGroup);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBySecKill.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u79d2\u6740")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySecKill(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SecKill);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForPm.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u62fc\u56e2")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForPm(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SpellGroup);
            param.put("goodsPmbillno", promotionCode);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractNumPageForGroup.json"}, name="\u67e5\u8be2\u56e2\u957f\u4e1a\u7ee9")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractNumPageForGroup(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForGroup.json"}, name="\u67e5\u8be2\u56e2\u957f\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForGroup(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForService.json"}, name="\u67e5\u8be2\u670d\u52a1")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForService(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsSupplierCode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractDelcode.json"}, name="\u6838\u63d0\u8d27\u7801")
    @ResponseBody
    public HtmlJsonReBean updateContractDelcode(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(CODE + ".updateContractDelcode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map paramStr = this.assemMapBuyParam(request);
        paramStr.put("contractBillcode", contractBillcode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(paramStr);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".updateContractDelcode", (Object)"ocContractReDomainSupQueryResult is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userinfoCode = this.getUserSession(request).getUserPcode();
        if (!(userinfoCode.equals(ocContractReDomain.getMemberBcode()) || userinfoCode.equals(ocContractReDomain.getMemberCode()) || userinfoCode.equals(ocContractReDomain.getMemberGcode()) || userinfoCode.equals(ocContractReDomain.getMemberMcode()) || userinfoCode.equals(ocContractReDomain.getGoodsSupplierCode()))) {
            this.logger.error(CODE + ".updateContractDelcode.error", (Object)"userinfoCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinfoCode");
        }
        return this.updateContractDelcodeCom(request, contractBillcode, contractDelcode);
    }

    @RequestMapping(value={"updateContractUserinfoCode.json"}, name="\u6279\u91cf\u6838\u9500\u63d0\u8d27\u7801")
    @ResponseBody
    public HtmlJsonReBean updateContractUserinfoCode(HttpServletRequest request, String contractBillcodes, String userinfoCode) {
        return this.updateContractUserinfoCodeCom(request, contractBillcodes, userinfoCode);
    }

    @RequestMapping(value={"cancelContractForAt.json"}, name="\u53d6\u6d88\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean cancelContractForAt(Integer contractId, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, -1, oldDataState);
    }

    @RequestMapping(value={"queryContractPageByGroup.json"}, name="\u641c\u7d22\u8ba2\u5355\u5217\u8868-\u56e2\u957f")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByGroup(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("memberCcode", this.getMerchantCode(request));
        return this.ocContractServiceRepository.queryContractPageBySearchParam(param);
    }

    @RequestMapping(value={"queryContractPageByMember.json"}, name="\u641c\u7d22\u8ba2\u5355\u5217\u8868-\u7528\u6237")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByMember(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        return this.ocContractServiceRepository.queryContractPageBySearchParam(param);
    }

    @RequestMapping(value={"queryContractPageByTakeTheir.json"}, name="\u641c\u7d22\u8ba2\u5355\u5217\u8868-\u81ea\u63d0\u70b9")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBy(HttpServletRequest request, String goodsSupplierCode) {
        Map param = this.assemMapParam(request);
        param.put("contractPumode", "1");
        if (StringUtils.isNotBlank((String)goodsSupplierCode)) {
            param.put("goodsSupplierCode", goodsSupplierCode);
        }
        return this.ocContractServiceRepository.queryContractPageBySearchParam(param);
    }

    @RequestMapping(value={"confirmNew.json"}, name="\u786e\u8ba4\u6536\u6b3e(\u51ed\u8bc1)")
    @ResponseBody
    public HtmlJsonReBean confirmNew(HttpServletRequest request, String ocContractSettlDomainStr) {
        if (StringUtils.isBlank((String)ocContractSettlDomainStr)) {
            this.logger.error(CODE + ".confirmNew.ocContractSettlDomainStr");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractSettlDomainStr, OcContractSettlDomain.class);
        return this.sendContractPay(request, OcContractServiceRepository.dataState_1, ocContractSettlDomain);
    }

    @RequestMapping(value={"confirmBatchNew.json"}, name="\u6279\u91cf\u786e\u8ba4\u6536\u6b3e(\u51ed\u8bc1)")
    @ResponseBody
    public HtmlJsonReBean confirmBatchNew(HttpServletRequest request, String ocContractSettlDomainStr) {
        if (StringUtils.isBlank((String)ocContractSettlDomainStr)) {
            this.logger.error(CODE + ".confirmBatchNew.ocContractSettlDomainStr");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        List ocContractSettlDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractSettlDomainStr, OcContractSettlDomain.class);
        if (ListUtil.isNotEmpty((Collection)ocContractSettlDomainList)) {
            HashMap<String, String> param = new HashMap<String, String>();
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
                param.put("tenantCode", ocContractSettlDomain.getTenantCode());
                param.put("contractSettlOpno", ocContractSettlDomain.getContractSettlOpno());
                SupQueryResult ocContractSettlDomainSupQueryResult = this.ocContractServiceRepository.queryContractSettlPage(param);
                if (!ListUtil.isNotEmpty((Collection)ocContractSettlDomainSupQueryResult.getList())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u51ed\u8bc1\u4ee5\u5b58\u5728");
            }
        }
        return this.sendContractPayBatch(request, OcContractServiceRepository.dataState_1, ocContractSettlDomainList);
    }

    @RequestMapping(value={"queryContractForPaasPlatformHy.json"}, name="\u8ba2\u5355\u5bfc\u51fa")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPaasPlatformHy(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "ag");
        }
        return this.queryContractPageComHy(request, null, param);
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageComHy(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        String template = null == param || null == param.get("template") ? "" : (String)param.get("template");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isBlank((String)template) && StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderStrHeadExcelParam());
            }
            if (StringUtils.isNotBlank((String)template) && StringUtils.isNotBlank((String)excelTemplate) && "bp".equals(template)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            }
            if (StringUtils.isNotBlank((String)template) && StringUtils.isNotBlank((String)excelTemplate) && "sc".equals(template)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScHeadExcelParam());
                excelTemplate = "sc";
                fileName = "\u751f\u4ea7\u8ba1\u5212";
            }
            if (StringUtils.isNotBlank((String)template) && StringUtils.isNotBlank((String)excelTemplate) && "xs".equals(template)) {
                infoMap.put("headMap", ExcelExportTemplate.covertXsHeadExcelParam());
                excelTemplate = "xs";
                fileName = "\u9500\u552e\u8ba1\u5212";
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractReDomainModelNewPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageComHy.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractServiceRepository.queryContractNewPageReDomain(param);
    }

    @RequestMapping(value={"sendUpdateTopNum.json"}, name="\u5b9e\u53d1\u6570\u91cf\u56de\u8c03")
    @ResponseBody
    public HtmlJsonReBean sendUpdateTopNum(HttpServletRequest request, String goodsSendNumBeanList) {
        if (StringUtils.isBlank((String)goodsSendNumBeanList)) {
            this.logger.error(CODE + ".updateTopNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsSendNumBeans = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsSendNumBeanList, GoodsSendNumBean.class);
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeans) {
            goodsSendNumBean.setTenantCode(this.getTenantCode(request));
        }
        this.ocContractServiceRepository.sendUpdateTopNum(goodsSendNumBeans);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateContractBatch.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5c5e\u6027")
    @ResponseBody
    public HtmlJsonReBean updateContractBatch(HttpServletRequest request, String mapList) {
        if (StringUtils.isBlank((String)mapList)) {
            this.logger.error(CODE + ".updateTopNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(mapList, Map.class);
        this.ocContractServiceRepository.updateContractBatch(list);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getContractDiscountRatio.json"}, name="\u8ba2\u5355\u4f18\u60e0\u5360\u6bd4\u63a7\u5236")
    @ResponseBody
    public HtmlJsonReBean getContractDiscountRatio(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingCode", "contractDiscountRatio");
        map.put("flagSettingType", "contractDiscountRatio");
        map.put("dataState", "1");
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult qlist = this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            htmlJsonReBean.setDataObj(qlist.getList().get(0));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveQcodeOrder.json"}, name="\u626b\u7801\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveQcodeOrder(HttpServletRequest request, String goodsBeanStr) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".saveQcodeOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(goodsBeanStr, GoodsBean.class);
        if (null == goodsBean) {
            this.logger.error(CODE + ".saveQcodeOrder.goodsBean", (Object)"goodsBean is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveQcodeOrder.userSession", (Object)"userSession is null");
            return null;
        }
        return this.saveOrder(request, goodsBean, userSession, tenantCode);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, GoodsBean goodsBean, UserSession userSession, String tenantCode) {
        if (null == userSession || null == goodsBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingDomain ocShoppingDomain = this.ocContractServiceRepository.makeOcShoppingDomain(userSession, goodsBean, null);
        if (null == ocShoppingDomain || ListUtil.isEmpty((Collection)ocShoppingDomain.getShoppingpackageList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocShoppingDomain");
        }
        OrderDomain orderDomain = new OrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orderDomain, (Object)ocShoppingDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.error(CODE + ".saveOrder", (Object)("orderDomain" + JsonUtil.buildNormalBinder().toJson((Object)orderDomain) + "ocShoppingDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocShoppingDomain)));
        orderDomain.setContractType(ocShoppingDomain.getShoppingType());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingDomain.getShoppingpackageList()) {
            PackageDomain packageDomain = new PackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)packageDomain, (Object)ocShoppingpackgeDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            packageList.add(packageDomain);
            packageDomain.setContractGoodsList((List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocShoppingpackgeDomain.getShoppingGoodsList()), OcContractGoodsDomain.class));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocContractServiceRepository.getOcSetting(orderDomain.getContractType(), tenantCode);
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setChannelCode(this.getNowChannel(request));
        orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        orderDomain.setGoodsReceiptMem(userSession.getMerberCompname());
        orderDomain.setGoodsReceiptPhone(userSession.getUserPhone());
        orderDomain.setContractTypepro("08");
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", orderDomain.getContractType());
        OrgUserBean orgUserBean = this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.createOcOrder(orderDomainList, orderDomain.getContractType(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", orderDomain.getContractInmoney());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getOcContractForRetailer.json"}, name="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f-\u5206\u9500\u5546")
    @ResponseBody
    public OcContractReDomain getOcContractFroRetailer(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".getOcContract", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(contractId);
    }

    @RequestMapping(value={"queryOcContractPageForRetailer.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868-\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractPageForRetailer(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String fileName = null;
        if (null != param) {
            String contractType;
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "retailer");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "retailerDetail");
                fileName = "\u8ba2\u5355\u660e\u7ec6";
            }
            UserSession userSession = this.getUserSession(request);
            param.put("memberMcode", userSession.getUserPcode());
            String string2 = contractType = null == param.get("contractType") ? null : (String)param.get("contractType");
            if (StringUtils.isBlank((String)contractType)) {
                param.put("contractType", "00,06,26,30");
            }
            this.logger.error(CODE + ".queryOcContractPageForRetailer", (Object)("param is" + param));
            return this.queryContractPageCom(request, fileName, param);
        }
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.queryContractPageCom(request, null, param);
        List list = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)"list is===-===null");
            return null;
        }
        for (OcContractReDomain ocContractReDomain : list) {
            String employeeCode = ocContractReDomain.getEmployeeCode();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("employeeCode", employeeCode);
            paramMap.put("tenantCode", (String)param.get("tenantCode"));
            List emploeeList = this.ocContractServiceRepository.queryEmployeePage(paramMap).getList();
            ocContractReDomain.setOrgEmployeeReDomainList(emploeeList);
        }
        return ocContractReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryOcContractPageForRetailerStr.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868-\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractPageForRetailerStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String fileName = null;
        if (null != param) {
            String packetsDetail;
            String packets;
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCcode", this.getMerchantCode(request));
            param.put("excelTemplate", "retailer");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "retailerDetail");
                fileName = "\u8ba2\u5355\u660e\u7ec6";
            }
            String string2 = packets = null == param.get("packets") ? null : (String)param.get("packets");
            if (StringUtils.isNotBlank((String)packets) && "true".equals(packets)) {
                param.put("excelTemplate", "retailerPackets");
                fileName = "\u7ea2\u5305\u8ba2\u5355\u660e\u7ec6";
            }
            String string3 = packetsDetail = null == param.get("packetsDetail") ? null : (String)param.get("packetsDetail");
            if (StringUtils.isNotBlank((String)packetsDetail) && "true".equals(packetsDetail)) {
                param.put("excelTemplate", "retailerPacketsDetail");
                fileName = "\u7ea2\u5305\u8ba2\u5355";
            }
            param.put("contractType", "28");
            this.logger.error(CODE + ".queryOcContractPageForRetailer", (Object)("param is" + param));
            return this.queryContractPageCom(request, fileName, param);
        }
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.queryContractPageCom(request, null, param);
        List list = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)"list is===-===null");
            return null;
        }
        for (OcContractReDomain ocContractReDomain : list) {
            String employeeCode = ocContractReDomain.getEmployeeCode();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("employeeCode", employeeCode);
            paramMap.put("tenantCode", (String)param.get("tenantCode"));
            List emploeeList = this.ocContractServiceRepository.queryEmployeePage(paramMap).getList();
            ocContractReDomain.setOrgEmployeeReDomainList(emploeeList);
        }
        return ocContractReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryOcContractPageForPlat.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractPageForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String fileName = null;
        if (null != param) {
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pg");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "pgDetail");
                fileName = "\u8ba2\u5355\u660e\u7ec6";
            }
        }
        this.logger.error(CODE + ".queryOcContractPageForPlat", (Object)("param is" + param));
        return this.queryContractPageCom(request, fileName, param);
    }

    @RequestMapping(value={"queryOcContractForPlatByNom.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractForPlatByNom(HttpServletRequest request) {
        String contractType;
        Map param = this.assemMapParam(request);
        String fileName = null;
        if (null != param) {
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pg");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "pgDetail");
                fileName = "\u8ba2\u5355\u660e\u7ec6";
            }
        }
        String string = contractType = null == param.get("contractType") ? "" : (String)param.get("contractType");
        if (StringUtils.isBlank((String)contractType)) {
            param.put("contractType", "00,06,16");
        }
        return this.queryContractPageCom(request, fileName, param);
    }

    @RequestMapping(value={"queryOcContractForPlatByPm.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractForPlatByPm(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String fileName = "\u7ea2\u5305\u8ba2\u5355";
        if (null != param) {
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pg");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "pgDetail");
                fileName = "\u7ea2\u5305\u8ba2\u5355\u660e\u7ec6";
            }
        }
        param.put("contractType", "28");
        return this.queryContractPageCom(request, fileName, param);
    }

    @RequestMapping(value={"queryContractPageBuiMat.json"}, name="\u5168\u6e20\u9053\u5efa\u6750\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String fileName = "\u62fc\u56e2\u8ba2\u5355\u5217\u8868";
        if (null != param) {
            String detailed;
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pt");
            String string = detailed = null == param.get("detailed") ? null : (String)param.get("detailed");
            if (StringUtils.isNotBlank((String)detailed) && "true".equals(detailed)) {
                param.put("excelTemplate", "ptD");
                fileName = "\u5e73\u53f0\u8ba2\u5355\u5217\u8868";
            }
        }
        return this.queryContractPageCom(request, fileName, param);
    }

    @RequestMapping(value={"queryContractPageByInvstate.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868\uff08\u8ba2\u5355\u5b8c\u6210\uff0c\u672a\u5f00\u7968\u8ba2\u5355\uff09")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByInvstate(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dataState", 4);
            param.put("contractInvstate", 0);
            param.put("memberCcode", userSession.getUserPcode());
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPageByInvstatePlat.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868\uff08\u8ba2\u5355\u5b8c\u6210\uff0c\u672a\u5f00\u7968\u8ba2\u5355\u5e73\u53f0\uff09")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByInvstatePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dataState", 4);
            param.put("contractInvstate", 0);
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"getContractByContractBillcode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\uff08\u4f9b\u5e94\u5546\u67e5\u770b\u8ba2\u5355\u8be6\u60c5\uff09")
    @ResponseBody
    public OcContractReDomain getContractByContractBillcode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocContractReDomain.getMemberCcode())) {
            return null;
        }
        return ocContractReDomain;
    }

    @RequestMapping(value={"getContractByContractBillcodePlat.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\uff08\u4f9b\u5e94\u5546\u67e5\u770b\u8ba2\u5355\u8be6\u60c5\uff09\u5e73\u53f0")
    @ResponseBody
    public OcContractReDomain getContractByContractBillcodePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcContractReDomain ocContractReDomain = this.getContractByCodeCom(request, param);
        if (null == ocContractReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocContractReDomain.getMemberCode())) {
            return null;
        }
        return ocContractReDomain;
    }

    @RequestMapping(value={"queryClinicRanking.json"}, name="\u7701\u4efd\u8bca\u6240\u6392\u540d")
    @ResponseBody
    public SupQueryResult<OcClinicRankingDomain> queryClinicRanking(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryClinicRankingCom(request, param);
    }

    @RequestMapping(value={"queryCityClinicRanking.json"}, name="\u524d\u5341\u57ce\u5e02\u8bca\u6240\u6392\u540d")
    @ResponseBody
    public SupQueryResult<OcClinicRankingDomain> queryCityClinicRanking(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryCityClinicRankingCom(request, param, userSession);
    }

    @RequestMapping(value={"queryBusinessDimensionData.json"}, name="\u751f\u610f\u7ef4\u5ea6")
    @ResponseBody
    public SupQueryResult<OcBusinessDimensionDomain> queryBusinessDimensionData(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryBusinessDimensionCom(request, param);
    }

    @RequestMapping(value={"queryOcClorstDataStatistics.json"}, name="\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcClorstDataStatisticsDomain> queryOcClorstDataStatistics(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcClorstDataStatistics(request, param);
    }

    @RequestMapping(value={"queryOcClinicStatisticsData.json"}, name="\u8bca\u6240\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcClorstDataStatisticsDomain> queryOcClinicStatisticsData(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcClinicStatisticsData(request, param);
    }

    @RequestMapping(value={"queryOcDentistStatisticsData.json"}, name="\u7259\u533b\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcClorstDataStatisticsDomain> queryOcDentistStatisticsData(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcDentistStatisticsData(request, param);
    }

    @RequestMapping(value={"queryOcCommissionStatisticsDomain.json"}, name="\u8fd4\u4f63\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcCommissionStatisticsDomain> queryOcCommissionStatisticsDomain(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcCommissionStatisticsDomain(request, param);
    }

    @RequestMapping(value={"queryOcClinicReport.json"}, name="\u8bca\u6240\u62a5\u8868")
    @ResponseBody
    public SupQueryResult<OcClinicReportDomain> queryOcClinicReport(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcClinicReport(request, param);
    }

    @RequestMapping(value={"queryOcDistributorEmployeeReport.json"}, name="\u5206\u9500\u5546/\u5458\u5de5\u62a5\u8868")
    @ResponseBody
    public SupQueryResult<OcDistributorEmployeeReportDomain> queryOcDistributorEmployeeReport(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcDistributorEmployeeReport(request, param);
    }

    @RequestMapping(value={"queryOcDentalReport.json"}, name="\u7259\u533b\u62a5\u8868")
    @ResponseBody
    public SupQueryResult<OcDentalReportDomain> queryOcDentalReport(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryOcDentalReport(request, param);
    }

    @RequestMapping(value={"queryDaopsumOrderListPageForm.json"}, name="\u8bca\u6240\u62a5\u8868da_opsum_orderlist")
    @ResponseBody
    public SupQueryResult<DaOpsumOrderlistReDomain> queryDaopsumOrderListPageForm(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryDaopsumOrderListPageCon(request, param);
    }

    @RequestMapping(value={"queryOcContractTotal.json"}, name="\u83b7\u53d6\u8ba2\u5355\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public OcConsumeBigData queryOcContractTotal(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryOcContractTotal(param);
    }

    @RequestMapping(value={"queryContractGoodsSum.json"}, name="\u8ba2\u5355\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryContractGoodsSum(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsSum(param);
    }

    @RequestMapping(value={"addContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addContract(HttpServletRequest request, String orderDomainStr) {
        if (StringUtils.isEmpty((String)orderDomainStr)) {
            this.logger.error(CODE + ".addContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ocContractGoodsDomain = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(orderDomainStr, OcContractGoodsBean.class);
        this.ocContractServiceRepository.saveContGoods(ocContractGoodsDomain, this.getTenantCode(request));
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateOcontractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcontractState(HttpServletRequest request, String orderDomainStr) {
        if (orderDomainStr == null) {
            this.logger.error(CODE + ".updateContractStateBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(orderDomainStr, OcContractDomain.class);
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        if ("2020050600004084".equals(ocContractDomain.getTenantCode())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractBillcode", ocContractDomain.getContractBillcode());
            map.put("tenantCode", ocContractDomain.getTenantCode());
            OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
            this.ocContractEngineServiceRepository.yuShiSendData(ocContractDomain, ocContractReDomain);
        }
        return this.ocContractEngineServiceRepository.sendUpdateContract(ocContractDomain, true);
    }

    @RequestMapping(value={"queryOcTatal.json"}, name="\u6761\u4ef6\u67e5\u8be2\u62a5\u8868\u6570\u636e")
    @ResponseBody
    public SupQueryResult<ContractStatisticsDomain> queryOcTatal(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        paramMap.put("memberMcode", this.getMerchantCode(request));
        SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryOcDataTotal(paramMap);
        List allOcList = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)allOcList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            return null;
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is " + allOcList));
        int storeNum = this.queryStoreNum(request, paramMap);
        ArrayList skuNoSupList = new ArrayList();
        ArrayList<String> skuNoNotSupList = new ArrayList<String>();
        ArrayList<String> singleStoreList = new ArrayList<String>();
        BigDecimal orderMoney = new BigDecimal(0);
        int orderNum = 0;
        BigDecimal discountPrice = new BigDecimal(0);
        BigDecimal contractMoney = new BigDecimal(0);
        BigDecimal GIV = new BigDecimal(0);
        int singleStoreNum = 0;
        int buyBackStore = 0;
        int singleStoreSupNum = 0;
        int singleStoreNotSupNum = 0;
        BigDecimal orderSupMoney = new BigDecimal(0);
        BigDecimal orderNotSupMoney = new BigDecimal(0);
        BigDecimal discountSupPrice = new BigDecimal(0);
        BigDecimal discountNotSupPrice = new BigDecimal(0);
        BigDecimal contractSupMoney = new BigDecimal(0);
        BigDecimal contractNotSupMoney = new BigDecimal(0);
        int buyBackSupStore = 0;
        int buyBackNotSupStore = 0;
        BigDecimal givSup = new BigDecimal(0);
        BigDecimal givNotSup = new BigDecimal(0);
        int orderSupNum = 0;
        int orderNotSupNum = 0;
        ArrayList<String> goodsStoreList = null;
        for (OcContractReDomain ocContractReDomain : allOcList) {
            goodsStoreList = new ArrayList<String>();
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                orderMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                Map<String, Object> orderMap = this.checkSup(orderSupMoney, orderNotSupMoney, "BigDecimal", ocContractGoodsDomain.getMemberBcode(), ocContractGoodsDomain.getContractGoodsInmoney());
                orderSupMoney = (BigDecimal)orderMap.get("supObj");
                orderNotSupMoney = (BigDecimal)orderMap.get("notSupObj");
                BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsMoney());
                discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                Map<String, Object> disMap = this.checkSup(discountSupPrice, discountNotSupPrice, "BigDecimal", ocContractGoodsDomain.getMemberBcode(), discountPrice);
                discountSupPrice = (BigDecimal)disMap.get("supObj");
                discountNotSupPrice = (BigDecimal)disMap.get("notSupObj");
                BigDecimal givAdd = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                GIV.add(givAdd);
                Map<String, Object> givMap = this.checkSup(givSup, givNotSup, "BigDecimal", ocContractGoodsDomain.getMemberBcode(), givAdd);
                givSup = (BigDecimal)givMap.get("supObj");
                givNotSup = (BigDecimal)givMap.get("notSupObj");
                String memberBcode = ocContractGoodsDomain.getMemberBcode();
                if (!singleStoreList.contains(memberBcode)) {
                    singleStoreList.add(memberBcode);
                    ++singleStoreNum;
                    Map<String, Object> anIntMap = this.checkSup(singleStoreSupNum, singleStoreNotSupNum, "int", ocContractGoodsDomain.getMemberBcode(), null);
                    singleStoreSupNum = (Integer)anIntMap.get("supObj");
                    singleStoreNotSupNum = (Integer)anIntMap.get("notSupObj");
                }
                if (singleStoreList.contains(memberBcode) && !goodsStoreList.contains(memberBcode)) {
                    ++buyBackStore;
                    goodsStoreList.add(memberBcode);
                    Map<String, Object> backMap = this.checkSup(buyBackSupStore, buyBackNotSupStore, "int", ocContractGoodsDomain.getMemberBcode(), null);
                    buyBackSupStore = (Integer)backMap.get("supObj");
                    buyBackNotSupStore = (Integer)backMap.get("notSupObj");
                }
                if (!skuNoSupList.contains(ocContractGoodsDomain.getSkuNo()) && ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    skuNoNotSupList.add(ocContractGoodsDomain.getSkuNo());
                }
                if (!skuNoNotSupList.contains(ocContractGoodsDomain.getSkuNo()) && !ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    skuNoNotSupList.add(ocContractGoodsDomain.getSkuNo());
                }
                contractMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                Map<String, Object> contractMoneyMap = this.checkSup(contractSupMoney, contractNotSupMoney, "BigDecimal", ocContractGoodsDomain.getMemberBcode(), ocContractGoodsDomain.getContractGoodsMoney());
                contractSupMoney = (BigDecimal)contractMoneyMap.get("supObj");
                contractNotSupMoney = (BigDecimal)contractMoneyMap.get("notSupObj");
            }
            ++orderNum;
            Map<String, Object> orderMap = this.checkSup(orderSupNum, orderNotSupNum, "int", ((OcContractGoodsDomain)ocContractReDomain.getGoodsList().get(0)).getMemberBcode(), null);
            orderSupNum = (Integer)orderMap.get("supObj");
            orderNotSupNum = (Integer)orderMap.get("notSupObj");
        }
        ContractStatisticsDomain contractStatisticsDomain = new ContractStatisticsDomain();
        contractStatisticsDomain.setBuyBackStore(buyBackStore);
        contractStatisticsDomain.setStoreNum(storeNum);
        contractStatisticsDomain.setSingleStoreNum(singleStoreNum);
        contractStatisticsDomain.setGIV(GIV);
        contractStatisticsDomain.setDiscountPrice(discountPrice);
        contractStatisticsDomain.setContractMoney(contractMoney);
        contractStatisticsDomain.setOrderNum(orderNum);
        contractStatisticsDomain.setOrderSupMoney(orderSupMoney);
        contractStatisticsDomain.setOrderNotSupMoney(orderNotSupMoney);
        contractStatisticsDomain.setContractSupMoney(contractSupMoney);
        contractStatisticsDomain.setContractNotSupMoney(contractNotSupMoney);
        contractStatisticsDomain.setSingleStoreSupNum(singleStoreSupNum);
        contractStatisticsDomain.setAverageNotSupPrice((double)singleStoreNotSupNum);
        contractStatisticsDomain.setBuyBackSupStore(buyBackSupStore);
        contractStatisticsDomain.setBuyBackNotSupStore(buyBackNotSupStore);
        contractStatisticsDomain.setOrderSupMoney(orderSupMoney);
        contractStatisticsDomain.setOrderNotSupMoney(orderNotSupMoney);
        contractStatisticsDomain.setDiscountSupPrice(discountSupPrice);
        contractStatisticsDomain.setDiscountNotSupPrice(discountNotSupPrice);
        contractStatisticsDomain.setContractSupMoney(contractSupMoney);
        contractStatisticsDomain.setContractNotSupMoney(contractNotSupMoney);
        contractStatisticsDomain.setGivNotSup(givNotSup);
        contractStatisticsDomain.setGivSup(givSup);
        if (singleStoreNum != 0 & storeNum != 0) {
            contractStatisticsDomain.setSingleStoreProportion(singleStoreNum / storeNum);
        } else {
            contractStatisticsDomain.setSingleStoreProportion(0);
        }
        if (buyBackStore != 0 & storeNum != 0) {
            contractStatisticsDomain.setBuyBackStoreProportion(buyBackStore / storeNum);
        } else {
            contractStatisticsDomain.setBuyBackStoreProportion(0);
        }
        contractStatisticsDomain.setAveragePrice(contractMoney.divide(new BigDecimal(orderNum), 2).doubleValue());
        contractStatisticsDomain.setAverageNotSupPrice(contractNotSupMoney.divide(new BigDecimal(orderNotSupNum), 2).doubleValue());
        contractStatisticsDomain.setAverageSupPrice(contractSupMoney.divide(orderSupMoney, 2).doubleValue());
        contractStatisticsDomain.setDistributionValid((double)(skuNoSupList.size() + skuNoNotSupList.size()));
        contractStatisticsDomain.setDistributionSupValid((double)skuNoSupList.size());
        contractStatisticsDomain.setDistributionNotSupValid((double)skuNoNotSupList.size());
        contractStatisticsDomain.setContractAllMoney(orderMoney.doubleValue());
        ArrayList<ContractStatisticsDomain> resultList = new ArrayList<ContractStatisticsDomain>();
        resultList.add(contractStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(resultList);
        return supQueryResult;
    }

    public int queryStoreNum(HttpServletRequest request, Map paramMap) {
        HashMap<String, String> storeMap = new HashMap<String, String>();
        storeMap.put("userinfoParentCode", this.getMerchantCode(request));
        storeMap.put("tenantCode", this.getTenantCode(request));
        storeMap.put("gmtCreateQstart", (String)paramMap.get("gmtCreateQstart"));
        storeMap.put("gmtCreateQend", (String)paramMap.get("gmtCreateQend"));
        List storeList = this.ocContractServiceRepository.queryUserinfoPage(storeMap).getList();
        if (ListUtil.isNotEmpty((Collection)storeList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            int storeNum = storeList.size();
            return storeNum;
        }
        return 0;
    }

    public Map<String, Object> checkSup(Object supObj, Object notSupObj, String condition, String memberBcode, Object num) {
        boolean flag = true;
        if (!memberBcode.equals("10000210370767")) {
            flag = false;
        }
        this.logger.error(CODE + ".checkSup", (Object)("supObj is" + supObj + "notSupObj is" + notSupObj + "condition is" + condition + "memberBcode is" + memberBcode + "num is" + num));
        if ("int".equals(condition)) {
            if (flag) {
                int supObj1 = (Integer)supObj;
                supObj = ++supObj1;
            } else {
                int notSupObj1 = (Integer)notSupObj;
                notSupObj = ++notSupObj1;
            }
        }
        if ("BigDecimal".equals(condition)) {
            BigDecimal num1 = (BigDecimal)num;
            if (flag) {
                BigDecimal supObj1 = (BigDecimal)supObj;
                supObj = supObj1.add(num1);
            } else {
                BigDecimal notSupObj1 = (BigDecimal)supObj;
                notSupObj = notSupObj1.add(num1);
            }
        }
        this.logger.error(CODE + ".checkSup.result", (Object)("supObj is" + supObj + "notSupObj is" + notSupObj));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notSupObj", notSupObj);
        map.put("supObj", supObj);
        return map;
    }

    @RequestMapping(value={"queryContractPagesRate.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u66f4\u6539\u56fd\u5185\u6c47\u7387\u91d1\u989d")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContract(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        StringBuilder sb = new StringBuilder();
        if (param.get("departCode") != null) {
            SupQueryResult user = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(this.getQueryMapParam("userinfoQuaVaule1,tenantCode", new Object[]{param.get("departCode"), this.getTenantCode(request)}));
            List umUserinfoQuaReDomains = user.getList();
            for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaReDomains) {
                sb.append(umUserinfoQuaReDomain.getUserinfoCode() + ",");
            }
            param.put("memberBcode", sb);
            this.logger.error(CODE + "user", (Object)JsonUtil.buildNormalBinder().toJson((Object)user));
        }
        this.logger.error("SB" + JsonUtil.buildNonEmptyBinder().toJson((Object)sb));
        param.remove("departCode");
        SupQueryResult<OcContractReDomain> supQueryResult = this.queryContractPageCom(request, null, param);
        if (supQueryResult == null) {
            this.logger.error(CODE + ".queryContractPagesRate", (Object)"ocContractReDomainSupQueryResult\u4e3a\u7a7a");
        }
        List ocContractReDomains = supQueryResult.getList();
        for (OcContractReDomain oc : ocContractReDomains) {
            if (!StringUtils.isNotBlank((String)oc.getPricesetCurrency()) || oc.getContractMoney() == null) continue;
            BigDecimal bigDecimal = new BigDecimal(oc.getPricesetCurrency());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(oc.getContractMoney()));
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            oc.setContractMoney(bigDecimal3);
        }
        return supQueryResult;
    }

    @RequestMapping(value={"queryOcTatalPlatShow.json"}, name="\u6761\u4ef6\u67e5\u8be2\u62a5\u8868\u6570\u636e\u76f4\u64ad-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<ContractStatisticsDomain> queryOcTatalPlatShow(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryOcDataTotal(paramMap);
        List allOcList = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)allOcList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            return null;
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is " + allOcList));
        int storeNum = 0;
        HashMap<String, String> storeMap = new HashMap<String, String>();
        storeMap.put("userinfoParentCode", this.getMerchantCode(request));
        storeMap.put("tenantCode", this.getTenantCode(request));
        storeMap.put("gmtCreateQstart", (String)paramMap.get("gmtCreateQstart"));
        storeMap.put("gmtCreateQend", (String)paramMap.get("gmtCreateQend"));
        List storeList = this.ocContractServiceRepository.queryUserinfoPage(storeMap).getList();
        if (ListUtil.isNotEmpty((Collection)storeList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            storeNum = storeList.size();
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("storeList is" + storeList));
        ArrayList<String> skuNoList = new ArrayList<String>();
        ArrayList<String> skuNoNotSupList = new ArrayList<String>();
        ArrayList<String> skuNoSupList = new ArrayList<String>();
        ArrayList<String> singleStoreList = new ArrayList<String>();
        BigDecimal orderMoney = new BigDecimal(0);
        int orderNum = 0;
        BigDecimal discountPrice = new BigDecimal(0);
        BigDecimal contractMoney = new BigDecimal(0);
        BigDecimal GIV = new BigDecimal(0);
        int singleStoreNum = 0;
        int buyBackStore = 0;
        int singleStoreSupNum = 0;
        int singleStoreNotSupNum = 0;
        int buyBackSupStore = 0;
        int buyBackNotSupStore = 0;
        BigDecimal givSup = new BigDecimal(0);
        BigDecimal givNotSup = new BigDecimal(0);
        BigDecimal orderSupMoney = new BigDecimal(0);
        BigDecimal orderNotSupMoney = new BigDecimal(0);
        BigDecimal discountSupPrice = new BigDecimal(0);
        BigDecimal discountNotSupPrice = new BigDecimal(0);
        BigDecimal contractSupMoney = new BigDecimal(0);
        BigDecimal contractNotSupMoney = new BigDecimal(0);
        int orderSupNum = 0;
        int orderNotSupNum = 0;
        for (OcContractReDomain ocContractReDomain : allOcList) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                orderMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    orderSupMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                } else {
                    orderNotSupMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                }
                BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsMoney());
                discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    discountSupPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                } else {
                    discountNotSupPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                }
                GIV = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    givSup = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                } else {
                    givNotSup = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                }
                String memberBcode = ocContractGoodsDomain.getMemberBcode();
                if (!singleStoreList.contains(memberBcode)) {
                    singleStoreList.add(memberBcode);
                    if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                        ++singleStoreSupNum;
                    } else {
                        ++singleStoreNotSupNum;
                    }
                    ++singleStoreNum;
                }
                if (singleStoreList.contains(memberBcode)) {
                    ++buyBackStore;
                    if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                        ++buyBackSupStore;
                    } else {
                        ++buyBackNotSupStore;
                    }
                }
                if (!skuNoList.contains(ocContractGoodsDomain.getSkuNo())) {
                    skuNoList.add(ocContractGoodsDomain.getSkuNo());
                    if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                        skuNoSupList.add(ocContractGoodsDomain.getSkuNo());
                    } else {
                        skuNoNotSupList.add(ocContractGoodsDomain.getSkuNo());
                    }
                }
                contractMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                if (ocContractGoodsDomain.getMemberCcode() != null & ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                    contractSupMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                contractNotSupMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
            }
            ++orderNum;
            if (ocContractReDomain.getMemberCcode() != null & ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                ++orderSupNum;
                continue;
            }
            ++orderNotSupNum;
        }
        ContractStatisticsDomain contractStatisticsDomain = new ContractStatisticsDomain();
        contractStatisticsDomain.setBuyBackStore(buyBackStore);
        contractStatisticsDomain.setStoreNum(storeNum);
        contractStatisticsDomain.setSingleStoreNum(singleStoreNum);
        contractStatisticsDomain.setGIV(GIV);
        contractStatisticsDomain.setDiscountPrice(discountPrice);
        contractStatisticsDomain.setContractMoney(contractMoney);
        contractStatisticsDomain.setOrderNum(orderNum);
        contractStatisticsDomain.setSingleStoreSupNum(singleStoreSupNum);
        contractStatisticsDomain.setSingleStoreNotSupNum(singleStoreNotSupNum);
        contractStatisticsDomain.setBuyBackSupStore(buyBackSupStore);
        contractStatisticsDomain.setBuyBackNotSupStore(buyBackNotSupStore);
        contractStatisticsDomain.setGivSup(givSup);
        contractStatisticsDomain.setGivNotSup(givNotSup);
        contractStatisticsDomain.setOrderSupMoney(orderSupMoney);
        contractStatisticsDomain.setOrderNotSupMoney(orderNotSupMoney);
        contractStatisticsDomain.setContractSupMoney(contractSupMoney);
        contractStatisticsDomain.setContractNotSupMoney(contractNotSupMoney);
        contractStatisticsDomain.setOrderSupNum(orderSupNum);
        contractStatisticsDomain.setOrderNotSupNum(orderNotSupNum);
        if (orderSupNum != 0) {
            contractStatisticsDomain.setAverageSupPrice(contractSupMoney.divide(new BigDecimal(orderSupNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAverageSupPrice(0.0);
        }
        if (orderNotSupNum != 0) {
            contractStatisticsDomain.setAverageNotSupPrice(contractNotSupMoney.divide(new BigDecimal(orderNotSupNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAverageNotSupPrice(0.0);
        }
        if (singleStoreNum != 0 & storeNum != 0) {
            contractStatisticsDomain.setSingleStoreProportion(singleStoreNum / storeNum);
        } else {
            contractStatisticsDomain.setSingleStoreProportion(0);
        }
        if (buyBackStore != 0 & storeNum != 0) {
            contractStatisticsDomain.setBuyBackStoreProportion(buyBackStore / storeNum);
        } else {
            contractStatisticsDomain.setBuyBackStoreProportion(0);
        }
        if (orderNum != 0) {
            contractStatisticsDomain.setAveragePrice(contractMoney.divide(new BigDecimal(orderNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAveragePrice(0.0);
        }
        contractStatisticsDomain.setDistributionValid((double)skuNoList.size());
        contractStatisticsDomain.setContractAllMoney(orderMoney.doubleValue());
        ArrayList<ContractStatisticsDomain> resultList = new ArrayList<ContractStatisticsDomain>();
        resultList.add(contractStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(resultList);
        return supQueryResult;
    }

    @RequestMapping(value={"queryOcTatalRetailShow.json"}, name="\u6761\u4ef6\u67e5\u8be2\u62a5\u8868\u6570\u636e\u76f4\u64ad-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<ContractStatisticsDomain> queryOcTatalRetailShow(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        paramMap.put("memberMcode", this.getMerchantCode(request));
        SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryOcDataTotal(paramMap);
        List allOcList = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)allOcList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            return null;
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is " + allOcList));
        int storeNum = 0;
        HashMap<String, String> storeMap = new HashMap<String, String>();
        storeMap.put("userinfoParentCode", this.getMerchantCode(request));
        storeMap.put("tenantCode", this.getTenantCode(request));
        storeMap.put("gmtCreateQstart", (String)paramMap.get("gmtCreateQstart"));
        storeMap.put("gmtCreateQend", (String)paramMap.get("gmtCreateQend"));
        List storeList = this.ocContractServiceRepository.queryUserinfoPage(storeMap).getList();
        if (ListUtil.isNotEmpty((Collection)storeList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            storeNum = storeList.size();
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("storeList is" + storeList));
        ArrayList<String> skuNoList = new ArrayList<String>();
        ArrayList<String> skuNoNotSupList = new ArrayList<String>();
        ArrayList<String> skuNoSupList = new ArrayList<String>();
        ArrayList<String> singleStoreList = new ArrayList<String>();
        BigDecimal orderMoney = new BigDecimal(0);
        int orderNum = 0;
        BigDecimal discountPrice = new BigDecimal(0);
        BigDecimal contractMoney = new BigDecimal(0);
        BigDecimal GIV = new BigDecimal(0);
        int singleStoreNum = 0;
        int buyBackStore = 0;
        int singleStoreSupNum = 0;
        int singleStoreNotSupNum = 0;
        int buyBackSupStore = 0;
        int buyBackNotSupStore = 0;
        BigDecimal givSup = new BigDecimal(0);
        BigDecimal givNotSup = new BigDecimal(0);
        BigDecimal orderSupMoney = new BigDecimal(0);
        BigDecimal orderNotSupMoney = new BigDecimal(0);
        BigDecimal discountSupPrice = new BigDecimal(0);
        BigDecimal discountNotSupPrice = new BigDecimal(0);
        BigDecimal contractSupMoney = new BigDecimal(0);
        BigDecimal contractNotSupMoney = new BigDecimal(0);
        int orderSupNum = 0;
        int orderNotSupNum = 0;
        for (OcContractReDomain ocContractReDomain : allOcList) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                orderMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                    orderSupMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                } else {
                    orderNotSupMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                }
                BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsMoney());
                discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                    discountSupPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                } else {
                    discountNotSupPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                }
                GIV = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                    givSup = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                } else {
                    givNotSup = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                }
                String memberBcode = ocContractGoodsDomain.getMemberBcode();
                if (!singleStoreList.contains(memberBcode)) {
                    singleStoreList.add(memberBcode);
                    if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                        ++singleStoreSupNum;
                    } else {
                        ++singleStoreNotSupNum;
                    }
                    ++singleStoreNum;
                }
                if (singleStoreList.contains(memberBcode)) {
                    ++buyBackStore;
                    if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                        ++buyBackSupStore;
                    } else {
                        ++buyBackNotSupStore;
                    }
                }
                if (!skuNoList.contains(ocContractGoodsDomain.getSkuNo())) {
                    skuNoList.add(ocContractGoodsDomain.getSkuNo());
                    if (ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                        skuNoSupList.add(ocContractGoodsDomain.getSkuNo());
                    } else {
                        skuNoNotSupList.add(ocContractGoodsDomain.getSkuNo());
                    }
                }
                contractMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                    contractSupMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                contractNotSupMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
            }
            ++orderNum;
            if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
                ++orderSupNum;
                continue;
            }
            ++orderNotSupNum;
        }
        ContractStatisticsDomain contractStatisticsDomain = new ContractStatisticsDomain();
        contractStatisticsDomain.setBuyBackStore(buyBackStore);
        contractStatisticsDomain.setStoreNum(storeNum);
        contractStatisticsDomain.setSingleStoreNum(singleStoreNum);
        contractStatisticsDomain.setGIV(GIV);
        contractStatisticsDomain.setDiscountPrice(discountPrice);
        contractStatisticsDomain.setContractMoney(contractMoney);
        contractStatisticsDomain.setOrderNum(orderNum);
        contractStatisticsDomain.setSingleStoreSupNum(singleStoreSupNum);
        contractStatisticsDomain.setSingleStoreNotSupNum(singleStoreNotSupNum);
        contractStatisticsDomain.setBuyBackSupStore(buyBackSupStore);
        contractStatisticsDomain.setBuyBackNotSupStore(buyBackNotSupStore);
        contractStatisticsDomain.setGivSup(givSup);
        contractStatisticsDomain.setGivNotSup(givNotSup);
        contractStatisticsDomain.setOrderSupMoney(orderSupMoney);
        contractStatisticsDomain.setOrderNotSupMoney(orderNotSupMoney);
        contractStatisticsDomain.setContractSupMoney(contractSupMoney);
        contractStatisticsDomain.setContractNotSupMoney(contractNotSupMoney);
        contractStatisticsDomain.setOrderSupNum(orderSupNum);
        contractStatisticsDomain.setOrderNotSupNum(orderNotSupNum);
        contractStatisticsDomain.setSingleStoreSupNum(singleStoreSupNum);
        contractStatisticsDomain.setAverageNotSupPrice((double)singleStoreNotSupNum);
        contractStatisticsDomain.setBuyBackSupStore(buyBackSupStore);
        contractStatisticsDomain.setBuyBackNotSupStore(buyBackNotSupStore);
        contractStatisticsDomain.setOrderSupMoney(orderSupMoney);
        contractStatisticsDomain.setOrderNotSupMoney(orderNotSupMoney);
        contractStatisticsDomain.setDiscountSupPrice(discountSupPrice);
        contractStatisticsDomain.setDiscountNotSupPrice(discountNotSupPrice);
        contractStatisticsDomain.setContractSupMoney(contractSupMoney);
        contractStatisticsDomain.setContractNotSupMoney(contractNotSupMoney);
        if (orderSupNum != 0) {
            contractStatisticsDomain.setAverageSupPrice(contractSupMoney.divide(new BigDecimal(orderSupNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAverageSupPrice(0.0);
        }
        if (orderNotSupNum != 0) {
            contractStatisticsDomain.setAverageNotSupPrice(contractNotSupMoney.divide(new BigDecimal(orderNotSupNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAverageNotSupPrice(0.0);
        }
        if (singleStoreNum != 0 & storeNum != 0) {
            contractStatisticsDomain.setSingleStoreProportion(singleStoreNum / storeNum);
        } else {
            contractStatisticsDomain.setSingleStoreProportion(0);
        }
        if (buyBackStore != 0 & storeNum != 0) {
            contractStatisticsDomain.setBuyBackStoreProportion(buyBackStore / storeNum);
        } else {
            contractStatisticsDomain.setBuyBackStoreProportion(0);
        }
        if (orderNum != 0) {
            contractStatisticsDomain.setAveragePrice(contractMoney.divide(new BigDecimal(orderNum), 2).doubleValue());
        } else {
            contractStatisticsDomain.setAveragePrice(0.0);
        }
        contractStatisticsDomain.setDistributionValid((double)skuNoList.size());
        contractStatisticsDomain.setContractAllMoney(orderMoney.doubleValue());
        ArrayList<ContractStatisticsDomain> resultList = new ArrayList<ContractStatisticsDomain>();
        resultList.add(contractStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(resultList);
        return supQueryResult;
    }

    @RequestMapping(value={"queryOcTatalPlat.json"}, name="\u6761\u4ef6\u67e5\u8be2\u62a5\u8868\u6570\u636e-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<ContractStatisticsDomain> queryOcTatalPlat(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryOcDataTotal(paramMap);
        List allOcList = ocContractReDomainSupQueryResult.getList();
        if (ListUtil.isEmpty((Collection)allOcList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            return null;
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is " + allOcList));
        int storeNum = 0;
        HashMap<String, String> storeMap = new HashMap<String, String>();
        storeMap.put("userinfoParentCode", this.getMerchantCode(request));
        storeMap.put("tenantCode", this.getTenantCode(request));
        storeMap.put("gmtCreateQstart", (String)paramMap.get("gmtCreateQstart"));
        storeMap.put("gmtCreateQend", (String)paramMap.get("gmtCreateQend"));
        List storeList = this.ocContractServiceRepository.queryUserinfoPage(storeMap).getList();
        if (ListUtil.isNotEmpty((Collection)storeList)) {
            this.logger.error(CODE + ".queryOcTatal", (Object)("allOcList is null====>paramMap is" + paramMap));
            storeNum = storeList.size();
        }
        this.logger.error(CODE + ".queryOcTatal", (Object)("storeList is" + storeList));
        ArrayList<String> skuNoList = new ArrayList<String>();
        HashMap<String, String> singleStoreMap = new HashMap<String, String>();
        BigDecimal orderMoney = new BigDecimal(0);
        int orderNum = 0;
        BigDecimal discountPrice = new BigDecimal(0);
        BigDecimal contractMoney = new BigDecimal(0);
        BigDecimal GIV = new BigDecimal(0);
        int singleStoreNum = 0;
        int buyBackStore = 0;
        for (OcContractReDomain ocContractReDomain : allOcList) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                orderMoney = orderMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
                BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsMoney());
                discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
                GIV = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getContractGoodsMoney());
                String memberBcode = ocContractGoodsDomain.getMemberBcode();
                if (singleStoreMap.containsKey(memberBcode) && singleStoreMap.get(memberBcode).equals("0")) {
                    ++buyBackStore;
                    singleStoreMap.put(memberBcode, "1");
                }
                if (!singleStoreMap.containsKey(memberBcode)) {
                    singleStoreMap.put(memberBcode, "0");
                    ++singleStoreNum;
                }
                if (!skuNoList.contains(ocContractGoodsDomain.getSkuNo())) {
                    skuNoList.add(ocContractGoodsDomain.getSkuNo());
                }
                contractMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
            }
            ++orderNum;
        }
        ContractStatisticsDomain contractStatisticsDomain = new ContractStatisticsDomain();
        contractStatisticsDomain.setBuyBackStore(buyBackStore);
        contractStatisticsDomain.setStoreNum(storeNum);
        contractStatisticsDomain.setSingleStoreNum(singleStoreNum);
        contractStatisticsDomain.setGIV(GIV);
        contractStatisticsDomain.setDiscountPrice(discountPrice);
        contractStatisticsDomain.setContractMoney(contractMoney.setScale(2, 4));
        contractStatisticsDomain.setOrderNum(orderNum);
        if (singleStoreNum != 0 & storeNum != 0) {
            contractStatisticsDomain.setSingleStoreProportion(singleStoreNum / storeNum);
        } else {
            contractStatisticsDomain.setSingleStoreProportion(0);
        }
        if (buyBackStore != 0 & storeNum != 0) {
            contractStatisticsDomain.setBuyBackStoreProportion(buyBackStore / storeNum);
        } else {
            contractStatisticsDomain.setBuyBackStoreProportion(0);
        }
        BigDecimal divide = contractMoney.divide(new BigDecimal(orderNum), 2);
        contractStatisticsDomain.setAveragePrice(divide.setScale(2, 4).doubleValue());
        contractStatisticsDomain.setDistributionValid((double)skuNoList.size());
        contractStatisticsDomain.setContractAllMoney(orderMoney.setScale(2, 4).doubleValue());
        ArrayList<ContractStatisticsDomain> resultList = new ArrayList<ContractStatisticsDomain>();
        resultList.add(contractStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(resultList);
        return supQueryResult;
    }

    @RequestMapping(value={"saveContractpc.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1\u914d\u7f6e\u6c47\u7387")
    @ResponseBody
    public HtmlJsonReBean saveContractpc(HttpServletRequest request, String orderDomainStr) {
        this.logger.error(CODE + "saveContract.json----------", (Object)(orderDomainStr + "                 \u53c2\u6570"));
        HtmlJsonReBean htmlJsonReBean = this.createOrderpc(request, orderDomainStr, ContractType.CON.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryOcMoneyTotal.json"}, name="\u8ba2\u5355\u6570\u636e\u91d1\u989d\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean queryOcMoneyTotal(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("memberMcode", this.getMerchantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryOcMoneyTotal(param);
    }

    @RequestMapping(value={"queryContractPageCRule.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u6c47\u7387\u6362\u7b97")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageCRule(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE, (Object)("--------------------" + param.toString()));
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.queryContractPageCom(request, null, param);
        List ocRefundReDomains = ocContractReDomainSupQueryResult.getList();
        for (OcContractReDomain oc : ocContractReDomainSupQueryResult.getList()) {
            if (!StringUtils.isNotBlank((String)oc.getPricesetCurrency())) continue;
            BigDecimal bigDecimal = new BigDecimal(oc.getPricesetCurrency());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(oc.getContractMoney()));
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            oc.setContractMoney(bigDecimal3);
        }
        return ocContractReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryOcGoodsMoneyTotal.json"}, name="\u8ba2\u5355\u5546\u54c1\u91d1\u989d\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean queryOcGoodsMoneyTotal(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("memberMcode", this.getMerchantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryOcGoodsMoneyTotal(param);
    }

    @RequestMapping(value={"queryContractGoodsForUserRule.json"}, name="\u67e5\u770b\u7528\u6237\u5546\u54c1\u6c47\u7387")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsForUserRule(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<OcContractGoodsReDomain> ocContractGoodsReDomainSupQueryResult = this.queryContractGoodsPageCom(request, param);
        List crmsURechargeReDomains = ocContractGoodsReDomainSupQueryResult.getList();
        UserSession userSession = this.getUserSession(request);
        for (OcContractGoodsReDomain oc : crmsURechargeReDomains) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{oc.getMemberBcode(), userSession.getTenantCode()}));
            if (null == umUser || !ListUtil.isNotEmpty((Collection)umUser.getList()) || !"1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) continue;
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            this.logger.error(ddFalgSettingReDomain.toString() + "111222");
            oc.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
        }
        return ocContractGoodsReDomainSupQueryResult;
    }

    @RequestMapping(value={"deleteOcContractGoods.json"}, name="\u5220\u9664\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteOcContractGoods(Integer contractGoodsId) {
        if (StringUtils.isBlank((Integer)contractGoodsId)) {
            this.logger.error(CODE + ".deleteOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContractGoods(contractGoodsId);
    }

    @RequestMapping(value={"updateOcontractStateRate.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001-\u8ba1\u7b97\u8fd0\u8d39\u7387")
    @ResponseBody
    public HtmlJsonReBean updateOcontractStateRate(HttpServletRequest request, String orderDomainStr) {
        if (orderDomainStr == null) {
            this.logger.error(CODE + ".updateContractStateBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(orderDomainStr, OcContractDomain.class);
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        OcContractReDomain occontract = this.ocContractServiceRepository.getContract(ocContractDomain.getContractId());
        UserSession userSession = this.getUserSession(request);
        UmUserinfoReDomainBean umUser = this.userServiceRepository.getUserinfoByCode(occontract.getMemberBcode(), userSession.getTenantCode());
        if (umUser != null) {
            String countries = umUser.getDepartName();
            String maoyi = occontract.getContractInvoice();
            if ("\u7f8e\u56fd".equals(countries) && "2".equals(maoyi) && ocContractDomain.getGoodsLogmoney() != null) {
                BigDecimal nprice = new BigDecimal(String.valueOf(ocContractDomain.getGoodsLogmoney()));
                BigDecimal camount = new BigDecimal(0.07);
                BigDecimal price = nprice.multiply(camount);
                BigDecimal Money = nprice.add(price);
                ocContractDomain.setContractMoney(Money.add(occontract.getContractMoney()));
            }
        }
        try {
            if ("2020050600004084".equals(ocContractDomain.getTenantCode())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("contractBillcode", ocContractDomain.getContractBillcode());
                map.put("tenantCode", ocContractDomain.getTenantCode());
                OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                ocContractReDomain.setAreaName(umUser.getDepartName());
                this.ocContractEngineServiceRepository.yuShiSendData(ocContractDomain, ocContractReDomain);
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        return this.ocContractEngineServiceRepository.sendUpdateContract(ocContractDomain, true);
    }

    @RequestMapping(value={"queryOcContractGoodsPages.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryOcContractGoodsPages(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    @RequestMapping(value={"sendEcidedMoney.json"}, name="\u5224\u65ad\u91d1\u989d\u662f\u5426\u591f\u7528")
    @ResponseBody
    public HtmlJsonReBean sendEcidedMoney(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".senDecidedMoney", (Object)"param is null");
            return null;
        }
        OcContractReDomain contract = this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
        return this.ocContractServiceRepository.sendEcidedMoney((OcContractDomain)contract);
    }
}

