/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsNumDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcNvrReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingpackgeDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcNvrServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PromotionForOcReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityQtypeSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ShoppingComCon
extends SpringmvcController {
    private static final String CODE = "oc.shoppingcom.con";
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private OcNvrServiceRepository ocNvrServiceRepository;
    @Autowired
    private UmQualityQtypeSkuServiceRepository umQualityQtypeSkuServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    UmGroupServiceRepository umGroupServiceRepository;

    protected String getContext() {
        return "shoppingcom";
    }

    public RsSkuReDomain getRsByNo(String skuNo, String memberCcode, String channelCode, String tenantCode, String goodsType) {
        SupQueryResult qrs = this.rsSkuServiceRepository.querySkuOnePage(this.getQueryMapParam("skuNo,memberCcode,channelCode,tenantCode,goodsType", new Object[]{skuNo, memberCcode, channelCode, tenantCode, goodsType}));
        if (null == qrs || ListUtil.isEmpty((Collection)qrs.getList())) {
            return null;
        }
        if (StringUtils.isBlank((String)goodsType)) {
            for (RsSkuReDomain rsSkuReDomain : qrs.getList()) {
                if ("24".equals(rsSkuReDomain.getGoodsType()) || "25".equals(rsSkuReDomain.getGoodsType()) || "26".equals(rsSkuReDomain.getGoodsType()) || "27".equals(rsSkuReDomain.getGoodsType()) || "28".equals(rsSkuReDomain.getGoodsType()) || "29".equals(rsSkuReDomain.getGoodsType())) continue;
                return rsSkuReDomain;
            }
        }
        return (RsSkuReDomain)qrs.getList().get(0);
    }

    public RsSkuReDomain getRsByCode(String skuCode, String tenantCode) {
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{skuCode, tenantCode}));
        return rsSkuReDomain;
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        SupQueryResult qemp = this.orgEmployeeServiceRepository.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", new Object[]{userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()}));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public HtmlJsonReBean saveShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error("oc.shoppingcom.con.saveShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveShopping(ocShoppingDomain);
    }

    public OcShoppingReDomain getShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error("oc.shoppingcom.con.getShoppingCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShopping(Integer.valueOf(shoppingId));
    }

    public HtmlJsonReBean updateShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error("oc.shoppingcom.con.updateShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShopping(ocShoppingDomain);
    }

    public HtmlJsonReBean deleteShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error("oc.shoppingcom.con.deleteShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingIdS = shoppingId.split(",");
        if (null == shoppingIdS || shoppingIdS.length <= 0) {
            this.logger.error("oc.shoppingcom.con.deleteShopping1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingServiceRepository.deleteShopping(Integer.valueOf(shoppingIdS[i]));
        }
        return htmlJsonReBean;
    }

    public SupQueryResult<Integer> wishListsCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<Integer> shoppingListCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPageCom(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        return this.queryShopping(request, param, memberBcode);
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPageComNew(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        return this.queryShoppingNew(request, param, memberBcode);
    }

    protected PmCheckBean getPmCheckBean(HttpServletRequest request, UserSession userSession, String contractPmode) {
        if (null == request) {
            return null;
        }
        return this.ocShoppingServiceRepository.getPmCheckBean(this.getPmChannel(request), this.getProappCode(request), this.getTenantCode(request), null == userSession ? null : userSession.getUserPcode(), null == userSession ? null : userSession.getMerberCompname(), null == userSession ? null : userSession.getUserCode(), contractPmode);
    }

    protected PmCheckBean getPmCheckBeanForPrice(String channelCode, HttpServletRequest request, UserSession userSession, String contractPmode) {
        if (null == request) {
            return null;
        }
        return this.ocShoppingServiceRepository.getPmCheckBean(channelCode, this.getProappCode(request), this.getTenantCode(request), null == userSession ? null : userSession.getUserPcode(), null == userSession ? null : userSession.getMerberCompname(), null == userSession ? null : userSession.getUserCode(), contractPmode);
    }

    private SupQueryResult<OcShoppingReDomain> queryShopping(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        SupQueryResult ocShoppingReDomainSupQueryResult;
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.queryShopping.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (ocShoppingReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingPage(param)) || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error("oc.shoppingcom.con.queryShopping.", (Object)("ocShoppingReDomainSupQueryResult is null" + param));
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainSupQueryResult.getRows()) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainList(shoppingpackage, userSession);
            }
        }
        TypeBean typeBean = this.ocShoppingServiceRepository.getOcSetting(((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType(), tenantCode);
        this.logger.error("oc.shoppingcom.con.queryShopping.typeBean", (Object)("typeBean" + JsonUtil.buildNormalBinder().toJson((Object)typeBean) + "shoppingType" + ((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType()));
        List ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getRows();
        if (this.ocShoppingServiceRepository.checkPm(typeBean)) {
            PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, (String)param.get("contractPmode"));
            ocShoppingReDomainList = this.ocShoppingServiceRepository.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        this.makeOcShoppingReDomain(ocShoppingReDomainSupQueryResult.getRows(), userSession);
        return ocShoppingReDomainSupQueryResult;
    }

    private SupQueryResult<OcShoppingReDomain> queryShoppingNew(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.queryShopping.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        long a = System.currentTimeMillis();
        SupQueryResult ocShoppingReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingPage(param);
        this.logger.error("oc.shoppingcom.con.ocShoppingReDomainSupQueryResult.", (Object)(System.currentTimeMillis() - a));
        if (null == ocShoppingReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error("oc.shoppingcom.con.queryShopping.++++++++", (Object)("ocShoppingReDomainSupQueryResult is null" + param));
            return null;
        }
        Map<String, String> goodClass = this.getGoodsClassLast(tenantCode);
        this.logger.error("goodClass is ---->++++++++", goodClass);
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainSupQueryResult.getRows()) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainListNew(shoppingpackage, userSession, goodClass);
            }
        }
        long b = System.currentTimeMillis();
        TypeBean typeBean = this.ocShoppingServiceRepository.getOcSetting(((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType(), tenantCode);
        this.logger.error("oc.shoppingcom.con.typeBean.+++++++", (Object)(System.currentTimeMillis() - b));
        List ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getRows();
        this.logger.error("oc.shoppingcom.con.queryShoppingNew.ocShoppingReDomain1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingReDomainList));
        long c = System.currentTimeMillis();
        if (this.ocShoppingServiceRepository.checkPm(typeBean)) {
            PmCheckBean pmCheckBean = this.getPmCheckBeanForPrice(((OcShoppingReDomain)ocShoppingReDomainList.get(0)).getChannelCode(), request, userSession, (String)param.get("contractPmode"));
            this.logger.error("oc.shoppingcom.con.queryShoppingNew.pmCheckBean2", (Object)JsonUtil.buildNormalBinder().toJson((Object)pmCheckBean));
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                    shoppingpackage.setAreaCode(null);
                    shoppingpackage.setAreaName(null);
                    shoppingpackage.setWarehouseName(null);
                }
            }
            this.logger.error("oc.shoppingcom.con.queryShoppingNew.ocShoppingReDomainList3", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingReDomainList));
            Map check = this.assemMapBuyParam(request);
            if (!check.containsKey("shoppingType")) {
                ocShoppingReDomainList = this.ocShoppingServiceRepository.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            } else if (!check.get("shoppingType").toString().equals("6")) {
                ocShoppingReDomainList = this.ocShoppingServiceRepository.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            }
            this.logger.error("oc.shoppingcom.con.queryShoppingNew.ocShoppingReDomainList4", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingReDomainList));
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                    this.makeShowShoppingDomainListNew(shoppingpackage, userSession, goodClass);
                }
            }
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        this.logger.error("oc.shoppingcom.con.checkPm.+++++++++++++", (Object)(System.currentTimeMillis() - c));
        long d = System.currentTimeMillis();
        this.makeOcShoppingReDomain(ocShoppingReDomainSupQueryResult.getRows(), userSession);
        this.logger.error("oc.shoppingcom.con.makeOcShoppingReDomain.++++++", (Object)(System.currentTimeMillis() - d));
        return ocShoppingReDomainSupQueryResult;
    }

    private Map<String, String> getGoodsClassLast(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<RsClasstreeReDomain> goods = this.getGoodsClass(tenantCode);
        if (ListUtil.isNotEmpty(goods)) {
            for (RsClasstreeReDomain domain : goods) {
                StringBuffer code = new StringBuffer();
                if (ListUtil.isNotEmpty((Collection)domain.getChildList())) {
                    for (RsClasstreeReDomain domain1 : domain.getChildList()) {
                        if (domain1.getClasstreeLast().equals("0")) {
                            code.append(domain1.getClasstreeCode() + ",");
                            continue;
                        }
                        if (!ListUtil.isNotEmpty((Collection)domain1.getChildList())) continue;
                        for (RsClasstreeReDomain domain2 : domain1.getChildList()) {
                            if (domain2.getClasstreeLast().equals("0")) {
                                code.append(domain2.getClasstreeCode() + ",");
                                continue;
                            }
                            if (!ListUtil.isNotEmpty((Collection)domain2.getChildList())) continue;
                            for (RsClasstreeReDomain domain3 : domain2.getChildList()) {
                                if (!domain3.getClasstreeLast().equals("0")) continue;
                                code.append(domain3.getClasstreeCode() + ",");
                            }
                        }
                    }
                }
                map.put(domain.getClasstreeCode(), code.toString());
            }
        }
        return map;
    }

    private List<RsClasstreeReDomain> getGoodsClass(String tenantCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantCode", tenantCode);
        SupQueryResult reDomainSupQueryResult = this.rsClasstreeServiceRepository.queryClasstreePage(params);
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return null;
        }
        this.logger.error("oc.shoppingcom.con\u7239\u89c9\u5f97\u4f60\u662f\u7a7a\u7684++++++++++++++", (Object)reDomainSupQueryResult.getList());
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals("-1")) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        Boolean flag = true;
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            List<RsClasstreeReDomain> childList = this.getChild(rsClasstreeReDomain.getClasstreeCode(), all);
            rsClasstreeReDomain.setChildList(childList);
        }
        return rootClass;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        this.logger.error("oc.shoppingcom.conchildList++++++++++++++", childList);
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private void makeOcShoppingSoReDomain(List<OcShoppingReDomain> ocShoppingReDomainList, String memberCode) {
        if (ListUtil.isNotEmpty(ocShoppingReDomainList)) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                if (!ListUtil.isNotEmpty((Collection)ocShoppingReDomain.getShoppingpackageList())) continue;
                for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingReDomain.getShoppingpackageList()) {
                    if (!ocShoppingpackgeDomain.getPbCode().equals("0022")) continue;
                    List shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
                    for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingGoodsList) {
                        this.ocShoppingServiceRepository.updateShoppingGoodsListCheckState(memberCode, ocShoppingReDomain.getShoppingCode(), ocShoppingGoodsDomain.getShoppingGoodsId().toString(), Integer.valueOf(1));
                        ocShoppingGoodsDomain.setShoppingGoodsCheck(Integer.valueOf(1));
                    }
                }
            }
        }
    }

    private void makeOcShoppingReDomain(List<OcShoppingReDomain> ocShoppingReDomainList, UserSession userSession) {
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShoppingDomainList(shoppingpackage, userSession);
            }
        }
    }

    private void makeShowShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        List objmapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)shoppingpackage.getShoppingGoodsList()), Map.class);
        List list = this.rsResourceGoodsServiceRepository.getShoppGoodMemPriceReBean(objmapList, userSession, shoppingpackage.getChannelCode(), shoppingpackage.getTenantCode());
        if (ListUtil.isEmpty((Collection)list)) {
            return;
        }
        List rsShoppingDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)list), OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)rsShoppingDomainList)) {
            shoppingpackage.setShoppingGoodsList(rsShoppingDomainList);
        }
    }

    private void makeShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        shoppingpackage.setSumMoney(BigDecimal.ZERO);
        shoppingpackage.setSumNum(BigDecimal.ZERO);
        shoppingpackage.setSumWeight(BigDecimal.ZERO);
        shoppingpackage.setSumRefMoney(BigDecimal.ZERO);
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
            if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
                ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
                ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(ocShoppingGoodsDomain.getPricesetAsprice());
            }
            if (null != ocShoppingGoodsDomain.getShoppingGoodsCheck() && 0 != ocShoppingGoodsDomain.getShoppingGoodsCheck()) continue;
            shoppingpackage.setSumMoney(shoppingpackage.getSumMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            shoppingpackage.setSumNum(shoppingpackage.getSumNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            shoppingpackage.setSumWeight(shoppingpackage.getSumWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            shoppingpackage.setSumRefMoney(shoppingpackage.getSumRefMoney().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
        }
    }

    public HtmlJsonReBean updateShoppingGoodsPmInfoCom(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsPmInfo(Integer.valueOf(shoppingGoodsId), promotionCode);
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateCom(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        String[] shoppingGoodsIdS;
        String memberCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsCheckStateCom", (Object)" shoppingGoodsIdStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        for (String shoppingGoodsId : shoppingGoodsIdS = shoppingGoodsIdStr.split("\\,")) {
            OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingServiceRepository.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
            if (null == ocShoppingGoodsReDomain) {
                this.logger.error("oc.shoppingcom.con.updateShoppingGoodsCheckStateCom.shoppingGoodsId", (Object)shoppingGoodsId);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error");
            }
            if (memberCode.equals(ocShoppingGoodsReDomain.getMemberBcode())) continue;
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsCheckStateCom.memberCode", (Object)(shoppingGoodsId + "=" + memberCode + "=" + ocShoppingGoodsReDomain.getMemberBcode()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u6709\u8bef");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateComCrm(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        Map param = this.assemMapParam(request);
        if (null == param.get("memberBcode")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberBcod\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String memberCode = param.get("memberBcode").toString();
        return this.ocShoppingServiceRepository.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    public HtmlJsonReBean updateShoppingGoodsNumCom(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingServiceRepository.getShoppingGoods(shoppingGoodsId);
        if (amount.compareTo(ocShoppingGoodsReDomain.getGoodsCamount()) > 0 && StringUtils.isNotBlank((String)ocShoppingGoodsReDomain.getShoppingGoodsPm())) {
            this.checkPm(ocShoppingGoodsReDomain.getShoppingGoodsPm(), amount, ocShoppingGoodsReDomain.getTenantCode(), ocShoppingGoodsReDomain.getMemberBcode());
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
    }

    private void checkTjShoppingGoods(HttpServletRequest request, OcShoppingReDomain ocShoppingReDomain, Integer shoppingGoodsId) {
        if ("01".equals(ocShoppingReDomain.getShoppingType())) {
            PmCheckBean pmCheckBean = this.getPmCheckBeanForPrice(ocShoppingReDomain.getChannelCode(), request, this.getUserSession(request), "");
            List list = this.ocShoppingServiceRepository.checkPromotionForShoppingList(Arrays.asList(ocShoppingReDomain), pmCheckBean);
            if (ListUtil.isEmpty((Collection)list)) {
                throw new ApiException("\u6570\u636e\u4e0d\u5b58\u5728\uff01");
            }
            for (OcShoppingReDomain shoppingReDomain : list) {
                for (OcShoppingpackgeDomain ocShoppingpackgeDomain : shoppingReDomain.getShoppingpackageList()) {
                    for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingpackgeDomain.getShoppingGoodsList()) {
                        if (shoppingGoodsId != null && !shoppingGoodsId.equals(ocShoppingGoodsDomain.getShoppingGoodsId()) || !ListUtil.isEmpty((Collection)ocShoppingGoodsDomain.getPmPromotionList()) && "0022".equals(((PromotionForOcReDomain)ocShoppingGoodsDomain.getPmPromotionList().get(0)).getPbCode())) continue;
                        throw new ApiException("\u8425\u9500\u9650\u5236\uff0c\u6570\u91cf\u5df2\u8fbe\u6700\u5927\u503c\uff01");
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println();
    }

    public HtmlJsonReBean updateShoppingStateCom(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error("oc.shoppingcom.con.updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }

    public HtmlJsonReBean saveContractByOcShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error("oc.shoppingcom.con.saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveContractByOcShopping(ocShoppingDomain, contractTypepro);
    }

    public HtmlJsonReBean insertShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error("oc.shoppingcom.con.insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.insertShoppingGoods", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberBcode())) {
            ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean addShoppingGoodsBySpecCom(HttpServletRequest request, String goodsCode, String specStr, String memberBcode) {
        List spcList;
        RsSkuReDomain rsSkuReDomain;
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error("oc.shoppingcom.con.addShoppingGoodsBySpecCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (rsSkuReDomain = this.rsSkuServiceRepository.getSkuBySpec(spcList = (List)JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class), goodsCode, tenantCode))) {
            this.logger.error("oc.shoppingcom.con.addShoppingGoodsBySpecCom", (Object)(specStr + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        if (null != userSession && rsSkuReDomain.getMemberCode().equals(userSession.getUserPcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5df1\u5546\u54c1");
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().subtract(new BigDecimal(1)).intValue() < 0) {
            this.logger.error("oc.shoppingcom.con.addShoppingGoodsBySpecCom", (Object)(specStr + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        rsSkuReDomain = this.rsSkuServiceRepository.getSkuMemPriceReBean(rsSkuReDomain, userSession, rsSkuReDomain.getChannelCode(), rsSkuReDomain.getTenantCode());
        return new HtmlJsonReBean((Object)rsSkuReDomain);
    }

    protected HtmlJsonReBean saveShopping(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        RsSkuReDomain skuReDomain;
        if (null == skuId) {
            this.logger.error("oc.shoppingcom.con.saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error("oc.shoppingcom.con.saveShopping.goodsNum", (Object)goodsNum);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u662f\u4e3a\u5c0f\u6570");
        }
        String channelCode = this.getNowChannel(request);
        if (StringUtils.isBlank((String)channelCode)) {
            Map param = this.assemMapParam(request);
            channelCode = param.get("channelCode") + "";
        }
        if (StringUtils.isBlank((String)channelCode) && !EmptyUtil.isEmpty((Object)(skuReDomain = this.rsSkuServiceRepository.getSku(skuId))) && StringUtils.isNotBlank((String)skuReDomain.getChannelCode())) {
            channelCode = skuReDomain.getChannelCode();
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(channelCode);
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    protected HtmlJsonReBean saveShoppings(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        if (null == skuId) {
            this.logger.error("oc.shoppingcom.con.saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private HtmlJsonReBean saveShoppingBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, UserSession userSession, OrgUserBean orgUserBean) {
        if (ListUtil.isEmpty(goodsBeanList) || null == userSession) {
            this.logger.error("oc.shoppingcom.con.saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        try {
            for (GoodsBean goodsBean : goodsBeanList) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingServiceRepository.createShoppingGoodsDomain(userSession, goodsBean, orgUserBean, "shop");
                if (null == ocShoppingGoodsDomain) {
                    this.logger.error("oc.shoppingcom.con.saveShopping", (Object)"ocShoppingGoodsDomain is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff01");
                }
                if (StringUtils.isBlank((Integer)goodsBean.getSkuId())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("skuCode", goodsBean.getSkuCode());
                    RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                    if (null != rsSkuReDomain && 0 != rsSkuReDomain.getSkuId()) {
                        ocShoppingGoodsDomain.setGoodsProperty3(String.valueOf(rsSkuReDomain.getSkuId()));
                    }
                } else {
                    ocShoppingGoodsDomain.setGoodsProperty3(goodsBean.getSkuId().toString());
                }
                if ("6".equals(goodsBean.getShoppingType())) {
                    ocShoppingGoodsDomain.setChannelCode(goodsBean.getGiftCode());
                }
                shoppingGoodsList.add(ocShoppingGoodsDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("oc.shoppingcom.con.saveOrder.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.shoppingcom.con.saveContract.ex", e.getMessage());
        }
        return this.saveShoppingDomain(request, shoppingGoodsList);
    }

    private HtmlJsonReBean saveShoppingDomain(HttpServletRequest request, List<OcShoppingGoodsDomain> shoppingGoodsList) {
        if (ListUtil.isEmpty(shoppingGoodsList)) {
            this.logger.error("oc.shoppingcom.con.saveShoppingDomain", (Object)"shoppingGoodsList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        SupDisUtil.setJson((String)"1", shoppingGoodsList);
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingServiceRepository.insertBatchShoppingGoods(shoppingGoodsList);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean addShoppingGoodsCustCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        String userinfoCode = this.getUserInfo(request).getUserInfoCode();
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userinfoCode = memberBcode;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("userinfoCode", userinfoCode);
        pMap.put("tenantCode", tenantCode);
        List ctCustrelEmpReDomainsList = this.ctCustrelServiceRepository.queryCustrelEmpPage(pMap).getList();
        if (ListUtil.isNotEmpty((Collection)ctCustrelEmpReDomainsList)) {
            UserSession userSession = this.getUserSession(request);
            OrgUserBean orgUserBean = null;
            if (StringUtils.isNotBlank((String)memberBcode)) {
                userSession = this.getUserSession(memberBcode, userSession);
                orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
            }
            return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        this.logger.error(umUserinfoReDomainBean + "--------umUserinfoReDomainBean-----------", (Object)"-----------------------++++++++");
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
            reuserSession.setUserPcode(umUserinfoReDomainBean.getUserinfoCode());
            reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult qmem = this.umGroupServiceRepository.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()}));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public HtmlJsonReBean addShoppingGoodsComBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsComs(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppings(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    private OrgUserBean getOrgUserBean(String memberBcode, String userCode, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
        }
        return orgUserBean;
    }

    private HtmlJsonReBean saveShoppingSkuCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error("oc.shoppingcom.con.saveShoppingSkuCodeCom", (Object)"goodsBeanStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        List skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        UserSession userSession = this.getUserSession(request);
        this.logger.error(userSession + "----------++++-------------", (Object)"---------++++--------------++++++++");
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.saveShoppingSkuCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)((GoodsBean)skuCodeList.get(0)).getShoppingGoodsPm())) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("memberBcode", memberBcode);
            paramMap.put("shoppingGoodsPm", ((GoodsBean)skuCodeList.get(0)).getShoppingGoodsPm());
            paramMap.put("fuzzy", false);
            if (((GoodsBean)skuCodeList.get(0)).getSkuId() != null) {
                paramMap.put("goodsProperty3", ((GoodsBean)skuCodeList.get(0)).getSkuId() + "");
            } else {
                paramMap.put("skuCode", ((GoodsBean)skuCodeList.get(0)).getSkuCode());
            }
            SupQueryResult supQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(paramMap);
            List ocShoppingGoodsReDomains = supQueryResult.getList();
            if (supQueryResult != null && ListUtil.isNotEmpty((Collection)ocShoppingGoodsReDomains) && ocShoppingGoodsReDomains.size() != 0) {
                for (OcShoppingGoodsReDomain ocShoppingGoodsReDomain : ocShoppingGoodsReDomains) {
                    this.checkPm(((GoodsBean)skuCodeList.get(0)).getShoppingGoodsPm(), ((GoodsBean)skuCodeList.get(0)).getGoodsNum().add(ocShoppingGoodsReDomain.getGoodsCamount()), userSession.getTenantCode(), memberBcode);
                }
            } else {
                this.checkPm(((GoodsBean)skuCodeList.get(0)).getShoppingGoodsPm(), ((GoodsBean)skuCodeList.get(0)).getGoodsNum(), userSession.getTenantCode(), memberBcode);
            }
        }
        return this.saveShoppingBean(request, skuCodeList, userSession, orgUserBean);
    }

    private void checkPm(String shoppingGoodsPm, BigDecimal goodsNum, String tenantCode, String memberBcode) {
        Integer promotionFrequency;
        String cacheKey = shoppingGoodsPm + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        if (pmPromotionInDomain.getCouponOnceNums() > 0) {
            Integer num = pmPromotionInDomain.getCouponOnceNumd() + goodsNum.intValue() - 1;
            if (pmPromotionInDomain.getCouponOnceNums() <= num) {
                throw new ApiException("\u8425\u9500\u9650\u5236\uff0c\u65e0\u53ef\u7528\u5e93\u5b58\uff01");
            }
        }
        if (null != (promotionFrequency = pmPromotionInDomain.getPromotionFrequency()) && 0 != promotionFrequency) {
            Integer nums;
            String num = DisUtil.getRemotMap((String)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode()), (String)memberBcode);
            if (StringUtils.isBlank((String)num)) {
                num = "0";
            }
            if ((nums = Integer.valueOf(Integer.valueOf(num) + goodsNum.intValue() - 1)) >= promotionFrequency) {
                throw new ApiException("\u8425\u9500\u9650\u5236\uff0c\u7528\u6237\u53ef\u8d2d\u91cf\u5df2\u8fbe\u6700\u5927\u503c\uff01");
            }
        }
    }

    public HtmlJsonReBean addShoppingGoodsCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        return this.saveShoppingSkuCodeCom(request, goodsBeanStr, memberBcode);
    }

    public OcShoppingGoodsReDomain getShoppingGoodsCom(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error("oc.shoppingcom.con.getShoppingGoodsCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
    }

    public HtmlJsonReBean updateShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean deleteShoppingGoodsCom(HttpServletRequest request, String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error("oc.shoppingcom.con.deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsIdS = shoppingGoodsId.split(",");
        if (null == shoppingGoodsIdS || shoppingGoodsIdS.length <= 0) {
            this.logger.error("oc.shoppingcom.con.deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (String string : shoppingGoodsIdS) {
            idList.add(Integer.valueOf(string));
        }
        htmlJsonReBean = this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(idList);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean deleteShoppingGoodsBatchCom(String shoppingGoodsIdStr, Map<String, Object> map) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error("oc.shoppingcom.con.deleteShoppingGoodsBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        ArrayList<Integer> shoppingGoodsIdListStr = new ArrayList<Integer>();
        for (Integer shoppingGoodsId : shoppingGoodsIdList) {
            map.put("shoppingGoodsId", shoppingGoodsId);
            SupQueryResult ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingGoodsPage(map);
            if (!ListUtil.isNotEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) continue;
            shoppingGoodsIdListStr.add(shoppingGoodsId);
        }
        return this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdListStr);
    }

    public void sendShoppingBigData(List<OcShoppingGoodsDomain> shoppingGoodsList) {
        String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson(shoppingGoodsList) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    public HtmlJsonReBean updateShoppingGoodsNumBatchCom(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsNumBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, GoodsNumDomain.class);
        return this.ocShoppingServiceRepository.updateShoppingGoodsNumBatch(goodsList);
    }

    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
    }

    public HtmlJsonReBean updateShoppingGoodsStateCom(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error("oc.shoppingcom.con.updateShoppingGoodsStateCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsState(Integer.valueOf(shoppingGoodsId), dataState, oldDataState);
    }

    public List<OcShoppingReDomain> queryShoppingToContractCom(HttpServletRequest request, String shoppingGoodsIdStr, String memberBcode, String contractPmode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error("oc.shoppingcom.con.queryShoppingToContractCom", (Object)"param is null");
            return null;
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.queryShoppingToContractCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        long b = System.currentTimeMillis();
        List ocShoppingReDomainList = this.ocShoppingServiceRepository.queryShoppingToContract(shoppingGoodsIdList, this.getOauthEnvCode(request));
        this.logger.error("oc.shoppingcom.con.ocShoppingReDomainList.++++++++++", (Object)(System.currentTimeMillis() - b));
        if (ListUtil.isEmpty((Collection)ocShoppingReDomainList)) {
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            if (ocShoppingReDomain.getMemberBcode().equals(userSession.getUserPcode())) continue;
            this.logger.error("oc.shoppingcom.con.queryShoppingToContractCom.getMemberBcode", (Object)"getMemberBcode is null");
            return null;
        }
        HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainList(shoppingpackage, userSession);
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    tempMap.put(ocShoppingGoodsDomain.getShoppingGoodsId(), ocShoppingGoodsDomain.getGoodsClass());
                }
            }
            this.checkTjShoppingGoods(request, ocShoppingReDomain, null);
        }
        PmCheckBean pmCheckBean = this.getPmCheckBeanForPrice(((OcShoppingReDomain)ocShoppingReDomainList.get(0)).getChannelCode(), request, userSession, null);
        ocShoppingReDomainList = this.ocShoppingServiceRepository.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
        this.makeOcShoppingReDomain(ocShoppingReDomainList, userSession);
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (!StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsClass())) continue;
                    ocShoppingGoodsDomain.setGoodsClass((String)tempMap.get(ocShoppingGoodsDomain.getShoppingGoodsId()));
                }
            }
        }
        return ocShoppingReDomainList;
    }

    public List<OcShoppingReDomain> queryToContractCodeCom(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType, String memberBcode, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeCom", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuCode(skuCode);
        goodsBean.setContractNbillcode(contractNbillcode);
        goodsBean.setPricesetType(pricesetType);
        goodsBean.setShoppingType(shoppingType);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        return this.ocShoppingServiceRepository.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCodeListCom(HttpServletRequest request, String goodsBeanStr, String memberBcode, String contractPmode) throws Exception {
        List skuCodeList;
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeList", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeList.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (ListUtil.isEmpty((Collection)(skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class)))) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return null;
        }
        List ocShoppingDomainList = this.ocShoppingServiceRepository.makeOcShoppingDomainList(userSession, skuCodeList, orgUserBean);
        return this.ocShoppingServiceRepository.queryToContractDomainList(ocShoppingDomainList, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode, String contractPmode) throws Exception {
        String channelCode;
        if (null == skuId) {
            this.logger.error("oc.shoppingcom.con.queryToContract", (Object)"skuId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.shoppingcom.con.makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error("oc.shoppingcom.con.makeOcShoppingDomain.goodsNum", (Object)goodsNum);
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (StringUtils.isBlank((String)(channelCode = this.getNowChannel(request)))) {
            Map param = this.assemMapParam(request);
            channelCode = param.get("channelCode") + "";
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(channelCode);
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingDomain ocShoppingDomain = this.ocShoppingServiceRepository.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        this.logger.error("oc.shoppingcom.con+++++++++++++++ocShoppingDomain+++++++++++", (Object)ocShoppingDomain);
        return this.ocShoppingServiceRepository.queryToContractDomain(ocShoppingDomain, this.getTeananMemberCode(request), this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<RsSkuReDomain> queryToNvrGo(HttpServletRequest request, String goodsSpec, String memberCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("bomCode", goodsSpec);
        SupQueryResult ocNvrReDomainSupQueryResult = this.ocNvrServiceRepository.querynvrPage(map);
        if (null == ocNvrReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocNvrReDomainSupQueryResult.getList())) {
            this.logger.error("oc.shoppingcom.con.queryToNvrGo", (Object)"ocNvrReDomainSupQueryResult is null");
            return null;
        }
        map.remove("bomCode");
        ArrayList<RsResourceGoodsReDomain> list = new ArrayList<RsResourceGoodsReDomain>();
        for (OcNvrReDomain ocNvrReDomain : ocNvrReDomainSupQueryResult.getList()) {
            map.put("goodsSpec", ocNvrReDomain.getBomCode1());
            map.put("memberCode", memberCode);
            map.put("goodsOrigin", "13");
            SupQueryResult goodsReDomainSupQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            if (null == goodsReDomainSupQueryResult || !ListUtil.isNotEmpty((Collection)goodsReDomainSupQueryResult.getList())) continue;
            for (RsResourceGoodsReDomain reDomain : goodsReDomainSupQueryResult.getList()) {
                reDomain.setMschannelCode(ocNvrReDomain.getGoodsNum().toString());
                list.add(reDomain);
            }
        }
        if (ListUtil.isEmpty(list)) {
            this.logger.error("oc.shoppingcom.con.queryToNvrGo", (Object)"list is null");
            return null;
        }
        map.remove("goodsSpec");
        map.remove("memberCode");
        ArrayList<RsSkuReDomain> skuList = new ArrayList<RsSkuReDomain>();
        for (RsResourceGoodsReDomain goodsReDomain : list) {
            map.put("goodsCode", goodsReDomain.getGoodsCode());
            SupQueryResult skuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuPage(map);
            if (null == skuReDomainSupQueryResult || !ListUtil.isNotEmpty((Collection)skuReDomainSupQueryResult.getList())) continue;
            for (RsSkuReDomain sku : skuReDomainSupQueryResult.getList()) {
                sku.setGoodsTopnum(new BigDecimal(goodsReDomain.getMschannelCode()));
                skuList.add(sku);
            }
        }
        return skuList;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(Map<String, Object> param) {
        return this.ocShoppingServiceRepository.queryShoppingPage(param);
    }

    public String checkOcContractGoodsDomainQuality(String goodsBeanStr, HttpServletRequest request, String memberBcode) {
        UmUserinfoReDomainBean userinfo;
        List skuCodeList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        if (ListUtil.isEmpty((Collection)skuCodeList)) {
            this.logger.error("oc.shoppingcom.con.queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return "\u53c2\u6570\u9519\u8bef";
        }
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (userinfo = this.userServiceRepository.getUserinfoByCode(userSession.getUserPcode(), userSession.getTenantCode()))) {
            return "\u4e3a\u83b7\u53d6\u7528\u6237\u4fe1\u606f";
        }
        String qualityQtypeCodes = userinfo.getQualityQtypeCode();
        for (GoodsBean goodsBean : skuCodeList) {
            RsSkuReDomain sku = this.rsSkuServiceRepository.getSku(goodsBean.getSkuId());
            Boolean falg = this.umQualityQtypeSkuServiceRepository.checkOcContractGoodsDomainQuality(sku.getGoodsNo(), qualityQtypeCodes, userSession.getTenantCode());
            if (falg.booleanValue()) continue;
            return "\u60a8\u4e0d\u5177\u5907\u8d2d\u4e70\u8be5\u5546\u54c1\u7684\u8d44\u8d28\uff0c\u8bf7\u8fdb\u884c\u5347\u7ea7";
        }
        return null;
    }

    private void makeShowShoppingDomainListNew(OcShoppingpackgeDomain shoppingpackage, UserSession userSession, Map<String, String> map) {
        List objmapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)shoppingpackage.getShoppingGoodsList()), Map.class);
        List list = this.rsResourceGoodsServiceRepository.getShoppGoodMemPriceReBean(objmapList, userSession, shoppingpackage.getChannelCode(), shoppingpackage.getTenantCode());
        if (ListUtil.isEmpty((Collection)list)) {
            return;
        }
        List rsShoppingDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)list), OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)rsShoppingDomainList)) {
            ArrayList<OcShoppingGoodsDomain> ling = new ArrayList<OcShoppingGoodsDomain>();
            ArrayList<OcShoppingGoodsDomain> hao = new ArrayList<OcShoppingGoodsDomain>();
            ArrayList<OcShoppingGoodsDomain> ji = new ArrayList<OcShoppingGoodsDomain>();
            for (OcShoppingGoodsDomain rsResourceGoodsReDomain : rsShoppingDomainList) {
                if (null == rsResourceGoodsReDomain.getClasstreeCode() || "".equals(rsResourceGoodsReDomain.getClasstreeCode()) || null == map) continue;
                if (map.get("2021032700000010").contains(rsResourceGoodsReDomain.getClasstreeCode())) {
                    rsResourceGoodsReDomain.setGoodsClass("1");
                    ling.add(rsResourceGoodsReDomain);
                    continue;
                }
                if (map.get("2021032700000040").contains(rsResourceGoodsReDomain.getClasstreeCode())) {
                    rsResourceGoodsReDomain.setGoodsClass("2");
                    hao.add(rsResourceGoodsReDomain);
                    continue;
                }
                if (!map.get("2021032700000001").contains(rsResourceGoodsReDomain.getClasstreeCode())) continue;
                rsResourceGoodsReDomain.setGoodsClass("3");
                ji.add(rsResourceGoodsReDomain);
            }
            String lingJson = JsonUtil.buildNormalBinder().toJson(ling);
            String haoJson = JsonUtil.buildNormalBinder().toJson(hao);
            String jiJson = JsonUtil.buildNormalBinder().toJson(ji);
            shoppingpackage.setAreaCode(lingJson);
            shoppingpackage.setAreaName(haoJson);
            shoppingpackage.setWarehouseName(jiJson);
            shoppingpackage.setShoppingGoodsList(rsShoppingDomainList);
        }
    }
}

