/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcCflowPprocessServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractCulePlatReginCon"}, name="\u7ba1\u7406\u5458\u7aef\u5927\u533a\u7ebf\u7d22\u8ba2\u5355")
public class ContractCulePlatReginCon
extends ContractComCon {
    private static final String CODE = "oc.contractCulePlatReginCon.con";
    @Autowired
    private OcCflowPprocessServiceRepository ocCflowPprocessServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"getRulPprocess.json"}, name="\u83b7\u53d6\u5ba1\u6838\u4eba\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getRulPprocess(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        HtmlJsonReBean bean = new HtmlJsonReBean();
        if (EmptyUtil.isEmpty((Object)param) || EmptyUtil.isEmpty(param.get("contractBillcode")) || EmptyUtil.isEmpty(param.get("tenantCode"))) {
            this.logger.error("oc.contractCulePlatReginCon.con.getRulPprocess", (Object)"param is null");
            bean.setMsg("\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
            return bean;
        }
        param.put("cflowNodeCode", "02104050");
        SupQueryResult result = this.ocCflowPprocessServiceRepository.queryCflowPprocessPage(param);
        if (EmptyUtil.isEmpty((Object)result) || ListUtil.isEmpty((Collection)result.getList())) {
            bean.setMsg("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return bean;
        }
        bean.setDataObj(result.getList().get(result.getList().size() - 1));
        return bean;
    }

    @RequestMapping(value={"getRulContractToFince.json"}, name="\u83b7\u53d6\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getRulContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error("oc.contractCulePlatReginCon.con.getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractPageToFince.json"}, name="\u7ebf\u7d22\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE, (Object)("-------------0-------param is" + param));
        this.makeColName(param);
        this.logger.error(CODE, (Object)("--------------1------param is" + param));
        return this.queryContractPageCom(request, null, param);
    }

    public void makeColName(Map<String, Object> param) {
        Object object = param.get("colName0");
        if (null != object && "USERINFO_GROUP".equals(object)) {
            param.put("colName0", "AREA_CODE");
        }
        if (null != (object = param.get("colName1")) && "USERINFO_GROUP".equals(object)) {
            param.put("colName1", "AREA_CODE");
        }
        if (null != (object = param.get("colName2")) && "USERINFO_GROUP".equals(object)) {
            param.put("colName2", "AREA_CODE");
        }
        if (null != (object = param.get("colName3")) && "USERINFO_GROUP".equals(object)) {
            param.put("colName3", "AREA_CODE");
        }
        if (null != (object = param.get("colName4")) && "USERINFO_GROUP".equals(object)) {
            param.put("colName4", "AREA_CODE");
        }
        if (null != (object = param.get("colName5")) && "USERINFO_GROUP".equals(object)) {
            param.put("colName5", "AREA_CODE");
        }
    }

    @RequestMapping(value={"updateRulContractToSuccess.json"}, name="\u5ba1\u6838\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean updateRulContractToSuccess(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error("oc.contractCulePlatReginCon.con.sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("dataStatestr", "8");
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"updateCuleContractToFail.json"}, name="\u5ba1\u6838\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateCuleContractToFail(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error("oc.contractCulePlatReginCon.con.updateCuleContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("dataStatestr", "9");
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney, String contractSubPmode, String memo) {
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error("oc.contractCulePlatReginCon.con.addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error("oc.contractCulePlatReginCon.con.addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("oc.contractCulePlatReginCon.con.addContractSub.ocContractReDomain", (Object)("userSession: " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error("oc.contractCulePlatReginCon.con.addContractSub.ocContractReDomain", (Object)("userPcode: " + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        OcContractSubDomain ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain);
        if (null == ocContractSubDomain) {
            this.logger.error("oc.contractCulePlatReginCon.con.addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setContractSubPmode(contractSubPmode);
        ocContractSubDomain.setMemo(memo);
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return ocContractSubDomain;
    }
}

