/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils.fubon;

import com.qjsoft.laser.controller.order.utils.fubon.SM2Result;
import com.qjsoft.laser.controller.order.utils.fubon.SM3Digest;
import com.qjsoft.laser.controller.order.utils.fubon.Util;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public final ECCurve ecc_curve;
    public final ECPoint ecc_point_g;
    public final ECDomainParameters ecc_bc_spec;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    public final ECFieldElement ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gx);
    public final ECFieldElement ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gy);

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement, false);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = Util.byteConvert32Bytes(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_gx);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_gy);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(userKey.getXCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(userKey.getYCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            String kS = "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F";
            k = new BigInteger(kS, 16);
            kp = this.ecc_point_g.multiply(k);
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Result.r = r;
        sm2Result.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s, SM2Result sm2Result) {
        sm2Result.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(sm2Result.s);
        x1y1 = x1y1.add(userKey.multiply(t));
        sm2Result.R = e.add(x1y1.getXCoord().toBigInteger()).mod(this.ecc_n);
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }
}

