/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class ThirdInterfaceUtils {
    private static final Logger log = LoggerFactory.getLogger(ThirdInterfaceUtils.class);
    public static String appkey = "dhuos61WGL";
    private static String appSecret = "FDO2pUkCTZ";
    private static String openApiHost = "http://dms-gateway-test-midend-b.jetour.com.cn";

    public static void main(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("endRow", "10");
        params.put("orderNo", "ZYOR202111020031");
        params.put("page", "1");
        params.put("startRow", "0");
        params.put("dataState", null);
        params.put("tenantCode", "2020121500000001");
        params.put("rows", "10");
        try {
            JSONObject result = ThirdInterfaceUtils.sendBPart(params, "/dms-api/order-center/thirdSync/detail", "2020121500000001");
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public static JSONObject sendBPart(Map<String, String> params, String requestPath, String tenantCode) {
        log.info("ThirdInterfaceUtils.sendBPart params:{},requestPath:{},tenantCode:{}", new Object[]{params, requestPath, tenantCode});
        openApiHost = openApiHost + requestPath;
        SortedMap<String, String> sortedMap = ThirdInterfaceUtils.sortMap("qStoreClue", params);
        String signString = ThirdInterfaceUtils.createSignString(sortedMap);
        String sign = ThirdInterfaceUtils.createSign(signString);
        String requestUrl = ThirdInterfaceUtils.createRequestUrl(signString, sign);
        log.info("signString:" + signString + ",sign:" + sign + ",requestUrl:" + requestUrl);
        RestTemplate restTemplate = new RestTemplate();
        String result = (String)restTemplate.postForObject(requestUrl, params, String.class, new Object[0]);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return JSON.parseObject((String)result);
    }

    private static SortedMap<String, String> sortMap(String apiName, Map<String, String> params) {
        TreeMap sortMap = Maps.newTreeMap();
        Date now = new Date();
        String timestamp = now.getTime() + "";
        sortMap.put("timestamp", timestamp);
        sortMap.put("appKey", appkey);
        sortMap.put("apiName", apiName);
        if (params == null || params.isEmpty()) {
            return sortMap;
        }
        for (String key : params.keySet()) {
            sortMap.put(key, params.get(key));
        }
        return sortMap;
    }

    private static String createSignString(Map<String, String> sortMap) {
        log.info("ThirdInterfaceUtils.createSignString sortMap:{}", sortMap);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortMap.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String v;
            String k = keys.get(i) == null ? "" : ((String)keys.get(i)).toString();
            String string = v = sortMap.get(k) == null ? "" : sortMap.get(k).toString();
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v)) continue;
            sb.append(k + "=" + v + "&");
        }
        String signString = sb.toString();
        if (signString.endsWith("&") && signString.length() >= 2) {
            signString = signString.substring(0, signString.length() - 1);
        }
        return signString;
    }

    private static String createSign(String signString) {
        String signStringBase64 = ThirdInterfaceUtils.base64(signString);
        String appSign = appSecret + ":" + signStringBase64;
        return ThirdInterfaceUtils.sha1(appSign);
    }

    private static String base64(String s) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        s = new String(Base64.encodeBase64((byte[])s.getBytes()));
        return s;
    }

    private static String sha1(String str) {
        MessageDigest md = null;
        String tmpStr = "";
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(str.getBytes());
            tmpStr = ThirdInterfaceUtils.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return tmpStr;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + ThirdInterfaceUtils.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    private static String createRequestUrl(String signString, String sign) {
        return openApiHost + "?" + signString + "&appSign=" + sign;
    }

    private static String getDdFlag(String tenantCode, String ddFlagCode, String ddFlagType) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ddFlagCode) || StringUtils.isBlank((String)ddFlagType)) {
            log.error("order.QueryFinancialProductsUtils.getDdFlag: params is null!!! tenantCode:{},ddFlagCode:{},ddFlagType:{}", new Object[]{tenantCode, ddFlagCode, ddFlagType});
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tenantCode).append("-").append(ddFlagType).append("-").append(ddFlagCode);
        String ddFlagKey = stringBuilder.toString();
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagKey is ********** {}", (Object)ddFlagKey);
        String ddFlagValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ddFlagKey);
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagValue is ********** {}", (Object)ddFlagValue);
        return ddFlagValue;
    }

    private static void initConstant(String tenantCode, String requestPath) {
        log.info("ThirdInterfaceUtils.initConstant tenantCode:{}", (Object)tenantCode);
        String ddFlagType = "B_END";
        String appKeyFlagValue = ThirdInterfaceUtils.getDdFlag(tenantCode, "APPKEY", ddFlagType);
        String appSecretFlagValue = ThirdInterfaceUtils.getDdFlag(tenantCode, "APPSECRET", ddFlagType);
        String openApiHostFlagValue = ThirdInterfaceUtils.getDdFlag(tenantCode, "DOMAIN", ddFlagType);
        appkey = appKeyFlagValue;
        appSecret = appSecretFlagValue;
        openApiHost = openApiHostFlagValue + requestPath;
        log.info("ThirdInterfaceUtils.initConstant appkey:{},appSecret:{},openApiHost:{}", new Object[]{appkey, appSecret, openApiHost});
    }
}

