/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils;

import com.alibaba.fastjson.JSONObject;
import com.fadada.sdk.base.client.FddBaseClient;
import com.fadada.sdk.base.model.req.RegisterAccountParams;
import com.fadada.sdk.utils.crypt.FddEncryptTool;
import com.fadada.sdk.verify.client.FddVerifyClient;
import com.fadada.sdk.verify.model.req.PersonVerifyUrlParams;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.order.domain.FadadaBean;
import com.qjsoft.laser.controller.order.domain.MemberGnameConntractBean;
import com.qjsoft.laser.controller.order.utils.CommonUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import sun.misc.BASE64Encoder;

public class FddInterUtils {
    private static final Logger log = LoggerFactory.getLogger(FddInterUtils.class);
    private static final String CODE = "FddInterUtils.";
    public static FddBaseClient fddBaseClient = new FddBaseClient(FddInterUtils.getAppId(), FddInterUtils.getAppKey(), FddInterUtils.getVersion(), FddInterUtils.getApiHost());

    public FddBaseClient init() {
        String appId = FddInterUtils.getAppId();
        String appKey = FddInterUtils.getAppKey();
        String v = FddInterUtils.getVersion();
        String appHost = FddInterUtils.getApiHost();
        FddBaseClient fddBaseClient = new FddBaseClient(appId, appKey, v, appHost);
        return fddBaseClient;
    }

    public static String registerAccount(String openId) {
        RegisterAccountParams accountParams = new RegisterAccountParams();
        accountParams.setAccountType("1");
        accountParams.setOpenId(openId);
        String fddResult = fddBaseClient.invokeRegisterAccount(accountParams);
        return fddResult;
    }

    public static String personalVerify(String customerId, String phoneNo, String userName, String certIdentNo, String orderNo) {
        FddVerifyClient verifyClient = new FddVerifyClient(FddInterUtils.getAppId(), FddInterUtils.getAppKey(), FddInterUtils.getVersion(), FddInterUtils.getApiHost());
        PersonVerifyUrlParams params = new PersonVerifyUrlParams();
        params.setCustomerId(customerId);
        params.setVerifiedWay("4");
        params.setPageModify("2");
        String notifyUrl = null;
        try {
            notifyUrl = FddInterUtils.getFddNotifyDomain() + "web/oc/fdd/plat/personVerifyNotifyFdd.json";
            log.info("FddInterUtils.personalVerify notifyUrl:{}", (Object)notifyUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u62fc\u63a5\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u56de\u8c03\u5730\u5740\u5f02\u5e38!");
            return null;
        }
        params.setNotifyUrl(notifyUrl);
        params.setCustomerName(userName);
        params.setCustomerIdentType("0");
        params.setCustomerIdentNo(certIdentNo);
        params.setMobile(phoneNo);
        params.setReturnUrl(FddInterUtils.getPersonReturnUrl() + orderNo);
        params.setCertFlag("1");
        String result = verifyClient.invokePersonVerifyUrl(params);
        return result;
    }

    public static boolean personalNotifySignCheck(HttpServletRequest request) {
        StringBuffer signParams = new StringBuffer();
        signParams.append(FddInterUtils.getAppKey()).append("1").append(request.getParameter("certStatus")).append(request.getParameter("customerId")).append(request.getParameter("serialNo")).append(request.getParameter("status")).append(request.getParameter("statusDesc"));
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            String localSign = encoder.encode(FddEncryptTool.sha1((String)(FddInterUtils.getAppId() + FddEncryptTool.md5Digest((String)request.getParameter("timestamp")) + FddEncryptTool.sha1((String)signParams.toString()))).getBytes());
            if (!localSign.equals(request.getParameter("sign"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean manualSignCheck(HttpServletRequest request) {
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            String localSign = encoder.encode(FddEncryptTool.sha1((String)(FddInterUtils.getAppId() + FddEncryptTool.md5Digest((String)request.getParameter("timestamp")) + FddEncryptTool.sha1((String)(FddInterUtils.getAppKey() + request.getParameter("transaction_id"))))).getBytes());
            if (!localSign.equals(request.getParameter("msg_digest"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean updateFddContract(Map<String, Object> param, FadadaBean bean, OcContractServiceRepository repository) {
        log.info("\u53c2\u6570param: " + param);
        param.put("contractBillcode", bean.getContractBillcode());
        OcContractReDomain contract = repository.getContractByCode(param);
        if (null == contract) {
            return false;
        }
        String memberGname = contract.getMemberGname();
        try {
            JSONObject memberGnameJson;
            if (StringUtils.isBlank((String)memberGname)) {
                memberGnameJson = new JSONObject();
            } else {
                memberGnameJson = JSONObject.parseObject((String)memberGname);
                if (null == memberGnameJson) {
                    memberGnameJson = new JSONObject();
                }
            }
            log.info("\u53c2\u6570bean: " + bean);
            MemberGnameConntractBean memberGnameConntractBean = MemberGnameConntractBean.fadadaBeanToContractBean(bean);
            log.info("memberGnameConntractBean: " + JSONObject.toJSONString((Object)memberGnameConntractBean));
            memberGnameJson.put("contract", (Object)JSONObject.toJSONString((Object)memberGnameConntractBean));
            contract.setMemberGname(memberGnameJson.toJSONString());
            if (StringUtils.isNotBlank((String)bean.getExtSignAutoViewUrl())) {
                contract.setContractEcurl(bean.getExtSignAutoViewUrl());
            } else {
                contract.setContractEcurl(bean.getExtSignViewUrl());
            }
            if (StringUtils.isNotBlank((String)bean.getVerifyStatus())) {
                contract.setCortState(bean.getVerifyStatus());
            }
            if (bean.getContractState() != null) {
                contract.setContractState(bean.getContractState());
            }
            if (StringUtils.isNotBlank((String)bean.getDataStatestr())) {
                contract.setDataStatestr(bean.getDataStatestr());
            }
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("contractBillcode", contract.getContractBillcode());
            updateMap.put("tenantCode", contract.getTenantCode());
            updateMap.put("memberGname", contract.getMemberGname());
            if (StringUtils.isNotBlank((String)bean.getExtSignAutoViewUrl())) {
                updateMap.put("contractEcurl", bean.getExtSignAutoViewUrl());
            }
            if (StringUtils.isNotBlank((String)bean.getDataStatestr())) {
                updateMap.put("dataStatestr", bean.getDataStatestr());
            }
            if (null != bean.getContractState()) {
                updateMap.put("contractState", contract.getContractState());
            }
            log.info("FddInterUtils.updateFddContract updateMap:{}", updateMap);
            repository.updateContractSimple(updateMap);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6cd5\u5927\u5927\u5408\u540c\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c{}", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getContractCompanySetting() {
        List valueJsonArray;
        String value = CommonUtils.getDdFlag("2020121500000001", "company", "contract");
        log.info("FddInterUtils.getContractCompanySetting value:" + value);
        List list = valueJsonArray = StringUtils.isNotBlank((String)value) ? JSONObject.parseArray((String)value, JSONObject.class) : null;
        if (!CollectionUtils.isEmpty((Collection)valueJsonArray)) {
            for (JSONObject json : valueJsonArray) {
                if (!json.containsKey((Object)"pagenum")) continue;
                Integer index = Integer.parseInt(json.getString("pagenum")) - 1;
                json.put("pagenum", (Object)index);
            }
        }
        return JSONObject.toJSONString((Object)valueJsonArray);
    }

    public static String getContractCustomerSetting() {
        List valueJsonArray;
        String value = CommonUtils.getDdFlag("2020121500000001", "customer", "contract");
        log.info("FddInterUtils.getContractCustomerSetting value:" + value);
        List list = valueJsonArray = StringUtils.isNotBlank((String)value) ? JSONObject.parseArray((String)value, JSONObject.class) : null;
        if (!CollectionUtils.isEmpty((Collection)valueJsonArray)) {
            for (JSONObject json : valueJsonArray) {
                if (!json.containsKey((Object)"pagenum")) continue;
                Integer index = Integer.parseInt(json.getString("pagenum")) - 1;
                json.put("pagenum", (Object)index);
            }
        }
        return JSONObject.toJSONString((Object)valueJsonArray);
    }

    public static String getContractTitle() {
        String value = CommonUtils.getDdFlag("2020121500000001", "title", "contract");
        log.info("FddInterUtils.getContractTitle value:" + value);
        return value;
    }

    public static String getContractTemplate() {
        String value = CommonUtils.getDdFlag("2020121500000001", "template", "contract");
        log.info("FddInterUtils.getContractTemplate value:" + value);
        return value;
    }

    public static String getContractFontSize() {
        String value = CommonUtils.getDdFlag("2020121500000001", "fontSize", "contract");
        log.info("FddInterUtils.getContractFontSize value:" + value);
        return value;
    }

    public static String getContractFontType() {
        String value = CommonUtils.getDdFlag("2020121500000001", "fontType", "contract");
        log.info("FddInterUtils.getContractFontType value:" + value);
        return value;
    }

    public static String getFddNotifyDomain() {
        String value = CommonUtils.getDdFlag("2020121500000001", "notifyDomain", "fdd");
        log.info("FddInterUtils.getFddNotifyDomain value:" + value);
        return value;
    }

    public static String getEnterpriseCustomerId() {
        String value = CommonUtils.getDdFlag("2020121500000001", "enterpriseCustomerId", "contract");
        log.info("FddInterUtils.getEnterpriseCustomerId value:" + value);
        return value;
    }

    public static String getAppId() {
        String value = CommonUtils.getDdFlag("2020121500000001", "appId", "fdd");
        log.info("FddInterUtils.getAppId value:" + value);
        return value;
    }

    public static String getAppKey() {
        String value = CommonUtils.getDdFlag("2020121500000001", "appKey", "fdd");
        log.info("FddInterUtils.getAppKey value:" + value);
        return value;
    }

    public static String getVersion() {
        String value = CommonUtils.getDdFlag("2020121500000001", "version", "fdd");
        log.info("FddInterUtils.getVersion value:" + value);
        return value;
    }

    public static String getApiHost() {
        String value = CommonUtils.getDdFlag("2020121500000001", "apiHost", "fdd");
        log.info("FddInterUtils.getApiHost value:" + value);
        return value;
    }

    public static final String getPersonReturnUrl() {
        String value = CommonUtils.getDdFlag("2020121500000001", "personVerifyReturnUrl", "fdd");
        log.info("FddInterUtils.getPersonReturnUrl value:" + value);
        return value;
    }

    public static final String getManualSigningReturnUrl() {
        String value = CommonUtils.getDdFlag("2020121500000001", "manualSigningReturnUrl", "fdd");
        log.info("FddInterUtils.getManualSigningReturnUrl value:" + value);
        return value;
    }
}

