/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.org.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgCompanyDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgCompanyReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/company"}, name="\u673a\u6784\u670d\u52a1")
public class orgCompanyCon
extends SpringmvcController {
    private static String CODE = "org.company.con";
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgGroupServiceRepository orgGroupServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;

    protected String getContext() {
        return "company";
    }

    @RequestMapping(value={"saveCompany.json"}, name="\u589e\u52a0\u673a\u6784\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveCompany(HttpServletRequest request, OrgCompanyDomain orgCompanyDomain) {
        if (null == orgCompanyDomain) {
            this.logger.error(CODE + ".saveCompany", (Object)"orgCompanyDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserinfoCompname(orgCompanyDomain.getCompanyName());
        umUserDomainBean.setUserinfoQuality("buy");
        umUserDomainBean.setCompanyAddress(orgCompanyDomain.getCompanyAddress());
        umUserDomainBean.setUserinfoEmail(orgCompanyDomain.getCompanyEmail());
        umUserDomainBean.setUserinfoTel(orgCompanyDomain.getCompanyTel());
        umUserDomainBean.setUserinfoCon(orgCompanyDomain.getCompanyContacts());
        umUserDomainBean.setUserinfoConPhone(orgCompanyDomain.getCompanyContactsPhone());
        umUserDomainBean.setUserinfoCertUrl(orgCompanyDomain.getCompanyLicense());
        umUserDomainBean.setUserPhone(orgCompanyDomain.getUserPhone());
        umUserDomainBean.setUserPwsswd(orgCompanyDomain.getUserPwsswd());
        umUserDomainBean.setUserRelname(orgCompanyDomain.getUserRelname());
        umUserDomainBean.setUserinfoType(Integer.valueOf(0));
        umUserDomainBean.setTenantCode(tenantCode);
        HtmlJsonReBean userinfo = this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
        String userinfoCode = userinfo.getDataObj().toString();
        if (StringUtils.isBlank((String)userinfoCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6dfb\u52a0\u516c\u53f8\u5931\u8d25");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyName", orgCompanyDomain.getCompanyName());
        map.put("tenantCode", tenantCode);
        List orgCompanyList = this.orgCompanyServiceRepository.queryCompanyPage(map).getList();
        if (null != orgCompanyList) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u53f8\u5df2\u5b58\u5728");
        }
        orgCompanyDomain.setCompanyCode(userinfoCode);
        orgCompanyDomain.setUserinfoCode(userinfoCode);
        orgCompanyDomain.setTenantCode(tenantCode);
        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
        orgEmployeeDomain.setEmployeeName(orgCompanyDomain.getUserRelname());
        orgEmployeeDomain.setEmployeePhone(orgCompanyDomain.getUserPhone());
        orgEmployeeDomain.setUserinfoCode(userinfoCode);
        HashMap usermap = new HashMap();
        map.put("userPcode", userinfoCode);
        map.put("tenantCode", tenantCode);
        List userList = this.userServiceRepository.queryUserPage(usermap).getList();
        if (null == userList || userList.size() <= 0) {
            this.logger.error(CODE + ".saveCompany", (Object)"userList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)userList.get(0);
        orgEmployeeDomain.setUserCode(umUserReDomainBean.getUserCode());
        ArrayList<OrgEmployeeDomain> orgEmployeeDomainList = new ArrayList<OrgEmployeeDomain>();
        orgEmployeeDomainList.add(orgEmployeeDomain);
        orgCompanyDomain.setOrgEmployeeDomainList(orgEmployeeDomainList);
        return this.orgCompanyServiceRepository.saveCompany(orgCompanyDomain);
    }

    @RequestMapping(value={"getCompany.json"}, name="\u83b7\u53d6\u673a\u6784\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgCompanyReDomain getCompany(Integer companyId) {
        if (StringUtils.isBlank((Integer)companyId)) {
            this.logger.error(CODE + ".getCompany", (Object)"param is null");
            return null;
        }
        return this.orgCompanyServiceRepository.getCompany(companyId);
    }

    @RequestMapping(value={"updateCompany.json"}, name="\u66f4\u65b0\u673a\u6784\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateCompany(HttpServletRequest request, OrgCompanyDomain orgCompanyDomain) {
        if (null == orgCompanyDomain) {
            this.logger.error(CODE + ".updateCompany", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgCompanyDomain.setTenantCode(this.getTenantCode(request));
        return this.orgCompanyServiceRepository.updateCompany(orgCompanyDomain);
    }

    @RequestMapping(value={"deleteCompany.json"}, name="\u5220\u9664\u673a\u6784\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteCompany(Integer companyId) {
        if (StringUtils.isBlank((Integer)companyId)) {
            this.logger.error(CODE + ".deleteCompany", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgCompanyServiceRepository.deleteCompany(companyId);
    }

    @RequestMapping(value={"queryCompanyPage.json"}, name="\u67e5\u8be2\u673a\u6784\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgCompanyReDomain> queryCompanyPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgCompanyServiceRepository.queryCompanyPage(param);
    }

    @RequestMapping(value={"getCompanyByCompanyCode.json"}, name="\u6839\u636ecode\u83b7\u53d6\u673a\u6784\u53ca\u6240\u5c5e\u90e8\u95e8\u548c\u7ec4\u7ec7\u4fe1\u606f")
    @ResponseBody
    public OrgCompanyReDomain getCompanyByCode(HttpServletRequest request, String companyCode) {
        List groupList;
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".getCompanyByCode", (Object)"companyCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        OrgCompanyReDomain orgCompany = this.orgCompanyServiceRepository.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            this.logger.error(CODE + ".getCompanyByCompanyCode", (Object)"orgCompany is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyCode", orgCompany.getCompanyCode());
        map.put("tenantCode", tenantCode);
        List departList = this.orgDepartServiceRepository.queryDepartPage(map).getList();
        if (null != departList) {
            orgCompany.setDepartList(departList);
        }
        if (null != (groupList = this.orgGroupServiceRepository.queryGroupPage(map).getList())) {
            orgCompany.setGroupList(groupList);
        }
        return orgCompany;
    }

    @RequestMapping(value={"getEmployeeByCompanyCode.json"}, name="\u6839\u636ecode\u83b7\u53d6\u516c\u53f8\u4e0b\u6240\u6709\u5458\u5de5")
    @ResponseBody
    public OrgCompanyReDomain getEmployeeByCompanyCode(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".getEmployeeByCompanyCode", (Object)"companyCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        OrgCompanyReDomain orgCompany = this.orgCompanyServiceRepository.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            this.logger.error(CODE + ".getEmployeeByCompanyCode", (Object)"orgCompany is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyCode", orgCompany.getCompanyCode());
        map.put("tenantCode", tenantCode);
        List employeeList = this.orgEmployeeServiceRepository.queryEmployeePage(map).getList();
        if (null != employeeList) {
            orgCompany.setEmployeeList(employeeList);
        }
        return orgCompany;
    }

    @RequestMapping(value={"updateCompanyState.json"}, name="\u66f4\u65b0\u673a\u6784\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCompanyState(String companyId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)companyId)) {
            this.logger.error(CODE + ".updateCompanyState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgCompanyServiceRepository.updateCompanyState(Integer.valueOf(companyId), dataState, oldDataState);
    }
}

