/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.org.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartempDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartempReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupempDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupempReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/employee"}, name="\u5458\u5de5\u670d\u52a1")
public class orgEmployeeCon
extends SpringmvcController {
    private static String CODE = "org.employee.con";
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgGroupServiceRepository orgGroupServiceRepository;

    protected String getContext() {
        return "employee";
    }

    @RequestMapping(value={"saveEmployee.json"}, name="\u589e\u52a0\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveEmployee(HttpServletRequest request, OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error(CODE + ".saveEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgEmployeeDomain.setTenantCode(this.getTenantCode(request));
        return this.orgEmployeeServiceRepository.saveEmployee(orgEmployeeDomain);
    }

    @RequestMapping(value={"getEmployee.json"}, name="\u83b7\u53d6\u5458\u5de5\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgEmployeeReDomain getEmployee(Integer employeeId) {
        if (StringUtils.isBlank((Integer)employeeId)) {
            this.logger.error(CODE + ".getEmployee", (Object)"param is null");
            return null;
        }
        return this.orgEmployeeServiceRepository.getEmployee(employeeId);
    }

    @RequestMapping(value={"updateEmployee.json"}, name="\u66f4\u65b0\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateEmployee(HttpServletRequest request, OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error(CODE + ".updateEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgEmployeeDomain.setTenantCode(this.getTenantCode(request));
        return this.orgEmployeeServiceRepository.updateEmployee(orgEmployeeDomain);
    }

    @RequestMapping(value={"deleteEmployee.json"}, name="\u5220\u9664\u5458\u5de5\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteEmployee(Integer employeeId) {
        if (StringUtils.isBlank((Integer)employeeId)) {
            this.logger.error(CODE + ".deleteEmployee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgEmployeeServiceRepository.deleteEmployee(employeeId);
    }

    @RequestMapping(value={"queryEmployeePage.json"}, name="\u67e5\u8be2\u5458\u5de5\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgEmployeeReDomain> queryEmployeePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgEmployeeServiceRepository.queryEmployeePage(param);
    }

    @RequestMapping(value={"getEmployeePageByCode.json"}, name="\u67e5\u8be2Code\u5458\u5de5\u8be6\u60c5")
    @ResponseBody
    public OrgEmployeeReDomain getEmployeePageByCode(HttpServletRequest request, String employeeCode) {
        List groupempList;
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".getEmployeePageByCode", (Object)"employeeCode is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        OrgEmployeeReDomain employeeReDomain = this.orgEmployeeServiceRepository.getEmployeeByCode(tenantCode, employeeCode);
        if (null == employeeReDomain) {
            this.logger.error(CODE + ".getEmployeePageByCode", (Object)"param is null");
            return null;
        }
        UmUserReDomainBean umUserReDomainBean = this.userServiceRepository.getUserByCode(employeeReDomain.getUserCode());
        if (null != umUserReDomainBean) {
            employeeReDomain.setUmUserReDomainBean(umUserReDomainBean);
        }
        HashMap<String, String> employeemap = new HashMap<String, String>();
        employeemap.put("employeeCode", employeeReDomain.getEmployeeCode());
        employeemap.put("tenantCode", tenantCode);
        List departempList = this.orgDepartServiceRepository.queryDepartempPage(employeemap).getList();
        if (null != departempList) {
            HashMap<String, String> departmap = new HashMap<String, String>();
            for (OrgDepartempReDomain OrgDepartempReDomain2 : departempList) {
                departmap.put("departCode", OrgDepartempReDomain2.getDepartCode());
                departmap.put("tenantCode", tenantCode);
                List departList = this.orgDepartServiceRepository.queryDepartPage(departmap).getList();
                if (null == departList) continue;
                employeeReDomain.setDepartList(departList);
            }
        }
        if (null != (groupempList = this.orgGroupServiceRepository.queryGroupempPage(employeemap).getList())) {
            HashMap<String, String> groupmap = new HashMap<String, String>();
            for (OrgGroupempReDomain orgGroupempReDomain : groupempList) {
                groupmap.put("groupCode", orgGroupempReDomain.getGroupCode());
                groupmap.put("tenantCode", tenantCode);
                List groupList = this.orgGroupServiceRepository.queryGroupPage(groupmap).getList();
                if (null == groupList) continue;
                employeeReDomain.setGroupList(groupList);
            }
        }
        return employeeReDomain;
    }

    @RequestMapping(value={"updateEmployeeState.json"}, name="\u66f4\u65b0\u5458\u5de5\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEmployeeState(String employeeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)employeeId)) {
            this.logger.error(CODE + ".updateEmployeeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgEmployeeServiceRepository.updateEmployeeState(Integer.valueOf(employeeId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateDepartempByCode.json"}, name="\u66f4\u65b0\u5458\u5de5\u90e8\u95e8")
    @ResponseBody
    public HtmlJsonReBean updateEmployeeByDepartempCode(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateEmployeeByDepartempCode", (Object)"paramStr is null");
            return null;
        }
        List orgDepartempDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgDepartempDomain.class);
        if (null == orgDepartempDomainList) {
            this.logger.error(CODE + ".updateEmployeeByDepartempCode", (Object)"orgDepartempDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        for (OrgDepartempDomain orgDepartempDomain : orgDepartempDomainList) {
            this.orgDepartServiceRepository.deleteDepartempByCode(tenantCode, orgDepartempDomain.getDepartempCode());
        }
        return this.orgDepartServiceRepository.saveDepartempBatch(orgDepartempDomainList);
    }

    @RequestMapping(value={"updateGroupempByCode.json"}, name="\u66f4\u65b0\u5458\u5de5\u7fa4\u7ec4")
    @ResponseBody
    public HtmlJsonReBean updateGroupempByCode(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateGroupempByCode", (Object)"paramStr is null");
            return null;
        }
        List orgGroupempDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgGroupempDomain.class);
        if (null == orgGroupempDomainList) {
            this.logger.error(CODE + ".updateGroupempByCode", (Object)"orgGroupempDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        for (OrgGroupempDomain orgGroupempDomain : orgGroupempDomainList) {
            this.orgGroupServiceRepository.deleteGroupempByCode(tenantCode, orgGroupempDomain.getGroupempCode());
        }
        return this.orgGroupServiceRepository.saveGroupempBatch(orgGroupempDomainList);
    }
}

