/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionCalcListDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotion"}, name="\u8425\u9500\u670d\u52a1")
public class PromotionCon
extends SpringmvcController {
    private static String CODE = "pm.promotion.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;

    protected String getContext() {
        return "promotion";
    }

    @RequestMapping(value={"savePromotion.json"}, name="\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotion(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    @RequestMapping(value={"getPromotion.json"}, name="\u83b7\u53d6\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotion(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        return this.pmPromotionServiceRepository.getPromotion(promotionId);
    }

    @RequestMapping(value={"updatePromotion.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotion(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    @RequestMapping(value={"deletePromotion.json"}, name="\u5220\u9664\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotion(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryPromotionPage.json"}, name="\u67e5\u8be2\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"updatePromotionState.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionState(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryPromotionListByGoodsCode.json"}, name="\u83b7\u53d6\u8425\u9500\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionListByGoodsCode(HttpServletRequest request, String goodsCode, String userCode, Integer terminalType) {
        if (StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".queryPromotionListByGoodsCode", (Object)"param is null");
        }
        return this.pmPromotionServiceRepository.checkPromotionListByGoodsCode(this.getTenantCode(request), goodsCode, userCode, this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"calcPromotionByOrder.json"}, name="\u4e0b\u8ba2\u5355\u65f6\u8ba1\u7b97\u8425\u9500\u6570\u503c")
    @ResponseBody
    public HtmlJsonReBean calcPromotionByOrder(HttpServletRequest request, String paramStr, String contractBillCode) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".calcPromotionByOrder", (Object)"param is null");
        }
        PmPromotionCalcListDomain pmPromotionCalcDomain = (PmPromotionCalcListDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionCalcListDomain.class);
        return this.pmPromotionServiceRepository.calcPromotionByOrder(pmPromotionCalcDomain.getPromotionCalcList(), contractBillCode, this.getTenantCode(request), this.getUserSession(request).getUserCode(), this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"promotionByFinishOrder.json"}, name="\u8ba2\u5355\u5b8c\u6210\u540e\u7684\u8425\u9500")
    @ResponseBody
    public HtmlJsonReBean promotionByFinishOrder(HttpServletRequest request, String contractBillCode, String userCode) {
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".promotionByFinishOrder", (Object)"param is null");
        }
        return this.pmPromotionServiceRepository.promotionByFinishOrder(contractBillCode, this.getTenantCode(request), userCode);
    }

    @RequestMapping(value={"getPromotionGoods.json"}, name="\u83b7\u53d6\u53c2\u4e0e\u8425\u9500\u7684\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean getPromotionGoods(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.pmPromotionServiceRepository.getPromotionGoods(param);
    }
}

