/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInTemplateDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.SkuBean;
import com.qjsoft.laser.controller.facade.pm.domain.UserBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionInServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmUserCouponlistServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotionIn"}, name="\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1")
public class PromotionInCon
extends SpringmvcController {
    private static String CODE = "pm.promotionIn.con";
    @Autowired
    private PmPromotionInServiceRepository pmPromotionInServiceRepository;
    @Autowired
    private PmUserCouponlistServiceRepository pmUserCouponlistServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;

    protected String getContext() {
        return "promotionIn";
    }

    @RequestMapping(value={"savePromotionIn.json"}, name="\u589e\u52a0\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionIn(HttpServletRequest request, PmPromotionInDomain pmPromotionInDomain) {
        if (null == pmPromotionInDomain) {
            this.logger.error(CODE + ".savePromotionIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pmPromotionInDomain.setTenantCode(this.getTenantCode(request));
        return this.pmPromotionInServiceRepository.savePromotionIn(pmPromotionInDomain);
    }

    @RequestMapping(value={"getPromotionIn.json"}, name="\u83b7\u53d6\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionInReDomain getPromotionIn(Integer promotionInId) {
        if (StringUtils.isBlank((Integer)promotionInId)) {
            this.logger.error(CODE + ".getPromotionIn", (Object)"param is null");
            return null;
        }
        return this.pmPromotionInServiceRepository.getPromotionIn(promotionInId);
    }

    @RequestMapping(value={"updatePromotionIn.json"}, name="\u66f4\u65b0\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionIn(HttpServletRequest request, PmPromotionInDomain pmPromotionInDomain) {
        if (null == pmPromotionInDomain) {
            this.logger.error(CODE + ".updatePromotionIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pmPromotionInDomain.setTenantCode(this.getTenantCode(request));
        return this.pmPromotionInServiceRepository.updatePromotionIn(pmPromotionInDomain);
    }

    @RequestMapping(value={"deletePromotionIn.json"}, name="\u5220\u9664\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionIn(Integer promotionInId) {
        if (StringUtils.isBlank((Integer)promotionInId)) {
            this.logger.error(CODE + ".deletePromotionIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionInServiceRepository.deletePromotionIn(promotionInId);
    }

    @RequestMapping(value={"queryPromotionInPage.json"}, name="\u67e5\u8be2\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionInReDomain> queryPromotionInPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("activationMode", 1);
        param.put("channelCode", this.getNowChannel(request));
        return this.pmPromotionInServiceRepository.queryPromotionInPage(param);
    }

    @RequestMapping(value={"updatePromotionInState.json"}, name="\u66f4\u65b0\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionInState(String promotionInId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionInId)) {
            this.logger.error(CODE + ".updatePromotionInState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionInServiceRepository.updatePromotionInState(Integer.valueOf(promotionInId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOrderCourtesyByDataState.json"}, name="\u67e5\u8be2\u5728\u751f\u6548\u7684\u4e0b\u5355\u6709\u793c")
    @ResponseBody
    public SupQueryResult<PmPromotionInReDomain> queryOrderCourtesyByDataState(HttpServletRequest request) {
        Map resultMap = this.assemMapParam(request);
        ArrayList pmPromotionReDomainList = new ArrayList();
        resultMap.put("dataState", 1);
        resultMap.put("pbCode", "0017");
        return this.pmPromotionInServiceRepository.queryPromotionInPage(resultMap);
    }

    @RequestMapping(value={"queryEditorPromotionInPage.json"}, name="\u67e5\u8be2\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1\u5206\u9875\u5217\u8868(\u7f16\u8f91\u5668)")
    @ResponseBody
    public SupQueryResult<PmPromotionInTemplateDomain> queryEditorPromotionInPage(HttpServletRequest request) {
        SupQueryResult pmPromotionInTemplateDomainSupQueryResult;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != (pmPromotionInTemplateDomainSupQueryResult = this.pmPromotionInServiceRepository.queryPromotionInTemplatePage(param)) && ListUtil.isNotEmpty((Collection)pmPromotionInTemplateDomainSupQueryResult.getList())) {
            for (PmPromotionInTemplateDomain pmPromotionInTemplateDomain : pmPromotionInTemplateDomainSupQueryResult.getList()) {
                pmPromotionInTemplateDomain.setTitle(pmPromotionInTemplateDomain.getPromotionName());
            }
        }
        return pmPromotionInTemplateDomainSupQueryResult;
    }

    @RequestMapping(value={"queryEditorPromotionPage.json"}, name="\u67e5\u8be2\u8425\u9500\u4f18\u60e0\u5238\u6279\u6b21\u670d\u52a1\u5206\u9875\u5217\u8868(\u7f16\u8f91\u5668)")
    @ResponseBody
    public Map<String, Object> queryEditorPromotionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        HashMap<String, Object> returnSup = new HashMap<String, Object>();
        String flagStr = null == param.get("more") ? "" : (String)param.get("more");
        boolean flag = Boolean.valueOf(flagStr);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!flag) {
            SupQueryResult pmPromotionInTemplateDomainSupQueryResult = this.pmPromotionInServiceRepository.queryPromotionInTemplatePage(param);
            if (null != pmPromotionInTemplateDomainSupQueryResult && ListUtil.isNotEmpty((Collection)pmPromotionInTemplateDomainSupQueryResult.getList())) {
                for (PmPromotionInTemplateDomain pmPromotionInTemplateDomain : pmPromotionInTemplateDomainSupQueryResult.getList()) {
                    pmPromotionInTemplateDomain.setTitle(pmPromotionInTemplateDomain.getPromotionName());
                    PmPromotionReDomain promotionByCode = this.pmPromotionServiceRepository.getPromotionByCode(this.getTenantCode(request), pmPromotionInTemplateDomain.getPromotionCode());
                    pmPromotionInTemplateDomain.setDiscAmount(((PmPromotionDiscountDomain)promotionByCode.getPmPromotionDiscountList().get(0)).getDiscAmount());
                }
            }
            returnSup.put("total", pmPromotionInTemplateDomainSupQueryResult.getTotal());
            returnSup.put("pageTools", pmPromotionInTemplateDomainSupQueryResult.getPageTools());
            returnSup.put("list", pmPromotionInTemplateDomainSupQueryResult.getList());
            return returnSup;
        }
        SupQueryResult pmPromotionInReDomainSupQueryResult = this.pmPromotionInServiceRepository.queryPromotionInPage(param);
        returnSup.put("total", pmPromotionInReDomainSupQueryResult.getTotal());
        returnSup.put("pageTools", pmPromotionInReDomainSupQueryResult.getPageTools());
        if (null == pmPromotionInReDomainSupQueryResult || ListUtil.isEmpty((Collection)pmPromotionInReDomainSupQueryResult.getList())) {
            returnSup.put("list", pmPromotionInReDomainSupQueryResult.getList());
            return returnSup;
        }
        String promotionInType = ((PmPromotionInReDomain)pmPromotionInReDomainSupQueryResult.getList().get(0)).getPromotionInType();
        SkuBean skuBean = new SkuBean();
        skuBean.setTenantCode(this.getTenantCode(request));
        List<PmPromotionInDomain> pmPromotionInDomains = this.queryCouponListBySkuCode(request, skuBean, promotionInType);
        if (ListUtil.isEmpty(pmPromotionInDomains)) {
            this.logger.error(CODE + ".queryEditorPromotionPage.pmPromotionInDomains.null", (Object)promotionInType);
            returnSup.put("list", pmPromotionInDomains);
            return returnSup;
        }
        ArrayList<PmPromotionInDomain> newPmPromotionInDomains = new ArrayList<PmPromotionInDomain>();
        for (PmPromotionInReDomain pmPromotionInReDomain : pmPromotionInReDomainSupQueryResult.getList()) {
            for (PmPromotionInDomain pmPromotionInDomain : pmPromotionInDomains) {
                if (!pmPromotionInReDomain.getPromotionCode().equals(pmPromotionInDomain.getPromotionCode())) continue;
                newPmPromotionInDomains.add(pmPromotionInDomain);
            }
        }
        returnSup.put("list", newPmPromotionInDomains);
        return returnSup;
    }

    public List<PmPromotionInDomain> queryCouponListBySkuCode(HttpServletRequest request, SkuBean skuBean, String promotionInType) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        List oldPmPromotionInDomains = "0".equals(promotionInType) ? this.pmPromotionServiceRepository.queryPromotionPmBySku(skuBean) : this.pmPromotionServiceRepository.queryPromotionConBySku(skuBean);
        if ("0".equals(promotionInType)) {
            return oldPmPromotionInDomains;
        }
        ArrayList<PmPromotionInDomain> pmPromotionInDomains = new ArrayList<PmPromotionInDomain>();
        if (ListUtil.isNotEmpty((Collection)oldPmPromotionInDomains)) {
            for (PmPromotionInDomain pmPromotionInDomain : oldPmPromotionInDomains) {
                if (1 != pmPromotionInDomain.getActivationMode()) continue;
                pmPromotionInDomains.add(pmPromotionInDomain);
            }
        }
        return pmPromotionInDomains;
    }

    private SkuBean makeSkuBean(HttpServletRequest request, SkuBean skuBean) {
        if (null == skuBean) {
            this.logger.error(CODE + ".queryPromotionListByGoodsCode.param", (Object)"param is null");
            return null;
        }
        skuBean.setTenantCode(this.getTenantCode(request));
        skuBean.setMemberCcode(this.getMemberCcode(request));
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setChannelCode(this.getNowChannel(request));
        pmCheckBean.setProappCode(this.getProappCode(request));
        pmCheckBean.setTenantCode(skuBean.getTenantCode());
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            UserBean userBean = new UserBean();
            userBean.setMemberCode(userSession.getUserPcode());
            userBean.setMemberName(userSession.getMerberCompname());
            userBean.setProappCode(userSession.getProappCode());
            userBean.setTenantCode(userSession.getTenantCode());
            userBean.setUserCode(userSession.getUserCode());
            userBean.setUserName(userSession.getUserName());
            Map userMap = new HashMap();
            String jsonUserSession = JsonUtil.buildNonDefaultBinder().toJson((Object)userSession);
            userMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonUserSession, String.class, Object.class);
            userBean.setUserMap(userMap);
            pmCheckBean.setUserBean(userBean);
        }
        skuBean.setPmCheckBean(pmCheckBean);
        return skuBean;
    }
}

