/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionFileDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionReDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionSettlDomain;
import com.qjsoft.laser.controller.facade.prb.repository.PrbAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.prb.repository.PrbAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.prb.repository.PrbAuctionSettlServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/prb/Auction"}, name="\u91c7\u8d2d\u9700\u6c42")
public class PrbAuctionCon
extends SpringmvcController {
    private static String CODE = "prb.Auction.con";
    @Autowired
    private PrbAuctionServiceRepository prbAuctionServiceRepository;
    @Autowired
    private PrbAuctionSettlServiceRepository prbAuctionSettlServiceRepository;
    @Autowired
    private PrbAuctionEnrollServiceRepository prbAuctionEnrollServiceRepository;

    protected String getContext() {
        return "Auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, String prbAuctionDomainStr) {
        if (null == prbAuctionDomainStr) {
            this.logger.error(CODE + ".saveAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PrbAuctionDomain prbAuctionDomain = (PrbAuctionDomain)JsonUtil.buildNormalBinder().getJsonToObject(prbAuctionDomainStr, PrbAuctionDomain.class);
        prbAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.prbAuctionServiceRepository.saveAuction(prbAuctionDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u91c7\u8d2d\u9700\u6c42\u4fe1\u606f")
    @ResponseBody
    public PrbAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        return this.prbAuctionServiceRepository.getAuction(auctionId);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, PrbAuctionDomain prbAuctionDomain) {
        if (null == prbAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        prbAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.prbAuctionServiceRepository.updateAuction(prbAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.prbAuctionServiceRepository.deleteAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PrbAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.prbAuctionServiceRepository.queryAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u91c7\u8d2d\u9700\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.prbAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveAuctionFile.json"}, name="\u589e\u52a0\u91c7\u8d2d\u9700\u6c42\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionFile(HttpServletRequest request, String PrbAuctionFileDomainStr) {
        if (StringUtils.isBlank((String)PrbAuctionFileDomainStr)) {
            this.logger.error(CODE + ".saveAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List prbAuctionFileDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(PrbAuctionFileDomainStr, PrbAuctionDomain.class);
        if (ListUtil.isNotEmpty((Collection)prbAuctionFileDomainList)) {
            for (PrbAuctionFileDomain prbAuctionFileDomain : prbAuctionFileDomainList) {
                prbAuctionFileDomain.setTenantCode(tenantCode);
            }
        } else {
            this.logger.error(CODE + ".saveAuction", (Object)PrbAuctionFileDomainStr);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.prbAuctionServiceRepository.saveAuctionFileBatch(prbAuctionFileDomainList);
    }

    @RequestMapping(value={"saveAuctionSettl.json"}, name="")
    @ResponseBody
    public HtmlJsonReBean saveAuctionSettl(HttpServletRequest request, String PrbAuctionSettlDomainStr) {
        if (StringUtils.isBlank((String)PrbAuctionSettlDomainStr)) {
            this.logger.error(CODE + ".saveAuctionSettl", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List prbAuctionSettlDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(PrbAuctionSettlDomainStr, PrbAuctionDomain.class);
        if (ListUtil.isNotEmpty((Collection)prbAuctionSettlDomainList)) {
            for (PrbAuctionSettlDomain prbAuctionSettlDmain : prbAuctionSettlDomainList) {
                prbAuctionSettlDmain.setTenantCode(tenantCode);
            }
        } else {
            this.logger.error(CODE + ".saveAuction", (Object)PrbAuctionSettlDomainStr);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.prbAuctionSettlServiceRepository.saveAuctionSettlBatch(prbAuctionSettlDomainList);
    }

    @RequestMapping(value={"saveAuctionGoods.json"}, name="\u589e\u52a0\u91c7\u8d2d\u9700\u6c42\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGoods(HttpServletRequest request, String PrbAuctionGoodsDomainStr) {
        if (StringUtils.isBlank((String)PrbAuctionGoodsDomainStr)) {
            this.logger.error(CODE + ".saveAuctionGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List prbAuctionGoodDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(PrbAuctionGoodsDomainStr, PrbAuctionDomain.class);
        if (ListUtil.isNotEmpty((Collection)prbAuctionGoodDomainList)) {
            for (PrbAuctionGoodsDomain prbAuctionGoodDomain : prbAuctionGoodDomainList) {
                prbAuctionGoodDomain.setTenantCode(tenantCode);
            }
        } else {
            this.logger.error(CODE + ".saveAuction", (Object)PrbAuctionGoodsDomainStr);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.prbAuctionServiceRepository.saveAuctionGoodsBatch(prbAuctionGoodDomainList);
    }

    @RequestMapping(value={"getPrbAuctionReDomain.json"}, name="\u83b7\u53d6\u91c7\u8d2d\u9700\u6c42\u4fe1\u606f")
    @ResponseBody
    public PrbAuctionReDomain getPrbAuctionReDomain(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.prbAuctionServiceRepository.getAuctionByCode(tenantCode, auctionCode);
    }
}

